/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class EnumOption<T extends Enum<T>>
extends Option<T> {
    protected final T defaultValue;
    protected final Class<T> enumClass;
    protected final String optDialogDescr;

    public EnumOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, T defaultValue, boolean showInDialog, String optDialogDescr) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.check((cmdValue != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.enumClass = defaultValue.getClass();
        this.optDialogDescr = optDialogDescr;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T parseValue(String optName, String value) {
        value = value.toUpperCase(Locale.US).replace('-', '_');
        try {
            return Enum.valueOf(this.enumClass, value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOptionException("Unknown option value.");
        }
    }

    @Override
    public String[] getCmdLine(Object value) {
        Enum enumValue = (Enum)value;
        String rslt = enumValue.name().toLowerCase(Locale.US).replace('_', '-');
        return new String[]{"--" + this.cmdLong + "=" + rslt};
    }

    protected T[] getDialogOrder() {
        return (Enum[])this.enumClass.getEnumConstants();
    }

    protected void checkEnumValues(T[] values) {
        Enum[] enumArray = (Enum[])this.enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum value = enumArray[n2];
            Assert.check((boolean)ArrayUtils.contains((Object[])values, (Object)value));
            ++n2;
        }
        Set valueSet = Sets.setc((int)values.length);
        T[] TArray = values;
        int n3 = values.length;
        n = 0;
        while (n < n3) {
            T value = TArray[n];
            boolean added = valueSet.add(value);
            Assert.check((boolean)added);
            ++n;
        }
    }

    protected abstract String getDialogText(T var1);

    @Override
    public OptionGroup<T> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new OptionGroup<T>(page, this){
            Button[] buttons;
            T[] enumValues;

            @Override
            protected void addComponents(Group group) {
                this.enumValues = EnumOption.this.getDialogOrder();
                EnumOption.this.checkEnumValues((Enum[])this.enumValues);
                this.buttons = new Button[this.enumValues.length];
                int i = 0;
                while (i < this.enumValues.length) {
                    this.buttons[i] = new Button((Composite)group, 16);
                    this.buttons[i].setText(EnumOption.this.getDialogText(this.enumValues[i]));
                    ++i;
                }
                this.layoutGeneric(this.buttons);
            }

            @Override
            public String getDescription() {
                return EnumOption.this.optDialogDescr;
            }

            @Override
            public void setToValue(T value) {
                int idx = ArrayUtils.indexOf((Object[])this.enumValues, value);
                this.buttons[idx].setSelection(true);
            }

            @Override
            public String[] getCmdLine() {
                int i = 0;
                while (i < this.buttons.length) {
                    if (this.buttons[i].getSelection()) {
                        Object value = this.enumValues[i];
                        return EnumOption.this.getCmdLine(value);
                    }
                    ++i;
                }
                throw new RuntimeException("This point is never reached.");
            }
        };
    }
}

