/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class OptionCategory {
    private final String name;
    private final String description;
    private final List<OptionCategory> categories;
    private final List<Option> options;
    private OptionCategory parent = null;

    public OptionCategory(String name, String description, List<OptionCategory> categories, List<Option> options) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)description);
        Assert.notNull(categories);
        Assert.notNull(options);
        this.name = name;
        this.description = description;
        this.categories = categories;
        this.options = options;
        for (OptionCategory category : categories) {
            category.setParent(this);
        }
    }

    private void setParent(OptionCategory parent) {
        Assert.check((this.parent == null ? 1 : 0) != 0);
        this.parent = parent;
    }

    public OptionCategory getParent() {
        return this.parent;
    }

    public OptionCategory getRoot() {
        OptionCategory current = this;
        while (current.parent != null) {
            current = current.parent;
        }
        return current;
    }

    protected void addOption(Option<?> option) {
        this.options.add(option);
    }

    protected void addSubCategory(OptionCategory category) {
        this.categories.add(category);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        List names = Lists.list((Object)this.getName());
        OptionCategory current = this.getParent();
        while (current != null) {
            OptionCategory parent = current.getParent();
            if (parent != null) {
                names.add(0, current.getName());
            }
            current = parent;
        }
        return String.join((CharSequence)", ", names);
    }

    public String getDescription() {
        return this.description;
    }

    public List<Option> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public List<OptionCategory> getSubCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void fillShortOptSet(Set<Character> names) {
        for (OptionCategory cat : this.categories) {
            cat.fillShortOptSet(names);
        }
        for (Option opt : this.options) {
            Character c = opt.getCmdShort();
            if (c == null) continue;
            names.add(c);
        }
    }

    public void fillShortOptMap(Map<Character, Option<?>> map) {
        for (OptionCategory cat : this.categories) {
            cat.fillShortOptMap(map);
        }
        for (Option opt : this.options) {
            Character c = opt.getCmdShort();
            if (c == null) continue;
            Option<?> opt2 = map.get(c);
            if (opt2 == null) {
                map.put(c, opt);
                continue;
            }
            Set shortNames = Sets.set();
            this.getRoot().fillShortOptSet(shortNames);
            String usedShortNames = Sets.sortedgeneric((Set)shortNames).stream().map(String::valueOf).collect(Collectors.joining(", "));
            String msg = Strings.fmt((String)"Duplicate short option name \"%s\" for application \"%s\" for options \"%s\" and \"%s\" (short names in use: %s).", (Object[])new Object[]{c, AppEnv.getApplication().getClass().getName(), opt.getClass().getName(), opt2.getClass().getName(), usedShortNames});
            throw new IllegalArgumentException(msg);
        }
    }

    public void fillLongOptMap(Map<String, Option<?>> map) {
        for (OptionCategory cat : this.categories) {
            cat.fillLongOptMap(map);
        }
        for (Option opt : this.options) {
            String s = opt.getCmdLong();
            Option<?> opt2 = map.get(s);
            if (opt2 == null) {
                map.put(s, opt);
                continue;
            }
            String msg = Strings.fmt((String)"Duplicate long option name \"%s\" for application \"%s\" for options \"%s\" and \"%s\".", (Object[])new Object[]{s, AppEnv.getApplication().getClass().getName(), opt.getClass().getName(), opt2.getClass().getName()});
            throw new IllegalArgumentException(msg);
        }
    }
}

