/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.runtime.CodePointBuffer;
import org.eclipse.escet.setext.runtime.CodePointReader;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.Token;
import org.eclipse.escet.setext.runtime.exceptions.ScanException;

public abstract class Scanner {
    private static final Token SKIPPED_TOKEN = new Token("<skipped>", -1, null);
    private CodePointReader reader;
    protected String location;
    protected String src;
    private CodePointBuffer buffer;
    protected int startOffset;
    protected int startLine;
    protected int startColumn;
    protected int acceptOffset;
    protected int acceptLine;
    protected int acceptColumn;
    protected int curOffset;
    protected int curLine;
    protected int curColumn;
    protected int accept;
    protected int scannerState;
    protected boolean debugScanner;
    protected boolean optimizeScanner;
    protected String[] scannerStates;
    protected boolean[] terminalNeedsPost;
    protected String[] terminals;
    protected String[] terminalNames;
    protected String[] terminalDescriptions;

    public void initScanner(CodePointReader reader, String location, String src, DebugMode debug, boolean optimize) {
        this.optimizeScanner = optimize;
        boolean bl = this.debugScanner = debug == DebugMode.SCANNER || debug == DebugMode.BOTH;
        if (this.debugScanner) {
            OutputProvider.out((String)"%s: Scanning...", (Object[])new Object[]{this.getClass().getSimpleName()});
        }
        this.location = location;
        this.src = src;
        this.reader = reader;
        this.buffer = new CodePointBuffer();
        this.startOffset = 0;
        this.startLine = 1;
        this.startColumn = 1;
        this.acceptOffset = -1;
        this.acceptLine = -1;
        this.acceptColumn = -1;
        this.curOffset = 0;
        this.curLine = 1;
        this.curColumn = 1;
        this.accept = -1;
        this.scannerState = 0;
    }

    protected int getNextCodePoint() throws IOException {
        if (!this.buffer.canRead()) {
            this.buffer.add(this.reader.read());
        }
        return this.buffer.read();
    }

    public Token nextToken() throws IOException {
        Token token;
        while ((token = this.nextTokenInternal()) == SKIPPED_TOKEN) {
        }
        return token;
    }

    public abstract Token nextTokenInternal() throws IOException;

    protected Token acceptOrError() {
        if (this.acceptOffset == -1) {
            TextPosition pos = new TextPosition(this.location, this.src, this.curLine, this.curColumn, this.curLine, this.curColumn, this.curOffset, this.curOffset);
            this.buffer.unread(1);
            int codePoint = this.buffer.read();
            throw new ScanException(codePoint, pos);
        }
        boolean skip = this.shouldSkipToken(this.accept);
        this.buffer.unread(this.curOffset - this.acceptOffset);
        int txtLength = this.acceptOffset - this.startOffset + 1;
        Character lastChar = null;
        String txt = null;
        if (skip) {
            lastChar = this.buffer.removePrefix(txtLength);
        } else {
            txt = this.buffer.pollPrefix(txtLength);
        }
        this.curOffset = this.acceptOffset + 1;
        this.curLine = this.acceptLine;
        this.curColumn = this.acceptColumn + 1;
        if (lastChar != null && lastChar.charValue() == '\n') {
            ++this.curLine;
            this.curColumn = 1;
        }
        if (txt != null && txt.endsWith("\n")) {
            ++this.curLine;
            this.curColumn = 1;
        }
        if (skip) {
            return SKIPPED_TOKEN;
        }
        TextPosition pos = new TextPosition(this.location, this.src, this.startLine, this.startColumn, this.acceptLine, this.acceptColumn, this.startOffset, this.acceptOffset);
        Token token = new Token(txt, this.accept, pos);
        if (this.terminalNeedsPost[this.accept]) {
            this.tokenAccepted(token);
        }
        if (this.debugScanner) {
            this.debugScanner(token);
        }
        return token;
    }

    private boolean shouldSkipToken(int id) {
        if (!this.optimizeScanner) {
            return false;
        }
        if (this.terminalNames[this.accept] != null) {
            return false;
        }
        if (this.buffer.peekEndOfFile()) {
            return false;
        }
        if (this.terminalNeedsPost[this.accept]) {
            return false;
        }
        return !this.debugScanner;
    }

    protected void tokenAccepted(Token token) {
    }

    protected void debugScanner(int codePoint, int state) {
        String acceptTxt;
        String codePointTxt;
        if (codePoint == -1) {
            codePointTxt = "<eof>";
        } else {
            codePointTxt = Strings.codePointToStr((int)codePoint);
            codePointTxt = Strings.stringToJava((String)codePointTxt);
            codePointTxt = String.valueOf(codePointTxt) + Strings.fmt((String)" (Unicode U+%s)", (Object[])new Object[]{Integer.toHexString(codePoint)});
        }
        if (this.accept == -1) {
            acceptTxt = "";
        } else {
            acceptTxt = this.terminals[this.accept];
            acceptTxt = Strings.fmt((String)" (accept %d=%s)", (Object[])new Object[]{this.accept, acceptTxt});
        }
        OutputProvider.out((String)"%s: Scanned text: %s @ line %d, column %d%s", (Object[])new Object[]{this.getClass().getSimpleName(), codePointTxt, this.curLine, this.curColumn, acceptTxt});
    }

    private void debugScanner(Token token) {
        String txt = token.isEof() ? "<eof>" : Strings.stringToJava((String)token.text);
        String posTxt = Strings.fmt((String)"%d:%d-%d:%d", (Object[])new Object[]{token.position.startLine, token.position.startColumn, token.position.endLine, token.position.endColumn});
        String stateTxt = this.scannerStates[this.scannerState];
        String terminalTxt = this.terminals[token.id];
        OutputProvider.out((String)"%s: Accepted token: %s @ %s (state=%d=\"%s\") (terminal=%d=%s)", (Object[])new Object[]{this.getClass().getSimpleName(), txt, posTxt, this.scannerState, stateTxt, token.id, terminalTxt});
    }

    public List<Token> scanString(String input, String location, DebugMode debug, boolean optimize) throws IOException {
        Token token;
        CodePointReader reader = new CodePointReader(new StringReader(input), false);
        this.initScanner(reader, location, null, debug, optimize);
        List tokens = Lists.list();
        do {
            token = this.nextToken();
            tokens.add(token);
        } while (!token.isEof());
        return tokens;
    }
}

