/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.texteditorbase.GenericTextEditor;
import org.eclipse.escet.setext.texteditorbase.commands.CommentHandlerBase;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class UncommentHandler
extends CommentHandlerBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GenericTextEditor<?, ?, ?> editor = this.getTextEditor(event);
        if (editor == null) {
            return null;
        }
        String chars = this.getCommentChars(event, editor);
        if (chars == null) {
            return null;
        }
        IDocument doc = this.getDocument(event, editor);
        ITextSelection textSelection = this.getSelection(editor);
        int startLine = this.getStartLine(event, textSelection);
        int endLine = this.getEndLine(event, textSelection);
        if (startLine < 0 || endLine < 0) {
            return null;
        }
        IDocumentExtension4 docExt = (IDocumentExtension4)doc;
        DocumentRewriteSession session = docExt.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        try {
            Assert.check((startLine <= endLine ? 1 : 0) != 0);
            int nr = startLine;
            while (nr <= endLine) {
                try {
                    IRegion region = doc.getLineInformation(nr);
                    String line = doc.get(region.getOffset(), region.getLength());
                    int whitespacePrefixLen = this.getWhitespacePrefixLength(line);
                    String line2 = line.substring(whitespacePrefixLen);
                    if (line2.startsWith(chars)) {
                        boolean spaceAfter = line2.startsWith(String.valueOf(chars) + " ");
                        int count = chars.length() + (spaceAfter ? 1 : 0);
                        doc.replace(region.getOffset() + whitespacePrefixLen, count, "");
                    }
                }
                catch (BadLocationException e) {
                    IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                    Shell shell = part.getSite().getShell();
                    String title = String.valueOf(this.getCommandName(event)) + " Command Error";
                    String msg = Strings.fmt((String)"Failed to uncomment line %d.", (Object[])new Object[]{nr});
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    docExt.stopRewriteSession(session);
                    return null;
                }
                ++nr;
            }
        }
        finally {
            docExt.stopRewriteSession(session);
        }
        return null;
    }

    private int getWhitespacePrefixLength(String line) {
        int i = 0;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return line.length();
    }
}

