/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.interpreter;

import java.util.List;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.tooldef.interpreter.ToolDefInterpreter;
import org.eclipse.escet.tooldef.io.ToolDefReader;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;

public class ToolDefInterpreterApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ToolDefInterpreterApp app = new ToolDefInterpreterApp();
        app.run(args);
    }

    public ToolDefInterpreterApp() {
    }

    public ToolDefInterpreterApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "ToolDef interpreter";
    }

    public String getAppDescription() {
        return "The ToolDef interpreter executes ToolDef scripts.";
    }

    protected int runInternal() {
        boolean dbgEnabled = OutputModeOption.getOutputMode() == OutputMode.DEBUG;
        String inputPath = InputFileOption.getPath();
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Reading ToolDef script file \"%s\".", (Object[])new Object[]{inputPath});
        }
        ToolDefReader reader = (ToolDefReader)new ToolDefReader().init();
        Script script = (Script)reader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        String scriptPath = Paths.resolve((String)inputPath);
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Executing ToolDef script.");
        }
        int exitCode = ToolDefInterpreter.execute(script, scriptPath, this);
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Finished executing ToolDef script (exit code %d).", (Object[])new Object[]{exitCode});
        }
        return exitCode;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = ToolDefInterpreterApp.getGeneralOptionCategory();
        List transOpts = Lists.list();
        transOpts.add(Options.getInstance(InputFileOption.class));
        List transSubCats = Lists.list();
        OptionCategory transCat = new OptionCategory("Interpreter", "Interpreter options.", transSubCats, transOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, transCat});
        OptionCategory options = new OptionCategory("ToolDef Interpreter Options", "All options for the ToolDef interpreter.", cats, Lists.list());
        return options;
    }
}

