/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDBitVector;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDPairing;
import com.github.javabdd.BDDVarSet;
import com.github.javabdd.JFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class BDDFactory {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT_FILL_IN_VAR_INDICES = false;
    public static final BDDOp and = new BDDOp(0, "and");
    public static final BDDOp xor = new BDDOp(1, "xor");
    public static final BDDOp or = new BDDOp(2, "or");
    public static final BDDOp nand = new BDDOp(3, "nand");
    public static final BDDOp nor = new BDDOp(4, "nor");
    public static final BDDOp imp = new BDDOp(5, "imp");
    public static final BDDOp biimp = new BDDOp(6, "biimp");
    public static final BDDOp diff = new BDDOp(7, "diff");
    public static final BDDOp less = new BDDOp(8, "less");
    public static final BDDOp invimp = new BDDOp(9, "invimp");
    protected StringTokenizer tokenizer;
    public static final ReorderMethod REORDER_NONE = new ReorderMethod(0, "NONE");
    public static final ReorderMethod REORDER_WIN2 = new ReorderMethod(1, "WIN2");
    public static final ReorderMethod REORDER_WIN2ITE = new ReorderMethod(2, "WIN2ITE");
    public static final ReorderMethod REORDER_WIN3 = new ReorderMethod(5, "WIN3");
    public static final ReorderMethod REORDER_WIN3ITE = new ReorderMethod(6, "WIN3ITE");
    public static final ReorderMethod REORDER_SIFT = new ReorderMethod(3, "SIFT");
    public static final ReorderMethod REORDER_SIFTITE = new ReorderMethod(4, "SIFTITE");
    public static final ReorderMethod REORDER_RANDOM = new ReorderMethod(7, "RANDOM");
    protected GCStats gcstats = new GCStats();
    protected ReorderStats reorderstats = new ReorderStats();
    protected CacheStats cachestats = new CacheStats();
    protected MaxUsedBddNodesStats maxusedbddnodesstats = new MaxUsedBddNodesStats();
    protected MaxMemoryStats maxmemorystats = new MaxMemoryStats();
    protected BDDDomain[] domain;
    protected int fdvarnum;
    protected int firstbddvar;
    protected List<GCStatsCallback> gcCallbacks = null;
    protected List<ReorderStatsCallback> reorderCallbacks = null;
    protected List<ResizeStatsCallback> resizeCallbacks = null;
    protected List<CacheStatsCallback> cacheCallbacks = null;
    protected List<MaxUsedBddNodesStatsCallback> maxUsedBddNodesCallbacks = null;
    protected List<MaxMemoryStatsCallback> maxMemoryCallbacks = null;
    protected List<ContinuousStatsCallback> continuousCallbacks = null;

    public static final String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (AccessControlException e) {
            return def;
        }
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        String bddpackage = BDDFactory.getProperty("bdd", "java");
        return BDDFactory.init(bddpackage, nodenum, cachesize);
    }

    public static BDDFactory init(String bddpackage, int nodenum, int cachesize) {
        try {
            if (bddpackage.equals("j") || bddpackage.equals("java")) {
                return JFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("zdd")) {
                BDDFactory bdd = JFactory.init(nodenum, cachesize);
                ((JFactory)bdd).ZDD = true;
                return bdd;
            }
            System.err.println("Unknown BDD package: " + bddpackage);
        }
        catch (LinkageError e) {
            System.err.println("Could not load BDD package " + bddpackage + ": " + e.getLocalizedMessage());
        }
        try {
            Class<?> c = Class.forName(bddpackage);
            Method m = c.getMethod("init", Integer.TYPE, Integer.TYPE);
            return (BDDFactory)m.invoke(null, nodenum, cachesize);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return JFactory.init(nodenum, cachesize);
    }

    protected BDDFactory() {
        String s = this.getClass().toString();
    }

    public boolean isZDD() {
        return false;
    }

    public abstract BDD zero();

    public abstract BDD one();

    public BDD universe() {
        return this.one();
    }

    public BDDVarSet emptySet() {
        return new BDDVarSet.DefaultImpl(this.one());
    }

    public BDD buildCube(int value, List<BDD> variables) {
        BDD result = this.universe();
        for (BDD var : variables) {
            var = (value & 1) != 0 ? var.id() : var.not();
            result.andWith(var);
            value >>= 1;
        }
        return result;
    }

    public BDD buildCube(int value, int[] variables) {
        BDD result = this.universe();
        int z = 0;
        while (z < variables.length) {
            BDD v = (value & 1) != 0 ? this.ithVar(variables[variables.length - z - 1]) : this.nithVar(variables[variables.length - z - 1]);
            result.andWith(v);
            ++z;
            value >>= 1;
        }
        return result;
    }

    public BDDVarSet makeSet(int[] varset) {
        BDDVarSet res = this.emptySet();
        int varnum = varset.length;
        for (int v = varnum - 1; v >= 0; --v) {
            res.unionWith(varset[v]);
        }
        return res;
    }

    protected abstract void initialize(int var1, int var2);

    public abstract boolean isInitialized();

    public void reset() {
        int nodes = this.getNodeTableSize();
        int cache = this.getCacheSize();
        this.domain = null;
        this.fdvarnum = 0;
        this.firstbddvar = 0;
        this.done();
        this.initialize(nodes, cache);
    }

    public abstract void done();

    public abstract void setError(int var1);

    public abstract void clearError();

    public abstract int setMaxNodeNum(int var1);

    public abstract double setMinFreeNodes(double var1);

    public abstract int setMaxIncrease(int var1);

    public abstract double setIncreaseFactor(double var1);

    public abstract double setCacheRatio(double var1);

    public abstract int setNodeTableSize(int var1);

    public abstract int setCacheSize(int var1);

    public abstract int varNum();

    public abstract int setVarNum(int var1);

    public int extVarNum(int num) {
        int start = this.varNum();
        if (num < 0 || num > 0x3FFFFFFF) {
            throw new BDDException();
        }
        this.setVarNum(start + num);
        return start;
    }

    public abstract BDD ithVar(int var1);

    public abstract BDD nithVar(int var1);

    public abstract void printAll();

    public abstract void printTable(BDD var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDD load(String filename) throws IOException {
        BufferedReader r = null;
        try {
            BDD result;
            r = new BufferedReader(new FileReader(filename));
            BDD bDD = result = this.load(r);
            return bDD;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public BDD load(BufferedReader ifile) throws IOException {
        return this.load(ifile, null);
    }

    public BDD load(BufferedReader ifile, int[] translate) throws IOException {
        this.tokenizer = null;
        int lh_nodenum = Integer.parseInt(this.readNext(ifile));
        int vnum = Integer.parseInt(this.readNext(ifile));
        if (lh_nodenum == 0 && vnum == 0) {
            int r = Integer.parseInt(this.readNext(ifile));
            return r == 0 ? this.zero() : this.universe();
        }
        int[] loadvar2level = new int[vnum];
        for (int n = 0; n < vnum; ++n) {
            loadvar2level[n] = Integer.parseInt(this.readNext(ifile));
        }
        if (vnum > this.varNum()) {
            this.setVarNum(vnum);
        }
        LoadHash[] lh_table = new LoadHash[lh_nodenum];
        for (int n = 0; n < lh_nodenum; ++n) {
            lh_table[n] = new LoadHash();
            lh_table[n].first = -1;
            lh_table[n].next = n + 1;
        }
        lh_table[lh_nodenum - 1].next = -1;
        int lh_freepos = 0;
        BDD root = null;
        for (int n = 0; n < lh_nodenum; ++n) {
            int key = Integer.parseInt(this.readNext(ifile));
            int var = Integer.parseInt(this.readNext(ifile));
            if (translate != null) {
                var = translate[var];
            }
            int lowi = Integer.parseInt(this.readNext(ifile));
            int highi = Integer.parseInt(this.readNext(ifile));
            BDD low = this.loadhash_get(lh_table, lh_nodenum, lowi);
            BDD high = this.loadhash_get(lh_table, lh_nodenum, highi);
            if (low == null || high == null || var < 0) {
                throw new BDDException("Incorrect file format");
            }
            BDD b = this.ithVar(var);
            root = b.ite(high, low);
            b.free();
            if (low.isZero() || low.isOne()) {
                low.free();
            }
            if (high.isZero() || high.isOne()) {
                high.free();
            }
            int hash = key % lh_nodenum;
            int pos = lh_freepos;
            lh_freepos = lh_table[pos].next;
            lh_table[pos].next = lh_table[hash].first;
            lh_table[hash].first = pos;
            lh_table[pos].key = key;
            lh_table[pos].data = root;
        }
        BDD tmproot = root.id();
        for (int n = 0; n < lh_nodenum; ++n) {
            lh_table[n].data.free();
        }
        lh_table = null;
        loadvar2level = null;
        return tmproot;
    }

    protected String readNext(BufferedReader ifile) throws IOException {
        while (this.tokenizer == null || !this.tokenizer.hasMoreTokens()) {
            String s = ifile.readLine();
            if (s == null) {
                throw new BDDException("Incorrect file format");
            }
            this.tokenizer = new StringTokenizer(s);
        }
        return this.tokenizer.nextToken();
    }

    protected BDD loadhash_get(LoadHash[] lh_table, int lh_nodenum, int key) {
        if (key < 0) {
            return null;
        }
        if (key == 0) {
            return this.zero();
        }
        if (key == 1) {
            return this.universe();
        }
        int hash = lh_table[key % lh_nodenum].first;
        while (hash != -1 && lh_table[hash].key != key) {
            hash = lh_table[hash].next;
        }
        if (hash == -1) {
            return null;
        }
        return lh_table[hash].data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename, BDD var) throws IOException {
        BufferedWriter is = null;
        try {
            is = new BufferedWriter(new FileWriter(filename));
            this.save(is, var);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void save(BufferedWriter out, BDD r) throws IOException {
        if (r.isOne() || r.isZero()) {
            out.write("0 0 " + (r.isOne() ? 1 : 0) + "\n");
            return;
        }
        out.write(r.nodeCount() + " " + this.varNum() + "\n");
        for (int x = 0; x < this.varNum(); ++x) {
            out.write(this.var2Level(x) + " ");
        }
        out.write("\n");
        BitSet visited = new BitSet(this.getNodeTableSize());
        this.save_rec(out, visited, r.id());
    }

    protected int save_rec(BufferedWriter out, BitSet visited, BDD root) throws IOException {
        if (root.isZero()) {
            root.free();
            return 0;
        }
        if (root.isOne()) {
            root.free();
            return 1;
        }
        int i = root.hashCode();
        if (visited.get(i)) {
            root.free();
            return i;
        }
        int v = i;
        visited.set(i);
        BDD h = root.high();
        BDD l = root.low();
        int rootvar = root.var();
        root.free();
        int lo = this.save_rec(out, visited, l);
        int hi = this.save_rec(out, visited, h);
        out.write(i + " ");
        out.write(rootvar + " ");
        out.write(lo + " ");
        out.write(hi + "\n");
        return v;
    }

    public abstract int level2Var(int var1);

    public abstract int var2Level(int var1);

    public abstract void reorder(ReorderMethod var1);

    public abstract void autoReorder(ReorderMethod var1);

    public abstract void autoReorder(ReorderMethod var1, int var2);

    public abstract ReorderMethod getReorderMethod();

    public abstract int getReorderTimes();

    public abstract void disableReorder();

    public abstract void enableReorder();

    public abstract int reorderVerbose(int var1);

    public abstract void setVarOrder(int[] var1);

    public int[] getVarOrder() {
        int n = this.varNum();
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.level2Var(i);
        }
        return result;
    }

    public abstract BDDPairing makePair();

    public BDDPairing makePair(int oldvar, int newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public BDDPairing makePair(int oldvar, BDD newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public BDDPairing makePair(BDDDomain oldvar, BDDDomain newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public abstract void swapVar(int var1, int var2);

    public void addVarBlock(BDDVarSet var, boolean fixed) {
        int last;
        int[] v = var.toArray();
        if (v.length < 1) {
            throw new BDDException("Invalid parameter for addVarBlock");
        }
        int first = last = v[0];
        for (int n = 1; n < v.length; ++n) {
            if (v[n] < first) {
                first = v[n];
            }
            if (v[n] <= last) continue;
            last = v[n];
        }
        this.addVarBlock(first, last, fixed);
    }

    public abstract void addVarBlock(int var1, int var2, boolean var3);

    public abstract void varBlockAll();

    public abstract void clearVarBlocks();

    public abstract void printOrder();

    public abstract int nodeCount(Collection<BDD> var1);

    public abstract int getNodeTableSize();

    public abstract int getNodeNum();

    public abstract int getCacheSize();

    public abstract int reorderGain();

    public abstract void printStat();

    public CacheStats getCacheStats() {
        return this.cachestats;
    }

    public MaxUsedBddNodesStats getMaxUsedBddNodesStats() {
        return this.maxusedbddnodesstats;
    }

    public MaxMemoryStats getMaxMemoryStats() {
        return this.maxmemorystats;
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new BDDDomain(a, b){

            @Override
            public BDDFactory getFactory() {
                return BDDFactory.this;
            }
        };
    }

    public BDDDomain extDomain(long domainSize) {
        return this.extDomain(BigInteger.valueOf(domainSize));
    }

    public BDDDomain extDomain(BigInteger domainSize) {
        return this.extDomain(new BigInteger[]{domainSize})[0];
    }

    public BDDDomain[] extDomain(int[] dom) {
        BigInteger[] a = new BigInteger[dom.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = BigInteger.valueOf(dom[i]);
        }
        return this.extDomain(a);
    }

    public BDDDomain[] extDomain(long[] dom) {
        BigInteger[] a = new BigInteger[dom.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = BigInteger.valueOf(dom[i]);
        }
        return this.extDomain(a);
    }

    public BDDDomain[] extDomain(BigInteger[] domainSizes) {
        int n;
        int offset = this.fdvarnum;
        int extravars = 0;
        int num = domainSizes.length;
        if (this.domain == null) {
            this.domain = new BDDDomain[num];
        } else if (this.fdvarnum + num > this.domain.length) {
            int fdvaralloc = this.domain.length + Math.max(num, this.domain.length);
            BDDDomain[] d2 = new BDDDomain[fdvaralloc];
            System.arraycopy(this.domain, 0, d2, 0, this.domain.length);
            this.domain = d2;
        }
        for (n = 0; n < num; ++n) {
            this.domain[n + this.fdvarnum] = this.createDomain(n + this.fdvarnum, domainSizes[n]);
            extravars += this.domain[n + this.fdvarnum].varNum();
        }
        int binoffset = this.firstbddvar;
        int bddvarnum = this.varNum();
        if (this.firstbddvar + extravars > bddvarnum) {
            this.setVarNum(this.firstbddvar + extravars);
        }
        int bn = 0;
        boolean more = true;
        while (more) {
            more = false;
            for (n = 0; n < num; ++n) {
                if (bn >= this.domain[n + this.fdvarnum].varNum()) continue;
                more = true;
                this.domain[n + this.fdvarnum].ivar[bn] = binoffset++;
            }
            ++bn;
        }
        if (this.isZDD()) {
            for (n = 0; n < this.fdvarnum; ++n) {
                this.domain[n].var.free();
                this.domain[n].var = this.makeSet(this.domain[n].ivar);
            }
        }
        for (n = 0; n < num; ++n) {
            this.domain[n + this.fdvarnum].var = this.makeSet(this.domain[n + this.fdvarnum].ivar);
        }
        this.fdvarnum += num;
        this.firstbddvar += extravars;
        BDDDomain[] r = new BDDDomain[num];
        System.arraycopy(this.domain, offset, r, 0, num);
        return r;
    }

    public BDDDomain overlapDomain(BDDDomain d1, BDDDomain d2) {
        int n;
        int fdvaralloc = this.domain.length;
        if (this.fdvarnum + 1 > fdvaralloc) {
            fdvaralloc += fdvaralloc;
            BDDDomain[] domain2 = new BDDDomain[fdvaralloc];
            System.arraycopy(this.domain, 0, domain2, 0, this.domain.length);
            this.domain = domain2;
        }
        BDDDomain d = this.domain[this.fdvarnum];
        d.realsize = d1.realsize.multiply(d2.realsize);
        d.ivar = new int[d1.varNum() + d2.varNum()];
        for (n = 0; n < d1.varNum(); ++n) {
            d.ivar[n] = d1.ivar[n];
        }
        for (n = 0; n < d2.varNum(); ++n) {
            d.ivar[d1.varNum() + n] = d2.ivar[n];
        }
        d.var = this.makeSet(d.ivar);
        ++this.fdvarnum;
        return d;
    }

    public BDDVarSet makeSet(BDDDomain[] v) {
        BDDVarSet res = this.emptySet();
        for (int n = 0; n < v.length; ++n) {
            res.unionWith(v[n].set());
        }
        return res;
    }

    public void clearAllDomains() {
        this.domain = null;
        this.fdvarnum = 0;
        this.firstbddvar = 0;
    }

    public int numberOfDomains() {
        return this.fdvarnum;
    }

    public BDDDomain getDomain(int i) {
        if (i < 0 || i >= this.fdvarnum) {
            throw new IndexOutOfBoundsException();
        }
        return this.domain[i];
    }

    public int[] makeVarOrdering(boolean reverseLocal, String ordering) {
        int i;
        int varnum = this.varNum();
        int nDomains = this.numberOfDomains();
        int[][] localOrders = new int[nDomains][];
        for (i = 0; i < localOrders.length; ++i) {
            localOrders[i] = new int[this.getDomain(i).varNum()];
        }
        for (i = 0; i < nDomains; ++i) {
            BDDDomain d = this.getDomain(i);
            int nVars = d.varNum();
            for (int j = 0; j < nVars; ++j) {
                localOrders[i][j] = reverseLocal ? nVars - j - 1 : j;
            }
        }
        BDDDomain[] doms = new BDDDomain[nDomains];
        int[] varorder = new int[varnum];
        StringTokenizer st = new StringTokenizer(ordering, "x_", true);
        int numberOfDomains = 0;
        int bitIndex = 0;
        boolean[] done = new boolean[nDomains];
        int i2 = 0;
        while (true) {
            BDDDomain d;
            String s = st.nextToken();
            int j = 0;
            while (true) {
                if (j == this.numberOfDomains()) {
                    throw new BDDException("bad domain: " + s);
                }
                d = this.getDomain(j);
                if (s.equals(d.getName())) break;
                ++j;
            }
            if (done[d.getIndex()]) {
                throw new BDDException("duplicate domain: " + s);
            }
            done[d.getIndex()] = true;
            doms[i2] = d;
            if (st.hasMoreTokens() && (s = st.nextToken()).equals("x")) {
                ++numberOfDomains;
            } else {
                bitIndex = BDDFactory.fillInVarIndices(doms, i2 - numberOfDomains, numberOfDomains + 1, localOrders, bitIndex, varorder);
                if (!st.hasMoreTokens()) break;
                if (s.equals("_")) {
                    numberOfDomains = 0;
                } else {
                    throw new BDDException("bad token: " + s);
                }
            }
            ++i2;
        }
        for (i2 = 0; i2 < doms.length; ++i2) {
            if (done[i2]) continue;
            throw new BDDException("missing domain #" + i2 + ": " + this.getDomain(i2));
        }
        while (bitIndex < varorder.length) {
            varorder[bitIndex] = bitIndex;
            ++bitIndex;
        }
        int[] test = new int[varorder.length];
        System.arraycopy(varorder, 0, test, 0, varorder.length);
        Arrays.sort(test);
        for (int i3 = 0; i3 < test.length; ++i3) {
            if (test[i3] == i3) continue;
            throw new BDDException(test[i3] + " != " + i3);
        }
        return varorder;
    }

    static int fillInVarIndices(BDDDomain[] doms, int domainIndex, int numDomains, int[][] localOrders, int bitIndex, int[] varorder) {
        int maxBits = 0;
        for (int i = 0; i < numDomains; ++i) {
            BDDDomain d = doms[domainIndex + i];
            maxBits = Math.max(maxBits, d.varNum());
        }
        for (int bitNumber = 0; bitNumber < maxBits; ++bitNumber) {
            for (int i = 0; i < numDomains; ++i) {
                BDDDomain d = doms[domainIndex + i];
                if (bitNumber >= d.varNum()) continue;
                int di = d.getIndex();
                int local = localOrders[di][bitNumber];
                varorder[bitIndex++] = d.vars()[local];
            }
        }
        return bitIndex;
    }

    protected BDDBitVector createBitVector(int a) {
        return new BDDBitVector(a){

            @Override
            public BDDFactory getFactory() {
                return BDDFactory.this;
            }
        };
    }

    public BDDBitVector buildVector(int bitnum, boolean b) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(b);
        return v;
    }

    public BDDBitVector constantVector(int bitnum, long val) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(val);
        return v;
    }

    public BDDBitVector constantVector(int bitnum, BigInteger val) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(val);
        return v;
    }

    public BDDBitVector buildVector(int bitnum, int offset, int step) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(offset, step);
        return v;
    }

    public BDDBitVector buildVector(BDDDomain d) {
        BDDBitVector v = this.createBitVector(d.varNum());
        v.initialize(d);
        return v;
    }

    public BDDBitVector buildVector(int[] var) {
        BDDBitVector v = this.createBitVector(var.length);
        v.initialize(var);
        return v;
    }

    public void registerGcStatsCallback(GCStatsCallback callback) {
        if (this.gcCallbacks == null) {
            this.gcCallbacks = new LinkedList<GCStatsCallback>();
        }
        this.gcCallbacks.add(callback);
    }

    public void registerReorderStatsCallback(ReorderStatsCallback callback) {
        if (this.reorderCallbacks == null) {
            this.reorderCallbacks = new LinkedList<ReorderStatsCallback>();
        }
        this.reorderCallbacks.add(callback);
    }

    public void registerResizeStatsCallback(ResizeStatsCallback callback) {
        if (this.resizeCallbacks == null) {
            this.resizeCallbacks = new LinkedList<ResizeStatsCallback>();
        }
        this.resizeCallbacks.add(callback);
    }

    public void registerCacheStatsCallback(CacheStatsCallback callback) {
        if (this.cacheCallbacks == null) {
            this.cacheCallbacks = new LinkedList<CacheStatsCallback>();
        }
        this.cacheCallbacks.add(callback);
    }

    public void registerMaxUsedBddNodesStatsCallback(MaxUsedBddNodesStatsCallback callback) {
        if (this.maxUsedBddNodesCallbacks == null) {
            this.maxUsedBddNodesCallbacks = new LinkedList<MaxUsedBddNodesStatsCallback>();
        }
        this.maxUsedBddNodesCallbacks.add(callback);
    }

    public void registerMaxMemoryStatsCallback(MaxMemoryStatsCallback callback) {
        if (this.maxMemoryCallbacks == null) {
            this.maxMemoryCallbacks = new LinkedList<MaxMemoryStatsCallback>();
        }
        this.maxMemoryCallbacks.add(callback);
    }

    public void registerContinuousStatsCallback(ContinuousStatsCallback callback) {
        if (this.continuousCallbacks == null) {
            this.continuousCallbacks = new LinkedList<ContinuousStatsCallback>();
        }
        this.continuousCallbacks.add(callback);
    }

    public void unregisterGcStatsCallback(GCStatsCallback callback) {
        if (this.gcCallbacks != null) {
            Iterator<GCStatsCallback> iter = this.gcCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.gcCallbacks.isEmpty()) {
                    this.gcCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterReorderStatsCallback(ReorderStatsCallback callback) {
        if (this.reorderCallbacks != null) {
            Iterator<ReorderStatsCallback> iter = this.reorderCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.reorderCallbacks.isEmpty()) {
                    this.reorderCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterResizeStatsCallback(ResizeStatsCallback callback) {
        if (this.resizeCallbacks != null) {
            Iterator<ResizeStatsCallback> iter = this.resizeCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.resizeCallbacks.isEmpty()) {
                    this.resizeCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterCacheStatsCallback(CacheStatsCallback callback) {
        if (this.cacheCallbacks != null) {
            Iterator<CacheStatsCallback> iter = this.cacheCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.cacheCallbacks.isEmpty()) {
                    this.cacheCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterMaxUsedBddNodesStatsCallback(MaxUsedBddNodesStatsCallback callback) {
        if (this.maxUsedBddNodesCallbacks != null) {
            Iterator<MaxUsedBddNodesStatsCallback> iter = this.maxUsedBddNodesCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.maxUsedBddNodesCallbacks.isEmpty()) {
                    this.maxUsedBddNodesCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterMaxMemoryStatsCallback(MaxMemoryStatsCallback callback) {
        if (this.maxMemoryCallbacks != null) {
            Iterator<MaxMemoryStatsCallback> iter = this.maxMemoryCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.maxMemoryCallbacks.isEmpty()) {
                    this.maxMemoryCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void unregisterContinuousStatsCallback(ContinuousStatsCallback callback) {
        if (this.continuousCallbacks != null) {
            Iterator<ContinuousStatsCallback> iter = this.continuousCallbacks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != callback) continue;
                iter.remove();
                if (this.continuousCallbacks.isEmpty()) {
                    this.continuousCallbacks = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean hasGcStatsCallback() {
        return this.gcCallbacks != null;
    }

    public boolean hasReorderStatsCallback() {
        return this.reorderCallbacks != null;
    }

    public boolean hasResizeStatsCallback() {
        return this.resizeCallbacks != null;
    }

    public boolean hasCacheStatsCallback() {
        return this.cacheCallbacks != null;
    }

    public boolean hasMaxUsedBddNodesStatsCallback() {
        return this.maxUsedBddNodesCallbacks != null;
    }

    public boolean hasMaxMemoryStatsCallback() {
        return this.maxMemoryCallbacks != null;
    }

    public boolean hasContinuousStatsCallback() {
        return this.continuousCallbacks != null;
    }

    public void invokeGcStatsCallbacks(boolean pre) {
        if (this.gcCallbacks != null) {
            for (GCStatsCallback callback : this.gcCallbacks) {
                callback.gc(this.gcstats, pre);
            }
        }
    }

    public void invokeReorderStatsCallbacks(boolean pre) {
        if (this.reorderCallbacks != null) {
            for (ReorderStatsCallback callback : this.reorderCallbacks) {
                callback.reorder(this.reorderstats, pre);
            }
        }
    }

    public void invokeResizeStatsCallbacks(int oldsize, int newsize) {
        if (this.resizeCallbacks != null) {
            for (ResizeStatsCallback callback : this.resizeCallbacks) {
                callback.resize(oldsize, newsize);
            }
        }
    }

    public void invokeCacheStatsCallbacks() {
        if (this.cacheCallbacks != null) {
            for (CacheStatsCallback callback : this.cacheCallbacks) {
                callback.cache(this.cachestats);
            }
        }
    }

    public void invokeMaxUsedBddNodesStatsCallbacks() {
        if (this.maxUsedBddNodesCallbacks != null) {
            for (MaxUsedBddNodesStatsCallback callback : this.maxUsedBddNodesCallbacks) {
                callback.maxUsedBddNodes(this.maxusedbddnodesstats);
            }
        }
    }

    public void invokeMaxMemoryStatsCallbacks() {
        if (this.maxMemoryCallbacks != null) {
            for (MaxMemoryStatsCallback callback : this.maxMemoryCallbacks) {
                callback.maxMemory(this.maxmemorystats);
            }
        }
    }

    public void invokeContinuousStatsCallbacks(int usedBddNodes, long opMiss) {
        if (this.continuousCallbacks != null) {
            for (ContinuousStatsCallback callback : this.continuousCallbacks) {
                callback.continuous(usedBddNodes, opMiss);
            }
        }
    }

    public static void defaultGcStatsCallback(GCStats stats, boolean pre) {
        if (pre) {
            if (stats.freenodes != 0) {
                System.out.println("Starting GC cycle  #" + (stats.num + 1) + ": " + stats.nodes + " nodes / " + stats.freenodes + " free");
            }
        } else {
            System.out.println(stats.toString());
        }
    }

    public static void defaultReorderStatsCallback(ReorderStats stats, boolean pre) {
        if (pre) {
            System.out.println("Start reordering");
        } else {
            System.out.println("End reordering. " + stats);
        }
    }

    public static void defaultResizeStatsCallback(int oldsize, int newsize) {
        StringBuilder sb = new StringBuilder();
        sb.append("Went from ");
        sb.append(oldsize);
        sb.append(" to ");
        sb.append(newsize);
        sb.append(" nodes");
        System.out.println(sb.toString());
    }

    public static void defaultCacheStatsCallback(CacheStats stats) {
        System.out.println(stats.toString());
    }

    public static void defaultMaxUsedBddNodesStatsCallback(MaxUsedBddNodesStats stats) {
        System.out.println(stats.toString());
    }

    public static void defaultMaxMemoryStatsCallback(MaxMemoryStats stats) {
        System.out.println(stats.toString());
    }

    public static void defaultContinuousStatsCallback(int usedBddNodes, long opMiss) {
        StringBuilder sb = new StringBuilder();
        sb.append("Used BDD nodes: ");
        sb.append(usedBddNodes);
        sb.append(", operation count: ");
        sb.append(opMiss);
        System.out.println(sb.toString());
    }

    @FunctionalInterface
    public static interface ContinuousStatsCallback {
        public void continuous(int var1, long var2);
    }

    @FunctionalInterface
    public static interface MaxMemoryStatsCallback {
        public void maxMemory(MaxMemoryStats var1);
    }

    @FunctionalInterface
    public static interface MaxUsedBddNodesStatsCallback {
        public void maxUsedBddNodes(MaxUsedBddNodesStats var1);
    }

    @FunctionalInterface
    public static interface CacheStatsCallback {
        public void cache(CacheStats var1);
    }

    @FunctionalInterface
    public static interface ResizeStatsCallback {
        public void resize(int var1, int var2);
    }

    @FunctionalInterface
    public static interface ReorderStatsCallback {
        public void reorder(ReorderStats var1, boolean var2);
    }

    @FunctionalInterface
    public static interface GCStatsCallback {
        public void gc(GCStats var1, boolean var2);
    }

    public static class MaxMemoryStats {
        protected boolean enabled = false;
        protected long maxMemoryBytes;

        protected MaxMemoryStats() {
        }

        void copyFrom(MaxMemoryStats that) {
            this.maxMemoryBytes = that.maxMemoryBytes;
        }

        public void enableMeasurements() {
            this.enabled = true;
        }

        public void disableMeasurements() {
            this.enabled = false;
        }

        public void resetMeasurements() {
            this.maxMemoryBytes = 0L;
        }

        public void newMeasurement() {
            long newMemoryBytes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.maxMemoryBytes = Math.max(newMemoryBytes, this.maxMemoryBytes);
        }

        public long getMaxMemoryBytes() {
            return this.maxMemoryBytes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Max memory: ");
            sb.append(this.maxMemoryBytes);
            sb.append(" bytes");
            return sb.toString();
        }
    }

    public static class MaxUsedBddNodesStats {
        protected boolean enabled = false;
        protected int maxUsedBddNodes;

        protected MaxUsedBddNodesStats() {
        }

        void copyFrom(MaxUsedBddNodesStats that) {
            this.maxUsedBddNodes = that.maxUsedBddNodes;
        }

        public void enableMeasurements() {
            this.enabled = true;
        }

        public void disableMeasurements() {
            this.enabled = false;
        }

        public void resetMeasurements() {
            this.maxUsedBddNodes = 0;
        }

        public void newMeasurement(int newUsedBddNodes) {
            this.maxUsedBddNodes = Math.max(newUsedBddNodes, this.maxUsedBddNodes);
        }

        public int getMaxUsedBddNodes() {
            return this.maxUsedBddNodes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Max used BDD nodes: ");
            sb.append(this.maxUsedBddNodes);
            return sb.toString();
        }
    }

    public static class CacheStats {
        protected boolean enabled = false;
        public long uniqueAccess;
        public long uniqueChain;
        public long uniqueHit;
        public long uniqueMiss;
        public long opAccess;
        public long opHit;
        public long opMiss;
        public long swapCount;

        protected CacheStats() {
        }

        void copyFrom(CacheStats that) {
            this.uniqueAccess = that.uniqueAccess;
            this.uniqueChain = that.uniqueChain;
            this.uniqueHit = that.uniqueHit;
            this.uniqueMiss = that.uniqueMiss;
            this.opAccess = that.opAccess;
            this.opHit = that.opHit;
            this.opMiss = that.opMiss;
            this.swapCount = that.swapCount;
        }

        public void enableMeasurements() {
            this.enabled = true;
        }

        public void disableMeasurements() {
            this.enabled = false;
        }

        public void resetMeasurements() {
            this.uniqueAccess = 0L;
            this.uniqueChain = 0L;
            this.uniqueHit = 0L;
            this.uniqueMiss = 0L;
            this.opAccess = 0L;
            this.opHit = 0L;
            this.opMiss = 0L;
            this.swapCount = 0L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String newLine = BDDFactory.getProperty("line.separator", "\n");
            sb.append(newLine);
            sb.append("Cache statistics");
            sb.append(newLine);
            sb.append("----------------");
            sb.append(newLine);
            sb.append("Unique Access:  ");
            sb.append(this.uniqueAccess);
            sb.append(newLine);
            sb.append("Unique Chain:   ");
            sb.append(this.uniqueChain);
            sb.append(newLine);
            sb.append("=> Ave. chain = ");
            if (this.uniqueAccess > 0L) {
                sb.append((float)this.uniqueChain / (float)this.uniqueAccess);
            } else {
                sb.append(0.0f);
            }
            sb.append(newLine);
            sb.append("Unique Hit:     ");
            sb.append(this.uniqueHit);
            sb.append(newLine);
            sb.append("Unique Miss:    ");
            sb.append(this.uniqueMiss);
            sb.append(newLine);
            sb.append("=> Hit rate =   ");
            if (this.uniqueHit + this.uniqueMiss > 0L) {
                sb.append((float)this.uniqueHit / ((float)this.uniqueHit + (float)this.uniqueMiss));
            } else {
                sb.append(0.0f);
            }
            sb.append(newLine);
            sb.append("Operator Access:  ");
            sb.append(this.opAccess);
            sb.append(newLine);
            sb.append("Operator Hits:  ");
            sb.append(this.opHit);
            sb.append(newLine);
            sb.append("Operator Miss:  ");
            sb.append(this.opMiss);
            sb.append(newLine);
            sb.append("=> Hit rate =   ");
            if (this.opHit + this.opMiss > 0L) {
                sb.append((float)this.opHit / ((float)this.opHit + (float)this.opMiss));
            } else {
                sb.append(0.0f);
            }
            sb.append(newLine);
            sb.append("Swap count =    ");
            sb.append(this.swapCount);
            sb.append(newLine);
            return sb.toString();
        }
    }

    public static class ReorderStats {
        public long time;
        public int usednum_before;
        public int usednum_after;

        protected ReorderStats() {
        }

        public int gain() {
            if (this.usednum_before == 0) {
                return 0;
            }
            return 100 * (this.usednum_before - this.usednum_after) / this.usednum_before;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Went from ");
            sb.append(this.usednum_before);
            sb.append(" to ");
            sb.append(this.usednum_after);
            sb.append(" nodes, gain = ");
            sb.append(this.gain());
            sb.append("% (");
            sb.append((float)this.time / 1000.0f);
            sb.append(" sec)");
            return sb.toString();
        }
    }

    public static class GCStats {
        public int nodes;
        public int freenodes;
        public long time;
        public long sumtime;
        public int num;

        protected GCStats() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Garbage collection #");
            sb.append(this.num);
            sb.append(": ");
            sb.append(this.nodes);
            sb.append(" nodes / ");
            sb.append(this.freenodes);
            sb.append(" free");
            sb.append(" / ");
            sb.append((float)this.time / 1000.0f);
            sb.append("s / ");
            sb.append((float)this.sumtime / 1000.0f);
            sb.append("s total");
            return sb.toString();
        }
    }

    public static class ReorderMethod {
        final int id;
        final String name;

        private ReorderMethod(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    protected static class LoadHash {
        int key;
        BDD data;
        int first;
        int next;

        protected LoadHash() {
        }
    }

    public static class BDDOp {
        final int id;
        final String name;

        private BDDOp(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

