/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BitString
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3257570590025265971L;
    private static final int BITS_PER_UNIT = 5;
    private static final int MASK = 31;
    private int[] bits;
    private static final byte[] bytemsb = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    private static int subscript(int bitIndex) {
        return bitIndex >> 5;
    }

    public BitString(int nbits) {
        this.bits = new int[BitString.subscript(nbits + 31)];
    }

    public int firstSet() {
        return this.firstSet(-1);
    }

    public int firstSet(int where) {
        where = where < -1 ? 0 : where + 1;
        int mask = -1 << (where & 0x1F);
        for (int i = BitString.subscript(where); i < this.bits.length; ++i) {
            int unit = this.bits[i] & mask;
            if (unit != 0) {
                return (i << 5) + (BitString.bsf(unit) - 1);
            }
            mask = -1;
        }
        return -1;
    }

    public static final byte popcount(int b) {
        int x = b;
        x -= x >> 1 & 0x55555555;
        int t = x >> 2 & 0x33333333;
        x = (x & 0x33333333) + t;
        x = x + (x >> 4) & 0xF0F0F0F;
        x += x >> 8;
        x += x >> 16;
        return (byte)x;
    }

    public static final byte popcount(long b) {
        long x = b;
        x -= x >> 1 & 0x5555555555555555L;
        long t = x >> 2 & 0x3333333333333333L;
        x = (x & 0x3333333333333333L) + t;
        x = x + (x >> 4) & 0xF0F0F0F0F0F0F0FL;
        x += x >> 8;
        x += x >> 16;
        x += x >> 32;
        return (byte)x;
    }

    public static final int bsf(int b) {
        int t = ~(b | -b);
        return BitString.popcount(t);
    }

    public static final int bsr(int v) {
        if ((v & 0xFFFF0000) != 0) {
            if ((v & 0xFF000000) != 0) {
                return 24 + bytemsb[v >> 24 & 0xFF];
            }
            return 16 + bytemsb[v >> 16];
        }
        if ((v & 0xFF00) != 0) {
            return 8 + bytemsb[v >> 8];
        }
        return bytemsb[v];
    }

    public int lastSet(int where) {
        if (--where < 0) {
            return -1;
        }
        int start = this.bits.length - 1;
        int mask = -1;
        if (BitString.subscript(where) < this.bits.length) {
            start = BitString.subscript(where);
            mask = -1 >>> 31 - (where & mask);
        }
        for (int i = start; i >= 0; --i) {
            int unit = this.bits[i] & mask;
            if (unit != 0) {
                return (i << 5) + (BitString.bsr(unit) - 1);
            }
            mask = -1;
        }
        return -1;
    }

    public int lastSet() {
        return this.lastSet(this.size());
    }

    public void setAll() {
        int i = this.bits.length;
        while (i-- > 0) {
            this.bits[i] = -1;
        }
    }

    public void setUpTo(int bit) {
        int where;
        int n = where = BitString.subscript(bit);
        this.bits[n] = this.bits[n] | (1 << (bit + 1 & 0x1F)) - 1;
        while (where-- > 0) {
            this.bits[where] = -1;
        }
    }

    public void setRange(int lo, int hi) {
        int where2;
        int where1 = BitString.subscript(lo);
        if (where1 == (where2 = BitString.subscript(hi))) {
            while (lo <= hi) {
                int n = where1;
                this.bits[n] = this.bits[n] | 1 << (lo & 0x1F);
                ++lo;
            }
        } else {
            int n = where2;
            this.bits[n] = this.bits[n] | (1 << (hi + 1 & 0x1F)) - 1;
            while (--where2 > where1) {
                this.bits[where2] = -1;
            }
            int n2 = where1;
            this.bits[n2] = this.bits[n2] | -(1 << (lo & 0x1F));
        }
    }

    public void set(int bit) {
        int n = BitString.subscript(bit);
        this.bits[n] = this.bits[n] | 1 << (bit & 0x1F);
    }

    public void clearAll() {
        int i = this.bits.length;
        while (i-- > 0) {
            this.bits[i] = 0;
        }
    }

    public void clearUpTo(int bit) {
        int where;
        int n = where = BitString.subscript(bit);
        this.bits[n] = this.bits[n] & ~((1 << (bit + 1 & 0x1F)) - 1);
        while (where-- > 0) {
            this.bits[where] = 0;
        }
    }

    public void clear(int bit) {
        int n = BitString.subscript(bit);
        this.bits[n] = this.bits[n] & ~(1 << (bit & 0x1F));
    }

    public boolean get(int bit) {
        int n = BitString.subscript(bit);
        return (this.bits[n] & 1 << (bit & 0x1F)) != 0;
    }

    public boolean and(BitString set) {
        if (this == set) {
            return false;
        }
        int n = this.bits.length;
        boolean changed = false;
        int i = n;
        while (i-- > 0) {
            int old = this.bits[i];
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean or(BitString set) {
        if (this == set) {
            return false;
        }
        int setLength = set.bits.length;
        boolean changed = false;
        int i = setLength;
        while (i-- > 0) {
            int old = this.bits[i];
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean or_upTo(BitString set, int bit) {
        boolean result;
        if (this == set) {
            return false;
        }
        int where = BitString.subscript(bit);
        int old = this.bits[where];
        int n = where;
        this.bits[n] = this.bits[n] | set.bits[where] & (1 << (bit + 1 & 0x1F)) - 1;
        boolean bl = result = this.bits[where] != old;
        while (where-- > 0) {
            old = this.bits[where];
            int n2 = where;
            this.bits[n2] = this.bits[n2] | set.bits[where];
            result |= this.bits[where] != old;
        }
        return result;
    }

    public boolean xor(BitString set) {
        int setLength = set.bits.length;
        boolean changed = false;
        int i = setLength;
        while (i-- > 0) {
            int old = this.bits[i];
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean minus(BitString set) {
        int n = this.bits.length;
        boolean changed = false;
        int i = n;
        while (i-- > 0) {
            int old = this.bits[i];
            int n2 = i;
            this.bits[n2] = this.bits[n2] & ~set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean intersectionEmpty(BitString other) {
        int n;
        int i = n = this.bits.length;
        while (i-- > 0) {
            if ((this.bits[i] & other.bits[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BitString other) {
        int n;
        int i = n = this.bits.length;
        while (i-- > 0) {
            if ((this.bits[i] & other.bits[i]) == other.bits[i]) continue;
            return false;
        }
        return true;
    }

    private static void shld(int[] bits, int i1, int i2, int amt) {
        bits[i1] = bits[i1] << amt | bits[i2] << 5 - amt >> 5 - amt;
    }

    public void shl(int amt) {
        int i;
        int div = amt >> 5;
        int mod = amt & 0x1F;
        int size = this.bits.length;
        if (amt < 0) {
            this.shr(-amt);
            return;
        }
        if (div > 0) {
            System.arraycopy(this.bits, 0, this.bits, div, size - div);
            for (i = 0; i < div; ++i) {
                this.bits[i] = 0;
            }
        }
        if (mod > 0) {
            for (i = size - 1; i > div; --i) {
                BitString.shld(this.bits, i, i - 1, mod);
            }
            int n = i;
            this.bits[n] = this.bits[n] << mod;
        }
    }

    private static void shrd(int[] bits, int i1, int i2, int amt) {
        bits[i1] = bits[i1] >>> amt | bits[i2] >>> 5 - amt << 5 - amt;
    }

    public void shr(int amt) {
        int i;
        int div = amt >> 5;
        int mod = amt & 0x1F;
        int size = this.bits.length;
        if (div > 0) {
            System.arraycopy(this.bits, div, this.bits, 0, size - div);
            for (i = size - div; i < size; ++i) {
                this.bits[i] = 0;
            }
        }
        if (mod > 0) {
            for (i = 0; i < size - div - 1; ++i) {
                BitString.shrd(this.bits, i, i + 1, mod);
            }
            int n = i;
            this.bits[n] = this.bits[n] >>> mod;
        }
    }

    public void copyBits(BitString set) {
        System.arraycopy(set.bits, 0, this.bits, 0, Math.min(this.bits.length, set.bits.length));
    }

    public int hashCode() {
        int h = 1234;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (i + 1);
        }
        return h;
    }

    public int length() {
        return this.lastSet() + 1;
    }

    public int size() {
        return this.bits.length << 5;
    }

    public boolean equals(Object obj) {
        BitString set;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        try {
            set = (BitString)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.length() != set.length()) {
            return false;
        }
        for (int n = this.bits.length - 1; n >= 0 && this.bits[n] == 0; --n) {
        }
        for (int i = n; i >= 0; --i) {
            if (this.bits[i] == set.bits[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        int setLength;
        int i = setLength = this.bits.length;
        while (i-- > 0) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int numberOfOnes() {
        int setLength = this.bits.length;
        int number = 0;
        int i = setLength;
        while (i-- > 0) {
            number += BitString.popcount(this.bits[i]);
        }
        return number;
    }

    public int numberOfOnes(int where) {
        int setLength = BitString.subscript(where);
        int number = 0;
        int i = setLength;
        while (i-- > 0) {
            number += BitString.popcount(this.bits[i]);
        }
        return number += BitString.popcount(this.bits[setLength] & (1 << (where + 1 & 0x1F)) - 1);
    }

    public Object clone() {
        BitString result = null;
        try {
            result = (BitString)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean needSeparator = false;
        buffer.append('{');
        ForwardBitStringIterator i = this.iterator();
        while (i.hasNext()) {
            int x = i.nextIndex();
            if (needSeparator) {
                buffer.append(", ");
            } else {
                needSeparator = true;
            }
            buffer.append(x);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public ForwardBitStringIterator iterator() {
        return new ForwardBitStringIterator();
    }

    public ForwardBitStringZeroIterator zeroIterator() {
        return new ForwardBitStringZeroIterator();
    }

    public BackwardBitStringIterator backwardsIterator() {
        return new BackwardBitStringIterator();
    }

    public BackwardBitStringIterator backwardsIterator(int i) {
        return new BackwardBitStringIterator(i);
    }

    public class BackwardBitStringIterator
    extends BitStringIterator {
        private int j;
        private int k;
        private int t;

        BackwardBitStringIterator(int i) {
            this.j = BitString.subscript(i);
            this.t = BitString.this.bits[this.j];
            this.t &= (1 << (i + 1 & 0x1F)) - 1;
            this.k = this.j << 5;
        }

        BackwardBitStringIterator() {
            this.j = BitString.this.bits.length - 1;
            this.t = BitString.this.bits[this.j];
            this.k = this.j << 5;
        }

        @Override
        public boolean hasNext() {
            while (this.t == 0) {
                if (this.j == 0) {
                    return false;
                }
                this.t = BitString.this.bits[--this.j];
                this.k -= 32;
            }
            return true;
        }

        @Override
        public int nextIndex() {
            while (this.t == 0) {
                if (this.j == 0) {
                    throw new NoSuchElementException();
                }
                this.t = BitString.this.bits[--this.j];
                this.k -= 32;
            }
            int index = BitString.bsr(this.t) - 1;
            this.t &= ~(1 << index);
            return this.k + index;
        }
    }

    public class ForwardBitStringZeroIterator
    extends BitStringIterator {
        private int j = 0;
        private int k = 0;
        private int t;

        ForwardBitStringZeroIterator() {
            this.t = ~BitString.this.bits[0];
        }

        @Override
        public boolean hasNext() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    return false;
                }
                this.t = ~BitString.this.bits[++this.j];
                this.k += 32;
            }
            return true;
        }

        @Override
        public int nextIndex() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    throw new NoSuchElementException();
                }
                this.t = ~BitString.this.bits[++this.j];
                this.k += 32;
            }
            int t2 = this.t ^ -this.t;
            int index = 31 - BitString.popcount(t2);
            this.t &= t2;
            return this.k + index;
        }
    }

    public class ForwardBitStringIterator
    extends BitStringIterator {
        private int j = 0;
        private int k = 0;
        private int t;

        ForwardBitStringIterator() {
            this.t = BitString.this.bits[0];
        }

        @Override
        public boolean hasNext() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    return false;
                }
                this.t = BitString.this.bits[++this.j];
                this.k += 32;
            }
            return true;
        }

        @Override
        public int nextIndex() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    throw new NoSuchElementException();
                }
                this.t = BitString.this.bits[++this.j];
                this.k += 32;
            }
            int t2 = this.t ^ -this.t;
            int index = 31 - BitString.popcount(t2);
            this.t &= t2;
            return this.k + index;
        }
    }

    public static abstract class BitStringIterator
    implements Iterator<Integer> {
        public abstract int nextIndex();

        @Override
        public final Integer next() {
            return this.nextIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unmodifiable Iterator");
        }
    }
}

