/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq.assignment;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BoolLiteral;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.CastExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelExpression;
import org.eclipse.escet.chi.metamodel.chi.ConstantReference;
import org.eclipse.escet.chi.metamodel.chi.DictionaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictionaryPair;
import org.eclipse.escet.chi.metamodel.chi.EnumValueReference;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.FunctionReference;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.ListExpression;
import org.eclipse.escet.chi.metamodel.chi.MatrixExpression;
import org.eclipse.escet.chi.metamodel.chi.MatrixRow;
import org.eclipse.escet.chi.metamodel.chi.ModelReference;
import org.eclipse.escet.chi.metamodel.chi.ProcessReference;
import org.eclipse.escet.chi.metamodel.chi.ReadCallExpression;
import org.eclipse.escet.chi.metamodel.chi.RealNumber;
import org.eclipse.escet.chi.metamodel.chi.SetExpression;
import org.eclipse.escet.chi.metamodel.chi.SliceExpression;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.chi.metamodel.chi.TimeLiteral;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.VariableReference;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class AssignmentFunctions {
    private AssignmentFunctions() {
    }

    public static String makeTupleSelection(String tupleVar, List<Integer> rhsIndices) {
        if (rhsIndices == null) {
            return tupleVar;
        }
        for (int index : rhsIndices) {
            tupleVar = String.valueOf(tupleVar) + Strings.fmt((String)".var%d", (Object[])new Object[]{index});
        }
        return tupleVar;
    }

    public static void expressionCollectVariables(Expression expr, Set<VariableDeclaration> vars) {
        if (expr instanceof BoolLiteral) {
            return;
        }
        if (expr instanceof RealNumber) {
            return;
        }
        if (expr instanceof IntNumber) {
            return;
        }
        if (expr instanceof StringLiteral) {
            return;
        }
        if (expr instanceof TimeLiteral) {
            return;
        }
        if (expr instanceof StdLibFunctionReference) {
            return;
        }
        if (expr instanceof ChannelExpression) {
            return;
        }
        if (expr instanceof ModelReference) {
            return;
        }
        if (expr instanceof ProcessReference) {
            return;
        }
        if (expr instanceof FieldReference) {
            return;
        }
        if (expr instanceof EnumValueReference) {
            return;
        }
        if (expr instanceof FunctionReference) {
            return;
        }
        if (expr instanceof ConstantReference) {
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression e = (BinaryExpression)expr;
            AssignmentFunctions.expressionCollectVariables(e.getLeft(), vars);
            AssignmentFunctions.expressionCollectVariables(e.getRight(), vars);
            return;
        }
        if (expr instanceof CallExpression) {
            CallExpression ce = (CallExpression)expr;
            AssignmentFunctions.expressionCollectVariables(ce.getFunction(), vars);
            for (Expression arg : ce.getArguments()) {
                AssignmentFunctions.expressionCollectVariables(arg, vars);
            }
            return;
        }
        if (expr instanceof DictionaryExpression) {
            DictionaryExpression de = (DictionaryExpression)expr;
            for (DictionaryPair pair : de.getPairs()) {
                AssignmentFunctions.expressionCollectVariables(pair.getKey(), vars);
                AssignmentFunctions.expressionCollectVariables(pair.getValue(), vars);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)expr;
            for (Expression tf : te.getFields()) {
                AssignmentFunctions.expressionCollectVariables(tf, vars);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression se = (SetExpression)expr;
            for (Expression elm : se.getElements()) {
                AssignmentFunctions.expressionCollectVariables(elm, vars);
            }
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression le = (ListExpression)expr;
            for (Expression elm : le.getElements()) {
                AssignmentFunctions.expressionCollectVariables(elm, vars);
            }
            return;
        }
        if (expr instanceof MatrixExpression) {
            MatrixExpression me = (MatrixExpression)expr;
            for (MatrixRow row : me.getRows()) {
                for (Expression elm : row.getElements()) {
                    AssignmentFunctions.expressionCollectVariables(elm, vars);
                }
            }
            return;
        }
        if (expr instanceof ReadCallExpression) {
            ReadCallExpression read = (ReadCallExpression)expr;
            if (read.getFile() != null) {
                AssignmentFunctions.expressionCollectVariables(read.getFile(), vars);
            }
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression se = (SliceExpression)expr;
            AssignmentFunctions.expressionCollectVariables(se.getSource(), vars);
            if (se.getStart() != null) {
                AssignmentFunctions.expressionCollectVariables(se.getStart(), vars);
            }
            if (se.getEnd() != null) {
                AssignmentFunctions.expressionCollectVariables(se.getEnd(), vars);
            }
            if (se.getStep() != null) {
                AssignmentFunctions.expressionCollectVariables(se.getStep(), vars);
            }
            return;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)expr;
            AssignmentFunctions.expressionCollectVariables(ue.getChild(), vars);
            return;
        }
        if (expr instanceof VariableReference) {
            VariableReference vr = (VariableReference)expr;
            vars.add(vr.getVariable());
            return;
        }
        if (expr instanceof CastExpression) {
            CastExpression ce = (CastExpression)expr;
            AssignmentFunctions.expressionCollectVariables(ce.getExpression(), vars);
            return;
        }
        Assert.fail((Object)"Unknown type of expression encountered.");
    }
}

