/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.Constants;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.StateLessObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.SliceExpression;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StringTypeID
extends StateLessObjectTypeID {
    public StringTypeID() {
        super(false, TypeID.TypeKind.STRING);
    }

    @Override
    public String getTypeText() {
        return "string";
    }

    @Override
    public String getJavaClassType() {
        return "String";
    }

    @Override
    public String getReadName(String stream, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        String funcPath = "org.eclipse.escet.chi.runtime.IoFunctions.readString";
        jf.addImport(funcPath, true);
        return Strings.fmt((String)"%s(%s)", (Object[])new Object[]{Constants.getClassname(funcPath), stream});
    }

    @Override
    public String getWriteName(String stream, String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        jf.addImport("org.eclipse.escet.chi.runtime.IoFunctions.writeString", true);
        return Strings.fmt((String)"%s(%s, %s);", (Object[])new Object[]{Constants.getClassname("org.eclipse.escet.chi.runtime.IoFunctions.writeString"), stream, val});
    }

    @Override
    public String getToString(String val, JavaFile jf) {
        return val;
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return "\"\"";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof StringLiteral) {
            StringLiteral txt = (StringLiteral)expr;
            String code = Strings.stringToJava((String)txt.getValue());
            return new SimpleExpression(code, (PositionObject)txt);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binexpr = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexpr.getLeft(), ctxt, currentFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexpr.getRight(), ctxt, currentFile);
            String lv = left.getValue();
            String rv = right.getValue();
            switch (binexpr.getOp()) {
                case ADDITION: {
                    List lines = Lists.list();
                    lines.addAll(left.getCode());
                    lines.addAll(right.getCode());
                    String text = Strings.fmt((String)"(%s + %s)", (Object[])new Object[]{lv, rv});
                    return ExpressionBase.makeExpression(lines, text, (PositionObject)expr);
                }
                case PROJECTION: {
                    List lines = Lists.list();
                    lines.addAll(left.getCode());
                    lines.addAll(right.getCode());
                    String line = "org.eclipse.escet.chi.runtime.data.DataSupport.stringProjection";
                    currentFile.addImport(line, true);
                    line = Strings.fmt((String)"stringProjection(%s, %s)", (Object[])new Object[]{lv, rv});
                    return ExpressionBase.makeExpression(lines, line, (PositionObject)expr);
                }
            }
            Assert.fail((Object)("Unexpected binary operator " + binexpr.getOp().toString() + " in StringTypeID.convertExprNode"));
            return null;
        }
        if (expr instanceof SliceExpression) {
            String stepStr;
            String endStr;
            String startStr;
            SliceExpression se = (SliceExpression)expr;
            List lines = Lists.list();
            String srcStr = ctxt.makeUniqueName("str");
            ExpressionBase eb = ExpressionBase.convertExpression(se.getSource(), ctxt, currentFile);
            lines.addAll(eb.getCode());
            lines.add("String " + srcStr + " = " + eb.getValue() + ";");
            if (se.getStart() == null) {
                startStr = "0";
            } else {
                eb = ExpressionBase.convertExpression(se.getStart(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                startStr = eb.getValue();
            }
            if (se.getEnd() == null) {
                endStr = String.valueOf(srcStr) + ".length()";
            } else {
                eb = ExpressionBase.convertExpression(se.getEnd(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                endStr = eb.getValue();
            }
            if (se.getStep() == null) {
                stepStr = "1";
            } else {
                eb = ExpressionBase.convertExpression(se.getStep(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                stepStr = eb.getValue();
            }
            String line = "org.eclipse.escet.chi.runtime.data.DataSupport.stringSlice";
            currentFile.addImport(line, true);
            line = Strings.fmt((String)"stringSlice(%s, %s, %s, %s)", (Object[])new Object[]{srcStr, startStr, endStr, stepStr});
            return ExpressionBase.makeExpression(lines, line, (PositionObject)expr);
        }
        Assert.fail((Object)("Unexpected expression in convertExprNode(" + expr.toString() + "): kind=" + this.kind.toString()));
        return null;
    }
}

