/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.io;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Strings;

public class ChiWriteDataFile
extends ChiFileHandle {
    private FileWriter handle = null;
    private boolean closed = false;

    public ChiWriteDataFile(String absPath) {
        super(absPath, "w");
    }

    private void ensureOpened() {
        if (this.closed) {
            String msg = Strings.fmt((String)"Write-only file \"%s\" has already been closed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg);
        }
        if (this.handle == null) {
            try {
                this.handle = new FileWriter(this.filename);
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Opening of write-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
    }

    @Override
    public int read() {
        String msg = Strings.fmt((String)"Reading from write-only file \"%s\" is not allowed.", (Object[])new Object[]{this.filename});
        throw new InputOutputException(msg);
    }

    @Override
    public void write(String data) {
        this.ensureOpened();
        try {
            this.handle.write(data);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Writing to write-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.handle != null) {
            try {
                this.handle.close();
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Closing of write-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        this.handle = null;
        this.closed = true;
    }

    @Override
    public void flush() {
        try {
            this.handle.flush();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Flushing of write-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    @Override
    public void markStream(int count) {
        String msg = Strings.fmt((String)"Marking of write-only file \"%s\" is not allowed.", (Object[])new Object[]{this.filename});
        throw new InputOutputException(msg);
    }

    @Override
    public void resetStream() {
        String msg = Strings.fmt((String)"Resetting of write-only file \"%s\" is not allowed.", (Object[])new Object[]{this.filename});
        throw new InputOutputException(msg);
    }
}

