/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif.app;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.AnonymizeNames;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.ConvertEventsControllability;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimAutCasts;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimEquations;
import org.eclipse.escet.cif.cif2cif.ElimGroups;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTauEvent;
import org.eclipse.escet.cif.cif2cif.ElimTupleFieldProjs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.EnumsToConsts;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.LiftEvents;
import org.eclipse.escet.cif.cif2cif.LinearizeMerge;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.MergeEnums;
import org.eclipse.escet.cif.cif2cif.PrintFileIntoDecls;
import org.eclipse.escet.cif.cif2cif.RemoveCifSvgDecls;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.RemovePositionInfo;
import org.eclipse.escet.cif.cif2cif.RemovePrintDecls;
import org.eclipse.escet.cif.cif2cif.RemoveRequirements;
import org.eclipse.escet.cif.cif2cif.RemoveUnusedAlgVariables;
import org.eclipse.escet.cif.cif2cif.RemoveUnusedEvents;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesNoRefs;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesNoRefsOptimized;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesOptimized;
import org.eclipse.escet.cif.cif2cif.SvgFileIntoDecls;
import org.eclipse.escet.cif.cif2cif.SwitchesToIfs;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class CifToCifTransOption
extends Option<String> {
    public static final Map<String, Class<? extends CifToCifTransformation>> TRANSFORMATIONS = Maps.map();

    static {
        TRANSFORMATIONS.put("add-default-init-values", AddDefaultInitialValues.class);
        TRANSFORMATIONS.put("anonymize-names", AnonymizeNames.class);
        TRANSFORMATIONS.put("convert-uncntrl-events-to-cntrl", ConvertEventsControllability.ConvertUncntrlEventsToCntrl.class);
        TRANSFORMATIONS.put("convert-cntrl-events-to-uncntrl", ConvertEventsControllability.ConvertCntrlEventsToUncntrl.class);
        TRANSFORMATIONS.put("elim-alg-vars", ElimAlgVariables.class);
        TRANSFORMATIONS.put("elim-aut-casts", ElimAutCasts.class);
        TRANSFORMATIONS.put("elim-comp-def-inst", ElimComponentDefInst.class);
        TRANSFORMATIONS.put("elim-consts", ElimConsts.class);
        TRANSFORMATIONS.put("elim-equations", ElimEquations.class);
        TRANSFORMATIONS.put("elim-groups", ElimGroups.class);
        TRANSFORMATIONS.put("elim-if-updates", ElimIfUpdates.class);
        TRANSFORMATIONS.put("elim-locs-in-exprs", ElimLocRefExprs.class);
        TRANSFORMATIONS.put("elim-monitors", ElimMonitors.class);
        TRANSFORMATIONS.put("elim-self", ElimSelf.class);
        TRANSFORMATIONS.put("elim-state-evt-excl-invs", ElimStateEvtExclInvs.class);
        TRANSFORMATIONS.put("elim-tau-event", ElimTauEvent.class);
        TRANSFORMATIONS.put("elim-tuple-field-projs", ElimTupleFieldProjs.class);
        TRANSFORMATIONS.put("elim-type-decls", ElimTypeDecls.class);
        TRANSFORMATIONS.put("enums-to-consts", EnumsToConsts.class);
        TRANSFORMATIONS.put("enums-to-ints", EnumsToInts.class);
        TRANSFORMATIONS.put("lift-events", LiftEvents.class);
        TRANSFORMATIONS.put("linearize-merge", LinearizeMerge.class);
        TRANSFORMATIONS.put("linearize-product", LinearizeProduct.class);
        TRANSFORMATIONS.put("merge-enums", MergeEnums.class);
        TRANSFORMATIONS.put("print-file-into-decls", PrintFileIntoDecls.class);
        TRANSFORMATIONS.put("remove-cif-svg-decls", RemoveCifSvgDecls.class);
        TRANSFORMATIONS.put("remove-io-decls", RemoveIoDecls.class);
        TRANSFORMATIONS.put("remove-print-decls", RemovePrintDecls.class);
        TRANSFORMATIONS.put("remove-pos-info", RemovePositionInfo.class);
        TRANSFORMATIONS.put("remove-reqs", RemoveRequirements.class);
        TRANSFORMATIONS.put("remove-unused-alg-vars", RemoveUnusedAlgVariables.class);
        TRANSFORMATIONS.put("remove-unused-events", RemoveUnusedEvents.class);
        TRANSFORMATIONS.put("simplify-others", SimplifyOthers.class);
        TRANSFORMATIONS.put("simplify-values", SimplifyValues.class);
        TRANSFORMATIONS.put("simplify-values-optimized", SimplifyValuesOptimized.class);
        TRANSFORMATIONS.put("simplify-values-no-refs", SimplifyValuesNoRefs.class);
        TRANSFORMATIONS.put("simplify-values-no-refs-optimized", SimplifyValuesNoRefsOptimized.class);
        TRANSFORMATIONS.put("svg-file-into-decls", SvgFileIntoDecls.class);
        TRANSFORMATIONS.put("switches-to-ifs", SwitchesToIfs.class);
    }

    public CifToCifTransOption() {
        super("Transformations", "Specifies the CIF to CIF transformations to apply. TRANS consists of comma separated transformation names, in the order they should be applied. If no transformations are applied, the input is only validated and pretty printed. See documentation for more information. [DEFAULT=\"\"].", Character.valueOf('t'), "transformations", "TRANS", true);
    }

    public String getDefault() {
        return "";
    }

    public String parseValue(String optName, String value) {
        CifToCifTransOption.splitValue(value);
        return value;
    }

    protected static List<String> splitValue(String value) {
        String[] parts = value.split(",");
        List rslt = Lists.list();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!(part = part.trim()).isEmpty()) {
                String msg = Strings.fmt((String)"Unknown transformation \"%s\".", (Object[])new Object[]{part});
                CifToCifTransOption.checkValue((boolean)TRANSFORMATIONS.containsKey(part), (String)msg);
                rslt.add(part);
            }
            ++n2;
        }
        return rslt;
    }

    public static List<CifToCifTransformation> getTransformations() {
        String value = (String)Options.get(CifToCifTransOption.class);
        List<String> transNames = CifToCifTransOption.splitValue(value);
        List rslt = Lists.list();
        for (String transName : transNames) {
            CifToCifTransformation trans;
            Class<? extends CifToCifTransformation> transClass = TRANSFORMATIONS.get(transName);
            try {
                trans = transClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String msg = "Failed to instantiate CIF to CIF trans: " + transClass;
                throw new RuntimeException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Failed to instantiate CIF to CIF trans: " + transClass;
                throw new RuntimeException(msg, e);
            }
            catch (SecurityException e) {
                String msg = "Failed to instantiate CIF to CIF trans: " + transClass;
                throw new RuntimeException(msg, e);
            }
            rslt.add(trans);
        }
        return rslt;
    }

    public String[] getCmdLine(Object value) {
        return new String[]{"--transformations=" + (String)value};
    }

    public OptionGroup<String> createOptionGroup(Composite page) {
        return new OptionGroup<String>(page, (Option)this){
            org.eclipse.swt.widgets.List availableList;
            org.eclipse.swt.widgets.List chosenList;
            Label availableLabel;
            Label chosenLabel;
            Button addButton;
            Button removeButton;

            protected void addComponents(Group group) {
                this.addButton = new Button((Composite)group, 8);
                this.addButton.setText("Add");
                FormData addData = new FormData();
                addData.bottom = new FormAttachment(100);
                addData.left = new FormAttachment(0);
                this.addButton.setLayoutData((Object)addData);
                this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int[] nArray = availableList.getSelectionIndices();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int idx = nArray[n2];
                            chosenList.add(availableList.getItem(idx));
                            ++n2;
                        }
                    }
                });
                this.removeButton = new Button((Composite)group, 8);
                this.removeButton.setText("Remove");
                FormData removeData = new FormData();
                removeData.bottom = new FormAttachment(100);
                removeData.right = new FormAttachment(100);
                this.removeButton.setLayoutData((Object)removeData);
                this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        chosenList.remove(chosenList.getSelectionIndices());
                    }
                });
                int listStyle = 2562;
                this.availableLabel = new Label((Composite)group, 0);
                this.availableLabel.setText("Available transformations:");
                FormData availableLabelData = new FormData();
                availableLabelData.top = new FormAttachment((Control)this.descrLabel);
                availableLabelData.left = new FormAttachment(0);
                availableLabelData.right = new FormAttachment(50);
                this.availableLabel.setLayoutData((Object)availableLabelData);
                this.chosenLabel = new Label((Composite)group, 0);
                this.chosenLabel.setText("Chosen transformations:");
                FormData chosenLabelData = new FormData();
                chosenLabelData.top = new FormAttachment((Control)this.descrLabel);
                chosenLabelData.left = new FormAttachment((Control)this.availableLabel);
                this.chosenLabel.setLayoutData((Object)chosenLabelData);
                this.availableList = new org.eclipse.swt.widgets.List((Composite)group, listStyle);
                FormData availableListData = new FormData();
                availableListData.top = new FormAttachment((Control)this.availableLabel);
                availableListData.bottom = new FormAttachment((Control)this.addButton);
                availableListData.left = new FormAttachment(0);
                availableListData.right = new FormAttachment(50);
                this.availableList.setLayoutData((Object)availableListData);
                this.availableList.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int cnt = availableList.getSelectionCount();
                        addButton.setEnabled(cnt > 0);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        addButton.notifyListeners(13, null);
                    }
                });
                this.availableList.notifyListeners(13, null);
                this.chosenList = new org.eclipse.swt.widgets.List((Composite)group, listStyle);
                FormData chosenData = new FormData();
                chosenData.top = new FormAttachment((Control)this.chosenLabel);
                chosenData.bottom = new FormAttachment((Control)this.removeButton);
                chosenData.left = new FormAttachment((Control)this.availableList);
                chosenData.right = new FormAttachment(100);
                this.chosenList.setLayoutData((Object)chosenData);
                this.chosenList.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int cnt = chosenList.getSelectionCount();
                        removeButton.setEnabled(cnt > 0);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        removeButton.notifyListeners(13, null);
                    }
                });
                this.chosenList.notifyListeners(13, null);
                List transNames = Sets.sortedstrings(TRANSFORMATIONS.keySet());
                for (String transName : transNames) {
                    this.availableList.add(transName);
                }
            }

            public String getDescription() {
                return "The CIF to CIF transformations to apply. The transformations are applied in the chosen order. If no transformations are applied, the input is only validated and pretty printed. See documentation for more information.";
            }

            public void setToValue(String value) {
                List<String> transNames = CifToCifTransOption.splitValue(value);
                for (String transName : transNames) {
                    this.chosenList.add(transName);
                }
            }

            public String[] getCmdLine() {
                StringBuilder rslt = new StringBuilder();
                String[] stringArray = this.chosenList.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String transName = stringArray[n2];
                    if (rslt.length() > 0) {
                        rslt.append(",");
                    }
                    rslt.append(transName);
                    ++n2;
                }
                return new String[]{"--transformations=" + rslt.toString()};
            }
        };
    }
}

