/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimLocRefExprs
extends CifWalker
implements CifToCifTransformation,
LocationPointerManager {
    private final Function<Automaton, String> varNamingFunction;
    private final Function<Automaton, String> enumNamingFunction;
    private final Function<Location, String> litNamingFunction;
    private final boolean optimized;
    private final boolean considerLocsForRename;
    private final boolean addInitPreds;
    private final Map<DiscVariable, String> lpVarToAbsAutNameMap;
    private final boolean optInits;
    private final boolean addEdgeGuards;
    private int phase;
    private Map<Automaton, DiscVariable> autToVarMap = Maps.map();
    private Map<Automaton, EnumDecl> autToEnumMap = Maps.map();

    public ElimLocRefExprs() {
        this(a -> "LP", a -> "LPE", l -> "LOC_" + l.getName(), true, true, true, null, true, false);
    }

    public ElimLocRefExprs(Function<Automaton, String> varNamingFunction, Function<Automaton, String> enumNamingFunction, Function<Location, String> litNamingFunction, boolean considerLocsForRename, boolean addInitPreds, boolean optimized, Map<DiscVariable, String> lpVarToAbsAutNameMap, boolean optInits, boolean addEdgeGuards) {
        this.varNamingFunction = varNamingFunction;
        this.enumNamingFunction = enumNamingFunction;
        this.litNamingFunction = litNamingFunction;
        this.considerLocsForRename = considerLocsForRename;
        this.addInitPreds = addInitPreds;
        this.optimized = optimized;
        this.lpVarToAbsAutNameMap = lpVarToAbsAutNameMap;
        this.optInits = optInits;
        this.addEdgeGuards = addEdgeGuards;
    }

    private DiscVariable getLocPointerVar(Automaton aut) {
        if (aut.getLocations().size() == 1) {
            return null;
        }
        DiscVariable var = this.autToVarMap.get(aut);
        if (var == null) {
            EnumDecl enumDecl = this.getLocPointerEnum(aut);
            EnumType enumType = CifConstructors.newEnumType();
            enumType.setEnum(enumDecl);
            String varName = this.varNamingFunction.apply(aut);
            var = CifConstructors.newDiscVariable();
            var.setValue(CifConstructors.newVariableValue());
            var.setName(varName);
            var.setType((CifType)enumType);
            this.autToVarMap.put(aut, var);
            if (this.lpVarToAbsAutNameMap != null) {
                this.lpVarToAbsAutNameMap.put(var, CifTextUtils.getAbsName((PositionObject)aut, (boolean)false));
            }
        }
        return var;
    }

    private EnumDecl getLocPointerEnum(Automaton aut) {
        if (aut.getLocations().size() == 1) {
            return null;
        }
        EnumDecl enumDecl = this.autToEnumMap.get(aut);
        if (enumDecl == null) {
            String enumName = this.enumNamingFunction.apply(aut);
            enumDecl = CifConstructors.newEnumDecl();
            enumDecl.setName(enumName);
            EList literals = enumDecl.getLiterals();
            for (Location loc : aut.getLocations()) {
                String name = loc.getName();
                Assert.notNull((Object)name);
                String litName = this.litNamingFunction.apply(loc);
                EnumLiteral literal = CifConstructors.newEnumLiteral();
                literal.setName(litName);
                literals.add(literal);
            }
            this.autToEnumMap.put(aut, enumDecl);
        }
        return enumDecl;
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating the use of locations in expressions from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.phase = 1;
        if (this.optimized) {
            this.walkSpecification(spec);
        }
        this.phase = 2;
        this.walkSpecification(spec);
    }

    protected void preprocessLocationExpression(LocationExpression locRef) {
        if (this.phase == 1) {
            Location loc = locRef.getLocation();
            Automaton aut = (Automaton)loc.eContainer();
            if (aut.getLocations().size() != 1) {
                this.autToVarMap.put(aut, null);
            }
        } else {
            Location loc = locRef.getLocation();
            Expression pred = this.createLocRef(loc);
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)pred);
        }
    }

    protected void preprocessAutomaton(Automaton aut) {
        if (this.phase == 2) {
            if (this.optimized && !this.autToVarMap.containsKey(aut)) {
                return;
            }
            if (aut.getLocations().size() == 1) {
                return;
            }
            DiscVariable var = this.getLocPointerVar(aut);
            EnumDecl enumDecl = this.getLocPointerEnum(aut);
            this.renameIfNeeded(aut, var, enumDecl);
            aut.getDeclarations().add((Object)var);
            aut.getDeclarations().add((Object)enumDecl);
            this.addInits(aut, var, enumDecl);
            if (this.addEdgeGuards) {
                this.addEdgeGuards(aut, var, enumDecl);
            }
            this.addUpdates(aut, var, enumDecl);
        }
    }

    private void renameIfNeeded(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        String name;
        String oldName;
        Set usedNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)aut, null);
        if (!this.considerLocsForRename) {
            for (Location loc : aut.getLocations()) {
                if (loc.getName() == null) continue;
                usedNames.remove(loc.getName());
            }
        }
        Set avoidNames = Sets.setc((int)(aut.getLocations().size() + 2));
        avoidNames.add(var.getName());
        avoidNames.add(enumDecl.getName());
        for (EnumLiteral literal : enumDecl.getLiterals()) {
            avoidNames.add(literal.getName());
        }
        if (usedNames.contains(var.getName())) {
            oldName = var.getName();
            name = CifScopeUtils.getUniqueName((String)oldName, (Set)usedNames, (Set)avoidNames);
            var.setName(name);
            OutputProvider.warn((String)"Location pointer variable \"%s\" for automaton \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, CifTextUtils.getAbsName((PositionObject)aut), name});
        }
        usedNames.add(var.getName());
        if (usedNames.contains(enumDecl.getName())) {
            oldName = enumDecl.getName();
            name = CifScopeUtils.getUniqueName((String)oldName, (Set)usedNames, (Set)avoidNames);
            enumDecl.setName(name);
            OutputProvider.warn((String)"Enumeration \"%s\", introduced as the type of the location pointer variable for automaton \"%s\", is renamed to \"%s\".", (Object[])new Object[]{oldName, CifTextUtils.getAbsName((PositionObject)aut), name});
        }
        usedNames.add(enumDecl.getName());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            if (usedNames.contains(lit.getName())) {
                String oldName2 = lit.getName();
                String name2 = CifScopeUtils.getUniqueName((String)oldName2, (Set)usedNames, (Set)avoidNames);
                lit.setName(name2);
                OutputProvider.warn((String)"Enumeration literal \"%s\", introduced as a value of the location pointer variable for automaton \"%s\", is renamed to \"%s\".", (Object[])new Object[]{oldName2, CifTextUtils.getAbsName((PositionObject)aut), name2});
            }
            usedNames.add(lit.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addInits(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        EList initials;
        Location loc;
        EList locs = aut.getLocations();
        int initIdx = -1;
        int idx = 0;
        while (idx < locs.size()) {
            block9: {
                loc = (Location)locs.get(idx);
                initials = loc.getInitials();
                if (!initials.isEmpty() && !CifValueUtils.isTriviallyFalse((List)initials, (boolean)true, (boolean)this.optInits)) {
                    if (!initials.isEmpty() && CifValueUtils.isTriviallyTrue((List)initials, (boolean)true, (boolean)this.optInits)) {
                        if (initIdx == -1) {
                            initIdx = idx;
                            break block9;
                        } else {
                            initIdx = -1;
                            break;
                        }
                    }
                    initIdx = -1;
                    break;
                }
            }
            ++idx;
        }
        if (initIdx != -1) {
            EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(initIdx);
            EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
            litRef.setLiteral(literal);
            litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
            VariableValue value = CifConstructors.newVariableValue();
            value.getValues().add((Object)litRef);
            var.setValue(value);
            return;
        }
        if (!this.addInitPreds) {
            return;
        }
        idx = 0;
        while (idx < locs.size()) {
            loc = (Location)locs.get(idx);
            initials = loc.getInitials();
            if (!initials.isEmpty() && !CifValueUtils.isTriviallyFalse((List)initials, (boolean)true, (boolean)this.optInits)) {
                BinaryExpression pred = this.createEquality(var, enumDecl, idx);
                loc.getInitials().add((Object)pred);
            }
            ++idx;
        }
    }

    private void addEdgeGuards(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        EList locs = aut.getLocations();
        int idx = 0;
        while (idx < locs.size()) {
            Location loc = (Location)locs.get(idx);
            for (Edge edge : loc.getEdges()) {
                BinaryExpression guard = this.createEquality(var, enumDecl, idx);
                edge.getGuards().add(0, (Object)guard);
            }
            ++idx;
        }
    }

    private void addUpdates(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        EList locs = aut.getLocations();
        int idx = 0;
        while (idx < locs.size()) {
            Location loc = (Location)locs.get(idx);
            for (Edge edge : loc.getEdges()) {
                if (edge.getTarget() == null || edge.getTarget() == loc) continue;
                Update asgn = this.createLocUpdate(edge.getTarget());
                edge.getUpdates().add((Object)asgn);
            }
            ++idx;
        }
    }

    private BinaryExpression createEquality(DiscVariable var, EnumDecl enumDecl, int idx) {
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(idx);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral(literal);
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        BinaryExpression pred = CifConstructors.newBinaryExpression();
        pred.setOperator(BinaryOperator.EQUAL);
        pred.setLeft((Expression)varRef);
        pred.setRight((Expression)litRef);
        pred.setType((CifType)CifConstructors.newBoolType());
        return pred;
    }

    @Override
    public Expression createLocRef(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        if (aut.getLocations().size() == 1) {
            return CifValueUtils.makeTrue();
        }
        DiscVariable var = this.getLocPointerVar(aut);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        int idx = aut.getLocations().indexOf((Object)loc);
        return this.createEquality(var, enumDecl, idx);
    }

    @Override
    public Update createLocUpdate(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        if (aut.getLocations().size() == 1) {
            return null;
        }
        DiscVariable var = this.getLocPointerVar(aut);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        int targetIdx = aut.getLocations().indexOf((Object)loc);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral((EnumLiteral)enumDecl.getLiterals().get(targetIdx));
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        Assignment asgn = CifConstructors.newAssignment();
        asgn.setAddressable((Expression)varRef);
        asgn.setValue((Expression)litRef);
        return asgn;
    }

    protected void postprocessSwitchExpression(SwitchExpression switchExpr) {
        if (this.phase == 1) {
            return;
        }
        Expression value = switchExpr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        if (!isAutRef) {
            return;
        }
        ComponentType compType = (ComponentType)value.getType();
        Component comp = compType.getComponent();
        Automaton aut = CifScopeUtils.getAutomaton((Component)comp);
        if (aut.getLocations().size() == 1) {
            SwitchCase firstCase = (SwitchCase)Lists.first((List)switchExpr.getCases());
            EMFHelper.updateParentContainment((EObject)switchExpr, (EObject)firstCase.getValue());
            return;
        }
        DiscVariable var = this.getLocPointerVar(aut);
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EMFHelper.updateParentContainment((EObject)value, (EObject)varRef);
    }

    protected void preprocessSwitchCase(SwitchCase cse) {
        if (this.phase == 1) {
            return;
        }
        Expression key = cse.getKey();
        if (key == null) {
            return;
        }
        SwitchExpression switchExpr = (SwitchExpression)cse.eContainer();
        Expression value = switchExpr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        if (!isAutRef) {
            return;
        }
        if (Lists.last((List)switchExpr.getCases()) == cse) {
            cse.setKey(null);
            return;
        }
        Assert.check((boolean)(key instanceof LocationExpression));
        Location loc = ((LocationExpression)key).getLocation();
        Automaton aut = (Automaton)loc.eContainer();
        if (aut.getLocations().size() == 1) {
            return;
        }
        int idx = aut.getLocations().indexOf((Object)loc);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(idx);
        DiscVariable var = this.getLocPointerVar(aut);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral(literal);
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EMFHelper.updateParentContainment((EObject)key, (EObject)litRef);
    }
}

