/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2mcrl2.AutomatonExtractor;
import org.eclipse.escet.cif.cif2mcrl2.Cif2Mcrl2PreChecker;
import org.eclipse.escet.cif.cif2mcrl2.InstanceTreeBuilder;
import org.eclipse.escet.cif.cif2mcrl2.InstanceTreeHelper;
import org.eclipse.escet.cif.cif2mcrl2.InstanceTreeVerifier;
import org.eclipse.escet.cif.cif2mcrl2.NameMaps;
import org.eclipse.escet.cif.cif2mcrl2.options.DebugFileOption;
import org.eclipse.escet.cif.cif2mcrl2.options.DefineInstanceTreeOption;
import org.eclipse.escet.cif.cif2mcrl2.options.EnableDebugOutputOption;
import org.eclipse.escet.cif.cif2mcrl2.options.GenerateValueActionsOption;
import org.eclipse.escet.cif.cif2mcrl2.storage.AutomatonData;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.TextNode;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.StreamCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class Cif2Mcrl2Application
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        Cif2Mcrl2Application cmApp = new Cif2Mcrl2Application();
        cmApp.run(args);
    }

    public Cif2Mcrl2Application() {
    }

    public Cif2Mcrl2Application(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        ProcessNode procRoot;
        Set<VariableData> localVars;
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new ElimComponentDefInst().transform(spec);
        new ElimSelf().transform(spec);
        new ElimAlgVariables().transform(spec);
        new ElimConsts().transform(spec);
        new ElimMonitors().transform(spec);
        new SimplifyValues().transform(spec);
        new AddDefaultInitialValues().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        Cif2Mcrl2PreChecker pca = new Cif2Mcrl2PreChecker();
        pca.checkSpec(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        List enumDecls = Lists.list();
        CifCollectUtils.collectEnumDecls((ComplexComponent)spec, (Collection)enumDecls);
        NameMaps names = new NameMaps(enumDecls);
        AutomatonExtractor ae = new AutomatonExtractor();
        ae.findElements(spec, names);
        List<AutomatonData> autDatas = ae.getAutDatas();
        Set<VariableData> sharedVars = ae.getSharedVariables();
        Set<VariableData> singleUseVars = ae.getSingleUseVariables();
        if (this.isTerminationRequested()) {
            return 0;
        }
        String text = DefineInstanceTreeOption.getTreeText();
        if (text.isEmpty()) {
            localVars = singleUseVars;
            procRoot = InstanceTreeBuilder.buildDefaultTree(autDatas, sharedVars);
        } else {
            TextNode tn = InstanceTreeHelper.parseTreeText(text);
            localVars = InstanceTreeVerifier.checkAndGetLocals(tn, autDatas, sharedVars, singleUseVars);
            procRoot = InstanceTreeBuilder.buildProcessTree(tn, autDatas, sharedVars, singleUseVars);
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        InstanceTreeVerifier.checkProcessTreeShape(procRoot);
        if (this.isTerminationRequested()) {
            return 0;
        }
        procRoot.deriveActions(localVars);
        if (this.isTerminationRequested()) {
            return 0;
        }
        if (EnableDebugOutputOption.getEnableDebugOutput()) {
            String path = DebugFileOption.getDerivedPath(".cif", "_dbg.txt");
            FileAppStream stream = new FileAppStream(path);
            StreamCodeBox code = new StreamCodeBox((AppStream)stream, 4);
            procRoot.dumpActions(code);
            code.close();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        Box code = Cif2Mcrl2Application.generateCode(procRoot, localVars, names);
        if (this.isTerminationRequested()) {
            return 0;
        }
        String outFile = OutputFileOption.getDerivedPath((String)".cif", (String)".mcrl2");
        outFile = Paths.resolve((String)outFile);
        code.writeToFile(outFile);
        return 0;
    }

    private static Box generateCode(ProcessNode procRoot, Set<VariableData> localVars, NameMaps names) {
        VBox code = new VBox();
        for (EnumDecl enumDecl : names.getRepresentativeEnums()) {
            String litNames = enumDecl.getLiterals().stream().map(l -> names.getEnumLitName((EnumLiteral)l)).collect(Collectors.joining(" | "));
            code.add((Box)new TextBox(Strings.fmt((String)"sort %s = struct %s;", (Object[])new Object[]{names.getEnumName(enumDecl), litNames})));
            code.add();
        }
        procRoot.addDefinitions(names, localVars, code);
        HBox hb = new HBox();
        hb.add("act ");
        boolean first = true;
        for (Event evt : procRoot.eventVarUse.keySet()) {
            if (!first) {
                hb.add(", ");
            }
            first = false;
            hb.add(Strings.fmt((String)"%s, %s", (Object[])new Object[]{names.getEventName(evt), names.getRenamedEventName(evt)}));
        }
        hb.add(";");
        code.add((Box)hb);
        code.add();
        VBox vb = new VBox();
        procRoot.addInstantiations(names, localVars, vb);
        code.add((Box)new HBox(new Object[]{"init ", vb, ";"}));
        return code;
    }

    public String getAppName() {
        return "CIF to mCRL2 transformer";
    }

    public String getAppDescription() {
        return "Convert CIF specification to mCRL2.";
    }

    private OptionCategory getConvertOptionsCategory() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(DefineInstanceTreeOption.class));
        options.add(Options.getInstance(GenerateValueActionsOption.class));
        options.add(Options.getInstance(EnableDebugOutputOption.class));
        options.add(Options.getInstance(DebugFileOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        return new OptionCategory("CIF to mCRL2 options", "Options for converting a CIF specification to mCRL2.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(Cif2Mcrl2Application.getGeneralOptionCategory());
        subPages.add(this.getConvertOptionsCategory());
        List options = Lists.list();
        String optDesc = "All options for the conversion from CIF to mCRL2.";
        return new OptionCategory("CIF to mCRL2 conversion options", optDesc, subPages, options);
    }
}

