/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.storage.AutomatonData;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.AutomatonProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.CombinedProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.CombinedTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.ElementaryTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.TextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.VariableProcessNode;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class InstanceTreeVerifier {
    private InstanceTreeVerifier() {
    }

    public static Set<VariableData> checkAndGetLocals(TextNode root, List<AutomatonData> autDatas, Set<VariableData> sharedVars, Set<VariableData> singleUseVars) {
        String msg;
        Map useMap = Maps.map();
        for (AutomatonData autData : autDatas) {
            useMap.put(autData.name, false);
        }
        for (VariableData dv : sharedVars) {
            useMap.put(dv.name, false);
        }
        for (VariableData dv : singleUseVars) {
            useMap.put(dv.name, false);
        }
        Assert.check((useMap.size() == autDatas.size() + sharedVars.size() + singleUseVars.size() ? 1 : 0) != 0);
        List<String> problems = InstanceTreeVerifier.checkNode(root, useMap);
        for (AutomatonData autData : autDatas) {
            if (((Boolean)useMap.get(autData.name)).booleanValue()) continue;
            msg = Strings.fmt((String)"Automaton \"%s\" is missing in the instance tree text.", (Object[])new Object[]{autData.name});
            problems.add(msg);
        }
        for (VariableData dv : sharedVars) {
            if (((Boolean)useMap.get(dv.name)).booleanValue()) continue;
            msg = Strings.fmt((String)"Discrete variable \"%s\" is missing in the instance tree text.", (Object[])new Object[]{dv.name});
            problems.add(msg);
        }
        if (!problems.isEmpty()) {
            Collections.sort(problems, Strings.SORTER);
            String msg2 = "CIF to mCRL2 transformation failed due to missing automata or discrete variables:\n - " + String.join((CharSequence)"\n - ", problems);
            throw new UnsupportedException(msg2);
        }
        Set localVars = Sets.set();
        for (VariableData dv : singleUseVars) {
            if (((Boolean)useMap.get(dv.name)).booleanValue()) {
                OutputProvider.out((String)Strings.fmt((String)"INFO: Discrete variable \"%s\" is instantiated as variable process, but could be a local variable of an automaton process instead.", (Object[])new Object[]{dv.name}));
                continue;
            }
            localVars.add(dv);
        }
        return localVars;
    }

    private static List<String> checkNode(TextNode node, Map<String, Boolean> useMap) {
        if (node instanceof ElementaryTextNode) {
            ElementaryTextNode etn = (ElementaryTextNode)node;
            Boolean used = useMap.get(etn.name);
            if (used == null) {
                return Lists.list((Object)Strings.fmt((String)"Name \"%s\" used in the instance tree text is not an absolute name of an automaton or discrete variable.", (Object[])new Object[]{etn.name}));
            }
            if (used.booleanValue()) {
                return Lists.list((Object)Strings.fmt((String)"Name \"%s\" is included multiple times in the instance tree option text.", (Object[])new Object[]{etn.name}));
            }
            useMap.put(etn.name, true);
            return Lists.list();
        }
        Assert.check((boolean)(node instanceof CombinedTextNode));
        CombinedTextNode ctn = (CombinedTextNode)node;
        List problems = Lists.list();
        for (TextNode n : ctn.children) {
            problems.addAll(InstanceTreeVerifier.checkNode(n, useMap));
        }
        return problems;
    }

    public static void checkProcessTreeShape(ProcessNode root) {
        if (root instanceof AutomatonProcessNode) {
            return;
        }
        if (root instanceof VariableProcessNode) {
            return;
        }
        Assert.check((boolean)(root instanceof CombinedProcessNode));
        InstanceTreeVerifier.checkProcessTreeShape((CombinedProcessNode)root, false);
    }

    private static void checkProcessTreeShape(CombinedProcessNode root, boolean seenBehaviour) {
        if (!seenBehaviour && root.children.size() == 2) {
            ProcessNode ch1 = root.children.get(0);
            ProcessNode ch2 = root.children.get(1);
            if (!(ch1 instanceof VariableProcessNode)) {
                ch1 = root.children.get(1);
                ch2 = root.children.get(0);
            }
            if (ch1 instanceof VariableProcessNode) {
                if (ch2 instanceof VariableProcessNode) {
                    String msg = "Unsupported tree shape. Instance tree has no behavior, please add one or more processes.";
                    throw new UnsupportedException(msg);
                }
                if (ch2 instanceof AutomatonProcessNode) {
                    return;
                }
                Assert.check((boolean)(ch2 instanceof CombinedProcessNode));
                InstanceTreeVerifier.checkProcessTreeShape((CombinedProcessNode)ch2, false);
                return;
            }
        }
        for (ProcessNode pn : root.children) {
            if (!(pn instanceof VariableProcessNode)) continue;
            VariableProcessNode vpn = (VariableProcessNode)pn;
            String msg = Strings.fmt((String)"Unsupported tree shape: Variable \"%s\" should be above all automata in the instance tree and be the only direct child in the parallel composition.", (Object[])new Object[]{vpn.name});
            throw new UnsupportedException(msg);
        }
        for (ProcessNode pn : root.children) {
            if (pn instanceof CombinedProcessNode) {
                InstanceTreeVerifier.checkProcessTreeShape((CombinedProcessNode)pn, true);
                continue;
            }
            Assert.check((boolean)(pn instanceof AutomatonProcessNode));
        }
    }
}

