/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.options;

import org.eclipse.escet.cif.cif2plc.options.PlcNumberBits;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class PlcNumberBitsOption
extends EnumOption<PlcNumberBits> {
    public PlcNumberBitsOption() {
        super("PLC number bits", "BITS is the maximum number of bits supported by the PLC for representing numeric values. Specify \"auto\" to automatically determine the maximum number of bits, \"32\" for 32-bits, or \"64\" for 64-bits. [DEFAULT=auto]", Character.valueOf('b'), "number-bits", "BITS", (Enum)PlcNumberBits.AUTO, true, "The maximum number of bits supported by the PLC for representing numeric values.");
    }

    protected String getDialogText(PlcNumberBits value) {
        return value.dialogText;
    }

    public PlcNumberBits parseValue(String optName, String value) {
        PlcNumberBits[] plcNumberBitsArray = PlcNumberBits.values();
        int n = plcNumberBitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlcNumberBits option = plcNumberBitsArray[n2];
            if (value.equals(option.cmdValueTxt)) {
                return option;
            }
            ++n2;
        }
        throw new InvalidOptionException("Unknown option value: " + value);
    }

    public String[] getCmdLine(Object value) {
        String valueTxt = ((PlcNumberBits)((Object)value)).cmdValueTxt;
        return new String[]{"--" + this.cmdLong + "=" + valueTxt};
    }

    public static PlcNumberBits getNumberBits() {
        return (PlcNumberBits)((Object)Options.get(PlcNumberBitsOption.class));
    }
}

