/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.java.JavaDataValue;
import org.eclipse.escet.cif.codegen.java.JavaExprCodeGen;
import org.eclipse.escet.cif.codegen.java.JavaFunctionCodeGen;
import org.eclipse.escet.cif.codegen.java.JavaTypeCodeGen;
import org.eclipse.escet.cif.codegen.options.JavaPackageOption;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.typechecker.annotations.DocAnnotationProvider;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.JavaCodeUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class JavaCodeGen
extends CodeGen {
    private static final int INDENT = 4;

    public JavaCodeGen() {
        super(TargetLanguage.JAVA, 4);
    }

    @Override
    protected ExprCodeGen getExpressionCodeGenerator() {
        return new JavaExprCodeGen();
    }

    @Override
    protected TypeCodeGen getTypeCodeGenerator() {
        return new JavaTypeCodeGen();
    }

    @Override
    protected void init() {
        super.init();
        this.replacements.put("java-package", JavaPackageOption.getPackage());
        this.replacements.put("java-tuples-code", "");
    }

    @Override
    protected Set<String> getReservedTargetNames() {
        return JavaCodeUtils.JAVA_IDS;
    }

    @Override
    protected Map<String, String> getTemplates() {
        Map templates = Maps.map();
        templates.put("main.txt", ".java");
        templates.put("test.txt", "Test.java");
        return templates;
    }

    @Override
    protected void addConstants(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        int i = 0;
        while (i < this.constants.size()) {
            ExprCode constantCode;
            Constant constant = (Constant)this.constants.get(i);
            String origName = (String)this.origDeclNames.get(constant);
            if (origName == null) {
                origName = constant.getName();
            }
            Assert.check((!(constantCode = ctxt.exprToTarget(constant.getValue(), null)).hasCode() ? 1 : 0) != 0);
            code.add();
            code.add("/** Constant \"%s\". */", new Object[]{origName});
            code.add("public static final %s %s = %s;", new Object[]{this.typeToJava(constant.getType(), ctxt), this.getTargetName((PositionObject)constant), constantCode.getData()});
            ++i;
        }
        this.replacements.put("java-const-decls", code.toString());
    }

    @Override
    protected void addEvents(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        int i = 0;
        while (i < this.events.size()) {
            Event event = (Event)this.events.get(i);
            String name = (String)this.origDeclNames.get(event);
            code.add("%s,", new Object[]{Strings.stringToJava((String)name)});
            ++i;
        }
        this.replacements.put("java-event-name-code", code.toString());
    }

    @Override
    protected void addStateVars(CodeContext ctxt) {
        String name;
        MemoryCodeBox code = this.makeCodeBox(1);
        for (Declaration var : this.stateVars) {
            String kindCode;
            String typeCode;
            name = this.getTargetName((PositionObject)var);
            if (var instanceof DiscVariable) {
                typeCode = this.typeToJava(((DiscVariable)var).getType(), ctxt);
                kindCode = "Discrete";
            } else {
                typeCode = "double";
                kindCode = "Continuous";
            }
            String origName = (String)this.origDeclNames.get(var);
            if (origName == null) {
                origName = CifTextUtils.getName((PositionObject)var);
            }
            code.add();
            code.add("/** %s variable \"%s\". */", new Object[]{kindCode, origName});
            code.add("public %s %s;", new Object[]{typeCode, name});
        }
        this.replacements.put("java-state-decls", code.toString());
        code = this.makeCodeBox(2);
        for (Declaration var : this.stateVars) {
            Expression value;
            name = this.getTargetName((PositionObject)var);
            if (var instanceof DiscVariable) {
                v = (DiscVariable)var;
                Assert.check((v.getValue() != null ? 1 : 0) != 0);
                Assert.check((v.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                value = (Expression)Lists.first((List)v.getValue().getValues());
            } else {
                Assert.check((boolean)(var instanceof ContVariable));
                v = (ContVariable)var;
                value = v.getValue();
            }
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            code.add("%s = %s;", new Object[]{name, valueCode.getData()});
        }
        if (this.stateVars.isEmpty()) {
            code.add("// No state variables, except variable 'time'.");
        }
        this.replacements.put("java-state-init", code.toString());
    }

    @Override
    protected void addContVars(CodeContext ctxt) {
        ContVariable var;
        String origName;
        String name;
        MemoryCodeBox code = this.makeCodeBox(1);
        for (ContVariable var2 : this.contVars) {
            name = this.getTargetName((PositionObject)var2);
            origName = (String)this.origDeclNames.get(var2);
            Assert.notNull((Object)origName);
            code.add();
            code.add("/**");
            code.add(" * Evaluates derivative of continuous variable \"%s\".", new Object[]{origName});
            code.add(" *");
            code.add(" * @return The evaluation result.");
            code.add(" */");
            code.add("public double %sderiv() {", new Object[]{name});
            code.indent();
            Expression deriv = var2.getDerivative();
            Assert.notNull((Object)deriv);
            ExprCode derivCode = ctxt.exprToTarget(deriv, null);
            code.add((Box)derivCode.getCode());
            code.add("return %s;", new Object[]{derivCode.getData()});
            code.dedent();
            code.add("}");
        }
        this.replacements.put("java-deriv-code", code.toString());
        code = this.makeCodeBox(3);
        int i = 0;
        while (i < this.contVars.size()) {
            var = (ContVariable)this.contVars.get(i);
            code.add("double deriv%d = %sderiv();", new Object[]{i, this.getTargetName((PositionObject)var)});
            ++i;
        }
        if (!this.contVars.isEmpty()) {
            code.add();
        }
        i = 0;
        while (i < this.contVars.size()) {
            var = (ContVariable)this.contVars.get(i);
            name = this.getTargetName((PositionObject)var);
            code.add("%s = %s + delta * deriv%d;", new Object[]{name, name, i});
            origName = (String)this.origDeclNames.get(var);
            code.add("checkDouble(%s, %s);", new Object[]{name, Strings.stringToJava((String)origName)});
            code.add("if (%s == -0.0) %s = 0.0;", new Object[]{name, name});
            ++i;
        }
        if (this.contVars.isEmpty()) {
            code.add("// No continuous variables, except variable 'time'.");
        }
        this.replacements.put("java-cont-upd-code", code.toString());
    }

    @Override
    protected void addAlgVars(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (AlgVariable var : this.algVars) {
            String typeCode = this.typeToJava(var.getType(), ctxt);
            String name = this.getTargetName((PositionObject)var);
            String origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add();
            code.add("/**");
            code.add(" * Evaluates algebraic variable \"%s\".", new Object[]{origName});
            code.add(" *");
            code.add(" * @return The evaluation result.");
            code.add(" */");
            code.add("public %s %s() {", new Object[]{typeCode, name});
            code.indent();
            Expression value = var.getValue();
            Assert.notNull((Object)value);
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            code.add("return %s;", new Object[]{valueCode.getData()});
            code.dedent();
            code.add("}");
        }
        this.replacements.put("java-alg-var-code", code.toString());
    }

    @Override
    protected void addInputVars(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (InputVariable var : this.inputVars) {
            String name = this.getTargetName((PositionObject)var);
            String typeCode = this.typeToJava(var.getType(), ctxt);
            String doc = DocAnnotationProvider.getDoc((AnnotatedObject)var);
            String origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add();
            if (doc == null) {
                code.add("/** Input variable \"%s\". */", new Object[]{origName});
            } else {
                code.add("/**");
                code.add(" * Input variable \"%s\".", new Object[]{origName});
                code.add(" *");
                code.add(" * <p>");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    code.add(" * %s", new Object[]{line});
                    ++n2;
                }
                code.add(" * </p>");
                code.add(" */");
            }
            code.add("public %s %s;", new Object[]{typeCode, name});
        }
        this.replacements.put("java-state-input", code.toString());
        code = this.makeCodeBox(2);
        if (this.inputVars.isEmpty()) {
            code.add("// No input variables.");
        } else {
            code.add("// Assign default values to the inputs, for testing.");
            List funcs = Lists.list();
            for (InputVariable var : this.inputVars) {
                String name = this.getTargetName((PositionObject)var);
                CifType type = var.getType();
                Expression value = CifValueUtils.getDefaultValue((CifType)type, (List)funcs);
                ExprCode valueCode = ctxt.exprToTarget(value, null);
                code.add((Box)valueCode.getCode());
                code.add("%s = %s;", new Object[]{name, valueCode.getData()});
            }
            Assert.check((boolean)funcs.isEmpty());
        }
        this.replacements.put("java-test-input-upd", code.toString());
    }

    @Override
    protected void addFunctions(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(1);
        for (InternalFunction func : this.functions) {
            JavaFunctionCodeGen funcGen = new JavaFunctionCodeGen(func);
            funcGen.generate((CodeBox)code, ctxt);
        }
        this.replacements.put("java-funcs-code", code.toString());
    }

    @Override
    protected void addEnum(EnumDecl enumDecl, CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        EList lits = enumDecl.getLiterals();
        int i = 0;
        while (i < lits.size()) {
            String name = ((EnumLiteral)lits.get(i)).getName();
            String line = Strings.fmt((String)"/** %s */ _%s", (Object[])new Object[]{name, name});
            line = String.valueOf(line) + (i == lits.size() - 1 ? ";" : ",");
            code.add(line);
            ++i;
        }
        this.replacements.put("java-enum-lits-code", code.toString());
    }

    @Override
    protected void addPrints(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox(2);
        for (Print print : this.printDecls) {
            boolean[] preAndPost;
            EList printFors = print.getFors();
            List printConds = Lists.list();
            if (printFors.isEmpty()) {
                printConds.add("(true)");
            } else {
                for (PrintFor printFor : printFors) {
                    switch (printFor.getKind()) {
                        case EVENT: {
                            printConds.add("(idx >= -1)");
                            break;
                        }
                        case FINAL: {
                            break;
                        }
                        case INITIAL: {
                            printConds.add("(idx == -3)");
                            break;
                        }
                        case NAME: {
                            Expression eventRef = printFor.getEvent();
                            Assert.check((boolean)(eventRef instanceof EventExpression));
                            Event event = ((EventExpression)eventRef).getEvent();
                            int idx = this.events.indexOf(event);
                            Assert.check((idx >= 0 ? 1 : 0) != 0);
                            printConds.add(Strings.fmt((String)"(idx == %d)", (Object[])new Object[]{idx}));
                            break;
                        }
                        case TIME: {
                            printConds.add("(idx == -2)");
                        }
                    }
                }
            }
            String printCond = printConds.isEmpty() ? "(false)" : (printConds.size() == 1 ? (String)Lists.first((List)printConds) : "(" + String.join((CharSequence)" || ", printConds) + ")");
            code.add("if %s {", new Object[]{printCond});
            code.indent();
            boolean[] blArray = new boolean[2];
            blArray[0] = true;
            boolean[] blArray2 = preAndPost = blArray;
            int n = preAndPost.length;
            int n2 = 0;
            while (n2 < n) {
                Expression txtExpr;
                boolean pre = blArray2[n2];
                Expression whenPred = pre ? print.getWhenPre() : print.getWhenPost();
                Expression expression = txtExpr = pre ? print.getTxtPre() : print.getTxtPost();
                if (txtExpr != null) {
                    code.add("if (%spre) {", new Object[]{pre ? "" : "!"});
                    code.indent();
                    if (whenPred != null) {
                        ExprCode whenCode = ctxt.exprToTarget(whenPred, null);
                        code.add((Box)whenCode.getCode());
                        code.add("if (%s) {", new Object[]{whenCode.getData()});
                        code.indent();
                    }
                    ExprCode txtCode = ctxt.exprToTarget(txtExpr, null);
                    code.add((Box)txtCode.getCode());
                    CifType valueType = txtExpr.getType();
                    valueType = CifTypeUtils.normalizeType((CifType)valueType);
                    if (valueType instanceof StringType) {
                        code.add("String text = %s;", new Object[]{txtCode.getData()});
                    } else {
                        code.add("Object value = %s;", new Object[]{txtCode.getData()});
                        code.add("String text = valueToStr(value);");
                    }
                    String target = print.getFile().getPath();
                    target = Strings.stringToJava((String)target);
                    code.add("infoPrintOutput(text, %s);", new Object[]{target});
                    if (whenPred != null) {
                        code.dedent();
                        code.add("}");
                    }
                    code.dedent();
                    code.add("}");
                }
                ++n2;
            }
            code.dedent();
            code.add("}");
        }
        if (this.printDecls.isEmpty()) {
            code.add("// No print declarations.");
        }
        this.replacements.put("java-print-code", code.toString());
    }

    @Override
    protected void addEdges(CodeContext ctxt) {
        MemoryCodeBox codeCalls = this.makeCodeBox(3);
        MemoryCodeBox codeMethods = this.makeCodeBox(1);
        int i = 0;
        while (i < this.edges.size()) {
            Expression guard;
            Edge edge = (Edge)this.edges.get(i);
            Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
            Event event = eventRef instanceof TauExpression ? null : ((EventExpression)eventRef).getEvent();
            int eventIdx = event == null ? -1 : this.events.indexOf(event);
            String eventName = event == null ? "tau" : (String)this.origDeclNames.get(event);
            Assert.notNull((Object)eventName);
            codeCalls.add("// Event \"%s\".", new Object[]{eventName});
            codeCalls.add("if (execEvent%d()) continue;", new Object[]{i});
            codeCalls.add();
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for event \"%s\".", new Object[]{eventName});
            codeMethods.add(" *");
            codeMethods.add(" * @return {@code true} if the event was executed, {@code false} otherwise.");
            codeMethods.add(" */");
            codeMethods.add("private boolean execEvent%d() {", new Object[]{i});
            codeMethods.indent();
            EList guards = edge.getGuards();
            Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
            Expression expression = guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
            if (guard != null) {
                ExprCode guardCode = ctxt.exprToTarget(guard, null);
                codeMethods.add((Box)guardCode.getCode());
                codeMethods.add("boolean guard = %s;", new Object[]{guardCode.getData()});
                codeMethods.add("if (!guard) return false;");
                codeMethods.add();
            }
            codeMethods.add("if (doInfoPrintOutput) printOutput(%d, true);", new Object[]{eventIdx});
            codeMethods.add("if (doInfoEvent) infoEvent(%d, true);", new Object[]{eventIdx});
            codeMethods.add();
            if (!edge.getUpdates().isEmpty()) {
                this.addUpdates((List<Update>)edge.getUpdates(), (CodeBox)codeMethods, ctxt);
            }
            codeMethods.add();
            codeMethods.add("if (doInfoEvent) infoEvent(%d, false);", new Object[]{eventIdx});
            codeMethods.add("if (doInfoPrintOutput) printOutput(%d, false);", new Object[]{eventIdx});
            codeMethods.add("return true;");
            codeMethods.dedent();
            codeMethods.add("}");
            ++i;
        }
        this.replacements.put("java-event-calls-code", codeCalls.toString());
        this.replacements.put("java-event-methods-code", codeMethods.toString());
    }

    @Override
    protected IfElseGenerator getIfElseUpdateGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt, CodeContext writeCtxt) {
        Assert.check((asgn.rhsProjections == null ? 1 : 0) != 0);
        Assert.check((asgn.lhsProjections == null ? 1 : 0) != 0);
        Assert.check((!asgn.needsRangeBoundCheck() ? 1 : 0) != 0);
        VariableInformation varInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        ExprCode assignment = readCtxt.exprToTarget(value, writeCtxt.makeDestination(varInfo));
        code.add((Box)assignment.getCode());
        Assert.check((!assignment.hasDataValue() ? 1 : 0) != 0);
    }

    @Override
    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt, CodeContext writeCtxt) {
        ArrayTypeInfo arrayTi;
        LhsTupleProjection tupleLhs;
        TupleTypeInfo tupleTi;
        LhsProjection lhsProj;
        VariableInformation fullVarInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        JavaDataValue rhsValue = new JavaDataValue(rhsText);
        if (asgn.lhsProjections == null) {
            CifType assignedType = asgn.getAssignedType();
            TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
            rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, Lists.list(), 0, code, readCtxt);
            fullVarInfo.typeInfo.storeValue(code, rhsValue, writeCtxt.makeDestination(fullVarInfo));
            return;
        }
        String[] indexTexts = new String[asgn.lhsProjections.length];
        List rangeErrorTexts = Lists.list();
        int i = 0;
        while (i < asgn.lhsProjections.length) {
            LhsProjection lhsProj2 = asgn.lhsProjections[i];
            if (lhsProj2 instanceof LhsTupleProjection) {
                LhsTupleProjection tupleProj = (LhsTupleProjection)lhsProj2;
                indexTexts[i] = Integer.toString(tupleProj.fieldNumber);
                rangeErrorTexts.add(new RangeCheckErrorLevelText(false, tupleProj.getSelectedFieldName()));
            } else {
                LhsListProjection listProj = (LhsListProjection)lhsProj2;
                VariableInformation indexVarInfo = writeCtxt.makeTempVariable((CifType)CifConstructors.newIntType(), "index");
                indexTexts[i] = indexVarInfo.targetName;
                rangeErrorTexts.add(new RangeCheckErrorLevelText(true, indexVarInfo.targetName));
                ExprCode indexCode = readCtxt.exprToTarget(listProj.index, null);
                indexVarInfo.typeInfo.declareInit(code, indexCode.getRawDataValue(), writeCtxt.makeDestination(indexVarInfo));
            }
            ++i;
        }
        CifType assignedType = asgn.getAssignedType();
        TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
        rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, rangeErrorTexts, 0, code, readCtxt);
        int last = asgn.lhsProjections.length - 1;
        VariableInformation[] partVariables = new VariableInformation[last];
        int i2 = 0;
        while (i2 < last) {
            ExprCode projectRhs;
            lhsProj = asgn.lhsProjections[i2];
            CifType elementType = CifTypeUtils.normalizeType((CifType)lhsProj.getPartType());
            partVariables[i2] = readCtxt.makeTempVariable(elementType, "part");
            VariableInformation containerInfo = i2 == 0 ? readCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerValue = new ExprCode();
            containerValue.setDataValue(new JavaDataValue(containerInfo.targetName));
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                projectRhs = tupleTi.getProjectedValue(containerValue, tupleLhs.fieldNumber, null, readCtxt);
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexVar = new ExprCode();
                indexVar.setDataValue(new JavaDataValue(indexTexts[i2]));
                projectRhs = arrayTi.getProjectedValue(containerValue, indexVar, null, readCtxt);
            }
            code.add((Box)projectRhs.getCode());
            partVariables[i2].typeInfo.declareInit(code, projectRhs.getRawDataValue(), readCtxt.makeDestination(partVariables[i2]));
            ++i2;
        }
        i2 = last;
        while (i2 >= 0) {
            MemoryCodeBox modify;
            lhsProj = asgn.lhsProjections[i2];
            VariableInformation containerInfo = i2 == 0 ? writeCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerCode = new ExprCode();
            containerCode.setDataValue(new JavaDataValue(containerInfo.targetName));
            ExprCode partCode = new ExprCode();
            if (i2 == last) {
                partCode.setDataValue(rhsValue);
            } else {
                partCode.setDataValue(new JavaDataValue(partVariables[i2].targetName));
            }
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                modify = readCtxt.makeCodeBox();
                modify.add("%s = %s.copy();", new Object[]{containerInfo.targetName, containerInfo.targetName});
                modify.add((Box)tupleTi.modifyContainer(containerInfo, partCode, tupleLhs.fieldNumber, readCtxt));
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexCode = new ExprCode();
                indexCode.setDataValue(new JavaDataValue(indexTexts[i2]));
                modify = arrayTi.modifyContainer(containerInfo, partCode, indexCode, readCtxt);
            }
            code.add((Box)modify);
            --i2;
        }
    }

    @Override
    protected void addUpdatesBeginScope(CodeBox code) {
        code.add("{");
        code.indent();
    }

    @Override
    protected void addUpdatesEndScope(CodeBox code) {
        code.dedent();
        code.add("}");
    }

    @Override
    public Destination makeDestination(VariableInformation varInfo) {
        JavaDataValue dataValue = new JavaDataValue(varInfo.targetName);
        return new Destination(null, varInfo.typeInfo, dataValue);
    }

    private String typeToJava(CifType type, CodeContext ctxt) {
        return ctxt.typeToTarget(type).getTargetType();
    }
}

