/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.java.JavaDataValue;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class JavaExprCodeGen
extends ExprCodeGen {
    private String typeToCastString(CifType type) {
        if (type instanceof BoolType) {
            return "bool";
        }
        if (type instanceof IntType) {
            return "int";
        }
        if (type instanceof RealType) {
            return "real";
        }
        if (type instanceof StringType) {
            return "str";
        }
        String msg = "Unexpected type: " + type;
        throw new RuntimeException(msg);
    }

    @Override
    protected ExprCode convertCastExpression(CifType exprType, CifType childType, Expression child, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(child, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        String childValue = childCode.getData();
        String childPart = this.typeToCastString(childType);
        String resultPart = Strings.makeInitialUppercase((String)this.typeToCastString(exprType));
        String resultText = Strings.fmt((String)"%sTo%s(%s)", (Object[])new Object[]{childPart, resultPart, childValue});
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(resultText));
        return result;
    }

    @Override
    protected ExprCode convertIfExpression(IfExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        ExprCode elseCode = this.exprToTarget(expr.getElse(), null, ctxt);
        Assert.check((!elseCode.hasCode() ? 1 : 0) != 0);
        result.add(elseCode);
        String resultText = elseCode.getData();
        int i = expr.getElifs().size() - 1;
        while (i >= 0) {
            ElifExpression elif = (ElifExpression)expr.getElifs().get(i);
            ExprCode guardCode = this.predsToTarget((List<Expression>)elif.getGuards(), ctxt);
            ExprCode thenCode = this.exprToTarget(elif.getThen(), null, ctxt);
            Assert.check((!guardCode.hasCode() ? 1 : 0) != 0);
            Assert.check((!thenCode.hasCode() ? 1 : 0) != 0);
            resultText = Strings.fmt((String)"(%s) ? %s : (%s)", (Object[])new Object[]{guardCode.getData(), thenCode.getData(), resultText});
            --i;
        }
        ExprCode guardCode = this.predsToTarget((List<Expression>)expr.getGuards(), ctxt);
        ExprCode thenCode = this.exprToTarget(expr.getThen(), null, ctxt);
        Assert.check((!guardCode.hasCode() ? 1 : 0) != 0);
        Assert.check((!thenCode.hasCode() ? 1 : 0) != 0);
        resultText = Strings.fmt((String)"(%s) ? %s : (%s)", (Object[])new Object[]{guardCode.getData(), thenCode.getData(), resultText});
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(resultText));
        return result;
    }

    @Override
    protected ExprCode convertInternalFunctionCall(InternalFunction func, List<ExprCode> argsCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        for (ExprCode argCode : argsCode) {
            result.add(argCode);
        }
        StringBuilder callText = new StringBuilder();
        callText.append(ctxt.getFunctionName(func));
        callText.append('(');
        boolean first = true;
        for (ExprCode argCode : argsCode) {
            if (!first) {
                callText.append(", ");
            }
            first = false;
            callText.append(argCode.getData());
        }
        callText.append(')');
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(callText.toString()));
        return result;
    }

    @Override
    protected ExprCode convertConstantExpression(ConstantExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)expr.getConstant(), false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(varInfo.targetName));
        return result;
    }

    @Override
    public ExprCode convertDiscVariableExpression(DiscVariable discVar, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)discVar, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(varInfo.targetName));
        return result;
    }

    @Override
    protected ExprCode convertAlgVariableExpression(AlgVariable algVar, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)algVar, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        String resultText = varInfo.isTempVar ? varInfo.targetName : Strings.fmt((String)"%s()", (Object[])new Object[]{varInfo.targetName});
        result.setDataValue(new JavaDataValue(resultText));
        result.setDestination(dest);
        return result;
    }

    @Override
    protected ExprCode convertContVariableExpression(ContVariable contVar, boolean isDerivative, Destination dest, CodeContext ctxt) {
        VariableWrapper var = new VariableWrapper((Declaration)contVar, isDerivative);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        String varName = varInfo.targetName;
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        if (!varInfo.isTempVar && isDerivative) {
            String resultText = Strings.fmt((String)"%sderiv()", (Object[])new Object[]{varName});
            result.setDataValue(new JavaDataValue(resultText));
        } else {
            result.setDataValue(new JavaDataValue(varName));
        }
        return result;
    }

    @Override
    protected ExprCode convertInputVariableExpression(InputVariableExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)expr.getVariable(), false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(varInfo.targetName));
        return result;
    }

    @Override
    protected ExprCode predTextsToTarget(List<ExprCode> predCodes, CodeContext ctxt) {
        if (predCodes.isEmpty()) {
            ExprCode result = new ExprCode();
            result.setDataValue(new JavaDataValue("true"));
            return result;
        }
        if (predCodes.size() == 1) {
            return (ExprCode)Lists.first(predCodes);
        }
        ExprCode result = new ExprCode();
        CharSequence[] preds = new String[predCodes.size()];
        int i = 0;
        while (i < predCodes.size()) {
            if (i == 0) {
                result.add(predCodes.get(i));
            } else {
                Assert.check((!predCodes.get(i).hasCode() ? 1 : 0) != 0);
            }
            preds[i] = Strings.fmt((String)"(%s)", (Object[])new Object[]{predCodes.get(i).getData()});
            ++i;
        }
        result.setDataValue(new JavaDataValue(String.join((CharSequence)" && ", preds)));
        return result;
    }
}

