/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.simulink;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.C89ExprCodeGen;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.simulink.SimulinkCodeGenPreChecker;
import org.eclipse.escet.cif.codegen.simulink.typeinfos.SimulinkArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class SimulinkExprCodeGen
extends C89ExprCodeGen {
    public final List<InputVariable> inputVars;
    public final List<ContVariable> contVars;
    private Map<InputVariable, Integer> inputVarMap = null;
    private Map<ContVariable, Integer> contVarMap = null;

    public SimulinkExprCodeGen(List<InputVariable> inputVars, List<ContVariable> contVars) {
        this.inputVars = inputVars;
        this.contVars = contVars;
    }

    @Override
    protected ExprCode convertInternalFunctionCall(InternalFunction func, List<ExprCode> argsCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        for (ExprCode argCode : argsCode) {
            result.add(argCode);
        }
        StringBuilder callText = new StringBuilder();
        callText.append(ctxt.getFunctionName(func));
        callText.append("(sim_struct");
        Assert.check((func.getParameters().size() == argsCode.size() ? 1 : 0) != 0);
        int arg = 0;
        while (arg < func.getParameters().size()) {
            DiscVariable param = ((FunctionParameter)func.getParameters().get(arg)).getParameter();
            TypeInfo paramTi = ctxt.typeToTarget(param.getType());
            ExprCode argCode = argsCode.get(arg);
            callText.append(", ");
            if (C89TypeInfoHelper.typeUsesValues(paramTi)) {
                callText.append(argCode.getData());
            } else {
                String refText = C89DataValue.constructReference(argCode.getRawDataValue(), paramTi, ctxt, result);
                callText.append(refText);
            }
            ++arg;
        }
        callText.append(')');
        CifType retType = CifTypeUtils.makeTupleType((List)func.getReturnTypes(), null);
        TypeInfo retTi = ctxt.typeToTarget(retType);
        boolean needsTemporary = dest == null ? !C89TypeInfoHelper.typeUsesValues(retTi) : false;
        if (needsTemporary) {
            VariableInformation tempVarInfo = ctxt.makeTempVariable(retType, "ret_val");
            result.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tempVarInfo.typeInfo.getTargetType(), tempVarInfo.targetName, callText.toString()}));
            result.setDestination(dest);
            result.setDataValue(C89DataValue.makeValue(tempVarInfo.targetName));
            return result;
        }
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeComputed(callText.toString()));
        return result;
    }

    @Override
    protected ExprCode convertInputVariableExpression(InputVariableExpression expr, Destination dest, CodeContext ctxt) {
        if (this.inputVarMap == null) {
            this.inputVarMap = Maps.mapc((int)this.inputVars.size());
            int i = 0;
            while (i < this.inputVars.size()) {
                this.inputVarMap.put(this.inputVars.get(i), i);
                ++i;
            }
        }
        InputVariable decl = expr.getVariable();
        VariableWrapper var = new VariableWrapper((Declaration)decl, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        int rows = SimulinkCodeGenPreChecker.getRowCount(decl.getType());
        ExprCode result = new ExprCode();
        int index = this.inputVarMap.get(decl);
        MemoryCodeBox code = new MemoryCodeBox(4);
        code.add("if (!work->input_loaded%02d) {", new Object[]{index});
        code.indent();
        code.add("InputRealPtrsType uPtrs = ssGetInputPortRealSignalPtrs(sim_struct, %d);", new Object[]{index});
        if (rows == 0) {
            code.add("%s = %s;", new Object[]{varInfo.targetName, SimulinkArrayTypeInfo.getElementConversionFromSimulinkVector(varInfo.typeInfo, "*uPtrs[0]")});
        } else {
            code.add("%sTypeToSimulink(*uPtrs, &%s)", new Object[]{varInfo.typeInfo.getTypeName(), varInfo.targetName});
        }
        code.add("work->input_loaded%02d = TRUE;", new Object[]{index});
        code.dedent();
        code.add("}");
        result.add((CodeBox)code);
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeValue(varInfo.targetName));
        return result;
    }

    @Override
    protected ExprCode convertAlgVariableExpression(AlgVariable algVar, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)algVar, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        if (varInfo.isTempVar) {
            String resultText = varInfo.targetName;
            result.setDataValue(C89DataValue.makeValue(resultText));
        } else {
            String resultText = Strings.fmt((String)"%s(sim_struct)", (Object[])new Object[]{varInfo.targetName});
            result.setDataValue(C89DataValue.makeComputed(resultText));
        }
        result.setDestination(dest);
        return result;
    }

    @Override
    protected ExprCode convertContVariableExpression(ContVariable contVar, boolean isDerivative, Destination dest, CodeContext ctxt) {
        VariableWrapper var = new VariableWrapper((Declaration)contVar, isDerivative);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        if (!varInfo.isTempVar && isDerivative) {
            if (this.contVarMap == null) {
                this.contVarMap = Maps.mapc((int)this.contVars.size());
                int i = 0;
                while (i < this.contVars.size()) {
                    this.contVarMap.put(this.contVars.get(i), i + 1);
                    ++i;
                }
            }
            String resultText = Strings.fmt((String)"deriv%02d(sim_struct)", (Object[])new Object[]{this.contVarMap.get(contVar)});
            result.setDataValue(C89DataValue.makeComputed(resultText));
        } else {
            result.setDataValue(C89DataValue.makeValue(varInfo.targetName));
        }
        return result;
    }
}

