/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifEvalUtils {
    private CifEvalUtils() {
    }

    public static Expression evalAsExpr(Expression expr, boolean initial) throws CifEvalException {
        Object rslt = CifEvalUtils.eval(expr, initial);
        return CifEvalUtils.valueToExpr(rslt, expr.getType());
    }

    public static Expression valueToExpr(Object value, CifType type) {
        CifType ntype = CifTypeUtils.normalizeType(type);
        if (ntype instanceof BoolType) {
            BoolExpression bexpr = CifConstructors.newBoolExpression();
            bexpr.setValue(((Boolean)value).booleanValue());
            bexpr.setType((CifType)CifConstructors.newBoolType());
            return bexpr;
        }
        if (ntype instanceof IntType) {
            int i = (Integer)value;
            IntType itype = CifConstructors.newIntType();
            itype.setLower(Integer.valueOf(i));
            itype.setUpper(Integer.valueOf(i));
            IntExpression iexpr = CifConstructors.newIntExpression();
            iexpr.setValue(i);
            iexpr.setType((CifType)itype);
            return iexpr;
        }
        if (ntype instanceof EnumType) {
            CifEnumLiteral lit = (CifEnumLiteral)value;
            EnumLiteralExpression rexpr = CifConstructors.newEnumLiteralExpression();
            rexpr.setLiteral(lit.literal);
            rexpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rexpr;
        }
        if (ntype instanceof ListType) {
            ListType ltype = (ListType)ntype;
            List lst = (List)value;
            List elements = Lists.listc((int)lst.size());
            for (Object elem : lst) {
                elements.add(CifEvalUtils.valueToExpr(elem, ltype.getElementType()));
            }
            ListExpression lexpr = CifConstructors.newListExpression();
            lexpr.getElements().addAll((Collection)elements);
            lexpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return lexpr;
        }
        if (ntype instanceof StringType) {
            StringExpression sexpr = CifConstructors.newStringExpression();
            sexpr.setValue((String)value);
            sexpr.setType((CifType)CifConstructors.newStringType());
            return sexpr;
        }
        if (ntype instanceof RealType) {
            double dvalue = (Double)value;
            boolean negate = false;
            if (dvalue < 0.0) {
                dvalue = -dvalue;
                negate = true;
            }
            if (dvalue == -0.0) {
                dvalue = 0.0;
            }
            RealExpression rexpr = CifConstructors.newRealExpression();
            rexpr.setValue(CifMath.realToStr(dvalue));
            rexpr.setType((CifType)CifConstructors.newRealType());
            if (negate) {
                UnaryExpression uexpr = CifConstructors.newUnaryExpression();
                uexpr.setOperator(UnaryOperator.NEGATE);
                uexpr.setChild((Expression)rexpr);
                uexpr.setType((CifType)CifConstructors.newRealType());
                return uexpr;
            }
            return rexpr;
        }
        if (ntype instanceof SetType) {
            SetType stype = (SetType)ntype;
            Set set = (Set)value;
            List elements = Lists.listc((int)set.size());
            for (Object elem : set) {
                elements.add(CifEvalUtils.valueToExpr(elem, stype.getElementType()));
            }
            SetExpression sexpr = CifConstructors.newSetExpression();
            sexpr.getElements().addAll((Collection)elements);
            sexpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return sexpr;
        }
        if (ntype instanceof FuncType) {
            Function func = (Function)value;
            FunctionExpression fexpr = CifConstructors.newFunctionExpression();
            fexpr.setFunction(func);
            fexpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return fexpr;
        }
        if (ntype instanceof DictType) {
            DictType dtype = (DictType)ntype;
            Map map = (Map)value;
            List pairs = Lists.listc((int)map.size());
            for (Map.Entry elem : map.entrySet()) {
                DictPair pair = CifConstructors.newDictPair();
                pair.setKey(CifEvalUtils.valueToExpr(elem.getKey(), dtype.getKeyType()));
                pair.setValue(CifEvalUtils.valueToExpr(elem.getValue(), dtype.getValueType()));
                pairs.add(pair);
            }
            DictExpression dexpr = CifConstructors.newDictExpression();
            dexpr.getPairs().addAll((Collection)pairs);
            dexpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return dexpr;
        }
        if (ntype instanceof TupleType) {
            TupleType ttype = (TupleType)ntype;
            CifTuple tpl = (CifTuple)value;
            List elements = Lists.listc((int)tpl.size());
            int i = 0;
            while (i < tpl.size()) {
                Object elem = tpl.get(i);
                Field field = (Field)ttype.getFields().get(i);
                elements.add(CifEvalUtils.valueToExpr(elem, field.getType()));
                ++i;
            }
            TupleExpression texpr = CifConstructors.newTupleExpression();
            texpr.getFields().addAll((Collection)elements);
            texpr.setType((CifType)EMFHelper.deepclone((EObject)type));
            return texpr;
        }
        if (ntype instanceof DistType) {
            throw new RuntimeException("Value of type dist unexpected.");
        }
        throw new RuntimeException("Unknown/unexpected type: " + ntype);
    }

    public static boolean evalPreds(List<Expression> preds, boolean initial, boolean checkRefs) throws CifEvalException {
        for (Expression pred : preds) {
            boolean value = CifEvalUtils.evalPred(pred, initial, checkRefs);
            if (value) continue;
            return false;
        }
        return true;
    }

    public static boolean evalPred(Expression pred, boolean initial, boolean checkRefs) throws CifEvalException {
        if (!CifValueUtils.hasSingleValue(pred, initial, checkRefs)) {
            String msg = Strings.fmt((String)"Predicate \"%s\" can not statically be evaluated to a single value.", (Object[])new Object[]{CifTextUtils.exprToStr(pred)});
            throw new UnsupportedException(msg);
        }
        Object rslt = CifEvalUtils.eval(pred, initial);
        return (Boolean)rslt;
    }

    public static Object eval(Expression expr, boolean initial) throws CifEvalException {
        if (expr instanceof IntExpression) {
            return ((IntExpression)expr).getValue();
        }
        if (expr instanceof BoolExpression) {
            return ((BoolExpression)expr).isValue();
        }
        if (expr instanceof RealExpression) {
            double rslt;
            RealExpression rexpr = (RealExpression)expr;
            try {
                rslt = CifMath.strToReal(rexpr.getValue(), null);
            }
            catch (CifEvalException e) {
                throw new RuntimeException(e);
            }
            return rslt;
        }
        if (expr instanceof StringExpression) {
            return ((StringExpression)expr).getValue();
        }
        if (expr instanceof TimeExpression) {
            if (initial) {
                return 0.0;
            }
            String msg = "Cannot run-time eval time ref in non-initial state: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof CastExpression) {
            return CifEvalUtils.evalCastExpr((CastExpression)expr, initial);
        }
        if (expr instanceof UnaryExpression) {
            return CifEvalUtils.evalUnaryExpr((UnaryExpression)expr, initial);
        }
        if (expr instanceof BinaryExpression) {
            return CifEvalUtils.evalBinaryExpr((BinaryExpression)expr, initial);
        }
        if (expr instanceof IfExpression) {
            return CifEvalUtils.evalIfExpr((IfExpression)expr, initial);
        }
        if (expr instanceof SwitchExpression) {
            return CifEvalUtils.evalSwitchExpr((SwitchExpression)expr, initial);
        }
        if (expr instanceof ProjectionExpression) {
            return CifEvalUtils.evalProjectionExpr((ProjectionExpression)expr, initial);
        }
        if (expr instanceof SliceExpression) {
            return CifEvalUtils.evalSliceExpr((SliceExpression)expr, initial);
        }
        if (expr instanceof FunctionCallExpression) {
            return CifEvalUtils.evalFuncCallExpr((FunctionCallExpression)expr, initial);
        }
        if (expr instanceof ListExpression) {
            return CifEvalUtils.evalListExpr((ListExpression)expr, initial);
        }
        if (expr instanceof SetExpression) {
            return CifEvalUtils.evalSetExpr((SetExpression)expr, initial);
        }
        if (expr instanceof TupleExpression) {
            return CifEvalUtils.evalTupleExpr((TupleExpression)expr, initial);
        }
        if (expr instanceof DictExpression) {
            return CifEvalUtils.evalDictExpr((DictExpression)expr, initial);
        }
        if (expr instanceof ConstantExpression) {
            return CifEvalUtils.eval(((ConstantExpression)expr).getConstant().getValue(), initial);
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            CifType type = var.getType();
            if (CifValueUtils.hasSingleValue(type)) {
                return CifEvalUtils.eval(type);
            }
            Assert.check((!(var.eContainer() instanceof FunctionParameter) ? 1 : 0) != 0);
            Assert.check((boolean)initial);
            if (var.getValue() == null) {
                List funcs = Lists.list();
                Expression value = CifValueUtils.getDefaultValue(type, funcs);
                Assert.check((boolean)funcs.isEmpty());
                return CifEvalUtils.eval(value, initial);
            }
            if (var.getValue().getValues().size() == 1) {
                Expression value = (Expression)Lists.first((List)var.getValue().getValues());
                return CifEvalUtils.eval(value, initial);
            }
            String msg = "Cannot run-time eval disc var ref: " + var;
            throw new RuntimeException(msg);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifEvalUtils.eval(value, initial);
            }
            if (var.eContainer() instanceof Parameter) {
                return CifEvalUtils.eval(var.getType());
            }
            ComplexComponent comp = (ComplexComponent)var.eContainer();
            for (Equation eq : comp.getEquations()) {
                if (eq.getVariable() != var) continue;
                return CifEvalUtils.eval(eq.getValue(), initial);
            }
            throw new RuntimeException("No equation found: " + var);
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = cexpr.getVariable();
            boolean isDer = cexpr.isDerivative();
            if (isDer) {
                Expression der = var.getDerivative();
                if (der != null) {
                    return CifEvalUtils.eval(der, initial);
                }
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    return CifEvalUtils.eval(eq.getValue(), initial);
                }
                throw new RuntimeException("No equation found: " + var);
            }
            Assert.check((boolean)initial);
            if (var.getValue() == null) {
                return 0.0;
            }
            return CifEvalUtils.eval(var.getValue(), initial);
        }
        if (expr instanceof TauExpression) {
            String msg = "Cannot run-time eval tau ref: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof LocationExpression) {
            Automaton aut;
            Location loc = ((LocationExpression)expr).getLocation();
            EObject parent = loc.eContainer();
            if (parent instanceof Automaton && (aut = (Automaton)parent).getLocations().size() == 1) {
                return true;
            }
            String msg = "Cannot run-time eval location ref: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral lit = ((EnumLiteralExpression)expr).getLiteral();
            return new CifEnumLiteral(lit);
        }
        if (expr instanceof EventExpression) {
            String msg = "Cannot run-time eval event ref: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof FieldExpression) {
            String msg = "Field expr should be handled by projection expr.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Cannot use stdlib func as value: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return ((FunctionExpression)expr).getFunction();
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            return CifEvalUtils.eval(var.getType());
        }
        if (expr instanceof ComponentExpression) {
            String msg = "Cannot use component as value: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof CompParamExpression) {
            String msg = "Cannot use component parameter as value: " + expr;
            throw new RuntimeException(msg);
        }
        if (expr instanceof CompInstWrapExpression) {
            return CifEvalUtils.eval(((CompInstWrapExpression)expr).getReference(), initial);
        }
        if (expr instanceof CompParamWrapExpression) {
            return CifEvalUtils.eval(((CompParamWrapExpression)expr).getReference(), initial);
        }
        if (expr instanceof ReceivedExpression) {
            return CifEvalUtils.eval(expr.getType());
        }
        if (expr instanceof SelfExpression) {
            String msg = "Cannot use \"self\" as value: " + expr;
            throw new RuntimeException(msg);
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    private static Object evalCastExpr(CastExpression expr, boolean initial) throws CifEvalException {
        Expression child = expr.getChild();
        if (CifTypeUtils.isAutRefExpr(child)) {
            Automaton aut;
            CifType ctype = child.getType();
            CifType nctype = CifTypeUtils.normalizeType(ctype);
            if (nctype instanceof ComponentType) {
                Component comp = ((ComponentType)nctype).getComponent();
                aut = CifScopeUtils.getAutomaton(comp);
            } else {
                Assert.check((boolean)(nctype instanceof ComponentDefType));
                ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
            }
            Assert.check((aut.getLocations().size() == 1 ? 1 : 0) != 0);
            Location loc = (Location)Lists.first((List)aut.getLocations());
            return CifLocationUtils.getName(loc);
        }
        Object crslt = CifEvalUtils.eval(expr.getChild(), initial);
        CifType ctype = expr.getChild().getType();
        CifType nctype = CifTypeUtils.normalizeType(ctype);
        CifType ntype = CifTypeUtils.normalizeType(expr.getType());
        if (nctype instanceof IntType && ntype instanceof RealType) {
            int value = (Integer)crslt;
            return CifMath.intToReal(value);
        }
        if (nctype instanceof IntType && ntype instanceof StringType) {
            int value = (Integer)crslt;
            return CifMath.intToStr(value);
        }
        if (nctype instanceof RealType && ntype instanceof StringType) {
            double value = (Double)crslt;
            return CifMath.realToStr(value);
        }
        if (nctype instanceof BoolType && ntype instanceof StringType) {
            boolean value = (Boolean)crslt;
            return CifMath.boolToStr(value);
        }
        if (nctype instanceof StringType && ntype instanceof IntType) {
            String value = (String)crslt;
            return CifMath.strToInt(value, (Expression)expr);
        }
        if (nctype instanceof StringType && ntype instanceof RealType) {
            String value = (String)crslt;
            return CifMath.strToReal(value, (Expression)expr);
        }
        if (nctype instanceof StringType && ntype instanceof BoolType) {
            String value = (String)crslt;
            return CifMath.strToBool(value, (Expression)expr);
        }
        if (CifTypeUtils.checkTypeCompat(nctype, ntype, RangeCompat.EQUAL)) {
            return crslt;
        }
        String msg = "Unknown cast: " + nctype + ", " + ntype;
        throw new RuntimeException(msg);
    }

    private static Object evalUnaryExpr(UnaryExpression expr, boolean initial) throws CifEvalException {
        Object crslt = CifEvalUtils.eval(expr.getChild(), initial);
        switch (expr.getOperator()) {
            case INVERSE: {
                return (Boolean)crslt == false;
            }
            case NEGATE: {
                if (crslt instanceof Integer) {
                    return CifMath.negate((Integer)crslt, (Expression)expr);
                }
                return CifMath.negate((Double)crslt);
            }
            case PLUS: {
                return crslt;
            }
            case SAMPLE: {
                String msg = "Cannot run-time eval sample unop: " + expr;
                throw new RuntimeException(msg);
            }
        }
        String msg = "Unknown unary op: " + expr.getOperator();
        throw new RuntimeException(msg);
    }

    private static Object evalBinaryExpr(BinaryExpression expr, boolean initial) throws CifEvalException {
        Object l = CifEvalUtils.eval(expr.getLeft(), initial);
        switch (expr.getOperator()) {
            case IMPLICATION: {
                if (!((Boolean)l).booleanValue()) {
                    return true;
                }
                Object r = CifEvalUtils.eval(expr.getRight(), initial);
                return r;
            }
            case DISJUNCTION: {
                if (!(l instanceof Boolean)) break;
                if (((Boolean)l).booleanValue()) {
                    return true;
                }
                Object r = CifEvalUtils.eval(expr.getRight(), initial);
                return r;
            }
            case CONJUNCTION: {
                if (!(l instanceof Boolean)) break;
                if (!((Boolean)l).booleanValue()) {
                    return false;
                }
                Object r = CifEvalUtils.eval(expr.getRight(), initial);
                return r;
            }
        }
        Object r = CifEvalUtils.eval(expr.getRight(), initial);
        switch (expr.getOperator()) {
            case BI_CONDITIONAL: {
                return ((Boolean)l).equals(r);
            }
            case DISJUNCTION: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                Set rslt = Sets.copy((Set)lset);
                rslt.addAll(rset);
                return rslt;
            }
            case CONJUNCTION: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                Set rslt = Sets.copy((Set)lset);
                rslt.retainAll(rset);
                return rslt;
            }
            case LESS_THAN: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld < rd) {
                    return true;
                }
                return false;
            }
            case LESS_EQUAL: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld <= rd) {
                    return true;
                }
                return false;
            }
            case GREATER_THAN: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld > rd) {
                    return true;
                }
                return false;
            }
            case GREATER_EQUAL: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld >= rd) {
                    return true;
                }
                return false;
            }
            case EQUAL: {
                return l.equals(r);
            }
            case UNEQUAL: {
                return !l.equals(r);
            }
            case ADDITION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.add((Integer)l, (Integer)r, (Expression)expr);
                }
                if (l instanceof List && r instanceof List) {
                    List llst = (List)l;
                    List rlst = (List)r;
                    List rslt = Lists.listc((int)(llst.size() + rlst.size()));
                    rslt.addAll(llst);
                    rslt.addAll(rlst);
                    return rslt;
                }
                if (l instanceof String && r instanceof String) {
                    return String.valueOf((String)l) + (String)r;
                }
                if (l instanceof Map && r instanceof Map) {
                    Map lmap = (Map)l;
                    Map rmap = (Map)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    rslt.putAll(rmap);
                    return rslt;
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.add(ld, rd, (Expression)expr);
            }
            case SUBTRACTION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.subtract((Integer)l, (Integer)r, (Expression)expr);
                }
                if (l instanceof Set && r instanceof Set) {
                    Set lset = (Set)l;
                    Set rset = (Set)r;
                    Set rslt = Sets.copy((Set)lset);
                    rslt.removeAll(rset);
                    return rslt;
                }
                if (l instanceof Map && r instanceof Map) {
                    Map lmap = (Map)l;
                    Map rmap = (Map)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rmap.keySet()) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                if (l instanceof Map && r instanceof List) {
                    Map lmap = (Map)l;
                    List rlst = (List)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rlst) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                if (l instanceof Map && r instanceof Set) {
                    Map lmap = (Map)l;
                    Set rset = (Set)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rset) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.subtract(ld, rd, (Expression)expr);
            }
            case MULTIPLICATION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.multiply((Integer)l, (Integer)r, (Expression)expr);
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.multiply(ld, rd, (Expression)expr);
            }
            case DIVISION: {
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.divide(ld, rd, (Expression)expr);
            }
            case INTEGER_DIVISION: {
                return CifMath.div((Integer)l, (Integer)r, (Expression)expr);
            }
            case MODULUS: {
                return CifMath.mod((Integer)l, (Integer)r, (Expression)expr);
            }
            case SUBSET: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                return rset.containsAll(lset);
            }
            case ELEMENT_OF: {
                if (r instanceof List) {
                    List list = (List)r;
                    return list.contains(l);
                }
                if (r instanceof Set) {
                    Set set = (Set)r;
                    return set.contains(l);
                }
                Map dict = (Map)r;
                return dict.containsKey(l);
            }
        }
        String msg = "Unknown binary op: " + expr.getOperator();
        throw new RuntimeException(msg);
    }

    private static Object evalIfExpr(IfExpression expr, boolean initial) throws CifEvalException {
        EList guards = expr.getGuards();
        boolean guardsTrue = true;
        for (Expression guard : guards) {
            boolean rslt = (Boolean)CifEvalUtils.eval(guard, initial);
            if (rslt) continue;
            guardsTrue = false;
            break;
        }
        if (guardsTrue) {
            return CifEvalUtils.eval(expr.getThen(), initial);
        }
        for (ElifExpression elif : expr.getElifs()) {
            guards = elif.getGuards();
            guardsTrue = true;
            for (Expression guard : guards) {
                boolean rslt = (Boolean)CifEvalUtils.eval(guard, initial);
                if (rslt) continue;
                guardsTrue = false;
                break;
            }
            if (!guardsTrue) continue;
            return CifEvalUtils.eval(elif.getThen(), initial);
        }
        return CifEvalUtils.eval(expr.getElse(), initial);
    }

    private static Object evalSwitchExpr(SwitchExpression expr, boolean initial) throws CifEvalException {
        Object value = CifTypeUtils.isAutRefExpr(expr.getValue()) ? null : CifEvalUtils.eval(expr.getValue(), initial);
        for (SwitchCase cse : expr.getCases()) {
            boolean match;
            if (cse.getKey() == null) {
                match = true;
            } else if (value == null) {
                match = true;
            } else {
                Object key = CifEvalUtils.eval(cse.getKey(), initial);
                match = value.equals(key);
            }
            if (!match) continue;
            return CifEvalUtils.eval(cse.getValue(), initial);
        }
        throw new RuntimeException("No switch case matches: " + expr);
    }

    private static Object evalProjectionExpr(ProjectionExpression expr, boolean initial) throws CifEvalException {
        Object crslt = CifEvalUtils.eval(expr.getChild(), initial);
        if (crslt instanceof CifTuple && expr.getIndex() instanceof FieldExpression) {
            CifTuple tuple;
            Field field = ((FieldExpression)expr.getIndex()).getField();
            TupleType ttype = (TupleType)field.eContainer();
            int idx = ttype.getFields().indexOf((Object)field);
            Assert.check((idx < (tuple = (CifTuple)crslt).size() ? 1 : 0) != 0);
            return CifMath.project(tuple, idx, null);
        }
        Object irslt = CifEvalUtils.eval(expr.getIndex(), initial);
        if (crslt instanceof List) {
            return CifMath.project((List)crslt, (int)((Integer)irslt), (Expression)expr);
        }
        if (crslt instanceof Map) {
            return CifMath.project((Map)crslt, irslt, (Expression)expr);
        }
        if (crslt instanceof String) {
            return CifMath.project((String)crslt, (int)((Integer)irslt), (Expression)expr);
        }
        if (crslt instanceof CifTuple) {
            return CifMath.project((CifTuple)crslt, (int)((Integer)irslt), (Expression)expr);
        }
        throw new RuntimeException("Unknown projection child.");
    }

    private static Object evalSliceExpr(SliceExpression expr, boolean initial) throws CifEvalException {
        Integer end;
        Object crslt = CifEvalUtils.eval(expr.getChild(), initial);
        Integer begin = expr.getBegin() == null ? null : (Integer)CifEvalUtils.eval(expr.getBegin(), initial);
        Integer n = end = expr.getEnd() == null ? null : (Integer)CifEvalUtils.eval(expr.getEnd(), initial);
        if (crslt instanceof List) {
            return CifMath.slice((List)crslt, begin, end);
        }
        return CifMath.slice((String)crslt, begin, end);
    }

    private static Object evalFuncCallExpr(FunctionCallExpression expr, boolean initial) throws CifEvalException {
        Object[] ps = new Object[expr.getParams().size()];
        int i = 0;
        while (i < expr.getParams().size()) {
            ps[i] = CifEvalUtils.eval((Expression)expr.getParams().get(i), initial);
            ++i;
        }
        Assert.check((boolean)(expr.getFunction() instanceof StdLibFunctionExpression));
        StdLibFunctionExpression stdlibExpr = (StdLibFunctionExpression)expr.getFunction();
        StdLibFunction func = stdlibExpr.getFunction();
        switch (func) {
            case ACOSH: {
                return CifMath.acosh((Double)ps[0], (Expression)expr);
            }
            case ACOS: {
                return CifMath.acos((Double)ps[0], (Expression)expr);
            }
            case ASINH: {
                return CifMath.asinh((Double)ps[0], (Expression)expr);
            }
            case ASIN: {
                return CifMath.asin((Double)ps[0], (Expression)expr);
            }
            case ATANH: {
                return CifMath.atanh((Double)ps[0], (Expression)expr);
            }
            case ATAN: {
                return CifMath.atan((Double)ps[0], (Expression)expr);
            }
            case COSH: {
                return CifMath.cosh((Double)ps[0], (Expression)expr);
            }
            case COS: {
                return CifMath.cos((Double)ps[0], (Expression)expr);
            }
            case SINH: {
                return CifMath.sinh((Double)ps[0], (Expression)expr);
            }
            case SIN: {
                return CifMath.sin((Double)ps[0], (Expression)expr);
            }
            case TANH: {
                return CifMath.tanh((Double)ps[0], (Expression)expr);
            }
            case TAN: {
                return CifMath.tan((Double)ps[0], (Expression)expr);
            }
            case ABS: {
                if (ps[0] instanceof Integer) {
                    return CifMath.abs((Integer)ps[0], (Expression)expr);
                }
                return CifMath.abs((Double)ps[0]);
            }
            case CBRT: {
                return CifMath.cbrt((Double)ps[0]);
            }
            case CEIL: {
                return CifMath.ceil((Double)ps[0], (Expression)expr);
            }
            case DELETE: {
                return CifMath.delete((List)ps[0], (Integer)ps[1], (Expression)expr);
            }
            case EMPTY: {
                if (ps[0] instanceof List) {
                    return ((List)ps[0]).isEmpty();
                }
                if (ps[0] instanceof Set) {
                    return ((Set)ps[0]).isEmpty();
                }
                return ((Map)ps[0]).isEmpty();
            }
            case EXP: {
                return CifMath.exp((Double)ps[0], (Expression)expr);
            }
            case FLOOR: {
                return CifMath.floor((Double)ps[0], (Expression)expr);
            }
            case FORMAT: {
                Object[] args = new Object[ps.length - 1];
                System.arraycopy(ps, 1, args, 0, args.length);
                return CifMath.fmt((String)ps[0], args);
            }
            case LN: {
                return CifMath.ln((Double)ps[0], (Expression)expr);
            }
            case LOG: {
                return CifMath.log((Double)ps[0], (Expression)expr);
            }
            case MAXIMUM: {
                if (ps[0] instanceof Integer && ps[1] instanceof Integer) {
                    return CifMath.max((Integer)ps[0], (Integer)ps[1]);
                }
                double p0 = ps[0] instanceof Integer ? (double)((Integer)ps[0]).intValue() : (Double)ps[0];
                double p1 = ps[1] instanceof Integer ? (double)((Integer)ps[1]).intValue() : (Double)ps[1];
                return CifMath.max(p0, p1);
            }
            case MINIMUM: {
                if (ps[0] instanceof Integer && ps[1] instanceof Integer) {
                    return CifMath.min((Integer)ps[0], (Integer)ps[1]);
                }
                double p0 = ps[0] instanceof Integer ? (double)((Integer)ps[0]).intValue() : (Double)ps[0];
                double p1 = ps[1] instanceof Integer ? (double)((Integer)ps[1]).intValue() : (Double)ps[1];
                return CifMath.min(p0, p1);
            }
            case POP: {
                return CifMath.pop((List)ps[0], (Expression)expr);
            }
            case POWER: {
                int ps1;
                if (ps[0] instanceof Integer && ps[1] instanceof Integer && (ps1 = ((Integer)ps[1]).intValue()) >= 0) {
                    return CifMath.pow((Integer)ps[0], ps1, (Expression)expr);
                }
                double p0 = ps[0] instanceof Integer ? (double)((Integer)ps[0]).intValue() : (Double)ps[0];
                double p1 = ps[1] instanceof Integer ? (double)((Integer)ps[1]).intValue() : (Double)ps[1];
                return CifMath.pow(p0, p1, (Expression)expr);
            }
            case ROUND: {
                return CifMath.round((Double)ps[0], (Expression)expr);
            }
            case SCALE: {
                double[] ds = new double[ps.length];
                int i2 = 0;
                while (i2 < ps.length) {
                    ds[i2] = ps[i2] instanceof Integer ? (double)((Integer)ps[i2]).intValue() : (Double)ps[i2];
                    ++i2;
                }
                return CifMath.scale(ds[0], ds[1], ds[2], ds[3], ds[4], (Expression)expr);
            }
            case SIGN: {
                if (ps[0] instanceof Integer) {
                    return CifMath.sign((Integer)ps[0]);
                }
                return CifMath.sign((Double)ps[0]);
            }
            case SIZE: {
                if (ps[0] instanceof String) {
                    return ((String)ps[0]).length();
                }
                if (ps[0] instanceof List) {
                    return ((List)ps[0]).size();
                }
                if (ps[0] instanceof Set) {
                    return ((Set)ps[0]).size();
                }
                return ((Map)ps[0]).size();
            }
            case SQRT: {
                return CifMath.sqrt((Double)ps[0], (Expression)expr);
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                String msg = "Cannot run-time eval dist stdlib: " + func;
                throw new RuntimeException(msg);
            }
        }
        String msg = "Unknown stdlib func: " + expr.getFunction();
        throw new RuntimeException(msg);
    }

    private static Object evalListExpr(ListExpression expr, boolean initial) throws CifEvalException {
        List list = Lists.listc((int)expr.getElements().size());
        for (Expression elem : expr.getElements()) {
            list.add(CifEvalUtils.eval(elem, initial));
        }
        return list;
    }

    private static Object evalSetExpr(SetExpression expr, boolean initial) throws CifEvalException {
        Set set = Sets.setc((int)expr.getElements().size());
        for (Expression elem : expr.getElements()) {
            set.add(CifEvalUtils.eval(elem, initial));
        }
        return set;
    }

    private static Object evalTupleExpr(TupleExpression expr, boolean initial) throws CifEvalException {
        CifTuple tuple = new CifTuple(expr.getFields().size());
        for (Expression elem : expr.getFields()) {
            tuple.add(CifEvalUtils.eval(elem, initial));
        }
        return tuple;
    }

    private static Object evalDictExpr(DictExpression expr, boolean initial) throws CifEvalException {
        int actualCount;
        Map dict = Maps.mapc((int)expr.getPairs().size());
        for (DictPair pair : expr.getPairs()) {
            dict.put(CifEvalUtils.eval(pair.getKey(), initial), CifEvalUtils.eval(pair.getValue(), initial));
        }
        int expectedCount = expr.getPairs().size();
        if (expectedCount != (actualCount = dict.size())) {
            int duplicates = expectedCount - actualCount;
            Assert.check((duplicates > 0 ? 1 : 0) != 0);
            String msg = Strings.fmt((String)"Dictionary has %d duplicate key%s.", (Object[])new Object[]{duplicates, duplicates == 1 ? "" : "s"});
            throw new CifEvalException(msg, (Expression)expr);
        }
        return dict;
    }

    public static Object eval(CifType type) {
        if (type instanceof BoolType) {
            String msg = "Cannot run-time eval bool type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            Assert.check((boolean)itype.getLower().equals(itype.getUpper()));
            return itype.getLower();
        }
        if (type instanceof RealType) {
            String msg = "Cannot run-time eval real type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof StringType) {
            String msg = "Cannot run-time eval string type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof VoidType) {
            String msg = "Cannot run-time eval void type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof CompInstWrapType) {
            CifType rtype = ((CompInstWrapType)type).getReference();
            return CifEvalUtils.eval(rtype);
        }
        if (type instanceof CompParamWrapType) {
            CifType rtype = ((CompParamWrapType)type).getReference();
            return CifEvalUtils.eval(rtype);
        }
        if (type instanceof ComponentDefType) {
            String msg = "Cannot run-time eval compdef type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof ComponentType) {
            String msg = "Cannot run-time eval component type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof EnumType) {
            EnumDecl edecl = ((EnumType)type).getEnum();
            EList literals = edecl.getLiterals();
            Assert.check((literals.size() == 1 ? 1 : 0) != 0);
            EnumLiteral lit = (EnumLiteral)literals.get(0);
            return new CifEnumLiteral(lit);
        }
        if (type instanceof TypeRef) {
            CifType rtype = ((TypeRef)type).getType().getType();
            return CifEvalUtils.eval(rtype);
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            Assert.check((boolean)ltype.getLower().equals(ltype.getUpper()));
            List rslt = Lists.listc((int)ltype.getLower());
            int i = 0;
            while (i < ltype.getLower()) {
                rslt.add(CifEvalUtils.eval(ltype.getElementType()));
                ++i;
            }
            return rslt;
        }
        if (type instanceof SetType) {
            String msg = "Cannot run-time eval set type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof DictType) {
            String msg = "Cannot run-time eval dict type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            CifTuple tuple = new CifTuple(ttype.getFields().size());
            for (Field field : ttype.getFields()) {
                tuple.add(CifEvalUtils.eval(field.getType()));
            }
            return tuple;
        }
        if (type instanceof DistType) {
            String msg = "Cannot run-time eval dist type: " + type;
            throw new RuntimeException(msg);
        }
        if (type instanceof FuncType) {
            String msg = "Cannot run-time eval func type: " + type;
            throw new RuntimeException(msg);
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public static String objsToStr(List<Object> objs) {
        List txts = Lists.listc((int)objs.size());
        for (Object obj : objs) {
            txts.add(CifEvalUtils.objToStr(obj));
        }
        return String.join((CharSequence)", ", txts);
    }

    public static String objToStr(Object obj) {
        if (obj instanceof Boolean) {
            return CifMath.boolToStr((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return CifMath.intToStr((Integer)obj);
        }
        if (obj instanceof CifEnumLiteral) {
            EnumLiteral lit = ((CifEnumLiteral)obj).literal;
            return lit.getName();
        }
        if (obj instanceof CifTuple) {
            return "(" + CifEvalUtils.objsToStr((CifTuple)obj) + ")";
        }
        if (obj instanceof List) {
            return "[" + CifEvalUtils.objsToStr((List)obj) + "]";
        }
        if (obj instanceof String) {
            return "\"" + Strings.escape((String)((String)obj)) + "\"";
        }
        if (obj instanceof Double) {
            return CifMath.realToStr((Double)obj);
        }
        if (obj instanceof Set) {
            Set set = (Set)obj;
            List txts = Lists.listc((int)set.size());
            for (Object elem : set) {
                txts.add(CifEvalUtils.objToStr(elem));
            }
            return "{" + String.join((CharSequence)", ", txts) + "}";
        }
        if (obj instanceof StdLibFunction) {
            return CifTextUtils.functionToStr((StdLibFunction)obj);
        }
        if (obj instanceof Function) {
            return CifTextUtils.getAbsName((PositionObject)((Function)obj));
        }
        if (obj instanceof Map) {
            Map dict = (Map)obj;
            List txts = Lists.listc((int)dict.size());
            for (Map.Entry entry : dict.entrySet()) {
                txts.add(String.valueOf(CifEvalUtils.objToStr(entry.getKey())) + ": " + CifEvalUtils.objToStr(entry.getValue()));
            }
            return "{" + String.join((CharSequence)", ", txts) + "}";
        }
        if (obj instanceof Component) {
            return CifTextUtils.getAbsName((PositionObject)((Component)obj));
        }
        throw new RuntimeException("Unknown Java obj for CIF value: " + obj);
    }
}

