/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.finiteresponse;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifSortUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.PrepareChecks;
import org.eclipse.escet.cif.controllercheck.finiteresponse.EventLoop;
import org.eclipse.escet.cif.controllercheck.finiteresponse.EventLoopSearch;
import org.eclipse.escet.cif.controllercheck.finiteresponse.FiniteResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.MvSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FiniteResponseChecker {
    private final AppEnvData env = AppEnv.getData();
    private Set<Event> controllableEvents;
    private boolean controllableEventsChanged;
    private Map<Event, Set<Declaration>> eventVarUpdate;
    private VarInfo[] nonCtrlIndependentVarsInfos;
    private Map<Event, Node> globalGuardsByEvent;
    private MvSpecBuilder builder;

    public CheckConclusion checkSystem(PrepareChecks prepareChecks) {
        int oldSize;
        List<Automaton> automata = prepareChecks.getAutomata();
        this.controllableEvents = Sets.copy(prepareChecks.getControllableEvents());
        if (automata.isEmpty() || this.controllableEvents.isEmpty()) {
            return new FiniteResponseCheckConclusion(List.of());
        }
        this.controllableEventsChanged = true;
        this.eventVarUpdate = prepareChecks.getUpdatedVariablesByEvent();
        this.nonCtrlIndependentVarsInfos = null;
        this.globalGuardsByEvent = prepareChecks.getGlobalGuardsByEvent();
        this.builder = prepareChecks.getBuilder();
        Iterator<Event> evtIterator = this.controllableEvents.iterator();
        while (evtIterator.hasNext()) {
            Event evt = evtIterator.next();
            Node n = this.globalGuardsByEvent.get(evt);
            Assert.notNull((Object)n);
            if (n != Tree.ZERO) continue;
            evtIterator.remove();
        }
        if (this.env.isTerminationRequested()) {
            return null;
        }
        int iterationNumber = 1;
        do {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Iteration %d.", (Object[])new Object[]{iterationNumber});
            ++iterationNumber;
            oldSize = this.controllableEvents.size();
            OutputProvider.idbg();
            for (Automaton aut : automata) {
                this.checkAutomaton(aut);
                if (!this.env.isTerminationRequested()) continue;
                OutputProvider.ddbg();
                return null;
            }
            OutputProvider.ddbg();
        } while (oldSize != this.controllableEvents.size() && !this.controllableEvents.isEmpty());
        List orderedEvents = Lists.set2list(this.controllableEvents);
        CifSortUtils.sortCifObjects((List)orderedEvents);
        return new FiniteResponseCheckConclusion(orderedEvents);
    }

    private void checkAutomaton(Automaton aut) {
        if (Sets.isEmptyIntersection((Set)CifEventUtils.getAlphabet((Automaton)aut), this.controllableEvents)) {
            return;
        }
        Set<EventLoop> controllableEventLoops = EventLoopSearch.searchEventLoops(aut, this.controllableEvents, this.env);
        if (this.env.isTerminationRequested()) {
            return;
        }
        if (this.controllableEventsChanged) {
            this.controllableEventsChanged = false;
            BitSet bits = new BitSet(this.builder.cifVarInfoBuilder.varInfos.size());
            for (Event evt : this.controllableEvents) {
                for (Declaration var : this.eventVarUpdate.getOrDefault(evt, Sets.set())) {
                    VarInfo varInfo = this.builder.cifVarInfoBuilder.getVarInfo(var, 1);
                    bits.set(varInfo.level);
                }
            }
            this.nonCtrlIndependentVarsInfos = new VarInfo[bits.cardinality()];
            int nextFree = 0;
            int level = bits.nextSetBit(0);
            while (level >= 0) {
                this.nonCtrlIndependentVarsInfos[nextFree] = (VarInfo)this.builder.cifVarInfoBuilder.varInfos.get(level);
                ++nextFree;
                level = bits.nextSetBit(level + 1);
            }
        }
        if (this.env.isTerminationRequested()) {
            return;
        }
        Set eventsInPotentialControllableLoops = Sets.set();
        if (!controllableEventLoops.isEmpty()) {
            OutputProvider.dbg((String)"The following events have been encountered in a controllable-event loop of automaton %s:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            OutputProvider.idbg();
            for (EventLoop controllableEventLoop : controllableEventLoops) {
                if (this.isUnconnectable(controllableEventLoop, this.nonCtrlIndependentVarsInfos)) {
                    OutputProvider.dbg((String)"%s, which is controllable unconnectable.", (Object[])new Object[]{controllableEventLoop.toString()});
                } else {
                    OutputProvider.dbg((String)"%s, which is not controllable unconnectable.", (Object[])new Object[]{controllableEventLoop.toString()});
                    eventsInPotentialControllableLoops.addAll(controllableEventLoop.events);
                }
                if (!this.env.isTerminationRequested()) continue;
                OutputProvider.ddbg();
                return;
            }
            OutputProvider.ddbg();
        }
        Set eventsInAlphabetNotInLoop = Sets.difference((Collection)CifEventUtils.getAlphabet((Automaton)aut), (Collection)eventsInPotentialControllableLoops);
        this.controllableEventsChanged = this.controllableEvents.removeAll(eventsInAlphabetNotInLoop);
    }

    private boolean isUnconnectable(EventLoop controllableEventLoop, VarInfo[] nonCtrlIndependentVarsInfos) {
        Node n = Tree.ONE;
        for (Event evt : controllableEventLoop.events) {
            Node g = this.globalGuardsByEvent.get(evt);
            Node gAbstract = this.builder.tree.variableAbstractions(g, nonCtrlIndependentVarsInfos);
            if ((n = this.builder.tree.conjunct(n, gAbstract)) != Tree.ZERO) continue;
            return true;
        }
        return false;
    }
}

