/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDD;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisReachability;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.options.BddSimplify;
import org.eclipse.escet.cif.datasynth.options.BddSimplifyOption;
import org.eclipse.escet.cif.datasynth.options.FixedPointComputationsOrderOption;
import org.eclipse.escet.cif.datasynth.options.ForwardReachOption;
import org.eclipse.escet.cif.datasynth.options.StateReqInvEnforceOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.workset.dependencies.BddBasedEdgeDependencySetCreator;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Stopwatch;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifDataSynthesis {
    private CifDataSynthesis() {
    }

    public static void synthesize(SynthesisAutomaton aut, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing, boolean doPrintCtrlSysStates) {
        boolean doForward = ForwardReachOption.isEnabled();
        if (doTiming) {
            timing.preSynth.start();
        }
        try {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.checkSystem(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.applyStateEvtExclPlants(aut, dbgEnabled);
            for (SynthesisEdge edge : aut.edges) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                edge.initApply(doForward);
            }
            if (!aut.plantInv.isOne()) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                CifDataSynthesis.applyStatePlantInvs(aut, dbgEnabled);
            }
        }
        finally {
            if (doTiming) {
                timing.preSynth.stop();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkSystem(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            for (BDD bDD : aut.plantInvsComps) {
                OutputProvider.dbg((String)"Invariant (component state plant invariant): %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (components state plant inv):      %s", (Object[])new Object[]{BddUtils.bddToStr(aut.plantInvComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.plantInvsLocs) {
                OutputProvider.dbg((String)"Invariant (location state plant invariant):  %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (locations state plant invariant): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.plantInvLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Invariant (system state plant invariant):    %s", (Object[])new Object[]{BddUtils.bddToStr(aut.plantInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.plantInv.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no states (taking into account only the state plant invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            for (BDD bDD : aut.reqInvsComps) {
                OutputProvider.dbg((String)"Invariant (component state req invariant):   %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (components state req invariant):  %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInvComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.reqInvsLocs) {
                OutputProvider.dbg((String)"Invariant (location state req invariant):    %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (locations state req invariant):   %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInvLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Invariant (system state req invariant):      %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.reqInv.isZero()) {
            OutputProvider.warn((String)"The controlled system has no states (taking into account only the state requirement invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            void var2_11;
            OutputProvider.dbg();
            boolean bl = false;
            while (var2_11 < aut.variables.length) {
                SynthesisVariable var = aut.variables[var2_11];
                if (var instanceof SynthesisDiscVariable) {
                    String nr = String.valueOf((int)var2_11);
                    OutputProvider.dbg((String)"Initial   (discrete variable %s):%s%s", (Object[])new Object[]{nr, Strings.spaces((int)(14 - nr.length())), BddUtils.bddToStr(aut.initialsVars.get((int)var2_11), aut)});
                }
                ++var2_11;
            }
            OutputProvider.dbg((String)"Initial   (discrete variables):              %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialVars, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.initialsComps) {
                OutputProvider.dbg((String)"Initial   (component init predicate):        %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Initial   (components init predicate):       %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.initialsLocs) {
                OutputProvider.dbg((String)"Initial   (aut/locs init predicate):         %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Initial   (auts/locs init predicate):        %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial   (uncontrolled system):             %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialUnctrl, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial   (system, combined init/plant inv): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialPlantInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial   (system, combined init/state inv): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.initialUnctrl.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no initial state (taking into account only initialization).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!aut.initialUnctrl.isZero() && !aut.plantInv.isZero() && aut.initialPlantInv.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no initial state (taking into account only initialization and state plant invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!(aut.initialPlantInv.isZero() || aut.initialUnctrl.isZero() || aut.plantInv.isZero() || aut.reqInv.isZero() || !aut.initialInv.isZero())) {
            OutputProvider.warn((String)"The controlled system has no initial state (taking into account both initialization and state invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            for (BDD bDD : aut.markedsComps) {
                OutputProvider.dbg((String)"Marked    (component marker predicate):      %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Marked    (components marker predicate):     %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.markedsLocs) {
                OutputProvider.dbg((String)"Marked    (aut/locs marker predicate):       %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Marked    (auts/locs marker predicate):      %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Marked    (uncontrolled system):             %s", (Object[])new Object[]{BddUtils.bddToStr(aut.marked, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Marked    (system, combined mark/plant inv): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedPlantInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Marked    (system, combined mark/state inv): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.marked.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no marked state (taking into account only marking).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!aut.marked.isZero() && !aut.plantInv.isZero() && aut.markedPlantInv.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no marked state (taking into account only marking and state plant invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!(aut.markedPlantInv.isZero() || aut.marked.isZero() || aut.plantInv.isZero() || aut.reqInv.isZero() || !aut.markedInv.isZero())) {
            OutputProvider.warn((String)"The controlled system has no marked state (taking into account both marking and state invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"State/event exclusion plants:");
            if (aut.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"  None");
            }
            for (Map.Entry entry : aut.stateEvtExclPlantLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                OutputProvider.dbg((String)"  Event \"%s\" needs:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    OutputProvider.dbg((String)"    %s", (Object[])new Object[]{BddUtils.bddToStr(pred, aut)});
                }
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"State/event exclusion requirements:");
            if (aut.stateEvtExclReqLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"  None");
            }
            for (Map.Entry entry : aut.stateEvtExclReqLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                OutputProvider.dbg((String)"  Event \"%s\" needs:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    OutputProvider.dbg((String)"    %s", (Object[])new Object[]{BddUtils.bddToStr(pred, aut)});
                }
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            if (aut.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"Uncontrolled system:");
            } else {
                OutputProvider.dbg((String)"Uncontrolled system (state/event exclusion plants not applied yet):");
            }
            OutputProvider.dbg((String)aut.toString(1));
        }
        for (BDD bDD : aut.plantInvsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.plantInvsLocs) {
            bDD.free();
        }
        aut.plantInvComps.free();
        aut.plantInvLocs.free();
        if (StateReqInvEnforceOption.getMode() == StateReqInvEnforceOption.StateReqInvEnforceMode.ALL_CTRL_BEH) {
            for (BDD bDD : aut.reqInvsComps) {
                bDD.free();
            }
            for (BDD bDD : aut.reqInvsLocs) {
                bDD.free();
            }
        }
        aut.reqInvComps.free();
        aut.reqInvLocs.free();
        for (BDD bDD : aut.initialsVars) {
            if (bDD == null) continue;
            bDD.free();
        }
        for (BDD bDD : aut.initialsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.initialsLocs) {
            bDD.free();
        }
        aut.initialVars.free();
        aut.initialComps.free();
        aut.initialLocs.free();
        aut.initialInv.free();
        for (BDD bDD : aut.markedsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.markedsLocs) {
            bDD.free();
        }
        aut.markedComps.free();
        aut.markedLocs.free();
        aut.markedPlantInv.free();
        aut.markedInv.free();
        for (List list : aut.stateEvtExclPlantLists.values()) {
            for (BDD pred : list) {
                pred.free();
            }
        }
        for (List list : aut.stateEvtExclReqLists.values()) {
            for (BDD pred : list) {
                pred.free();
            }
        }
        aut.plantInvsComps = null;
        aut.plantInvComps = null;
        aut.plantInvsLocs = null;
        aut.plantInvLocs = null;
        if (StateReqInvEnforceOption.getMode() == StateReqInvEnforceOption.StateReqInvEnforceMode.ALL_CTRL_BEH) {
            aut.reqInvsComps = null;
            aut.reqInvsLocs = null;
        }
        aut.reqInvComps = null;
        aut.reqInvLocs = null;
        aut.initialsVars = null;
        aut.initialVars = null;
        aut.initialsComps = null;
        aut.initialComps = null;
        aut.initialsLocs = null;
        aut.initialLocs = null;
        aut.initialInv = null;
        aut.markedsComps = null;
        aut.markedComps = null;
        aut.markedsLocs = null;
        aut.markedLocs = null;
        aut.markedPlantInv = null;
        aut.markedInv = null;
        aut.stateEvtExclPlantLists = null;
        aut.stateEvtExclReqLists = null;
    }

    private static void applyStateEvtExclPlants(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting behavior using state/event exclusion plants.");
        }
        boolean firstDbg = true;
        boolean guardChanged = false;
        for (SynthesisEdge edge : aut.edges) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD plant = aut.stateEvtExclPlants.get(edge.event);
            if (plant == null || plant.isOne() || edge.guard.isZero()) continue;
            BDD newGuard = edge.guard.and(plant);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (firstDbg) {
                    firstDbg = false;
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Edge %s: guard: %s -> %s [plant: %s].", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut), BddUtils.bddToStr(plant, aut)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardChanged = true;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && guardChanged) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Uncontrolled system:");
            OutputProvider.dbg((String)aut.toString(1, guardChanged));
        }
    }

    private static void applyStatePlantInvs(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting uncontrolled behavior using state plant invariants.");
        }
        boolean guardUpdated = false;
        for (SynthesisEdge edge : aut.edges) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD updPred = aut.plantInv.id();
            edge.preApply(false, null);
            updPred = edge.apply(updPred, false, false, null, false);
            edge.postApply(false);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD guardAndPlantInv = edge.guard.and(aut.plantInv);
            BDD implication = guardAndPlantInv.imp(updPred);
            boolean skip = implication.isOne();
            guardAndPlantInv.free();
            implication.free();
            if (skip) {
                updPred.free();
                updPred = aut.factory.one();
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (!guardUpdated) {
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Edge %s: guard: %s -> %s.", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
    }

    private static void applyStateReqInvs(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting behavior using state requirements.");
        }
        StateReqInvEnforceOption.StateReqInvEnforceMode enforceMode = StateReqInvEnforceOption.getMode();
        switch (enforceMode) {
            case ALL_CTRL_BEH: {
                BDD newCtrlBeh = aut.ctrlBeh.and(aut.reqInv);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                    newCtrlBeh.free();
                    break;
                }
                if (dbgEnabled) {
                    OutputProvider.dbg((String)"Controlled behavior: %s -> %s [state requirements: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut), BddUtils.bddToStr(aut.reqInv, aut)});
                }
                aut.ctrlBeh.free();
                aut.ctrlBeh = newCtrlBeh;
                break;
            }
            case PER_EDGE: {
                List reqInvs = Lists.concat(aut.reqInvsComps, aut.reqInvsLocs);
                Function<SynthesisEdge, Stream<BDD>> reqsPerEdge = edge -> reqInvs.stream().map(reqInv -> {
                    BDD updPred = reqInv.id();
                    edge.preApply(false, null);
                    updPred = edge.apply(updPred, false, false, null, false);
                    edge.postApply(false);
                    if (updPred.isOne()) {
                        return updPred;
                    }
                    if (synthesisAutomaton.env.isTerminationRequested()) {
                        return updPred;
                    }
                    BDD guardAndReqInv = synthesisEdge.guard.and(reqInv);
                    BDD implication = guardAndReqInv.imp(updPred);
                    boolean skip = implication.isOne();
                    guardAndReqInv.free();
                    implication.free();
                    if (skip) {
                        updPred.free();
                        updPred = synthesisAutomaton.factory.one();
                    }
                    return updPred;
                });
                CifDataSynthesis.applyReqsPerEdge(aut, reqsPerEdge, true, dbgEnabled, "state");
                BDD newInitialCtrl = aut.initialCtrl.and(aut.reqInv);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (aut.initialCtrl.equals((Object)newInitialCtrl)) {
                    newInitialCtrl.free();
                } else {
                    if (dbgEnabled) {
                        OutputProvider.dbg((String)"Controlled initialization: %s -> %s [state requirements: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.initialCtrl, aut), BddUtils.bddToStr(newInitialCtrl, aut), BddUtils.bddToStr(aut.reqInv, aut)});
                    }
                    aut.initialCtrl.free();
                    aut.initialCtrl = newInitialCtrl;
                }
                for (BDD bdd : aut.reqInvsComps) {
                    bdd.free();
                }
                for (BDD bdd : aut.reqInvsLocs) {
                    bdd.free();
                }
                aut.reqInvsComps = null;
                aut.reqInvsLocs = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mode: " + (Object)((Object)enforceMode));
            }
        }
    }

    private static void applyVarRanges(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Extending controlled-behavior predicate using variable ranges.");
        }
        boolean firstDbg = true;
        boolean changed = false;
        SynthesisVariable[] synthesisVariableArray = aut.variables;
        int n = aut.variables.length;
        int n2 = 0;
        while (n2 < n) {
            SynthesisVariable var = synthesisVariableArray[n2];
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD range = BddUtils.getVarDomain(var, false, aut.factory);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newCtrlBeh = aut.ctrlBeh.and(range);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                range.free();
            } else {
                if (dbgEnabled) {
                    if (firstDbg) {
                        firstDbg = false;
                        OutputProvider.dbg();
                    }
                    OutputProvider.dbg((String)"Controlled behavior: %s -> %s [range: %s, variable: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut), BddUtils.bddToStr(range, aut), var.toString(0, "")});
                }
                range.free();
                aut.ctrlBeh.free();
                aut.ctrlBeh = newCtrlBeh;
                changed = true;
            }
            ++n2;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && changed) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Extended controlled-behavior predicate using variable ranges: %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut)});
        }
    }

    private static void applyStateEvtExclReqs(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting behavior using state/event exclusion requirements.");
        }
        Function<SynthesisEdge, Stream<BDD>> reqsPerEdge = edge -> {
            BDD req = synthesisAutomaton.stateEvtExclReqs.get(edge.event);
            return req == null ? Stream.empty() : Stream.of(req);
        };
        CifDataSynthesis.applyReqsPerEdge(aut, reqsPerEdge, false, dbgEnabled, "state/event exclusion");
        for (BDD bdd : aut.stateEvtExclReqs.values()) {
            bdd.free();
        }
        aut.stateEvtExclReqs = null;
    }

    private static void applyReqsPerEdge(SynthesisAutomaton aut, Function<SynthesisEdge, Stream<BDD>> reqsPerEdge, boolean freeReqs, boolean dbgEnabled, String dbgDescription) {
        boolean firstDbg = true;
        boolean changed = false;
        boolean guardChanged = false;
        for (SynthesisEdge edge : aut.edges) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            Stream<BDD> reqsStream = reqsPerEdge.apply(edge);
            Iterable reqsIterable = () -> reqsStream.iterator();
            for (BDD req : reqsIterable) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (req.isOne()) continue;
                if (edge.event.getControllable().booleanValue()) {
                    BDD newGuard = edge.guard.and(req);
                    if (aut.env.isTerminationRequested()) {
                        return;
                    }
                    if (edge.guard.equals((Object)newGuard)) {
                        newGuard.free();
                    } else {
                        if (dbgEnabled) {
                            if (firstDbg) {
                                firstDbg = false;
                                OutputProvider.dbg();
                            }
                            OutputProvider.dbg((String)"Edge %s: guard: %s -> %s [%s requirement: %s].", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut), dbgDescription, BddUtils.bddToStr(req, aut)});
                        }
                        edge.guard.free();
                        edge.guard = newGuard;
                        changed = true;
                        guardChanged = true;
                    }
                } else {
                    BDD reqGood = edge.guard.imp(req);
                    if (aut.env.isTerminationRequested()) {
                        return;
                    }
                    BDD newCtrlBeh = aut.ctrlBeh.id().andWith(reqGood);
                    if (aut.env.isTerminationRequested()) {
                        return;
                    }
                    if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                        newCtrlBeh.free();
                    } else {
                        if (dbgEnabled) {
                            if (firstDbg) {
                                firstDbg = false;
                                OutputProvider.dbg();
                            }
                            OutputProvider.dbg((String)"Controlled behavior: %s -> %s [%s requirement: %s, edge: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut), dbgDescription, BddUtils.bddToStr(req, aut), edge.toString(0, "")});
                        }
                        aut.ctrlBeh.free();
                        aut.ctrlBeh = newCtrlBeh;
                        changed = true;
                    }
                }
                if (!freeReqs) continue;
                req.free();
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && changed) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricted behavior using %s requirements:", (Object[])new Object[]{dbgDescription});
            OutputProvider.dbg((String)aut.toString(1, guardChanged));
        }
    }

    private static void checkInputEdges(SynthesisAutomaton aut) {
        aut.disabledEvents = Sets.setc((int)aut.alphabet.size());
        for (Event event : aut.alphabet) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.inputVarEvents.contains(event)) continue;
            if (aut.eventEdges.get(event) == null) {
                aut.disabledEvents.add(event);
                continue;
            }
            if (aut.stateEvtExclPlants.get(event).isZero()) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion plants.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            if (event.getControllable().booleanValue() && aut.stateEvtExclsReqInvs.get(event).isZero()) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion requirements.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            if (aut.eventEdges.get(event).stream().filter(edge -> !edge.origGuard.isZero()).count() == 0L) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only automaton guards.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            boolean alwaysDisabled = true;
            for (SynthesisEdge edge2 : aut.eventEdges.get(event)) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                BDD enabledExpression = edge2.guard.and(aut.reqInv);
                if ((enabledExpression = enabledExpression.andWith(aut.plantInv.id())).isZero()) continue;
                enabledExpression.free();
                alwaysDisabled = false;
                break;
            }
            if (!alwaysDisabled) continue;
            OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account automaton guards and invariants.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            aut.disabledEvents.add(event);
        }
    }

    private static void prepareWorksetAlgorithm(SynthesisAutomaton aut, boolean dbgEnabled) {
        int edgeCnt;
        boolean forwardEnabled = ForwardReachOption.isEnabled();
        BddBasedEdgeDependencySetCreator creator = new BddBasedEdgeDependencySetCreator();
        creator.createAndStore(aut, forwardEnabled);
        if (dbgEnabled && (edgeCnt = aut.worksetDependenciesBackward.size()) > 0) {
            Object bitset;
            GridBox box;
            if (forwardEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Edge workset algorithm forward dependencies:");
                box = new GridBox(edgeCnt, 4, 0, 1);
                int i = 0;
                while (i < edgeCnt) {
                    bitset = aut.worksetDependenciesForward.get(i);
                    box.set(i, 0, " -");
                    box.set(i, 1, String.valueOf(Integer.toString(i + 1)) + ":");
                    box.set(i, 2, CifTextUtils.getAbsName((PositionObject)aut.orderedEdgesForward.get((int)i).event));
                    box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                    ++i;
                }
                for (String line : box.getLines()) {
                    OutputProvider.dbg((String)line);
                }
            }
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Edge workset algorithm backward dependencies:");
            box = new GridBox(edgeCnt, 4, 0, 1);
            int i = 0;
            while (i < edgeCnt) {
                bitset = aut.worksetDependenciesBackward.get(i);
                box.set(i, 0, " -");
                box.set(i, 1, String.valueOf(Integer.toString(i + 1)) + ":");
                box.set(i, 2, CifTextUtils.getAbsName((PositionObject)aut.orderedEdgesBackward.get((int)i).event));
                box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                ++i;
            }
            for (String line : box.getLines()) {
                OutputProvider.dbg((String)line);
            }
        }
    }

    private static void synthesizeFixedPoints(SynthesisAutomaton aut, boolean doForward, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing) {
        List<FixedPointComputationsOrderOption.FixedPointComputation> computationsInOrder = FixedPointComputationsOrderOption.getOrder().computations;
        if (!doForward) {
            computationsInOrder = computationsInOrder.stream().filter(c -> c != FixedPointComputationsOrderOption.FixedPointComputation.REACH).toList();
        }
        int numberOfComputations = computationsInOrder.size();
        int round = 0;
        int stableCount = 0;
        block31: while (true) {
            ++round;
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: started.", (Object[])new Object[]{round});
            }
            for (FixedPointComputationsOrderOption.FixedPointComputation fixedPointComputation : computationsInOrder) {
                boolean changed;
                BDD newCtrlBeh;
                BDD reachabilityResult;
                boolean applyForward;
                boolean badStates;
                BDD restriction;
                String restrictionName;
                String initName;
                String predName;
                BDD startPred = switch (fixedPointComputation) {
                    case FixedPointComputationsOrderOption.FixedPointComputation.NONBLOCK -> aut.marked.id();
                    case FixedPointComputationsOrderOption.FixedPointComputation.CTRL -> aut.ctrlBeh.not();
                    case FixedPointComputationsOrderOption.FixedPointComputation.REACH -> aut.initialCtrl.id();
                    default -> throw new IncompatibleClassChangeError();
                };
                if (fixedPointComputation == FixedPointComputationsOrderOption.FixedPointComputation.CTRL && aut.env.isTerminationRequested()) {
                    return;
                }
                boolean inclUnctrl = true;
                boolean inclCtrl = switch (fixedPointComputation) {
                    case FixedPointComputationsOrderOption.FixedPointComputation.NONBLOCK -> {
                        predName = "backward controlled-behavior";
                        initName = "marker";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = aut.ctrlBeh;
                        badStates = false;
                        applyForward = false;
                        yield true;
                    }
                    case FixedPointComputationsOrderOption.FixedPointComputation.CTRL -> {
                        predName = "backward uncontrolled bad-state";
                        initName = "current/previous controlled behavior";
                        restrictionName = null;
                        restriction = null;
                        badStates = true;
                        applyForward = false;
                        yield false;
                    }
                    case FixedPointComputationsOrderOption.FixedPointComputation.REACH -> {
                        predName = "forward controlled-behavior";
                        initName = "initialization";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = aut.ctrlBeh;
                        badStates = false;
                        applyForward = true;
                        yield true;
                    }
                    default -> throw new RuntimeException("Unknown fixed-point computation: " + (Object)((Object)fixedPointComputation));
                };
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputationsOrderOption.FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                        case FixedPointComputationsOrderOption.FixedPointComputation.CTRL -> timing.mainBwBadState;
                        case FixedPointComputationsOrderOption.FixedPointComputation.REACH -> timing.mainFwInit;
                        default -> throw new IncompatibleClassChangeError();
                    };
                    stopwatch.start();
                }
                try {
                    CifDataSynthesisReachability reachability = new CifDataSynthesisReachability(aut, round, predName, initName, restrictionName, restriction, badStates, applyForward, inclCtrl, true, dbgEnabled);
                    reachabilityResult = reachability.performReachability(startPred);
                }
                catch (Throwable throwable) {
                    if (doTiming) {
                        Stopwatch stopwatch = switch (fixedPointComputation) {
                            case FixedPointComputationsOrderOption.FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                            case FixedPointComputationsOrderOption.FixedPointComputation.CTRL -> timing.mainBwBadState;
                            case FixedPointComputationsOrderOption.FixedPointComputation.REACH -> timing.mainFwInit;
                            default -> throw new IncompatibleClassChangeError();
                        };
                        stopwatch.stop();
                    }
                    throw throwable;
                }
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputationsOrderOption.FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                        case FixedPointComputationsOrderOption.FixedPointComputation.CTRL -> timing.mainBwBadState;
                        case FixedPointComputationsOrderOption.FixedPointComputation.REACH -> timing.mainFwInit;
                        default -> throw new IncompatibleClassChangeError();
                    };
                    stopwatch.stop();
                }
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                switch (fixedPointComputation) {
                    case NONBLOCK: 
                    case REACH: {
                        newCtrlBeh = reachabilityResult;
                        break;
                    }
                    case CTRL: {
                        newCtrlBeh = reachabilityResult.not();
                        reachabilityResult.free();
                        if (!aut.env.isTerminationRequested()) break;
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown fixed-point computation: " + (Object)((Object)fixedPointComputation));
                    }
                }
                boolean unchanged = aut.ctrlBeh.equals((Object)newCtrlBeh);
                boolean bl = changed = !unchanged;
                if (unchanged) {
                    newCtrlBeh.free();
                    ++stableCount;
                } else {
                    if (dbgEnabled) {
                        OutputProvider.dbg((String)"Controlled behavior: %s -> %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut)});
                    }
                    aut.ctrlBeh.free();
                    aut.ctrlBeh = newCtrlBeh;
                    stableCount = 1;
                }
                BDD ctrlStates = aut.ctrlBeh.and(aut.plantInv);
                boolean noCtrlStates = ctrlStates.isZero();
                ctrlStates.free();
                if (noCtrlStates) {
                    if (!dbgEnabled) break block31;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, all states are bad.", (Object[])new Object[]{round});
                    break block31;
                }
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (stableCount == numberOfComputations) {
                    if (!dbgEnabled) break block31;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, controlled behavior is stable.", (Object[])new Object[]{round});
                    break block31;
                }
                if (!changed || fixedPointComputation == FixedPointComputationsOrderOption.FixedPointComputation.REACH) continue;
                BDD init = aut.initialCtrl.and(aut.ctrlBeh);
                boolean noInit = init.isZero();
                init.free();
                if (noInit) {
                    if (!dbgEnabled) break block31;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, no initialization possible.", (Object[])new Object[]{round});
                    break block31;
                }
                if (!aut.env.isTerminationRequested()) continue;
                return;
            }
            if (!dbgEnabled) continue;
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Round %d: finished, need another round.", (Object[])new Object[]{round});
        }
    }

    private static void determineCtrlSysGuards(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Computing controlled system guards.");
        }
        boolean guardUpdated = false;
        for (SynthesisEdge edge : aut.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD updPred = aut.ctrlBeh.id();
            edge.preApply(false, null);
            updPred = edge.apply(updPred, false, false, null, true);
            edge.postApply(false);
            edge.cleanupApply();
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (!guardUpdated) {
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Edge %s: guard: %s -> %s.", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
    }

    private static void determineCtrlSysInit(SynthesisAutomaton aut) {
        aut.initialCtrl = aut.initialCtrl.andWith(aut.ctrlBeh.id());
        aut.initialPlantInv.free();
        aut.initialPlantInv = null;
    }

    private static boolean checkInitStatePresent(SynthesisAutomaton aut) {
        boolean emptySup = aut.initialCtrl.isZero();
        return !emptySup;
    }

    private static void printNumberStates(SynthesisAutomaton aut, boolean emptySup, boolean doForward, boolean dbgEnabled) {
        boolean isExact;
        double nr;
        if (emptySup) {
            nr = 0.0;
        } else if (aut.variables.length == 0) {
            Assert.check((aut.ctrlBeh.isZero() || aut.ctrlBeh.isOne() ? 1 : 0) != 0);
            nr = aut.ctrlBeh.isOne() ? 1 : 0;
        } else {
            nr = aut.ctrlBeh.satCount(aut.varSetOld);
        }
        Assert.check((emptySup || nr > 0.0 ? 1 : 0) != 0);
        boolean bl = isExact = emptySup || doForward;
        if (dbgEnabled) {
            OutputProvider.dbg();
        }
        OutputProvider.out((String)"Controlled system: %s %,.0f state%s.", (Object[])new Object[]{isExact ? "exactly" : "at most", nr, nr == 1.0 ? "" : "s"});
    }

    private static void determineOutputInitial(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Initial (synthesis result):            %s", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut)});
            OutputProvider.dbg((String)"Initial (uncontrolled system):         %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialUnctrl, aut)});
            OutputProvider.dbg((String)"Initial (controlled system):           %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialCtrl, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        BDD initialRemoved = aut.initialUnctrl.id().andWith(aut.initialCtrl.not());
        if (aut.env.isTerminationRequested()) {
            return;
        }
        BDD initialAdded = initialRemoved.not();
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial (removed by supervisor):       %s", (Object[])new Object[]{BddUtils.bddToStr(initialRemoved, aut)});
            OutputProvider.dbg((String)"Initial (added by supervisor):         %s", (Object[])new Object[]{BddUtils.bddToStr(initialAdded, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        EnumSet<BddSimplify> simplifications = BddSimplifyOption.getSimplifications();
        List assumptionTxts = Lists.list();
        if (!initialRemoved.isZero()) {
            BDD extra;
            aut.initialOutput = aut.initialCtrl.id();
            BDD assumption = aut.factory.one();
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_UNCTRL)) {
                assumptionTxts.add("uncontrolled system initialization predicates");
                extra = aut.initialUnctrl.id();
                assumption = assumption.andWith(extra);
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_STATE_PLANT_INVS)) {
                assumptionTxts.add("state plant invariants");
                extra = aut.plantInv.id();
                assumption = assumption.andWith(extra);
            }
            if (!assumptionTxts.isEmpty()) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
                BDD newInitial = aut.initialOutput.simplify(assumption);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (dbgEnabled && !aut.initialOutput.equals((Object)newInitial)) {
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Simplification of controlled system initialization predicate under the assumption of the %s:", (Object[])new Object[]{assumptionsTxt});
                    OutputProvider.dbg((String)"  Initial: %s -> %s [assume %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.initialOutput, aut), BddUtils.bddToStr(newInitial, aut), BddUtils.bddToStr(assumption, aut)});
                }
                aut.initialOutput.free();
                aut.initialOutput = newInitial;
            }
            assumption.free();
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        aut.initialCtrl.free();
        aut.initialUnctrl.free();
        initialRemoved.free();
        initialAdded.free();
        aut.initialCtrl = null;
        aut.initialUnctrl = null;
    }

    private static Map<Event, BDD> determineGuards(SynthesisAutomaton aut, Set<Event> events, boolean useOrigGuards) {
        Map guards = Maps.mapc((int)events.size());
        for (Event event : events) {
            guards.put(event, aut.factory.zero());
        }
        for (SynthesisEdge synthEdge : aut.edges) {
            if (!events.contains(synthEdge.event)) continue;
            if (aut.env.isTerminationRequested()) {
                return null;
            }
            BDD guard = (BDD)guards.get(synthEdge.event);
            guard = useOrigGuards ? guard.orWith(synthEdge.origGuard) : guard.orWith(synthEdge.guard);
            guards.put(synthEdge.event, guard);
        }
        return guards;
    }

    private static void checkOutputEdges(SynthesisAutomaton aut, Map<Event, BDD> ctrlGuards) {
        Set uncontrollables = Sets.difference(aut.alphabet, (Collection[])new Collection[]{aut.controllables, aut.inputVarEvents});
        Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(aut, uncontrollables, false);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(aut, ctrlGuards);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(aut, unctrlGuards);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        for (BDD bdd : unctrlGuards.values()) {
            bdd.free();
        }
    }

    private static void warnEventsDisabled(SynthesisAutomaton aut, Map<Event, BDD> guards) {
        BDD ctrlBehPlantInv = aut.ctrlBeh.and(aut.plantInv);
        for (Event event : guards.keySet()) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD ctrlBehGuard = guards.get(event).and(ctrlBehPlantInv);
            if (ctrlBehGuard.isZero() && !aut.disabledEvents.contains(event)) {
                OutputProvider.warn((String)"Event \"%s\" is disabled in the controlled system.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            ctrlBehGuard.free();
        }
        ctrlBehPlantInv.free();
    }

    private static void determineOutputGuards(SynthesisAutomaton aut, Map<Event, BDD> ctrlGuards, boolean dbgEnabled) {
        BDD extra;
        BDD assumption;
        EnumSet<BddSimplify> simplifications = BddSimplifyOption.getSimplifications();
        List assumptionTxts = Lists.list();
        Map assumptions = Maps.mapc((int)aut.controllables.size());
        for (Event controllable : aut.controllables) {
            assumptions.put(controllable, aut.factory.one());
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_PLANTS)) {
            assumptionTxts.add("plants");
            Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(aut, aut.controllables, true);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            for (Event controllable : aut.controllables) {
                BDD assumption2 = (BDD)assumptions.get(controllable);
                BDD extra2 = unctrlGuards.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption2 = assumption2.andWith(extra2);
                assumptions.put(controllable, assumption2);
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_REQ_AUTS)) {
            assumptionTxts.add("requirement automata");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclsReqAuts.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclsReqAuts = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_PLANT_INVS)) {
            assumptionTxts.add("state/event exclusion plant invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclPlants.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclPlants = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_REQ_INVS)) {
            assumptionTxts.add("state/event exclusion requirement invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclsReqInvs.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclsReqInvs = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_PLANT_INVS)) {
            assumptionTxts.add("state plant invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.plantInv.id();
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.plantInv.free();
        aut.plantInv = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_REQ_INVS)) {
            assumptionTxts.add("state requirement invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.reqInv.id();
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.reqInv.free();
        aut.reqInv = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_CTRL_BEH)) {
            assumptionTxts.add("controlled behavior");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.ctrlBeh.id();
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.ctrlBeh.free();
        aut.ctrlBeh = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        aut.outputGuards = ctrlGuards;
        if (assumptionTxts.isEmpty()) {
            return;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
        CifDataSynthesis.simplifyOutputGuards(aut, dbgEnabled, assumptions, assumptionsTxt);
    }

    private static String combineAssumptionTexts(List<String> texts) {
        if (texts.size() == 0) {
            return "";
        }
        if (texts.size() == 1) {
            return texts.get(0);
        }
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < texts.size()) {
            if (i > 0) {
                if (texts.size() > 2) {
                    txt.append(",");
                }
                txt.append(" ");
            }
            if (i == texts.size() - 1) {
                txt.append("and ");
            }
            txt.append(texts.get(i));
            ++i;
        }
        return txt.toString();
    }

    private static void simplifyOutputGuards(SynthesisAutomaton aut, boolean dbgEnabled, Map<Event, BDD> assumptions, String assumptionsTxt) {
        boolean dbgPrinted = false;
        for (Event controllable : aut.controllables) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD guard = aut.outputGuards.get(controllable);
            BDD assumption = assumptions.get(controllable);
            BDD newGuard = assumption.isZero() && guard.isZero() ? aut.factory.one() : guard.simplify(assumption);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            aut.outputGuards.put(controllable, newGuard);
            if (dbgEnabled && !guard.equals((Object)newGuard)) {
                if (!dbgPrinted) {
                    dbgPrinted = true;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Simplification of controlled system under the assumption of the %s:", (Object[])new Object[]{assumptionsTxt});
                }
                OutputProvider.dbg((String)"  Event %s: guard: %s -> %s [assume %s].", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)controllable), BddUtils.bddToStr(guard, aut), BddUtils.bddToStr(newGuard, aut), BddUtils.bddToStr(assumption, aut)});
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            assumption.free();
            guard.free();
        }
    }
}

