/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDD;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderDuplicateEventsOption;
import org.eclipse.escet.cif.datasynth.options.EdgeWorksetAlgoOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.workset.pruners.MaxCardinalityEdgePruner;
import org.eclipse.escet.cif.datasynth.workset.pruners.RewardBasedEdgePruner;
import org.eclipse.escet.cif.datasynth.workset.pruners.SequentialEdgePruner;
import org.eclipse.escet.cif.datasynth.workset.selectors.EdgeSelector;
import org.eclipse.escet.cif.datasynth.workset.selectors.FirstEdgeSelector;
import org.eclipse.escet.cif.datasynth.workset.selectors.PruningEdgeSelector;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CifDataSynthesisReachability {
    private final SynthesisAutomaton aut;
    private final int round;
    private final String predName;
    private final String initName;
    private final String restrictionName;
    private final BDD restriction;
    private final boolean bad;
    private final boolean forward;
    private final boolean ctrl;
    private final boolean unctrl;
    private final boolean dbgEnabled;

    public CifDataSynthesisReachability(SynthesisAutomaton aut, int round, String predName, String initName, String restrictionName, BDD restriction, boolean bad, boolean forward, boolean ctrl, boolean unctrl, boolean dbgEnabled) {
        Assert.areEqual((Object)(restrictionName == null ? 1 : 0), (Object)(restriction == null ? 1 : 0));
        this.aut = aut;
        this.round = round;
        this.predName = predName;
        this.initName = initName;
        this.restrictionName = restrictionName;
        this.restriction = restriction;
        this.bad = bad;
        this.forward = forward;
        this.ctrl = ctrl;
        this.unctrl = unctrl;
        this.dbgEnabled = dbgEnabled;
    }

    public BDD performReachability(BDD pred) {
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Round %d: computing %s predicate.", (Object[])new Object[]{this.round, this.predName});
            OutputProvider.dbg((String)"%s: %s [%s predicate]", (Object[])new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.aut), this.initName});
        }
        boolean changed = false;
        if (this.restriction != null) {
            BDD restrictedPred = pred.and(this.restriction);
            if (this.aut.env.isTerminationRequested()) {
                return null;
            }
            if (pred.equals((Object)restrictedPred)) {
                restrictedPred.free();
            } else {
                if (this.dbgEnabled) {
                    Assert.notNull((Object)this.restrictionName);
                    OutputProvider.dbg((String)"%s: %s -> %s [restricted to %s predicate: %s]", (Object[])new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.aut), BddUtils.bddToStr(restrictedPred, this.aut), this.restrictionName, BddUtils.bddToStr(this.restriction, this.aut)});
                }
                pred.free();
                pred = restrictedPred;
                changed = true;
            }
        }
        boolean useWorkSetAlgo = EdgeWorksetAlgoOption.isEnabled();
        List<SynthesisEdge> orderedEdges = this.forward ? this.aut.orderedEdgesForward : this.aut.orderedEdgesBackward;
        Predicate<SynthesisEdge> edgeShouldBeApplied = e -> this.ctrl && e.event.getControllable() != false || this.unctrl && e.event.getControllable() == false;
        List<SynthesisEdge> edgesToApply = orderedEdges.stream().filter(edgeShouldBeApplied).toList();
        BitSet edgesToApplyMask = useWorkSetAlgo ? (BitSet)IntStream.range(0, orderedEdges.size()).filter(i -> edgeShouldBeApplied.test((SynthesisEdge)orderedEdges.get(i))).boxed().collect(BitSets.toBitSet()) : null;
        Collection<SynthesisEdge> edgesToPrepare = EdgeOrderDuplicateEventsOption.getAllowance() == EdgeOrderDuplicateEventsOption.EdgeOrderDuplicateEventAllowance.ALLOWED ? Sets.list2set(edgesToApply) : edgesToApply;
        for (SynthesisEdge edge : edgesToPrepare) {
            edge.preApply(this.forward, this.restriction);
        }
        if (this.aut.env.isTerminationRequested()) {
            return null;
        }
        Pair<BDD, Boolean> reachabilityResult = useWorkSetAlgo ? this.performReachabilityWorkset(pred, orderedEdges, edgesToApplyMask) : this.performReachabilityFixedOrder(pred, edgesToApply);
        if (reachabilityResult == null || this.aut.env.isTerminationRequested()) {
            return null;
        }
        pred = (BDD)reachabilityResult.left;
        changed |= ((Boolean)reachabilityResult.right).booleanValue();
        for (SynthesisEdge edge : edgesToPrepare) {
            edge.postApply(this.forward);
        }
        if (this.aut.env.isTerminationRequested()) {
            return null;
        }
        if (this.dbgEnabled && changed) {
            OutputProvider.dbg((String)"%s: %s [fixed point].", (Object[])new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.aut)});
        }
        return pred;
    }

    private Pair<BDD, Boolean> performReachabilityWorkset(BDD pred, List<SynthesisEdge> edges, BitSet edgesMask) {
        boolean changed = false;
        List<BitSet> dependencies = this.forward ? this.aut.worksetDependenciesForward : this.aut.worksetDependenciesBackward;
        PruningEdgeSelector edgeSelector = new PruningEdgeSelector(new SequentialEdgePruner(new MaxCardinalityEdgePruner(dependencies), new RewardBasedEdgePruner(edges.size(), 1, -1)), new FirstEdgeSelector());
        BitSet workset = BitSets.copy((BitSet)edgesMask);
        while (!workset.isEmpty()) {
            BDD newPred;
            int edgeIdx = edgeSelector.select(workset);
            SynthesisEdge edge = edges.get(edgeIdx);
            boolean changedByEdge = false;
            while (true) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.bad, this.forward, this.restriction, !this.forward);
                if (this.aut.env.isTerminationRequested()) {
                    return null;
                }
                newPred = pred.id().orWith(updPred);
                if (this.aut.env.isTerminationRequested()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) break;
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.aut)});
                    }
                    OutputProvider.dbg((String)"%s: %s -> %s [%s reach with edge: %s%s]", (Object[])new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.aut), BddUtils.bddToStr(newPred, this.aut), this.forward ? "forward" : "backward", edge.toString(0, ""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                changedByEdge = true;
            }
            newPred.free();
            if (changedByEdge) {
                BitSet dependents = BitSets.copy((BitSet)dependencies.get(edgeIdx));
                dependents.and(edgesMask);
                workset.or(dependents);
            }
            workset.clear(edgeIdx);
            ((EdgeSelector)edgeSelector).update(edgeIdx, changedByEdge);
        }
        return Pair.pair((Object)pred, (Object)changed);
    }

    private Pair<BDD, Boolean> performReachabilityFixedOrder(BDD pred, List<SynthesisEdge> edges) {
        boolean changed = false;
        int iter = 0;
        int remainingEdges = edges.size();
        block0: while (remainingEdges > 0) {
            ++iter;
            if (this.dbgEnabled) {
                OutputProvider.dbg((String)"%s reachability: iteration %d.", (Object[])new Object[]{this.forward ? "Forward" : "Backward", iter});
            }
            for (SynthesisEdge edge : edges) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.bad, this.forward, this.restriction, !this.forward);
                if (this.aut.env.isTerminationRequested()) {
                    return null;
                }
                BDD newPred = pred.id().orWith(updPred);
                if (this.aut.env.isTerminationRequested()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) {
                    newPred.free();
                    if (--remainingEdges != 0) continue;
                    continue block0;
                }
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.aut)});
                    }
                    OutputProvider.dbg((String)"%s: %s -> %s [%s reach with edge: %s%s]", (Object[])new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.aut), BddUtils.bddToStr(newPred, this.aut), this.forward ? "forward" : "backward", edge.toString(0, ""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                remainingEdges = edges.size();
            }
        }
        return Pair.pair((Object)pred, (Object)changed);
    }
}

