/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.bdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.bdd.BddToCif;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Strings;

public class BddUtils {
    private BddUtils() {
    }

    public static int getMinimumBits(int value) {
        int count = 0;
        while (value > 0) {
            ++count;
            value >>= 1;
        }
        return count;
    }

    public static BDD getVarDomain(SynthesisVariable variable, boolean newDomain, BDDFactory factory) {
        int min = variable.lower;
        int max = variable.upper;
        BDDDomain domain = newDomain ? variable.domainNew : variable.domain;
        BDD rslt = factory.zero();
        int i = min;
        while (i <= max) {
            rslt = rslt.orWith(domain.ithVar((long)i));
            ++i;
        }
        return rslt;
    }

    public static String bddToStr(BDD bdd, SynthesisAutomaton aut) {
        if (aut.debugMaxNodes != null || aut.debugMaxPaths != null) {
            boolean skip;
            int nc = bdd.nodeCount();
            double tpc = bdd.pathCount();
            boolean bl = skip = aut.debugMaxNodes != null && nc > aut.debugMaxNodes || aut.debugMaxPaths != null && tpc > aut.debugMaxPaths;
            if (skip) {
                return Strings.fmt((String)"<bdd %,dn %,.0fp>", (Object[])new Object[]{nc, tpc});
            }
        }
        Expression pred = BddToCif.bddToCifPred(bdd, aut);
        return CifTextUtils.exprToStr((Expression)pred);
    }

    public static void registerBddCallbacks(BDDFactory factory, boolean doGcStats, boolean doResizeStats, boolean doContinuousPerformanceStats, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes) {
        if (doGcStats && OutputProvider.doout()) {
            factory.registerGcStatsCallback(BddUtils::bddGcStatsCallback);
        }
        if (doResizeStats && OutputProvider.doout()) {
            factory.registerResizeStatsCallback(BddUtils::bddResizeStatsCallback);
        }
        if (doContinuousPerformanceStats) {
            factory.registerContinuousStatsCallback((n, o) -> {
                continuousOpMisses.add(o);
                continuousUsedBddNodes.add(n);
            });
        }
    }

    private static void bddGcStatsCallback(BDDFactory.GCStats stats, boolean pre) {
        StringBuilder txt = new StringBuilder();
        txt.append("BDD ");
        txt.append(pre ? "pre " : "post");
        txt.append(" garbage collection: #");
        txt.append(Strings.fmt((String)"%,d", (Object[])new Object[]{stats.num + 1 - (pre ? 0 : 1)}));
        txt.append(", ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.freenodes}));
        txt.append(" of ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.nodes}));
        txt.append(" nodes free");
        if (!pre) {
            txt.append(", ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.time}));
            txt.append(" ms, ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.sumtime}));
            txt.append(" ms total");
        }
        OutputProvider.out((String)txt.toString());
    }

    private static void bddResizeStatsCallback(int oldSize, int newSize) {
        OutputProvider.out((String)"BDD node table resize: from %,13d nodes to %,13d nodes", (Object[])new Object[]{oldSize, newSize});
    }
}

