/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.conversion;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifDataSynthesisLocationPointerManager
implements LocationPointerManager {
    private final Map<Automaton, DiscVariable> autToLpMap;
    private final Map<DiscVariable, Automaton> lpToAutMap;

    public CifDataSynthesisLocationPointerManager(List<Automaton> automata) {
        Assert.check((boolean)automata.stream().allMatch(aut -> aut.getLocations().size() > 1));
        Specification dummySpec = CifConstructors.newSpecification();
        this.autToLpMap = Maps.mapc((int)automata.size());
        this.lpToAutMap = Maps.mapc((int)automata.size());
        for (Automaton automaton : automata) {
            DiscVariable var = CifConstructors.newDiscVariable();
            var.setName(CifTextUtils.getAbsName((PositionObject)automaton));
            this.autToLpMap.put(automaton, var);
            this.lpToAutMap.put(var, automaton);
            dummySpec.getDeclarations().add((Object)var);
        }
    }

    public DiscVariable getLocationPointer(Automaton automaton) {
        return this.autToLpMap.get(automaton);
    }

    public Automaton getAutomaton(DiscVariable locPtr) {
        return this.lpToAutMap.get(locPtr);
    }

    public Update createLocUpdate(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        int locIdx = aut.getLocations().indexOf((Object)loc);
        DiscVariable lp = this.autToLpMap.get(aut);
        Assert.notNull((Object)lp);
        IntType type = CifConstructors.newIntType();
        type.setLower(Integer.valueOf(0));
        type.setUpper(Integer.valueOf(aut.getLocations().size() - 1));
        DiscVariableExpression lpRef = CifConstructors.newDiscVariableExpression();
        lpRef.setVariable(lp);
        lpRef.setType((CifType)type);
        Assignment asgn = CifConstructors.newAssignment();
        asgn.setAddressable((Expression)lpRef);
        asgn.setValue(CifValueUtils.makeInt((int)locIdx));
        return asgn;
    }

    public Expression createLocRef(Location loc) {
        return CifGuardUtils.LocRefExprCreator.DEFAULT.create(loc);
    }
}

