/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class BddHyperEdgeAlgoOption
extends EnumOption<BddHyperEdgeAlgo> {
    public static final BddHyperEdgeAlgo DEFAULT_VALUE = BddHyperEdgeAlgo.DEFAULT;

    public BddHyperEdgeAlgoOption() {
        super("BDD hyper-edge creation algorithm", "The algorithm to use to create hyper-edges for BDD variable ordering. Specify \"legacy\" to use the legacy hyper-edge creation algorithm, \"linearized\" to use the linearized hyper-edge creation algorithm, or \"default\" to use the linearized hyper-edge creation algorithm for the FORCE and sliding window algorithms, and the legacy hyper-edge creation algorithm for all other variable orderers. By default, \"default\" is used.", null, "hyper-edge-algo", "ALGO", (Enum)DEFAULT_VALUE, true, "The algorithm to use to create hyper-edges for BDD variable ordering.");
    }

    protected String getDialogText(BddHyperEdgeAlgo algo) {
        switch (algo) {
            case LEGACY: {
                return "Legacy hyper-edge creation algorithm";
            }
            case LINEARIZED: {
                return "Linearized hyper-edge creation algorithm";
            }
            case DEFAULT: {
                return "Default (linearized for FORCE and sliding window, legacy otherwise)";
            }
        }
        throw new RuntimeException("Unknown algorithm: " + (Object)((Object)algo));
    }

    public static BddHyperEdgeAlgo getAlgo() {
        return (BddHyperEdgeAlgo)((Object)Options.get(BddHyperEdgeAlgoOption.class));
    }

    public static boolean isDefault() {
        return BddHyperEdgeAlgoOption.getAlgo().equals((Object)DEFAULT_VALUE);
    }

    public static enum BddHyperEdgeAlgo {
        LEGACY,
        LINEARIZED,
        DEFAULT;

    }
}

