/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import java.util.List;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;

public class FixedPointComputationsOrderOption
extends EnumOption<FixedPointComputationsOrder> {
    public FixedPointComputationsOrderOption() {
        super("Fixed-point computations order", "Specify the order in which the fixed-point computations are to be performed during synthesis. Three fixed-point computations are performed (depending on other settings), to compute the non-blocking states, controllable states and reachable states. Specify \"nonblock\", \"ctrl\", and \"reach\", in the desired order, joined by dashes. For instance, specify \"ctrl-reach-nonblock\" or \"reach-ctrl-nonblock\". [DEFAULT=nonblock-ctrl-reach]", null, "fixed-point-order", "ORDER", (Enum)FixedPointComputationsOrder.NONBLOCK_CTRL_REACH, true, "Specify the order in which the fixed-point computations are to be performed during synthesis. Three fixed-point computations are performed (depending on other settings), to compute the non-blocking states, controllable states and reachable states.");
    }

    protected String getDialogText(FixedPointComputationsOrder order) {
        switch (order) {
            case NONBLOCK_CTRL_REACH: {
                return "Non-blocking -> controllable -> reachable";
            }
            case NONBLOCK_REACH_CTRL: {
                return "Non-blocking -> reachable -> controllable";
            }
            case CTRL_NONBLOCK_REACH: {
                return "Controllable -> non-blocking -> reachable";
            }
            case CTRL_REACH_NONBLOCK: {
                return "Controllable -> reachable -> non-blocking";
            }
            case REACH_NONBLOCK_CTRL: {
                return "Reachable -> non-blocking -> controllable";
            }
            case REACH_CTRL_NONBLOCK: {
                return "Reachable -> controllable -> non-blocking";
            }
        }
        throw new RuntimeException("Unknown order: " + (Object)((Object)order));
    }

    public static FixedPointComputationsOrder getOrder() {
        return (FixedPointComputationsOrder)((Object)Options.get(FixedPointComputationsOrderOption.class));
    }

    public static enum FixedPointComputation {
        NONBLOCK,
        CTRL,
        REACH;

    }

    public static enum FixedPointComputationsOrder {
        NONBLOCK_CTRL_REACH(FixedPointComputation.NONBLOCK, FixedPointComputation.CTRL, FixedPointComputation.REACH),
        NONBLOCK_REACH_CTRL(FixedPointComputation.NONBLOCK, FixedPointComputation.REACH, FixedPointComputation.CTRL),
        CTRL_NONBLOCK_REACH(FixedPointComputation.CTRL, FixedPointComputation.NONBLOCK, FixedPointComputation.REACH),
        CTRL_REACH_NONBLOCK(FixedPointComputation.CTRL, FixedPointComputation.REACH, FixedPointComputation.NONBLOCK),
        REACH_NONBLOCK_CTRL(FixedPointComputation.REACH, FixedPointComputation.NONBLOCK, FixedPointComputation.CTRL),
        REACH_CTRL_NONBLOCK(FixedPointComputation.REACH, FixedPointComputation.CTRL, FixedPointComputation.NONBLOCK);

        public final List<FixedPointComputation> computations;

        private FixedPointComputationsOrder(FixedPointComputation ... computations) {
            Assert.areEqual((Object)FixedPointComputation.values().length, (Object)Sets.set((Object[])computations).size());
            this.computations = List.of(computations);
        }
    }
}

