/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.graph.algos;

import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.graph.Graph;
import org.eclipse.escet.cif.datasynth.varorder.graph.Node;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;

public class RootedLevelStructureConstructor {
    private RootedLevelStructureConstructor() {
    }

    static List<List<Node>> constructRootedLevelStructure(Graph graph, Node root) {
        return RootedLevelStructureConstructor.constructRootedLevelStructure(graph, root, null);
    }

    static List<List<Node>> constructRootedLevelStructure(Graph graph, Node root, Integer widthLimit) {
        if (widthLimit != null && widthLimit <= 1) {
            return null;
        }
        List result = Lists.list();
        result.add(Lists.list((Object)root));
        BitSet marked = BitSets.bitset((int)graph.size());
        marked.set(root.index);
        while (true) {
            List nextLevel = Lists.list();
            for (Node node : (List)Lists.last((List)result)) {
                for (Node neighbour : node.neighbours()) {
                    if (marked.get(neighbour.index)) continue;
                    nextLevel.add(neighbour);
                    marked.set(neighbour.index);
                }
            }
            if (widthLimit != null && nextLevel.size() >= widthLimit) {
                return null;
            }
            if (nextLevel.isEmpty()) break;
            result.add(nextLevel);
        }
        return result;
    }
}

