/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.graph.algos;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.datasynth.varorder.graph.Graph;
import org.eclipse.escet.cif.datasynth.varorder.graph.Node;
import org.eclipse.escet.cif.datasynth.varorder.graph.algos.PseudoPeripheralNodePairFinder;
import org.eclipse.escet.cif.datasynth.varorder.graph.algos.RootedLevelStructureConstructor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;

public class SloanPseudoPeripheralNodeFinder
implements PseudoPeripheralNodePairFinder {
    @Override
    public Node findPseudoPeripheralNode(Graph graph, List<Node> partition, Node startNode) {
        return (Node)this.findPseudoPeripheralNodePair((Graph)graph, partition, (Node)startNode).left;
    }

    @Override
    public Pair<Node, Node> findPseudoPeripheralNodePair(Graph graph, List<Node> partition, Node startNode) {
        Node s = startNode != null ? startNode : partition.stream().min(Comparator.comparing(Node::degree)).get();
        List<List<Node>> rlsS = RootedLevelStructureConstructor.constructRootedLevelStructure(graph, s);
        Node e = null;
        block0: while (true) {
            List lastLevel = (List)Lists.last(rlsS);
            List q = lastLevel.stream().collect(Collectors.groupingBy(Node::degree)).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (Node)((List)entry.getValue()).get(0)).collect(Collectors.toList());
            int we = Integer.MAX_VALUE;
            e = null;
            for (Node i : q) {
                List<List<Node>> rlsI = RootedLevelStructureConstructor.constructRootedLevelStructure(graph, i, we);
                if (rlsI == null) continue;
                if (rlsI.size() > rlsS.size()) {
                    s = i;
                    rlsS = rlsI;
                    continue block0;
                }
                e = i;
                we = rlsI.stream().max(Comparator.comparing(List::size)).get().size();
            }
            break;
        }
        Assert.notNull(e);
        return Pair.pair((Object)s, e);
    }
}

