/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.helper;

import java.util.List;
import java.util.Objects;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;

public class VarOrder {
    private final List<List<SynthesisVariable>> varOrder;

    public VarOrder(List<List<SynthesisVariable>> varOrder) {
        this.varOrder = varOrder;
    }

    public static VarOrder createFromOrderedVars(List<SynthesisVariable> orderedVars) {
        return new VarOrder(orderedVars.stream().map(v -> List.of(v)).toList());
    }

    public List<List<SynthesisVariable>> getVarOrder() {
        return this.varOrder;
    }

    public List<SynthesisVariable> getOrderedVars() {
        return this.varOrder.stream().flatMap(grp -> grp.stream()).toList();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void that;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof VarOrder)) {
            return false;
        }
        VarOrder varOrder = (VarOrder)object;
        VarOrder cfr_ignored_0 = (VarOrder)object;
        return Objects.equals(this.varOrder, that.varOrder);
    }

    public int hashCode() {
        return Objects.hashCode(this.varOrder);
    }
}

