/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.hyperedges;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisInputVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisLocPtrVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class HyperEdgeCreator {
    private final Specification spec;
    private final List<SynthesisVariable> variables;
    private final Map<PositionObject, Integer> synthVarBitIndices;

    public HyperEdgeCreator(Specification spec, List<SynthesisVariable> variables) {
        this.spec = spec;
        this.variables = variables;
        this.synthVarBitIndices = Maps.mapc((int)variables.size());
        int i = 0;
        while (i < variables.size()) {
            SynthesisVariable synthVar = variables.get(i);
            if (synthVar instanceof SynthesisDiscVariable) {
                this.synthVarBitIndices.put((PositionObject)((SynthesisDiscVariable)synthVar).var, i);
            } else if (synthVar instanceof SynthesisInputVariable) {
                this.synthVarBitIndices.put((PositionObject)((SynthesisInputVariable)synthVar).var, i);
            } else if (synthVar instanceof SynthesisLocPtrVariable) {
                this.synthVarBitIndices.put((PositionObject)((SynthesisLocPtrVariable)synthVar).aut, i);
            } else {
                throw new RuntimeException("Unknown synthesis variable: " + synthVar);
            }
            ++i;
        }
    }

    protected Specification getSpecification() {
        return this.spec;
    }

    protected List<SynthesisVariable> getVariables() {
        return this.variables;
    }

    public abstract List<BitSet> getHyperEdges();

    protected void addHyperEdge(Collection<PositionObject> edgeVars, List<BitSet> hyperEdges) {
        if (edgeVars.isEmpty()) {
            return;
        }
        BitSet hyperEdge = new BitSet(this.synthVarBitIndices.size());
        for (PositionObject var : edgeVars) {
            int bitIdx = this.synthVarBitIndices.get(var);
            hyperEdge.set(bitIdx);
        }
        hyperEdges.add(hyperEdge);
    }
}

