/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.metrics;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetric;
import org.eclipse.escet.common.java.BitSets;

public class TotalSpanMetric
implements VarOrderMetric {
    @Override
    public double computeForNewIndices(int[] newIndices, List<BitSet> hyperEdges) {
        return TotalSpanMetric.compute(newIndices, hyperEdges);
    }

    public static long compute(int[] newIndices, List<BitSet> hyperEdges) {
        long totalSpan = 0L;
        for (BitSet edge : hyperEdges) {
            int minIdx = Integer.MAX_VALUE;
            int maxIdx = 0;
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                int newIdx = newIndices[i];
                minIdx = Math.min(minIdx, newIdx);
                maxIdx = Math.max(maxIdx, newIdx);
            }
            int span = maxIdx - minIdx;
            totalSpan += (long)span;
        }
        return totalSpan;
    }
}

