/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.metrics;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetric;
import org.eclipse.escet.common.java.BitSets;

public class WesMetric
implements VarOrderMetric {
    @Override
    public double computeForNewIndices(int[] newIndices, List<BitSet> hyperEdges) {
        return WesMetric.compute(newIndices, hyperEdges);
    }

    public static double compute(int[] newIndices, List<BitSet> hyperEdges) {
        double nx = newIndices.length;
        double nE = hyperEdges.size();
        if (nx == 0.0 || nE == 0.0) {
            return 0.0;
        }
        double wes = 0.0;
        for (BitSet edge : hyperEdges) {
            int xT = Integer.MAX_VALUE;
            int xB = 0;
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                int newIdx = newIndices[i];
                xT = Math.min(xT, newIdx);
                xB = Math.max(xB, newIdx);
            }
            wes += (double)(2 * xB) / nx * (double)(xB - xT + 1) / (nx * nE);
        }
        return wes;
    }
}

