/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.orderers;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetric;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetricKind;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ForceVarOrderer
extends VarOrderer {
    private final VarOrderMetricKind metricKind;
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public ForceVarOrderer(VarOrderMetricKind metricKind, RelationsKind relationsKind, VarOrdererEffect effect) {
        this.metricKind = metricKind;
        this.relationsKind = relationsKind;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        double curMetricValue;
        int varCnt = inputData.helper.size();
        List<BitSet> hyperEdges = inputData.helper.getHyperEdges(this.relationsKind);
        int maxIter = (int)Math.ceil(Math.log(varCnt));
        maxIter *= 10;
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying FORCE algorithm:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Metric: %s", this.enumValueToParserArg(this.metricKind));
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.HYPER_EDGES, this.relationsKind);
            inputData.helper.dbg(dbgLevel + 1, "Maximum number of iterations: %,d", maxIter);
            inputData.helper.dbg();
        }
        if (hyperEdges.isEmpty()) {
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Skipping algorithm: no hyper-edges.", new Object[0]);
            }
            return inputData;
        }
        double[] locations = new double[varCnt];
        List idxLocPairs = Lists.listc((int)varCnt);
        int i = 0;
        while (i < varCnt) {
            idxLocPairs.add(new IdxLocPair());
            ++i;
        }
        double[] cogs = new double[hyperEdges.size()];
        int[] edgeCounts = new int[varCnt];
        for (BitSet edge : hyperEdges) {
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i2;
                int n = i2 = ((Integer)iterator.next()).intValue();
                edgeCounts[n] = edgeCounts[n] + 1;
            }
        }
        int[] curIndices = inputData.helper.getNewIndicesForVarOrder(inputData.varOrder.getOrderedVars());
        int[] bestIndices = (int[])curIndices.clone();
        VarOrderMetric metric = this.metricKind.create();
        double bestMetricValue = curMetricValue = metric.computeForNewIndices(curIndices, hyperEdges);
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, curIndices, "before", this.relationsKind);
        }
        int curIter = 0;
        while (curIter < maxIter) {
            BitSet edge;
            int i3 = 0;
            while (i3 < hyperEdges.size()) {
                edge = hyperEdges.get(i3);
                double cog = 0.0;
                Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    cog += (double)curIndices[j];
                }
                cogs[i3] = cog / (double)edge.cardinality();
                ++i3;
            }
            Arrays.fill(locations, 0.0);
            i3 = 0;
            while (i3 < hyperEdges.size()) {
                edge = hyperEdges.get(i3);
                Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
                while (iterator.hasNext()) {
                    int j;
                    int n = j = ((Integer)iterator.next()).intValue();
                    locations[n] = locations[n] + cogs[i3];
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < varCnt) {
                int n = i3;
                locations[n] = locations[n] / (double)edgeCounts[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < varCnt) {
                IdxLocPair pair = (IdxLocPair)idxLocPairs.get(i3);
                pair.idx = i3;
                pair.location = locations[i3];
                ++i3;
            }
            Collections.sort(idxLocPairs);
            i3 = 0;
            while (i3 < varCnt) {
                curIndices[((IdxLocPair)idxLocPairs.get((int)i3)).idx] = i3;
                ++i3;
            }
            double newMetricValue = metric.computeForNewIndices(curIndices, hyperEdges);
            if (dbgEnabled) {
                inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, curIndices, Strings.fmt((String)"iteration %,d", (Object[])new Object[]{curIter + 1}), this.relationsKind);
            }
            if (newMetricValue == curMetricValue) break;
            if (newMetricValue < bestMetricValue) {
                System.arraycopy(curIndices, 0, bestIndices, 0, varCnt);
                bestMetricValue = newMetricValue;
            }
            curMetricValue = newMetricValue;
            ++curIter;
        }
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, bestIndices, "after", this.relationsKind);
        }
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(inputData.helper.reorderForNewIndices(bestIndices)), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"force(metric=%s, relations=%s, effect=%s)", (Object[])new Object[]{this.enumValueToParserArg(this.metricKind), this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect)});
    }

    private static class IdxLocPair
    implements Comparable<IdxLocPair> {
        public int idx;
        public double location;

        private IdxLocPair() {
        }

        @Override
        public int compareTo(IdxLocPair other) {
            int rslt = Double.compare(this.location, other.location);
            if (rslt != 0) {
                return rslt;
            }
            return Integer.compare(this.idx, other.idx);
        }

        public String toString() {
            return Strings.fmt((String)"(%s, %s)", (Object[])new Object[]{this.idx, this.location});
        }
    }
}

