/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.orderers;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class RandomVarOrderer
extends VarOrderer {
    private final Long seed;
    private final VarOrdererEffect effect;

    public RandomVarOrderer(Long seed, VarOrdererEffect effect) {
        this.seed = seed;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying a random variable order:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Seed: %s", this.seed == null ? "random" : this.seed);
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
        }
        List<SynthesisVariable> modelOrder = inputData.varsInModelOrder;
        List randomOrder = Lists.copy(modelOrder);
        if (this.seed == null) {
            Collections.shuffle(randomOrder);
        } else {
            Collections.shuffle(randomOrder, new Random(this.seed));
        }
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(randomOrder), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"random(%seffect=%s)", (Object[])new Object[]{this.seed == null ? "" : Strings.fmt((String)"seed=%d, ", (Object[])new Object[]{this.seed}), this.enumValueToParserArg(this.effect)});
    }
}

