/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.orderers;

import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetric;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetricKind;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.PermuteUtils;
import org.eclipse.escet.common.java.Strings;

public class SlidingWindowVarOrderer
extends VarOrderer {
    private final int maxLen;
    private final VarOrderMetricKind metricKind;
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public SlidingWindowVarOrderer(int maxLen, VarOrderMetricKind metricKind, RelationsKind relationsKind, VarOrdererEffect effect) {
        this.maxLen = maxLen;
        this.metricKind = metricKind;
        this.relationsKind = relationsKind;
        this.effect = effect;
        Assert.check((maxLen >= 1 ? 1 : 0) != 0);
        Assert.check((maxLen <= 12 ? 1 : 0) != 0);
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        List<BitSet> hyperEdges;
        int varCnt = inputData.helper.size();
        int length = Math.min(this.maxLen, varCnt);
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying sliding window algorithm:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Size: %d", this.maxLen);
            inputData.helper.dbg(dbgLevel + 1, "Metric: %s", this.enumValueToParserArg(this.metricKind));
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.HYPER_EDGES, this.relationsKind);
            inputData.helper.dbg(dbgLevel + 1, "Window length: %,d", length);
            inputData.helper.dbg();
        }
        if ((hyperEdges = inputData.helper.getHyperEdges(this.relationsKind)).isEmpty()) {
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Skipping algorithm: no hyper-edges.", new Object[0]);
            }
            return inputData;
        }
        VarOrderMetric metric = this.metricKind.create();
        int[] curIndices = inputData.helper.getNewIndicesForVarOrder(inputData.varOrder.getOrderedVars());
        double curMetricValue = metric.computeForNewIndices(curIndices, hyperEdges);
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, curIndices, "before", this.relationsKind);
        }
        int[] window = new int[length];
        int permCnt = PermuteUtils.factorial((int)window.length);
        int[][] windowPerms = new int[permCnt][window.length];
        int offset = 0;
        while (offset <= varCnt - length) {
            System.arraycopy(curIndices, offset, window, 0, length);
            PermuteUtils.permute((int[])window, (int[][])windowPerms);
            int bestIdx = -1;
            int[] windowIndices = (int[])curIndices.clone();
            int i = 0;
            while (i < windowPerms.length) {
                int[] windowPerm = windowPerms[i];
                System.arraycopy(windowPerm, 0, windowIndices, offset, length);
                double windowMetricValue = metric.computeForNewIndices(windowIndices, hyperEdges);
                if (windowMetricValue < curMetricValue) {
                    curMetricValue = windowMetricValue;
                    bestIdx = i;
                }
                ++i;
            }
            if (bestIdx >= 0) {
                System.arraycopy(windowPerms[bestIdx], 0, curIndices, offset, length);
                if (dbgEnabled) {
                    inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, curIndices, Strings.fmt((String)"window %d..%d", (Object[])new Object[]{offset, offset + length - 1}), this.relationsKind);
                }
            }
            ++offset;
        }
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNewIndices(dbgLevel + 1, curIndices, "after", this.relationsKind);
        }
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(inputData.helper.reorderForNewIndices(curIndices)), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"slidwin(size=%d, metric=%s, relations=%s, effect=%s)", (Object[])new Object[]{this.maxLen, this.enumValueToParserArg(this.metricKind), this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect)});
    }
}

