/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.orderers;

import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.graph.Graph;
import org.eclipse.escet.cif.datasynth.varorder.graph.Node;
import org.eclipse.escet.cif.datasynth.varorder.graph.algos.SloanNodeOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Strings;

public class SloanVarOrderer
extends VarOrderer {
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public SloanVarOrderer(RelationsKind relationsKind, VarOrdererEffect effect) {
        this.relationsKind = relationsKind;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        Graph graph = inputData.helper.getGraph(this.relationsKind);
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying Sloan algorithm:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.GRAPH, this.relationsKind);
            inputData.helper.dbg();
        }
        if (graph.edgeCount() == 0L) {
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Skipping algorithm: no graph edges.", new Object[0]);
            }
            return inputData;
        }
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForVarOrder(dbgLevel + 1, inputData.varOrder.getOrderedVars(), "before", this.relationsKind);
        }
        List<Node> order = new SloanNodeOrderer().orderNodes(graph);
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNodeOrder(dbgLevel + 1, order, "after", this.relationsKind);
        }
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(inputData.helper.reorderForNodeOrder(order)), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"sloan(relations=%s, effect=%s)", (Object[])new Object[]{this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect)});
    }
}

