/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.orderers;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Strings;

public class SortedVarOrderer
extends VarOrderer {
    private final VarOrdererEffect effect;

    public SortedVarOrderer(VarOrdererEffect effect) {
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying sorted variable order:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
        }
        List<SynthesisVariable> modelOrder = inputData.varsInModelOrder;
        List<SynthesisVariable> sortedOrder = modelOrder.stream().sorted((v, w) -> Strings.SORTER.compare(v.rawName, w.rawName)).collect(Collectors.toList());
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(sortedOrder), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"sorted(effect=%s)", (Object[])new Object[]{this.enumValueToParserArg(this.effect)});
    }
}

