/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CustomVarOrderParser {
    private CustomVarOrderParser() {
    }

    public static Pair<VarOrder, String> parse(String orderTxt, List<SynthesisVariable> variables) {
        List customVarOrder = Lists.list();
        String[] stringArray = StringUtils.split((String)orderTxt, (String)";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupTxt = stringArray[n2];
            if (!(groupTxt = groupTxt.trim()).isEmpty()) {
                List group = Lists.list();
                String[] stringArray2 = StringUtils.split((String)groupTxt, (String)",");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String elemTxt = stringArray2[n4];
                    if (!(elemTxt = elemTxt.trim()).isEmpty()) {
                        String regEx = elemTxt.replace(".", "\\.");
                        regEx = regEx.replace("*", ".*");
                        Pattern pattern = Pattern.compile("^" + regEx + "$");
                        List matches = variables.stream().filter(v -> pattern.matcher(v.rawName).matches()).collect(Collectors.toList());
                        if (matches.isEmpty()) {
                            String msg = Strings.fmt((String)"can't find a match for \"%s\". There is no supported variable or automaton (with two or more locations) in the specification that matches the given name pattern.", (Object[])new Object[]{elemTxt});
                            return Pair.pair(null, (Object)msg);
                        }
                        Collections.sort(matches, (v, w) -> Strings.SORTER.compare(v.rawName, w.rawName));
                        group.addAll(matches);
                    }
                    ++n4;
                }
                customVarOrder.add(group);
            }
            ++n2;
        }
        Set varsInOrder = Sets.setc((int)customVarOrder.size());
        for (List group : customVarOrder) {
            for (SynthesisVariable var : group) {
                boolean added = varsInOrder.add(var);
                if (added) continue;
                String msg = Strings.fmt((String)"\"%s\" is included more than once.", (Object[])new Object[]{var.name});
                return Pair.pair(null, (Object)msg);
            }
        }
        Set missingVars = Sets.difference((Collection)Sets.list2set(variables), (Collection)varsInOrder);
        if (!missingVars.isEmpty()) {
            String names = missingVars.stream().map(v -> "\"" + v.name + "\"").sorted(Strings.SORTER).collect(Collectors.joining(", "));
            String msg = Strings.fmt((String)"the following are missing from the specified order: %s.", (Object[])new Object[]{names});
            return Pair.pair(null, (Object)msg);
        }
        return Pair.pair((Object)new VarOrder(customVarOrder), null);
    }
}

