/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.datasynth.options.BddAdvancedVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddDcshVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddForceVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddHyperEdgeAlgoOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddVariableOrderOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.graph.algos.PseudoPeripheralNodeFinderKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrder;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.datasynth.varorder.metrics.VarOrderMetricKind;
import org.eclipse.escet.cif.datasynth.varorder.orderers.ChoiceVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.CustomVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.DcshVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.ForceVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.ModelVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.RandomVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.ReverseVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.SequentialVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.SlidingWindowVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.SloanVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.SortedVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.orderers.WeightedCuthillMcKeeVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.parser.CustomVarOrderParser;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererArg;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererInstance;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererListOrderersArg;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererMultiInstance;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererNumberArg;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererOrdererArg;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererSingleInstance;
import org.eclipse.escet.cif.datasynth.varorder.parser.ast.VarOrdererStringArg;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.runtime.Token;

public class VarOrdererTypeChecker
extends TypeChecker<List<VarOrdererInstance>, VarOrderer> {
    private final List<SynthesisVariable> variables;

    public VarOrdererTypeChecker(List<SynthesisVariable> variables) {
        this.variables = variables;
    }

    protected VarOrderer transRoot(List<VarOrdererInstance> astInstances) {
        this.checkBasicAndAdvancedOptionsMix();
        List<VarOrderer> orderers = this.checkVarOrderers(astInstances);
        VarOrderer orderer = orderers.size() == 1 ? (VarOrderer)Lists.first(orderers) : new SequentialVarOrderer(orderers);
        return orderer;
    }

    private List<VarOrderer> checkVarOrderers(List<VarOrdererInstance> astInstances) {
        Assert.check((!astInstances.isEmpty() ? 1 : 0) != 0);
        List orderers = Lists.listc((int)astInstances.size());
        for (VarOrdererInstance astOrderer : astInstances) {
            orderers.add(this.checkVarOrderer(astOrderer));
        }
        return orderers;
    }

    /*
     * WARNING - void declaration
     */
    private VarOrderer checkVarOrderer(VarOrdererInstance astInstance) {
        String name;
        VarOrdererInstance varOrdererInstance = astInstance;
        if (varOrdererInstance instanceof VarOrdererMultiInstance) {
            void multiInstance;
            VarOrdererMultiInstance varOrdererMultiInstance = (VarOrdererMultiInstance)varOrdererInstance;
            VarOrdererMultiInstance cfr_ignored_0 = (VarOrdererMultiInstance)varOrdererInstance;
            List<VarOrderer> orderers = this.checkVarOrderers(multiInstance.instances);
            VarOrderer orderer = orderers.size() == 1 ? (VarOrderer)Lists.first(orderers) : new SequentialVarOrderer(orderers);
            return orderer;
        }
        Assert.check((boolean)(astInstance instanceof VarOrdererSingleInstance));
        VarOrdererSingleInstance astOrderer = (VarOrdererSingleInstance)astInstance;
        switch (name = astOrderer.name.text) {
            case "basic": {
                return this.checkBasicOrderer(astOrderer);
            }
            case "model": {
                return this.checkModelOrderer(astOrderer);
            }
            case "sorted": {
                return this.checkSortedOrderer(astOrderer);
            }
            case "random": {
                return this.checkRandomOrderer(astOrderer);
            }
            case "custom": {
                return this.checkCustomOrderer(astOrderer);
            }
            case "dcsh": {
                return this.checkDcshVarOrderer(astOrderer);
            }
            case "force": {
                return this.checkForceVarOrderer(astOrderer);
            }
            case "slidwin": {
                return this.checkSlidWinVarOrderer(astOrderer);
            }
            case "sloan": {
                return this.checkSloanVarOrderer(astOrderer);
            }
            case "weighted-cm": {
                return this.checkWeightedCmVarOrderer(astOrderer);
            }
            case "or": {
                return this.checkChoiceVarOrderer(astOrderer);
            }
            case "reverse": {
                return this.checkReverseVarOrderer(astOrderer);
            }
        }
        this.addError(Strings.fmt((String)"Unknown variable orderer \"%s\".", (Object[])new Object[]{name}), astOrderer.name.position);
        throw new SemanticException();
    }

    private VarOrderer checkBasicOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        if (!astOrderer.arguments.isEmpty()) {
            this.reportUnsupportedArgumentName(name, (VarOrdererArg)Lists.first(astOrderer.arguments));
            throw new SemanticException();
        }
        return this.getBasicConfiguredOrderer();
    }

    private void checkBasicAndAdvancedOptionsMix() {
        boolean basicDefault = BddVariableOrderOption.isDefault() && BddDcshVarOrderOption.isDefault() && BddForceVarOrderOption.isDefault() && BddSlidingWindowVarOrderOption.isDefault() && BddSlidingWindowSizeOption.isDefault() && BddHyperEdgeAlgoOption.isDefault();
        boolean advancedDefault = BddAdvancedVariableOrderOption.isDefault();
        if (!basicDefault && !advancedDefault) {
            throw new InvalidOptionException("The BDD variable ordering is configured through basic and advanced options, which is not supported. Use only basic or only advanced options.");
        }
    }

    private VarOrderer getBasicConfiguredOrderer() {
        VarOrderer initialOrderer = this.getBasicConfiguredInitialOrderer();
        List orderers = Lists.list((Object)initialOrderer);
        if (BddDcshVarOrderOption.isEnabled()) {
            orderers.add(new DcshVarOrderer(PseudoPeripheralNodeFinderKind.GEORGE_LIU, VarOrderMetricKind.WES, this.getBasicConfiguredRelationsKind("dcsh"), VarOrdererEffect.VAR_ORDER));
        }
        if (BddForceVarOrderOption.isEnabled()) {
            orderers.add(new ForceVarOrderer(VarOrderMetricKind.TOTAL_SPAN, this.getBasicConfiguredRelationsKind("force"), VarOrdererEffect.VAR_ORDER));
        }
        if (BddSlidingWindowVarOrderOption.isEnabled()) {
            int maxLen = BddSlidingWindowSizeOption.getMaxLen();
            orderers.add(new SlidingWindowVarOrderer(maxLen, VarOrderMetricKind.TOTAL_SPAN, this.getBasicConfiguredRelationsKind("slidwin"), VarOrdererEffect.VAR_ORDER));
        }
        return orderers.size() == 1 ? (VarOrderer)Lists.first((List)orderers) : new SequentialVarOrderer(orderers);
    }

    private VarOrderer getBasicConfiguredInitialOrderer() {
        String orderTxt = BddVariableOrderOption.getOrder().trim();
        String orderTxtLower = orderTxt.toLowerCase(Locale.US);
        if (orderTxtLower.equals("model")) {
            return new ModelVarOrderer(VarOrdererEffect.BOTH);
        }
        if (orderTxtLower.equals("reverse-model")) {
            return new SequentialVarOrderer(Lists.list((Object[])new VarOrderer[]{new ModelVarOrderer(VarOrdererEffect.VAR_ORDER), new ReverseVarOrderer(this.getBasicConfiguredRelationsKind("reverse"), VarOrdererEffect.BOTH)}));
        }
        if (orderTxtLower.equals("sorted")) {
            return new SortedVarOrderer(VarOrdererEffect.BOTH);
        }
        if (orderTxtLower.equals("reverse-sorted")) {
            return new SequentialVarOrderer(Lists.list((Object[])new VarOrderer[]{new SortedVarOrderer(VarOrdererEffect.VAR_ORDER), new ReverseVarOrderer(this.getBasicConfiguredRelationsKind("reverse"), VarOrdererEffect.BOTH)}));
        }
        if (orderTxtLower.equals("random")) {
            return new RandomVarOrderer(null, VarOrdererEffect.BOTH);
        }
        if (orderTxtLower.startsWith("random:")) {
            long seed;
            int idx = orderTxt.indexOf(":");
            String seedTxt = orderTxt.substring(idx + 1).trim();
            try {
                seed = Long.parseUnsignedLong(seedTxt);
            }
            catch (NumberFormatException ex) {
                String msg = Strings.fmt((String)"Invalid BDD random variable order seed number: \"%s\".", (Object[])new Object[]{orderTxt});
                throw new InvalidOptionException(msg, (Throwable)ex);
            }
            return new RandomVarOrderer(seed, VarOrdererEffect.BOTH);
        }
        Pair<VarOrder, String> customVarOrderOrError = CustomVarOrderParser.parse(orderTxt, this.variables);
        if (customVarOrderOrError.right != null) {
            throw new InvalidOptionException("Invalid BDD variable random order: " + (String)customVarOrderOrError.right);
        }
        return new CustomVarOrderer((VarOrder)customVarOrderOrError.left, VarOrdererEffect.BOTH);
    }

    private RelationsKind getBasicConfiguredRelationsKind(String ordererName) {
        switch (BddHyperEdgeAlgoOption.getAlgo()) {
            case LEGACY: {
                return RelationsKind.LEGACY;
            }
            case LINEARIZED: {
                return RelationsKind.LINEARIZED;
            }
            case DEFAULT: {
                boolean useLinearized = ordererName.equals("force") || ordererName.equals("slidwin");
                return useLinearized ? RelationsKind.LINEARIZED : RelationsKind.LEGACY;
            }
        }
        throw new RuntimeException("Unexpected option value: " + (Object)((Object)BddHyperEdgeAlgoOption.getAlgo()));
    }

    private VarOrderer checkModelOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (effect == null) {
            effect = VarOrdererEffect.BOTH;
        }
        return new ModelVarOrderer(effect);
    }

    private VarOrderer checkSortedOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (effect == null) {
            effect = VarOrdererEffect.BOTH;
        }
        return new SortedVarOrderer(effect);
    }

    private VarOrderer checkRandomOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        Long seed = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "seed": {
                    this.checkDuplicateArg(name, arg, seed);
                    seed = this.checkLongArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (effect == null) {
            effect = VarOrdererEffect.BOTH;
        }
        return new RandomVarOrderer(seed, effect);
    }

    private VarOrderer checkCustomOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        VarOrder order = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "order": {
                    this.checkDuplicateArg(name, arg, order);
                    if (!(arg instanceof VarOrdererStringArg)) {
                        this.reportUnsupportedArgumentValue(name, arg, "the value must be a string.");
                        throw new SemanticException();
                    }
                    Pair<VarOrder, String> customVarOrderOrError = CustomVarOrderParser.parse(((VarOrdererStringArg)arg).text, this.variables);
                    if (customVarOrderOrError.right != null) {
                        this.reportUnsupportedArgumentValue(name, arg, (String)customVarOrderOrError.right);
                        throw new SemanticException();
                    }
                    order = (VarOrder)customVarOrderOrError.left;
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (order == null) {
            this.reportMissingArgument(astOrderer.name, "order");
            throw new SemanticException();
        }
        if (effect == null) {
            effect = VarOrdererEffect.BOTH;
        }
        return new CustomVarOrderer(order, effect);
    }

    private VarOrderer checkDcshVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        PseudoPeripheralNodeFinderKind nodeFinder = null;
        VarOrderMetricKind metric = null;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "node-finder": {
                    this.checkDuplicateArg(name, arg, (Object)nodeFinder);
                    nodeFinder = this.checkEnumArg(name, arg, PseudoPeripheralNodeFinderKind.class, "a node finder algorithm");
                    break;
                }
                case "metric": {
                    this.checkDuplicateArg(name, arg, (Object)metric);
                    metric = this.checkEnumArg(name, arg, VarOrderMetricKind.class, "a metric");
                    break;
                }
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (nodeFinder == null) {
            nodeFinder = PseudoPeripheralNodeFinderKind.GEORGE_LIU;
        }
        if (metric == null) {
            metric = VarOrderMetricKind.WES;
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new DcshVarOrderer(nodeFinder, metric, relations, effect);
    }

    private VarOrderer checkForceVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        VarOrderMetricKind metric = null;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "metric": {
                    this.checkDuplicateArg(name, arg, (Object)metric);
                    metric = this.checkEnumArg(name, arg, VarOrderMetricKind.class, "a metric");
                    break;
                }
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (metric == null) {
            metric = VarOrderMetricKind.TOTAL_SPAN;
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new ForceVarOrderer(metric, relations, effect);
    }

    private VarOrderer checkSlidWinVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        Integer size = null;
        VarOrderMetricKind metric = null;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        block12: for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "size": {
                    this.checkDuplicateArg(name, arg, size);
                    size = this.checkIntArg(name, arg);
                    if (size >= 1 && size <= 12) continue block12;
                    this.reportUnsupportedArgumentValue(name, arg, "the value must be in the range [1..12].");
                    throw new SemanticException();
                }
                case "metric": {
                    this.checkDuplicateArg(name, arg, (Object)metric);
                    metric = this.checkEnumArg(name, arg, VarOrderMetricKind.class, "a metric");
                    break;
                }
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (size == null) {
            size = BddSlidingWindowSizeOption.getMaxLen();
        }
        if (metric == null) {
            metric = VarOrderMetricKind.TOTAL_SPAN;
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new SlidingWindowVarOrderer(size, metric, relations, effect);
    }

    private VarOrderer checkSloanVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new SloanVarOrderer(relations, effect);
    }

    private VarOrderer checkWeightedCmVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        PseudoPeripheralNodeFinderKind nodeFinder = null;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "node-finder": {
                    this.checkDuplicateArg(name, arg, (Object)nodeFinder);
                    nodeFinder = this.checkEnumArg(name, arg, PseudoPeripheralNodeFinderKind.class, "a node finder algorithm");
                    break;
                }
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (nodeFinder == null) {
            nodeFinder = PseudoPeripheralNodeFinderKind.GEORGE_LIU;
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new WeightedCuthillMcKeeVarOrderer(nodeFinder, relations, effect);
    }

    private VarOrderer checkChoiceVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        List<VarOrderer> choices = null;
        VarOrderMetricKind metric = null;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        block12: for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "choices": {
                    this.checkDuplicateArg(name, arg, choices);
                    if (!(arg instanceof VarOrdererListOrderersArg)) {
                        this.reportUnsupportedArgumentValue(name, arg, "the value must be a list of variable orderers.");
                        throw new SemanticException();
                    }
                    choices = this.checkVarOrderers(((VarOrdererListOrderersArg)arg).value);
                    if (choices.size() >= 2) continue block12;
                    this.reportUnsupportedArgumentValue(name, arg, "the value must be a list with at least two variable orderers.");
                    throw new SemanticException();
                }
                case "metric": {
                    this.checkDuplicateArg(name, arg, (Object)metric);
                    metric = this.checkEnumArg(name, arg, VarOrderMetricKind.class, "a metric");
                    break;
                }
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (choices == null) {
            this.reportMissingArgument(astOrderer.name, "choices");
            throw new SemanticException();
        }
        if (metric == null) {
            metric = VarOrderMetricKind.WES;
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new ChoiceVarOrderer(choices, metric, relations, effect);
    }

    private VarOrderer checkReverseVarOrderer(VarOrdererSingleInstance astOrderer) {
        String name = astOrderer.name.text;
        RelationsKind relations = null;
        VarOrdererEffect effect = null;
        for (VarOrdererArg arg : astOrderer.arguments) {
            switch (arg.name.text) {
                case "relations": {
                    this.checkDuplicateArg(name, arg, (Object)relations);
                    relations = this.checkRelationsKindArg(name, arg);
                    break;
                }
                case "effect": {
                    this.checkDuplicateArg(name, arg, (Object)effect);
                    effect = this.checkEnumArg(name, arg, VarOrdererEffect.class, "a variable orderer effect");
                    break;
                }
                default: {
                    this.reportUnsupportedArgumentName(name, arg);
                    throw new SemanticException();
                }
            }
        }
        if (relations == null) {
            relations = this.getBasicConfiguredRelationsKind(name);
        }
        if (effect == null) {
            effect = VarOrdererEffect.VAR_ORDER;
        }
        return new ReverseVarOrderer(relations, effect);
    }

    private void checkDuplicateArg(String name, VarOrdererArg arg, Object curValue) {
        if (curValue != null) {
            this.reportDuplicateArgument(name, arg);
            throw new SemanticException();
        }
    }

    private int checkIntArg(String name, VarOrdererArg arg) {
        int value;
        if (!(arg instanceof VarOrdererNumberArg)) {
            this.reportUnsupportedArgumentValue(name, arg, "the value must be a number.");
            throw new SemanticException();
        }
        try {
            value = Integer.parseInt(((VarOrdererNumberArg)arg).value.text);
        }
        catch (NumberFormatException e) {
            this.reportUnsupportedArgumentValue(name, arg, "the value is out of range.");
            throw new SemanticException();
        }
        return value;
    }

    private long checkLongArg(String name, VarOrdererArg arg) {
        long value;
        if (!(arg instanceof VarOrdererNumberArg)) {
            this.reportUnsupportedArgumentValue(name, arg, "the value must be a number.");
            throw new SemanticException();
        }
        try {
            value = Long.parseLong(((VarOrdererNumberArg)arg).value.text);
        }
        catch (NumberFormatException e) {
            this.reportUnsupportedArgumentValue(name, arg, "the value is out of range.");
            throw new SemanticException();
        }
        return value;
    }

    private <T extends Enum<T>> T checkEnumArg(String name, VarOrdererArg arg, Class<T> enumClass, String valueDescription) {
        if (!(arg instanceof VarOrdererOrdererArg)) {
            this.reportUnsupportedArgumentValue(name, arg, Strings.fmt((String)"the value must be %s.", (Object[])new Object[]{valueDescription}));
            throw new SemanticException();
        }
        VarOrdererInstance orderer = ((VarOrdererOrdererArg)arg).value;
        if (orderer instanceof VarOrdererMultiInstance) {
            this.reportUnsupportedArgumentValue(name, arg, Strings.fmt((String)"the value must be %s.", (Object[])new Object[]{valueDescription}));
            throw new SemanticException();
        }
        VarOrdererSingleInstance single = (VarOrdererSingleInstance)orderer;
        if (single.hasArgs) {
            this.reportUnsupportedArgumentValue(name, arg, Strings.fmt((String)"the value must be %s.", (Object[])new Object[]{valueDescription}));
            throw new SemanticException();
        }
        String constantName = single.name.text.replace("-", "_").toUpperCase(Locale.US);
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        List matches = Arrays.stream(values).filter(v -> v.name().equals(constantName)).collect(Collectors.toList());
        Assert.check((matches.size() <= 2 ? 1 : 0) != 0);
        if (matches.size() == 1) {
            return (T)((Enum)Lists.first(matches));
        }
        this.reportUnsupportedArgumentValue(name, arg, Strings.fmt((String)"the value must be %s.", (Object[])new Object[]{valueDescription}));
        throw new SemanticException();
    }

    private RelationsKind checkRelationsKindArg(String name, VarOrdererArg arg) {
        if (!(arg instanceof VarOrdererOrdererArg)) {
            this.reportUnsupportedArgumentValue(name, arg, "the value must be a kind of relations.");
            throw new SemanticException();
        }
        VarOrdererInstance orderer = ((VarOrdererOrdererArg)arg).value;
        if (orderer instanceof VarOrdererMultiInstance) {
            this.reportUnsupportedArgumentValue(name, arg, "the value must be a kind of relations.");
            throw new SemanticException();
        }
        VarOrdererSingleInstance single = (VarOrdererSingleInstance)orderer;
        if (single.hasArgs) {
            this.reportUnsupportedArgumentValue(name, arg, "the value must be a kind of relations.");
            throw new SemanticException();
        }
        String constantName = single.name.text.replace("-", "_").toUpperCase(Locale.US);
        RelationsKind[] values = (RelationsKind[])RelationsKind.class.getEnumConstants();
        List matches = Arrays.stream(values).filter(v -> v.name().equals(constantName)).collect(Collectors.toList());
        Assert.check((matches.size() <= 2 ? 1 : 0) != 0);
        if (matches.size() == 1) {
            return (RelationsKind)((Object)Lists.first(matches));
        }
        if (constantName.equals("CONFIGURED")) {
            return this.getBasicConfiguredRelationsKind(name);
        }
        this.reportUnsupportedArgumentValue(name, arg, "the value must be a kind of relations.");
        throw new SemanticException();
    }

    private void reportUnsupportedArgumentName(String name, VarOrdererArg arg) {
        this.addError(Strings.fmt((String)"The \"%s\" orderer does not support the \"%s\" argument.", (Object[])new Object[]{name, arg.name.text}), arg.name.position);
    }

    private void reportDuplicateArgument(String name, VarOrdererArg arg) {
        this.addError(Strings.fmt((String)"The \"%s\" orderer has a duplicate \"%s\" argument.", (Object[])new Object[]{name, arg.name.text}), arg.name.position);
    }

    private void reportMissingArgument(Token name, String missingArgName) {
        this.addError(Strings.fmt((String)"The \"%s\" orderer is missing its mandatory \"%s\" argument.", (Object[])new Object[]{name.text, missingArgName}), name.position);
    }

    private void reportUnsupportedArgumentValue(String name, VarOrdererArg arg, String details) {
        this.addError(Strings.fmt((String)"The \"%s\" orderer has an unsupported value for the \"%s\" argument: %s", (Object[])new Object[]{name, arg.name.text, details}), arg.name.position);
    }
}

