/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.workset.dependencies;

import com.github.javabdd.BDD;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.workset.dependencies.EdgeDependencySetCreator;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class BddBasedEdgeDependencySetCreator
implements EdgeDependencySetCreator {
    @Override
    public void createAndStore(SynthesisAutomaton synthAut, boolean forwardEnabled) {
        int edgeCnt = synthAut.edges.size();
        Map followEvents = Maps.mapc((int)edgeCnt);
        for (SynthesisEdge precedingEdge : synthAut.orderedEdgesForward) {
            Event precedingEvent = precedingEdge.event;
            precedingEdge.preApply(true, null);
            BDD precedingEdgeReachableStates = precedingEdge.apply(synthAut.factory.one(), false, true, null, false);
            precedingEdge.postApply(true);
            for (SynthesisEdge followingEdge : synthAut.orderedEdgesForward) {
                Event followingEvent = followingEdge.event;
                if (precedingEvent == followingEvent) continue;
                BDD enabled = precedingEdgeReachableStates.and(followingEdge.guard);
                if (!enabled.isZero()) {
                    followEvents.computeIfAbsent(precedingEvent, e -> Sets.set()).add(followingEvent);
                }
                enabled.free();
            }
            precedingEdgeReachableStates.free();
        }
        synthAut.worksetDependenciesBackward = this.create(followEvents, synthAut.orderedEdgesBackward, false);
        if (forwardEnabled) {
            synthAut.worksetDependenciesForward = this.create(followEvents, synthAut.orderedEdgesForward, true);
        }
    }

    private List<BitSet> create(Map<Event, Set<Event>> followEvents, List<SynthesisEdge> edges, boolean forward) {
        List dependencies = Lists.listc((int)edges.size());
        for (SynthesisEdge edge1 : edges) {
            BitSet dependencies1 = new BitSet(edges.size());
            int i = 0;
            while (i < edges.size()) {
                SynthesisEdge edge2 = edges.get(i);
                boolean isDependency = forward ? followEvents.computeIfAbsent(edge1.event, e -> Sets.set()).contains(edge2.event) : followEvents.computeIfAbsent(edge2.event, e -> Sets.set()).contains(edge1.event);
                if (isDependency) {
                    dependencies1.set(i);
                }
                ++i;
            }
            dependencies.add(dependencies1);
        }
        return dependencies;
    }
}

