/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.workset.pruners;

import java.util.BitSet;
import java.util.Iterator;
import org.eclipse.escet.cif.datasynth.workset.pruners.EdgePruner;
import org.eclipse.escet.common.java.BitSets;

public class RewardBasedEdgePruner
extends EdgePruner {
    private final int[] rewards;
    private final int effectReward;
    private final int noEffectReward;

    public RewardBasedEdgePruner(int edgeCnt, int effectReward, int noEffectReward) {
        this.rewards = new int[edgeCnt];
        this.effectReward = effectReward;
        this.noEffectReward = noEffectReward;
    }

    @Override
    protected BitSet pruneInternal(BitSet workset) {
        int max = Integer.MIN_VALUE;
        Iterator iterator = BitSets.iterateTrueBits((BitSet)workset).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int reward = this.rewards[i];
            if (reward < max) {
                workset.clear(i);
                continue;
            }
            if (reward <= max) continue;
            max = reward;
            workset.clear(0, i);
        }
        return workset;
    }

    @Override
    public void update(int edgeIdx, boolean hadAnEffect) {
        long curReward = this.rewards[edgeIdx];
        if ((curReward += (long)(hadAnEffect ? this.effectReward : this.noEffectReward)) > Integer.MAX_VALUE) {
            curReward = Integer.MAX_VALUE;
        } else if (curReward < Integer.MIN_VALUE) {
            curReward = Integer.MIN_VALUE;
        }
        this.rewards[edgeIdx] = (int)curReward;
    }
}

