/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.workset.pruners;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.datasynth.workset.pruners.EdgePruner;
import org.eclipse.escet.common.java.Assert;

public class SequentialEdgePruner
extends EdgePruner {
    private final List<EdgePruner> pruners;

    public SequentialEdgePruner(EdgePruner ... pruners) {
        this(Arrays.asList(pruners));
    }

    public SequentialEdgePruner(List<EdgePruner> pruners) {
        this.pruners = pruners;
        Assert.check((pruners.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public BitSet pruneInternal(BitSet workset) {
        for (EdgePruner pruner : this.pruners) {
            workset = pruner.prune(workset);
        }
        return workset;
    }

    @Override
    public void update(int edgeIdx, boolean hadAnEffect) {
        for (EdgePruner pruner : this.pruners) {
            pruner.update(edgeIdx, hadAnEffect);
        }
    }
}

