/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FunctionState
extends BaseState {
    public final InternalFunction func;
    public final Map<DiscVariable, Integer> indices;

    public FunctionState(Explorer explorer, InternalFunction func, Object[] paramValues, Object[] varValues) {
        super(explorer, new Location[0], ArrayUtils.addAll((Object[])paramValues, (Object[])varValues));
        this.func = func;
        this.indices = Maps.mapc((int)this.values.length);
        int i = 0;
        for (FunctionParameter param : func.getParameters()) {
            this.indices.put(param.getParameter(), i);
            ++i;
        }
        for (DiscVariable var : func.getVariables()) {
            this.indices.put(var, i);
            ++i;
        }
    }

    public FunctionState(FunctionState state) {
        super(state.explorer, new Location[0], (Object[])state.values.clone());
        this.func = state.func;
        this.indices = state.indices;
    }

    @Override
    public boolean isInitial() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMarked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getVarValue(PositionObject var) {
        Expression valueExpr;
        Integer idx = this.indices.get(var);
        Assert.notNull((Object)idx);
        Object value = this.values[idx];
        if (value != null) {
            return value;
        }
        Assert.check((!(var.eContainer() instanceof FunctionParameter) ? 1 : 0) != 0);
        DiscVariable localVar = (DiscVariable)var;
        if (localVar.getValue() != null) {
            Assert.check((localVar.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            valueExpr = (Expression)localVar.getValue().getValues().get(0);
        } else {
            CifType type = localVar.getType();
            valueExpr = CifValueUtils.getDefaultValue((CifType)type, (List)Lists.list());
        }
        try {
            value = this.eval(valueExpr, null);
        }
        catch (CifEvalException ex) {
            String msg = Strings.fmt((String)"Failed to compute initial value of variable \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            throw new InvalidModelException(msg, (Throwable)ex);
        }
        this.values[idx.intValue()] = value;
        return value;
    }

    @Override
    public void setVarValue(PositionObject var, Object value) {
        Assert.notNull((Object)value);
        int index = this.indices.get(var);
        this.values[index] = value;
    }

    @Override
    public Location getCurrentLocation(int autIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression getAlgExpression(AlgVariable algVar) {
        throw new UnsupportedOperationException();
    }
}

