/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.CollectedAlgVariable;
import org.eclipse.escet.cif.explorer.runtime.CollectedInvariants;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.NoInitialInitPredReason;
import org.eclipse.escet.cif.explorer.runtime.NoInitialInvReason;
import org.eclipse.escet.cif.explorer.runtime.NoInitialLocReason;
import org.eclipse.escet.cif.explorer.runtime.NoInitialStateException;
import org.eclipse.escet.cif.explorer.runtime.NoInitialStateReason;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InitialState
extends BaseState {
    private List<InternalFunction> funcs = Lists.list();
    public Map<Automaton, Location> autLocs;
    public Map<DiscVariable, Expression> varVals;

    public InitialState(Explorer explorer) {
        super(explorer, new Location[explorer.automata.length], new Object[explorer.variables.length]);
    }

    @Override
    public Object getVarValue(PositionObject var) {
        int index = this.explorer.indices.get(var);
        if (this.values[index] != null) {
            return this.values[index];
        }
        if (var instanceof ContVariable) {
            ContVariable cv = (ContVariable)var;
            if (cv.getValue() != null) {
                try {
                    this.values[index] = this.eval(cv.getValue(), null);
                    return this.values[index];
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute initial value of variable \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)cv)});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
            }
            this.values[index] = 0.0;
            return this.values[index];
        }
        if (var instanceof DiscVariable) {
            DiscVariable dv = (DiscVariable)var;
            Expression value = this.varVals.get(dv);
            if (value != null) {
                Assert.check((dv.getValue().getValues().size() != 1 ? 1 : 0) != 0);
                try {
                    this.values[index] = this.eval(value, null);
                    return this.values[index];
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute initial value \"%s\" of variable \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)value), CifTextUtils.getAbsName((PositionObject)dv)});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
            }
            if (dv.getValue() != null) {
                Assert.check((dv.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                try {
                    this.values[index] = this.eval((Expression)dv.getValue().getValues().get(0), null);
                    return this.values[index];
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute the initial value of variable \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)dv)});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
            }
            Expression e = CifValueUtils.getDefaultValue((CifType)dv.getType(), this.funcs);
            try {
                this.values[index] = this.eval(e, null);
                return this.values[index];
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute default initial value of variable \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        String msg = Strings.fmt((String)"Unknown kind of variable %s requested.", (Object[])new Object[]{var});
        throw new RuntimeException(msg);
    }

    @Override
    public void setVarValue(PositionObject var, Object value) {
        throw new UnsupportedOperationException();
    }

    private boolean isInitialLoc(Location loc) {
        List<Expression> initialExprs = this.explorer.initialLocs.get(loc);
        if (initialExprs == null || initialExprs.isEmpty()) {
            return false;
        }
        for (Expression expr : initialExprs) {
            boolean val;
            try {
                val = (Boolean)this.eval(expr, null);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute initialization predicate \"%s\" in %s.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.getLocationText2((Location)loc)});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
            if (val) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression getAlgExpression(AlgVariable algVar) {
        CollectedAlgVariable cav = this.explorer.algVariables.get(algVar);
        if (cav.value != null) {
            return cav.value;
        }
        Assert.check((cav.autIndex >= 0 ? 1 : 0) != 0);
        Location curLoc = this.getCurrentLocation(cav.autIndex);
        return cav.getExpression(curLoc);
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    @Override
    public boolean isMarked() {
        for (Expression expr : this.explorer.markeds) {
            try {
                if (((Boolean)this.eval(expr, null)).booleanValue()) continue;
                return false;
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute marker predicate \"%s\" for initial state.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        int autIndex = 0;
        while (autIndex < this.explorer.automata.length) {
            Location loc = this.getCurrentLocation(autIndex);
            if (loc.getMarkeds().isEmpty()) {
                return false;
            }
            for (Expression expr : loc.getMarkeds()) {
                try {
                    if (((Boolean)this.eval(expr, null)).booleanValue()) continue;
                    return false;
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute marker predicate \"%s\" in %s, for initial state.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.getLocationText2((Location)loc)});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
            }
            ++autIndex;
        }
        return true;
    }

    @Override
    public Location getCurrentLocation(int autIndex) {
        if (this.locations[autIndex] != null) {
            return this.locations[autIndex];
        }
        Automaton aut = this.explorer.automata[autIndex];
        Location initLoc = this.autLocs.get(aut);
        if (initLoc != null) {
            if (this.isInitialLoc(initLoc)) {
                this.locations[autIndex] = initLoc;
                return initLoc;
            }
        } else {
            for (Location loc : aut.getLocations()) {
                if (!this.isInitialLoc(loc)) continue;
                this.locations[autIndex] = loc;
                return loc;
            }
        }
        NoInitialLocReason reason = new NoInitialLocReason(aut);
        throw new NoInitialStateException(reason);
    }

    public NoInitialStateReason computeCompletely() {
        NoInitialInvReason reason;
        PositionObject[] positionObjectArray = this.explorer.variables;
        int n = this.explorer.variables.length;
        int n2 = 0;
        while (n2 < n) {
            PositionObject po = positionObjectArray[n2];
            this.getVarValue(po);
            ++n2;
        }
        int i = 0;
        while (i < this.explorer.automata.length) {
            this.getCurrentLocation(i);
            ++i;
        }
        List<Expression> globalInits = this.explorer.initialLocs.get(null);
        if (globalInits != null) {
            for (Expression expr : globalInits) {
                boolean val;
                try {
                    val = (Boolean)this.eval(expr, null);
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute initialization predicate \"%s\" in initial state.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
                if (val) continue;
                return new NoInitialInitPredReason(expr);
            }
        }
        if ((reason = this.checkStateInvs(this.explorer.stateInvs.get(null))) != null) {
            return reason;
        }
        Location[] locationArray = this.locations;
        int n3 = this.locations.length;
        int n4 = 0;
        while (n4 < n3) {
            Location loc = locationArray[n4];
            reason = this.checkStateInvs(this.explorer.stateInvs.get(loc));
            if (reason != null) {
                return reason;
            }
            ++n4;
        }
        return null;
    }

    private NoInitialInvReason checkStateInvs(CollectedInvariants ci) {
        if (ci == null) {
            return null;
        }
        NoInitialInvReason reason = null;
        reason = this.checkStateInvs(ci.getNoneInvariants());
        if (reason == null) {
            reason = this.checkStateInvs(ci.getPlantInvariants());
        }
        if (reason == null) {
            reason = this.checkStateInvs(ci.getRequirementInvariants());
        }
        if (reason == null) {
            reason = this.checkStateInvs(ci.getSupervisorInvariants());
        }
        return reason;
    }

    private NoInitialInvReason checkStateInvs(List<Invariant> invs) {
        for (Invariant inv : invs) {
            boolean val;
            try {
                val = (Boolean)this.eval(inv.getPredicate(), null);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute invariant \"%s\" in initial state.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false)});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
            if (val) continue;
            return new NoInitialInvReason(inv);
        }
        return null;
    }
}

