/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesOptimized;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.multilevel.WriteDMMsOption;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifRelations;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifToDmm;
import org.eclipse.escet.cif.multilevel.clustering.ComputeMultiLevelTree;
import org.eclipse.escet.cif.multilevel.clustering.TreeNode;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.ClusterInputData;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmClustering;

public class MultilevelApp
extends Application<IOutputComponent> {
    private static final RealMatrixFormat MAT_DEBUG_FORMAT;

    static {
        NumberFormat valueFmt = NumberFormat.getIntegerInstance(Locale.US);
        MAT_DEBUG_FORMAT = new RealMatrixFormat("", "", "  ", "", "\n", " ", valueFmt);
    }

    public static void main(String[] args) {
        MultilevelApp app = new MultilevelApp();
        app.run(args);
    }

    public MultilevelApp() {
    }

    public MultilevelApp(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ElimComponentDefInst().transform(spec);
        new ElimSelf().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new SimplifyValuesOptimized().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifToDmm.checkSpec(spec, absSpecPath);
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifRelations cifRelations = CifToDmm.transformToDmms(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        if (WriteDMMsOption.writeDmms()) {
            String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".dmms.txt");
            cifRelations.writeDmms(InputFileOption.getPath(), outPath);
        }
        Dmm reqsPlantsDmm = cifRelations.relations;
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Plant groups:");
            OutputProvider.dbg((String)cifRelations.plantGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement groups:");
            OutputProvider.dbg((String)cifRelations.requirementGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement / Plant relations:");
            OutputProvider.dbg((String)cifRelations.relations.toString());
            OutputProvider.dbg();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        RealMatrix unclusteredMatrix = reqsPlantsDmm.adjacencies.transpose().multiply(reqsPlantsDmm.adjacencies);
        OutputProvider.dbg((String)"Unclustered reqsPlants:");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(unclusteredMatrix));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        OutputProvider.dbg((String)"--- Start of clustering --");
        OutputProvider.idbg();
        ClusterInputData clusteringData = new ClusterInputData(unclusteredMatrix, reqsPlantsDmm.columnLabels);
        Dsm clusteredDsm = DsmClustering.flowBasedMarkovClustering((ClusterInputData)clusteringData);
        OutputProvider.ddbg();
        OutputProvider.dbg((String)"--- End of clustering --");
        OutputProvider.dbg();
        OutputProvider.dbg((String)"Clustered DSM for reqsPlantsDmm (for information only, this data is not actually used):");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(clusteredDsm.adjacencies));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        TreeNode rootNode = ComputeMultiLevelTree.transformCluster(clusteredDsm.rootGroup, unclusteredMatrix, reqsPlantsDmm.adjacencies);
        if (this.isTerminationRequested()) {
            return 0;
        }
        for (TreeNode node : rootNode.linearizeTree()) {
            OutputProvider.out((String)"Index: %d", (Object[])new Object[]{node.index});
            OutputProvider.out((String)"Plant groups: %s", (Object[])new Object[]{node.plantGroups.isEmpty() ? "<none>" : node.plantGroups.toString()});
            OutputProvider.out((String)"Req groups:   %s", (Object[])new Object[]{node.requirementGroups.isEmpty() ? "<none>" : node.requirementGroups.toString()});
            String childNodeNumbers = node.childNodes.stream().map(n -> String.valueOf(n.index)).collect(Collectors.joining(", "));
            OutputProvider.out((String)"Child nodes: %s", (Object[])new Object[]{childNodeNumbers.isEmpty() ? "<none>" : childNodeNumbers});
            OutputProvider.out();
        }
        OutputProvider.warn((String)"Multi-level synthesis not yet implemented.");
        return 0;
    }

    public String getAppName() {
        return "CIF multi-level synthesis";
    }

    public String getAppDescription() {
        return "Performs synthesis by making several smaller co-operating supervisors.";
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = MultilevelApp.getGeneralOptionCategory();
        List<Option> programOpts = List.of(Options.getInstance(InputFileOption.class), Options.getInstance(OutputFileOption.class), Options.getInstance(WriteDMMsOption.class));
        OptionCategory programCat = new OptionCategory("Multi-level synthesis", "Multi-level synthesis options.", List.of(), programOpts);
        return new OptionCategory("CIF Multi-level Synthesis Options", "All options for the CIF multi-level synthesis tool.", List.of(generalCat, programCat), List.of());
    }
}

