/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.dsm.Dmm;

public class CifRelations {
    public final Dmm plantGroups;
    public final Dmm requirementGroups;
    public final Dmm relations;

    public CifRelations(Dmm plantGroups, Dmm requirementGroups, Dmm relations) {
        this.plantGroups = plantGroups;
        this.requirementGroups = requirementGroups;
        this.relations = relations;
    }

    public void writeDmms(String cifPath, String outPath) {
        String absOutPath = Paths.resolve((String)outPath);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileAppStream stream = new FileAppStream(outPath, absOutPath);){
            stream.printfln("DMMs of the \"%s\" CIF specification.", new Object[]{cifPath});
            stream.println();
            stream.printfln("Plant groups:%n%s", new Object[]{this.plantGroups.toString()});
            stream.println();
            stream.printfln("Requirement groups:%n%s", new Object[]{this.requirementGroups.toString()});
            stream.println();
            stream.printfln("Plant-groups/requirement-groups relations:%n%s", new Object[]{this.relations.toString()});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

