/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlySpecificSupKindsCheck;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithOneInitLocCheck;
import org.eclipse.escet.cif.checkers.checks.EqnNotAllowedCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoTauCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarDiscOnlyStaticEvalInitCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoContinuousCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifRelations;
import org.eclipse.escet.cif.multilevel.ciftodmm.Labels;
import org.eclipse.escet.cif.multilevel.ciftodmm.OwnedAndAccessedElements;
import org.eclipse.escet.cif.multilevel.ciftodmm.RelationsCollector;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasPlantCheck;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasRequirementCheck;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.Lists;

public class CifToDmm {
    private CifToDmm() {
    }

    public static void checkSpec(Specification spec, String absSpecPath) {
        CifToDmmPreChecker checker = new CifToDmmPreChecker();
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF to DMM transformation");
    }

    public static CifRelations transformToDmms(Specification spec) {
        RelationsCollector collector = new RelationsCollector();
        collector.collect(spec);
        if (AppEnv.isTerminationRequested()) {
            return null;
        }
        List<OwnedAndAccessedElements> plantGroups = collector.computePlantGroups();
        List<OwnedAndAccessedElements> requirementGroups = collector.computeRequirementGroups();
        Dmm plantGroupsDmm = CifToDmm.makeGroupDmm(collector, plantGroups, Labels::makePlantGroupLabel);
        Dmm requirementGroupsDmm = CifToDmm.makeGroupDmm(collector, requirementGroups, Labels::makeRequirementGroupLabel);
        List plantRelations = plantGroups.stream().map(pg -> pg.getRelations()).collect(Collectors.toCollection(Lists::list));
        List requirementRelations = requirementGroups.stream().map(rg -> rg.getRelations()).collect(Collectors.toCollection(Lists::list));
        int numColumns = plantRelations.size();
        int numRows = requirementRelations.size();
        Label[] columnLabels = (Label[])IntStream.range(0, numColumns).mapToObj(Labels::makePlantGroupLabel).toArray(Label[]::new);
        Label[] rowLabels = (Label[])IntStream.range(0, numRows).mapToObj(Labels::makeRequirementGroupLabel).toArray(Label[]::new);
        BlockRealMatrix values = new BlockRealMatrix(numRows, numColumns);
        int row = 0;
        while (row < numRows) {
            BitSet rowRelations = (BitSet)requirementRelations.get(row);
            int col = 0;
            while (col < numColumns) {
                BitSet colRelations = (BitSet)plantRelations.get(col);
                values.setEntry(row, col, (double)(rowRelations.intersects(colRelations) ? 1 : 0));
                ++col;
            }
            ++row;
        }
        Dmm plantGrpsRequirementGrpsDmm = new Dmm((RealMatrix)values, rowLabels, columnLabels);
        return new CifRelations(plantGroupsDmm, requirementGroupsDmm, plantGrpsRequirementGrpsDmm);
    }

    private static Dmm makeGroupDmm(RelationsCollector collector, List<OwnedAndAccessedElements> groups, Function<Integer, Label> labelFunc) {
        int numColumns = groups.size();
        int numRows = groups.stream().collect(Collectors.summingInt(grp -> grp.groupElements.cardinality()));
        Label[] columnLabels = new Label[numColumns];
        Label[] rowLabels = new Label[numRows];
        BlockRealMatrix dmmValues = new BlockRealMatrix(numRows, numColumns);
        int row = 0;
        int col = 0;
        while (col < numColumns) {
            OwnedAndAccessedElements group = groups.get(col);
            columnLabels[col] = labelFunc.apply(col);
            Iterator iterator = new BitSetIterator(group.groupElements).iterator();
            while (iterator.hasNext()) {
                int groupElement = (Integer)iterator.next();
                rowLabels[row] = Labels.makeLabel(collector.getElement(groupElement));
                dmmValues.setEntry(row, col, 1.0);
                ++row;
            }
            ++col;
        }
        Assert.areEqual((Object)numRows, (Object)row);
        return new Dmm((RealMatrix)dmmValues, rowLabels, columnLabels);
    }

    private static class CifToDmmPreChecker
    extends CifPreconditionChecker {
        public CifToDmmPreChecker() {
            super(new CifCheck[]{new AutOnlyWithOneInitLocCheck(), new VarNoDiscWithMultiInitValuesCheck(), new VarDiscOnlyStaticEvalInitCheck(), new AutOnlySpecificSupKindsCheck(SupKind.PLANT, SupKind.REQUIREMENT), new SpecHasPlantCheck(), new SpecHasRequirementCheck(), new InvNoSpecificInvsCheck().disallow(NoInvariantSupKind.KINDLESS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.SUPERVISOR, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.PLANT, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.REQUIREMENT, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.LOCATIONS), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.COMP_DEF_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.COMP_TYPES}), new EventNoTauCheck(), new VarNoContinuousCheck(), new EqnNotAllowedCheck()});
        }
    }
}

