/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.clustering;

import java.util.BitSet;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.cif.multilevel.clustering.TreeNode;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Strings;

public class ComputeMultiLevelTree {
    private ComputeMultiLevelTree() {
    }

    public static TreeNode transformCluster(Group clusterGroup, RealMatrix p, RealMatrix rp) {
        if (clusterGroup.members.cardinality() == 1) {
            return ComputeMultiLevelTree.transformClusterSingle(clusterGroup.members.nextSetBit(0), p, rp);
        }
        return ComputeMultiLevelTree.transformClusterMultiple(clusterGroup, p, rp);
    }

    private static TreeNode transformClusterMultiple(Group clusterGroup, RealMatrix p, RealMatrix rp) {
        Assert.check((boolean)p.isSquare());
        OutputProvider.dbg((String)"Make a multi-level tree node for a cluster group with multiple nodes:");
        OutputProvider.idbg();
        clusterGroup.dbgDump();
        OutputProvider.dbg();
        p = p.copy();
        rp = rp.copy();
        TreeNode treeNode = ComputeMultiLevelTree.calculateGandKMultiple(clusterGroup, p, rp);
        if (clusterGroup.localNodes != null) {
            Iterator iterator = new BitSetIterator(clusterGroup.localNodes).iterator();
            while (iterator.hasNext()) {
                int childNode = (Integer)iterator.next();
                treeNode.childNodes.add(ComputeMultiLevelTree.transformClusterSingle(childNode, p, rp));
            }
        }
        for (Group childGroup : clusterGroup.childGroups) {
            treeNode.childNodes.add(ComputeMultiLevelTree.transformCluster(childGroup, p, rp));
        }
        OutputProvider.ddbg();
        OutputProvider.dbg((String)"---------- DONE Created tree node for cluster with multiple nodes.");
        OutputProvider.dbg();
        return treeNode;
    }

    private static TreeNode transformClusterSingle(int clusterGroup, RealMatrix p, RealMatrix rp) {
        Assert.check((boolean)p.isSquare());
        OutputProvider.dbg((String)"Make a multi-level tree node for a cluster group with a single node (plant group %d):", (Object[])new Object[]{clusterGroup});
        OutputProvider.idbg();
        TreeNode treeNode = ComputeMultiLevelTree.calculateGandKSingle(clusterGroup, p, rp);
        OutputProvider.ddbg();
        OutputProvider.dbg((String)"---------- DONE Created tree node for cluster with a single node.");
        OutputProvider.dbg();
        return treeNode;
    }

    private static TreeNode calculateGandKMultiple(Group clusterGroup, RealMatrix p, RealMatrix rp) {
        Assert.check((boolean)p.isSquare());
        OutputProvider.dbg((String)"Starting Algorithm 2 by searching and modifying the matrices based on group information.");
        OutputProvider.idbg();
        ComputeMultiLevelTree.dbgDumpPmatrix(p);
        ComputeMultiLevelTree.dbgDumpRPmatrix(rp);
        OutputProvider.dbg();
        TreeNode treeNode = new TreeNode();
        if (clusterGroup.localNodes != null) {
            Iterator iterator = new BitSetIterator(clusterGroup.localNodes).iterator();
            while (iterator.hasNext()) {
                int node1 = (Integer)iterator.next();
                Iterator iterator2 = new BitSetIterator(clusterGroup.localNodes).iterator();
                while (iterator2.hasNext()) {
                    int node2 = (Integer)iterator2.next();
                    ComputeMultiLevelTree.update(p, rp, treeNode, node1, node2);
                }
                for (Group childGroup : clusterGroup.childGroups) {
                    Iterator iterator3 = new BitSetIterator(childGroup.members).iterator();
                    while (iterator3.hasNext()) {
                        int node2 = (Integer)iterator3.next();
                        ComputeMultiLevelTree.update(p, rp, treeNode, node1, node2);
                    }
                }
            }
        }
        int numChildGroups = clusterGroup.childGroups.size();
        int grp1 = 0;
        while (grp1 < numChildGroups) {
            Iterator iterator;
            Group child1 = (Group)clusterGroup.childGroups.get(grp1);
            if (clusterGroup.localNodes != null) {
                Iterator node2 = new BitSetIterator(child1.members).iterator();
                while (node2.hasNext()) {
                    int node1 = (Integer)node2.next();
                    iterator = new BitSetIterator(clusterGroup.localNodes).iterator();
                    while (iterator.hasNext()) {
                        int node22 = (Integer)iterator.next();
                        ComputeMultiLevelTree.update(p, rp, treeNode, node1, node22);
                    }
                }
            }
            int grp2 = 0;
            while (grp2 < numChildGroups) {
                if (grp1 != grp2) {
                    Group child2 = (Group)clusterGroup.childGroups.get(grp2);
                    iterator = new BitSetIterator(child1.members).iterator();
                    while (iterator.hasNext()) {
                        int node1 = (Integer)iterator.next();
                        Iterator iterator4 = new BitSetIterator(child2.members).iterator();
                        while (iterator4.hasNext()) {
                            int node2 = (Integer)iterator4.next();
                            ComputeMultiLevelTree.update(p, rp, treeNode, node1, node2);
                        }
                    }
                }
                ++grp2;
            }
            ++grp1;
        }
        OutputProvider.dbg((String)"Updated Algorithm 2 data for cluster group members %s: %s plant groups, %s req groups.", (Object[])new Object[]{clusterGroup.members, treeNode.plantGroups, treeNode.requirementGroups});
        OutputProvider.dbg((String)"Updated matrices:");
        OutputProvider.idbg();
        ComputeMultiLevelTree.dbgDumpPmatrix(p);
        ComputeMultiLevelTree.dbgDumpRPmatrix(rp);
        OutputProvider.ddbg();
        OutputProvider.dbg();
        OutputProvider.ddbg();
        return treeNode;
    }

    private static void update(RealMatrix p, RealMatrix rp, TreeNode treeNode, int plantGroup1, int plantGroup2) {
        if (plantGroup1 == plantGroup2 || p.getEntry(plantGroup1, plantGroup2) == 0.0) {
            return;
        }
        BitSet reqGroups = ComputeMultiLevelTree.collectRequirementsForPlantGroupPair(rp, plantGroup1, plantGroup2);
        if (reqGroups.isEmpty()) {
            OutputProvider.dbg((String)"Found P cell (%d, %d), but no requirements.", (Object[])new Object[]{plantGroup1, plantGroup2});
            return;
        }
        OutputProvider.dbg((String)"Found P cell (%d, %d), with %s requirements:", (Object[])new Object[]{plantGroup1, plantGroup2, reqGroups});
        OutputProvider.idbg();
        OutputProvider.dbg((String)"(%d, %d): add %d", (Object[])new Object[]{plantGroup1, plantGroup2, -reqGroups.cardinality()});
        p.addToEntry(plantGroup1, plantGroup2, (double)(-reqGroups.cardinality()));
        OutputProvider.ddbg();
        BitSet plantGroups = ComputeMultiLevelTree.collectPlantGroupsForRequirementGroups(rp, reqGroups);
        treeNode.plantGroups.or(plantGroups);
        treeNode.requirementGroups.or(reqGroups);
        ComputeMultiLevelTree.clearPlantGroupsOfRequirementGroups(rp, reqGroups);
    }

    private static BitSet collectRequirementsForPlantGroupPair(RealMatrix rp, int plantGrp1, int plantGrp2) {
        BitSet reqGroups = new BitSet();
        int row = 0;
        while (row < rp.getRowDimension()) {
            if (rp.getEntry(row, plantGrp1) != 0.0 && rp.getEntry(row, plantGrp2) != 0.0) {
                reqGroups.set(row);
            }
            ++row;
        }
        return reqGroups;
    }

    private static BitSet collectPlantGroupsForRequirementGroups(RealMatrix rp, BitSet reqGroups) {
        BitSet plantGroups = new BitSet();
        int col = 0;
        while (col < rp.getColumnDimension()) {
            Iterator iterator = new BitSetIterator(reqGroups).iterator();
            while (iterator.hasNext()) {
                int reqGrp = (Integer)iterator.next();
                if (rp.getEntry(reqGrp, col) == 0.0) continue;
                plantGroups.set(col);
                break;
            }
            ++col;
        }
        return plantGroups;
    }

    private static void clearPlantGroupsOfRequirementGroups(RealMatrix rp, BitSet reqGroups) {
        Iterator iterator = new BitSetIterator(reqGroups).iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            int col = 0;
            while (col < rp.getColumnDimension()) {
                rp.setEntry(row, col, 0.0);
                ++col;
            }
        }
    }

    private static TreeNode calculateGandKSingle(int clusterGroup, RealMatrix p, RealMatrix rp) {
        Assert.check((boolean)p.isSquare());
        ComputeMultiLevelTree.dbgDumpPmatrix(p);
        ComputeMultiLevelTree.dbgDumpRPmatrix(rp);
        BitSet plantGroups = new BitSet();
        plantGroups.set(clusterGroup);
        BitSet reqGroups = ComputeMultiLevelTree.reqGroupsOnlyUsedBy(rp, clusterGroup);
        OutputProvider.dbg((String)"Tree node for singleton cluster group %d: %s plant groups, %s req groups.", (Object[])new Object[]{clusterGroup, plantGroups, reqGroups});
        OutputProvider.dbg();
        return new TreeNode(plantGroups, reqGroups);
    }

    private static BitSet reqGroupsOnlyUsedBy(RealMatrix rp, int plantGroup) {
        BitSet reqGroups = new BitSet();
        int row = 0;
        while (row < rp.getRowDimension()) {
            if (rp.getEntry(row, plantGroup) == 1.0) {
                double sum = 0.0;
                int col = 0;
                while (col < rp.getColumnDimension()) {
                    sum += rp.getEntry(row, col);
                    ++col;
                }
                if (sum == 1.0) {
                    reqGroups.set(row);
                }
            }
            ++row;
        }
        return reqGroups;
    }

    public static void dbgDumpPmatrix(RealMatrix p) {
        Assert.check((boolean)p.isSquare());
        OutputProvider.dbg((String)"Dumping P:");
        OutputProvider.idbg();
        String headerLine = IntStream.range(0, p.getColumnDimension()).mapToObj(c -> Strings.fmt((String)"%2d", (Object[])new Object[]{c})).collect(Collectors.joining(" "));
        OutputProvider.dbg((String)("   : " + headerLine));
        int row = 0;
        while (row < p.getRowDimension()) {
            int finalRow = row;
            IntFunction<String> convertValue = col -> {
                double v = p.getEntry(finalRow, col);
                return v == 0.0 ? " ." : Strings.fmt((String)"%2d", (Object[])new Object[]{(int)v});
            };
            String line = String.valueOf(Strings.fmt((String)"%3d: ", (Object[])new Object[]{row})) + IntStream.range(0, p.getColumnDimension()).mapToObj(convertValue).collect(Collectors.joining(" "));
            OutputProvider.dbg((String)line);
            ++row;
        }
        OutputProvider.ddbg();
        OutputProvider.dbg();
    }

    public static void dbgDumpRPmatrix(RealMatrix rp) {
        OutputProvider.dbg((String)"Dumping RP:");
        OutputProvider.idbg();
        int row = 0;
        while (row < rp.getRowDimension()) {
            int finalRow = row;
            IntPredicate nonzero = col -> rp.getEntry(finalRow, col) != 0.0;
            String line = String.valueOf(Strings.fmt((String)"%3d: ", (Object[])new Object[]{row})) + ((BitSet)IntStream.range(0, rp.getColumnDimension()).filter(nonzero).boxed().collect(BitSets.toBitSet())).toString();
            OutputProvider.dbg((String)line);
            ++row;
        }
        OutputProvider.ddbg();
        OutputProvider.dbg();
    }
}

