//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2023 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

// Disable Eclipse Java formatter for generated code file:
// @formatter:off

package org.eclipse.escet.cif.parser;

import static org.eclipse.escet.common.java.Strings.fmt;

import java.io.IOException;
import java.util.List;

import org.eclipse.escet.cif.parser.ast.ADecl;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.AFormalEventParameterPart;
import org.eclipse.escet.cif.parser.ast.AFormalParameter;
import org.eclipse.escet.cif.parser.ast.AGroupBody;
import org.eclipse.escet.cif.parser.ast.AImport;
import org.eclipse.escet.cif.parser.ast.AInvariant;
import org.eclipse.escet.cif.parser.ast.AInvariantDecl;
import org.eclipse.escet.cif.parser.ast.ASpecification;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotation;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotationArgument;
import org.eclipse.escet.cif.parser.ast.automata.AAutomatonBody;
import org.eclipse.escet.cif.parser.ast.automata.ACoreEdge;
import org.eclipse.escet.cif.parser.ast.automata.AEdgeEvent;
import org.eclipse.escet.cif.parser.ast.automata.AElifUpdate;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.automata.ALocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AUpdate;
import org.eclipse.escet.cif.parser.ast.declarations.AAlgVariable;
import org.eclipse.escet.cif.parser.ast.declarations.AConstant;
import org.eclipse.escet.cif.parser.ast.declarations.AContVariable;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariable;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDef;
import org.eclipse.escet.cif.parser.ast.expressions.ADictPair;
import org.eclipse.escet.cif.parser.ast.expressions.AElifExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AProjectionExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASetExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASwitchCase;
import org.eclipse.escet.cif.parser.ast.functions.AElifFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AElseFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AFuncBody;
import org.eclipse.escet.cif.parser.ast.functions.AFuncParam;
import org.eclipse.escet.cif.parser.ast.functions.AFuncStatement;
import org.eclipse.escet.cif.parser.ast.iodecls.AIoDecl;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrint;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFile;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFor;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintTxt;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintWhen;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgCopy;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgIn;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgInEvent;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgInEventIfEntry;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgMove;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgOut;
import org.eclipse.escet.cif.parser.ast.tokens.AEventParamFlag;
import org.eclipse.escet.cif.parser.ast.tokens.AIdentifier;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.parser.ast.tokens.AStringToken;
import org.eclipse.escet.cif.parser.ast.types.ACifType;
import org.eclipse.escet.cif.parser.ast.types.AField;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.ParserHooksBase;
import org.eclipse.escet.setext.runtime.Token;

/**
 * CifParser.
 *
 * <p>This parser is generated by SeText for main symbol
 * "Specification".</p>
 */
@SuppressWarnings("unchecked")
public final class CifParser extends Parser<ASpecification> {
    /** The names of the non-terminals, ordered by their unique ids. */
    private static final String[] NON_TERMINAL_NAMES = {
        "SupKind",
        "StdLibFunction",
        "Specification",
        "GroupBody",
        "AutomatonBody",
        "OptGroupDecls",
        "GroupDecl",
        "OptAutDecls",
        "AutDecl",
        "Decl",
        "Identifier",
        "Imports",
        "StringToken",
        "TypeDefs",
        "ConstantDefs",
        "AlgVarsDefs",
        "FuncParams",
        "FuncParamDecls",
        "FuncBody",
        "FuncVarDecls",
        "FuncVarDecl",
        "FuncStatements",
        "FuncStatement",
        "OptElifFuncStats",
        "OptElseFuncStat",
        "Events",
        "CoreEdge",
        "OptEdgeGuard",
        "OptEdgeUrgent",
        "OptEdgeUpdate",
        "EdgeEvents",
        "EdgeEvent",
        "Locations",
        "Location",
        "LocationElements",
        "LocationElement",
        "ActualParms",
        "FormalParms",
        "FormalDecls",
        "FormalDeclaration",
        "EventParamIds",
        "EventParamId",
        "OptEventParamFlags",
        "EventParamFlag",
        "DiscDecls",
        "DiscDecl",
        "ContDecls",
        "ContDecl",
        "OptDerivative",
        "Equations",
        "Equation",
        "InvariantDecls",
        "Invariants",
        "Invariant",
        "NamesSet",
        "Names",
        "Updates",
        "Update",
        "Addressables",
        "Addressable",
        "Projections",
        "Projection",
        "OptElifUpdates",
        "OptElseUpdate",
        "Identifiers",
        "OptSupKind",
        "OptControllability",
        "Controllability",
        "OptIoDecls",
        "IoDecl",
        "SvgFile",
        "OptSvgFile",
        "SvgCopy",
        "OptSvgCopyPre",
        "OptSvgCopyPost",
        "SvgMove",
        "SvgOut",
        "SvgAttr",
        "SvgIn",
        "SvgInEvent",
        "OptSvgInEventElifs",
        "SvgInEventElifs",
        "PrintFile",
        "Print",
        "PrintTxt",
        "OptPrintFors",
        "PrintFors",
        "PrintFor",
        "OptPrintWhen",
        "OptPrintFile",
        "Types",
        "EventType",
        "Type",
        "Fields",
        "Field",
        "Expressions",
        "OptExpression",
        "Expression",
        "OrExpression",
        "AndExpression",
        "CompareExpression",
        "AddExpression",
        "MulExpression",
        "UnaryExpression",
        "FuncExpression",
        "ExpressionFactor",
        "NonEmptySetExpression",
        "DictPairs",
        "OptElifExprs",
        "SwitchBody",
        "SwitchCases",
        "Name",
        "OptAnnos",
        "Annotation",
        "AnnotationArgs",
        "AnnotationArg",
        "OptComma",
    };

    /**
     * The entry symbol names for each of the parser states, and {@code null}
     * for the initial state.
     */
    private static final String[] ENTRY_SYMBOL_NAMES = new String[] {
        null,
        "GroupBody",
        "OptGroupDecls",
        "Specification",
        "ALGKW",
        "CONSTKW",
        "CONTKW",
        "CONTROLLABLEKW",
        "ENUMKW",
        "EQUATIONKW",
        "FUNCKW",
        "GROUPKW",
        "IMPORTKW",
        "INITIALKW",
        "MARKEDKW",
        "NAMESPACEKW",
        "PRINTKW",
        "PRINTFILEKW",
        "SVGCOPYKW",
        "SVGFILEKW",
        "SVGINKW",
        "SVGMOVEKW",
        "SVGOUTKW",
        "TYPEKW",
        "UNCONTROLLABLEKW",
        "PLANTKW",
        "REQUIREMENTKW",
        "SUPERVISORKW",
        "IDENTIFIERTK",
        "Controllability",
        "Decl",
        "GroupDecl",
        "Identifier",
        "InvariantDecls",
        "IoDecl",
        "OptAnnos",
        "OptControllability",
        "OptSupKind",
        "Print",
        "PrintFile",
        "SupKind",
        "SvgCopy",
        "SvgFile",
        "SvgIn",
        "SvgMove",
        "SvgOut",
        "DEFKW",
        "FALSEKW",
        "IFKW",
        "SELFKW",
        "SWITCHKW",
        "TIMEKW",
        "TRUEKW",
        "ACOSHKW",
        "ACOSKW",
        "ASINHKW",
        "ASINKW",
        "ATANHKW",
        "ATANKW",
        "COSHKW",
        "COSKW",
        "SINHKW",
        "SINKW",
        "TANHKW",
        "TANKW",
        "ABSKW",
        "CBRTKW",
        "CEILKW",
        "DELKW",
        "EMPTYKW",
        "EXPKW",
        "FLOORKW",
        "FMTKW",
        "LNKW",
        "LOGKW",
        "MAXKW",
        "MINKW",
        "POPKW",
        "POWKW",
        "ROUNDKW",
        "SCALEKW",
        "SIGNKW",
        "SIZEKW",
        "SQRTKW",
        "BERNOULLIKW",
        "BETAKW",
        "BINOMIALKW",
        "CONSTANTKW",
        "ERLANGKW",
        "EXPONENTIALKW",
        "GAMMAKW",
        "GEOMETRICKW",
        "LOGNORMALKW",
        "NORMALKW",
        "POISSONKW",
        "RANDOMKW",
        "TRIANGLEKW",
        "UNIFORMKW",
        "WEIBULLKW",
        "NOTKW",
        "SAMPLEKW",
        "QUESTIONTK",
        "LTTK",
        "PLUSTK",
        "MINUSTK",
        "CUROPENTK",
        "PAROPENTK",
        "SQOPENTK",
        "RELATIVENAMETK",
        "ABSOLUTENAMETK",
        "ROOTNAMETK",
        "NUMBERTK",
        "REALTK",
        "STRINGTK",
        "AddExpression",
        "AndExpression",
        "CompareExpression",
        "Expression",
        "ExpressionFactor",
        "FuncExpression",
        "Identifier",
        "Invariant",
        "Invariants",
        "MulExpression",
        "Name",
        "NonEmptySetExpression",
        "OrExpression",
        "StdLibFunction",
        "StringToken",
        "UnaryExpression",
        "PAROPENTK",
        "PARCLOSETK",
        "Expression",
        "Expressions",
        "Identifier",
        "Name",
        "NonEmptySetExpression",
        "APOSTROPHETK",
        "COMMATK",
        "PARCLOSETK",
        "Expression",
        "ORKW",
        "IMPLIESTK",
        "EQUIVALENCETK",
        "OrExpression",
        "OrExpression",
        "AndExpression",
        "ANDKW",
        "CompareExpression",
        "INKW",
        "SUBKW",
        "LTTK",
        "LETK",
        "EQTK",
        "NETK",
        "GETK",
        "GTTK",
        "AddExpression",
        "PLUSTK",
        "MINUSTK",
        "MulExpression",
        "DIVKW",
        "MODKW",
        "ASTERISKTK",
        "SLASHTK",
        "UnaryExpression",
        "UnaryExpression",
        "UnaryExpression",
        "UnaryExpression",
        "MulExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "NEEDSKW",
        "Expression",
        "NEEDSKW",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "Identifier",
        "Invariant",
        "COLONTK",
        "Expression",
        "Name",
        "NEEDSKW",
        "Expression",
        "DISABLESKW",
        "Name",
        "COLONTK",
        "AutomatonBody",
        "OptAutDecls",
        "ALPHABETKW",
        "DISCKW",
        "LOCATIONKW",
        "MONITORKW",
        "AutDecl",
        "Decl",
        "Location",
        "Locations",
        "OptSupKind",
        "SupKind",
        "INVARIANTKW",
        "Invariants",
        "SEMICOLTK",
        "Location",
        "OptIoDecls",
        "IoDecl",
        "SEMICOLTK",
        "Events",
        "Name",
        "COMMATK",
        "SEMICOLTK",
        "Name",
        "SEMICOLTK",
        "COLONTK",
        "Identifier",
        "SEMICOLTK",
        "COLONTK",
        "EDGEKW",
        "EQUATIONKW",
        "INITIALKW",
        "MARKEDKW",
        "URGENTKW",
        "InvariantDecls",
        "LocationElement",
        "LocationElements",
        "LocationElement",
        "SEMICOLTK",
        "SEMICOLTK",
        "Expressions",
        "SEMICOLTK",
        "SEMICOLTK",
        "Expressions",
        "SEMICOLTK",
        "Equation",
        "Equations",
        "Identifier",
        "APOSTROPHETK",
        "EQTK",
        "Expression",
        "EQTK",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "Equation",
        "DOKW",
        "NOWKW",
        "TAUKW",
        "WHENKW",
        "CoreEdge",
        "EdgeEvent",
        "EdgeEvents",
        "Name",
        "EXCLAMATIONTK",
        "QUESTIONTK",
        "Expression",
        "WHENKW",
        "COMMATK",
        "OptEdgeGuard",
        "NOWKW",
        "OptEdgeUrgent",
        "DOKW",
        "OptEdgeUpdate",
        "IFKW",
        "PAROPENTK",
        "Addressable",
        "Identifier",
        "Update",
        "Updates",
        "COMMATK",
        "Update",
        "SQOPENTK",
        "Projection",
        "Projections",
        "Projection",
        "Expression",
        "SQCLOSETK",
        "BECOMESTK",
        "Expression",
        "Addressable",
        "COMMATK",
        "Addressable",
        "Addressables",
        "COMMATK",
        "PARCLOSETK",
        "Addressable",
        "Expressions",
        "COLONTK",
        "Updates",
        "OptElifUpdates",
        "ELIFKW",
        "ELSEKW",
        "OptElseUpdate",
        "ENDKW",
        "Updates",
        "Expressions",
        "COLONTK",
        "Updates",
        "EdgeEvent",
        "Expressions",
        "GOTOKW",
        "SEMICOLTK",
        "Identifier",
        "SEMICOLTK",
        "Expressions",
        "OptEdgeUrgent",
        "OptEdgeUpdate",
        "OptEdgeUpdate",
        "Updates",
        "LocationElements",
        "BOOLKW",
        "DICTKW",
        "DISTKW",
        "FUNCKW",
        "INTKW",
        "LISTKW",
        "REALKW",
        "SETKW",
        "STRINGKW",
        "TUPLEKW",
        "Name",
        "Type",
        "DiscDecl",
        "DiscDecls",
        "Identifier",
        "INKW",
        "EQTK",
        "Expression",
        "ANYKW",
        "CUROPENTK",
        "Expressions",
        "CURCLOSETK",
        "COMMATK",
        "SEMICOLTK",
        "DiscDecl",
        "PAROPENTK",
        "Field",
        "Fields",
        "Type",
        "Identifier",
        "Identifiers",
        "COMMATK",
        "Identifier",
        "SEMICOLTK",
        "PARCLOSETK",
        "Field",
        "Type",
        "SQOPENTK",
        "Type",
        "Expression",
        "DOTDOTTK",
        "SQCLOSETK",
        "Type",
        "Expression",
        "SQCLOSETK",
        "Type",
        "SQOPENTK",
        "Expression",
        "DOTDOTTK",
        "Expression",
        "SQCLOSETK",
        "Type",
        "PAROPENTK",
        "PARCLOSETK",
        "Type",
        "Types",
        "COMMATK",
        "PARCLOSETK",
        "Type",
        "Type",
        "PAROPENTK",
        "Type",
        "COLONTK",
        "Type",
        "PARCLOSETK",
        "SEMICOLTK",
        "Events",
        "SEMICOLTK",
        "ENDKW",
        "PAROPENTK",
        "SQOPENTK",
        "Expression",
        "OptExpression",
        "COLONTK",
        "Expression",
        "OptExpression",
        "SQCLOSETK",
        "SQCLOSETK",
        "PARCLOSETK",
        "Expressions",
        "PARCLOSETK",
        "DISABLESKW",
        "CUROPENTK",
        "Name",
        "NamesSet",
        "Name",
        "Names",
        "COMMATK",
        "CURCLOSETK",
        "Name",
        "SQCLOSETK",
        "Expressions",
        "SQCLOSETK",
        "Expression",
        "COMMATK",
        "PARCLOSETK",
        "Expressions",
        "PARCLOSETK",
        "CURCLOSETK",
        "DictPairs",
        "Expression",
        "Expressions",
        "CURCLOSETK",
        "COLONTK",
        "Expression",
        "COMMATK",
        "CURCLOSETK",
        "Expression",
        "COLONTK",
        "Expression",
        "UnaryExpression",
        "UnaryExpression",
        "Type",
        "GTTK",
        "ExpressionFactor",
        "FuncExpression",
        "UnaryExpression",
        "Expression",
        "COLONTK",
        "CASEKW",
        "ELSEKW",
        "SwitchBody",
        "SwitchCases",
        "CASEKW",
        "ELSEKW",
        "Expression",
        "Expression",
        "COLONTK",
        "Expression",
        "ENDKW",
        "Expression",
        "Expression",
        "COLONTK",
        "Expression",
        "Expressions",
        "COLONTK",
        "Expression",
        "OptElifExprs",
        "ELIFKW",
        "ELSEKW",
        "Expression",
        "ENDKW",
        "Expressions",
        "COLONTK",
        "Expression",
        "Identifier",
        "PAROPENTK",
        "FormalParms",
        "COLONTK",
        "AutomatonBody",
        "ENDKW",
        "ALGKW",
        "LOCATIONKW",
        "PARCLOSETK",
        "Controllability",
        "FormalDeclaration",
        "FormalDecls",
        "Name",
        "OptControllability",
        "EVENTKW",
        "VOIDKW",
        "EventParamId",
        "EventParamIds",
        "EventType",
        "Identifier",
        "Type",
        "OptEventParamFlags",
        "EXCLAMATIONTK",
        "QUESTIONTK",
        "TILDETK",
        "EventParamFlag",
        "EventParamIds",
        "Identifier",
        "COMMATK",
        "EventParamId",
        "Identifiers",
        "SEMICOLTK",
        "PARCLOSETK",
        "FormalDeclaration",
        "EventParamIds",
        "EventType",
        "EventParamIds",
        "Identifiers",
        "Type",
        "Identifiers",
        "AUTOMATONKW",
        "DEFKW",
        "Identifier",
        "COLONTK",
        "AutomatonBody",
        "ENDKW",
        "Identifier",
        "FormalParms",
        "COLONTK",
        "AutomatonBody",
        "ENDKW",
        "EVENTKW",
        "EventType",
        "Identifier",
        "Identifiers",
        "SEMICOLTK",
        "Identifiers",
        "SEMICOLTK",
        "INPUTKW",
        "ANNOTATIONNAMETK",
        "Annotation",
        "PAROPENTK",
        "PARCLOSETK",
        "RELATIVENAMETK",
        "IDENTIFIERTK",
        "AnnotationArg",
        "AnnotationArgs",
        "COMMATK",
        "OptComma",
        "PARCLOSETK",
        "AnnotationArg",
        "EQTK",
        "Expression",
        "EQTK",
        "Expression",
        "Type",
        "Identifiers",
        "SEMICOLTK",
        "COLONTK",
        "Name",
        "PAROPENTK",
        "ActualParms",
        "SEMICOLTK",
        "PARCLOSETK",
        "Expressions",
        "PARCLOSETK",
        "EventType",
        "Identifiers",
        "SEMICOLTK",
        "Identifiers",
        "SEMICOLTK",
        "Identifier",
        "TypeDefs",
        "COMMATK",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "Type",
        "EQTK",
        "Type",
        "IDKW",
        "Expression",
        "ATTRKW",
        "TEXTKW",
        "SvgAttr",
        "VALUEKW",
        "Expression",
        "FILEKW",
        "OptSvgFile",
        "SEMICOLTK",
        "StringToken",
        "StringToken",
        "IDKW",
        "Expression",
        "TOKW",
        "Expression",
        "COMMATK",
        "Expression",
        "OptSvgFile",
        "SEMICOLTK",
        "IDKW",
        "Expression",
        "EVENTKW",
        "IFKW",
        "Name",
        "SvgInEvent",
        "OptSvgFile",
        "SEMICOLTK",
        "Expression",
        "COLONTK",
        "Name",
        "ELIFKW",
        "OptSvgInEventElifs",
        "SvgInEventElifs",
        "ELIFKW",
        "ENDKW",
        "Expression",
        "COLONTK",
        "Name",
        "ELSEKW",
        "Name",
        "ENDKW",
        "Expression",
        "COLONTK",
        "Name",
        "StringToken",
        "SEMICOLTK",
        "IDKW",
        "Expression",
        "PREKW",
        "OptSvgCopyPre",
        "POSTKW",
        "OptSvgCopyPost",
        "OptSvgFile",
        "SEMICOLTK",
        "Expression",
        "Expression",
        "StringToken",
        "SEMICOLTK",
        "POSTKW",
        "PREKW",
        "Expression",
        "PrintTxt",
        "FORKW",
        "OptPrintFors",
        "WHENKW",
        "OptPrintWhen",
        "FILEKW",
        "OptPrintFile",
        "SEMICOLTK",
        "StringToken",
        "POSTKW",
        "PREKW",
        "Expression",
        "Expression",
        "POSTKW",
        "Expression",
        "Expression",
        "EVENTKW",
        "FINALKW",
        "INITIALKW",
        "TIMEKW",
        "Name",
        "PrintFor",
        "PrintFors",
        "COMMATK",
        "PrintFor",
        "Expression",
        "POSTKW",
        "Expression",
        "Expression",
        "RELATIVENAMETK",
        "IDENTIFIERTK",
        "SEMICOLTK",
        "SEMICOLTK",
        "Expressions",
        "SEMICOLTK",
        "Expressions",
        "SEMICOLTK",
        "Imports",
        "StringToken",
        "COMMATK",
        "SEMICOLTK",
        "StringToken",
        "DEFKW",
        "Identifier",
        "COLONTK",
        "GroupBody",
        "ENDKW",
        "Identifier",
        "FormalParms",
        "COLONTK",
        "GroupBody",
        "ENDKW",
        "Types",
        "Identifier",
        "PAROPENTK",
        "FuncParams",
        "COLONTK",
        "FuncBody",
        "FuncVarDecls",
        "StringToken",
        "SEMICOLTK",
        "BREAKKW",
        "CONTINUEKW",
        "IFKW",
        "RETURNKW",
        "WHILEKW",
        "Addressables",
        "FuncStatement",
        "FuncStatements",
        "Identifier",
        "Type",
        "FuncVarDecl",
        "Identifier",
        "EQTK",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "Expression",
        "ENDKW",
        "FuncStatement",
        "BECOMESTK",
        "Expressions",
        "SEMICOLTK",
        "Expressions",
        "COLONTK",
        "FuncStatements",
        "ENDKW",
        "Expressions",
        "SEMICOLTK",
        "Expressions",
        "COLONTK",
        "FuncStatements",
        "OptElifFuncStats",
        "ELIFKW",
        "ELSEKW",
        "OptElseFuncStat",
        "ENDKW",
        "FuncStatements",
        "Expressions",
        "COLONTK",
        "FuncStatements",
        "SEMICOLTK",
        "SEMICOLTK",
        "PARCLOSETK",
        "FuncParamDecls",
        "Type",
        "Identifiers",
        "SEMICOLTK",
        "PARCLOSETK",
        "Type",
        "Identifiers",
        "Equations",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "Identifiers",
        "SEMICOLTK",
        "ContDecl",
        "ContDecls",
        "Identifier",
        "DERKW",
        "EQTK",
        "OptDerivative",
        "Expression",
        "OptDerivative",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "ContDecl",
        "Type",
        "ConstantDefs",
        "Identifier",
        "EQTK",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "Expression",
        "Type",
        "AlgVarsDefs",
        "Identifier",
        "EQTK",
        "Expression",
        "COMMATK",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "Expression",
    };

    /** Parser call back hook methods. */
    private final CifParserHooks hooks;

    /** Whether parsing has completed (final result has been accepted). */
    private boolean accept;

    /** The parse result, but only if {@code #accept} is {@code true}. */
    private ASpecification acceptObject;

    /** The current scanner token to process, if any. */
    private Token token;

    /** Whether parsing has resulted in a reduce action. */
    private boolean reduce;

    /** The state from which to reduce, if {@code #reduce} is {@code true}. */
    private int reduceState;

    /** The non-terminal to reduce, if {@code #reduce} is {@code true}. */
    private int reduceNonTerminal;

    /** Constructor for the {@link CifParser} class. */
    public CifParser() {
        super(new CifScanner());
        entrySymbolNames = ENTRY_SYMBOL_NAMES;
        firstTerminals = FirstTerminals.FIRST_TERMINALS;
        firstTerminalsReduced = FirstTerminalsReduced.FIRST_TERMINALS_REDUCED;
        reducibleNonTerminals = ReducibleNonTerminals.REDUCIBLE_NON_TERMINALS;
        reducibleNonTerminalsReduced = ReducibleNonTerminalsReduced.REDUCIBLE_NON_TERMINALS_REDUCED;
        hooks = new CifParserHooks();
    }

    @Override
    public ParserHooksBase getHooks() {
        return hooks;
    }

    @Override
    protected final ASpecification parse() throws IOException {
        token = nextToken();
        int state;

        accept = false;

        while (true) {
            // Perform action.
            state = getCurrentState();
            reduce = false;

            switch (state) {
                case 0:
                    action0();
                    break;
                case 1:
                    action1();
                    break;
                case 2:
                    action2();
                    break;
                case 3:
                    action3();
                    break;
                case 4:
                    action4();
                    break;
                case 5:
                    action5();
                    break;
                case 6:
                    action6();
                    break;
                case 7:
                    action7();
                    break;
                case 8:
                    action8();
                    break;
                case 9:
                    action9();
                    break;
                case 10:
                    action10();
                    break;
                case 11:
                    action11();
                    break;
                case 12:
                    action12();
                    break;
                case 13:
                    action13();
                    break;
                case 14:
                    action14();
                    break;
                case 15:
                    action15();
                    break;
                case 16:
                    action16();
                    break;
                case 17:
                    action17();
                    break;
                case 18:
                    action18();
                    break;
                case 19:
                    action19();
                    break;
                case 20:
                    action20();
                    break;
                case 21:
                    action21();
                    break;
                case 22:
                    action22();
                    break;
                case 23:
                    action23();
                    break;
                case 24:
                    action24();
                    break;
                case 25:
                    action25();
                    break;
                case 26:
                    action26();
                    break;
                case 27:
                    action27();
                    break;
                case 28:
                    action28();
                    break;
                case 29:
                    action29();
                    break;
                case 30:
                    action30();
                    break;
                case 31:
                    action31();
                    break;
                case 32:
                    action32();
                    break;
                case 33:
                    action33();
                    break;
                case 34:
                    action34();
                    break;
                case 35:
                    action35();
                    break;
                case 36:
                    action36();
                    break;
                case 37:
                    action37();
                    break;
                case 38:
                    action38();
                    break;
                case 39:
                    action39();
                    break;
                case 40:
                    action40();
                    break;
                case 41:
                    action41();
                    break;
                case 42:
                    action42();
                    break;
                case 43:
                    action43();
                    break;
                case 44:
                    action44();
                    break;
                case 45:
                    action45();
                    break;
                case 46:
                    action46();
                    break;
                case 47:
                    action47();
                    break;
                case 48:
                    action48();
                    break;
                case 49:
                    action49();
                    break;
                case 50:
                    action50();
                    break;
                case 51:
                    action51();
                    break;
                case 52:
                    action52();
                    break;
                case 53:
                    action53();
                    break;
                case 54:
                    action54();
                    break;
                case 55:
                    action55();
                    break;
                case 56:
                    action56();
                    break;
                case 57:
                    action57();
                    break;
                case 58:
                    action58();
                    break;
                case 59:
                    action59();
                    break;
                case 60:
                    action60();
                    break;
                case 61:
                    action61();
                    break;
                case 62:
                    action62();
                    break;
                case 63:
                    action63();
                    break;
                case 64:
                    action64();
                    break;
                case 65:
                    action65();
                    break;
                case 66:
                    action66();
                    break;
                case 67:
                    action67();
                    break;
                case 68:
                    action68();
                    break;
                case 69:
                    action69();
                    break;
                case 70:
                    action70();
                    break;
                case 71:
                    action71();
                    break;
                case 72:
                    action72();
                    break;
                case 73:
                    action73();
                    break;
                case 74:
                    action74();
                    break;
                case 75:
                    action75();
                    break;
                case 76:
                    action76();
                    break;
                case 77:
                    action77();
                    break;
                case 78:
                    action78();
                    break;
                case 79:
                    action79();
                    break;
                case 80:
                    action80();
                    break;
                case 81:
                    action81();
                    break;
                case 82:
                    action82();
                    break;
                case 83:
                    action83();
                    break;
                case 84:
                    action84();
                    break;
                case 85:
                    action85();
                    break;
                case 86:
                    action86();
                    break;
                case 87:
                    action87();
                    break;
                case 88:
                    action88();
                    break;
                case 89:
                    action89();
                    break;
                case 90:
                    action90();
                    break;
                case 91:
                    action91();
                    break;
                case 92:
                    action92();
                    break;
                case 93:
                    action93();
                    break;
                case 94:
                    action94();
                    break;
                case 95:
                    action95();
                    break;
                case 96:
                    action96();
                    break;
                case 97:
                    action97();
                    break;
                case 98:
                    action98();
                    break;
                case 99:
                    action99();
                    break;
                case 100:
                    action100();
                    break;
                case 101:
                    action101();
                    break;
                case 102:
                    action102();
                    break;
                case 103:
                    action103();
                    break;
                case 104:
                    action104();
                    break;
                case 105:
                    action105();
                    break;
                case 106:
                    action106();
                    break;
                case 107:
                    action107();
                    break;
                case 108:
                    action108();
                    break;
                case 109:
                    action109();
                    break;
                case 110:
                    action110();
                    break;
                case 111:
                    action111();
                    break;
                case 112:
                    action112();
                    break;
                case 113:
                    action113();
                    break;
                case 114:
                    action114();
                    break;
                case 115:
                    action115();
                    break;
                case 116:
                    action116();
                    break;
                case 117:
                    action117();
                    break;
                case 118:
                    action118();
                    break;
                case 119:
                    action119();
                    break;
                case 120:
                    action120();
                    break;
                case 121:
                    action121();
                    break;
                case 122:
                    action122();
                    break;
                case 123:
                    action123();
                    break;
                case 124:
                    action124();
                    break;
                case 125:
                    action125();
                    break;
                case 126:
                    action126();
                    break;
                case 127:
                    action127();
                    break;
                case 128:
                    action128();
                    break;
                case 129:
                    action129();
                    break;
                case 130:
                    action130();
                    break;
                case 131:
                    action131();
                    break;
                case 132:
                    action132();
                    break;
                case 133:
                    action133();
                    break;
                case 134:
                    action134();
                    break;
                case 135:
                    action135();
                    break;
                case 136:
                    action136();
                    break;
                case 137:
                    action137();
                    break;
                case 138:
                    action138();
                    break;
                case 139:
                    action139();
                    break;
                case 140:
                    action140();
                    break;
                case 141:
                    action141();
                    break;
                case 142:
                    action142();
                    break;
                case 143:
                    action143();
                    break;
                case 144:
                    action144();
                    break;
                case 145:
                    action145();
                    break;
                case 146:
                    action146();
                    break;
                case 147:
                    action147();
                    break;
                case 148:
                    action148();
                    break;
                case 149:
                    action149();
                    break;
                case 150:
                    action150();
                    break;
                case 151:
                    action151();
                    break;
                case 152:
                    action152();
                    break;
                case 153:
                    action153();
                    break;
                case 154:
                    action154();
                    break;
                case 155:
                    action155();
                    break;
                case 156:
                    action156();
                    break;
                case 157:
                    action157();
                    break;
                case 158:
                    action158();
                    break;
                case 159:
                    action159();
                    break;
                case 160:
                    action160();
                    break;
                case 161:
                    action161();
                    break;
                case 162:
                    action162();
                    break;
                case 163:
                    action163();
                    break;
                case 164:
                    action164();
                    break;
                case 165:
                    action165();
                    break;
                case 166:
                    action166();
                    break;
                case 167:
                    action167();
                    break;
                case 168:
                    action168();
                    break;
                case 169:
                    action169();
                    break;
                case 170:
                    action170();
                    break;
                case 171:
                    action171();
                    break;
                case 172:
                    action172();
                    break;
                case 173:
                    action173();
                    break;
                case 174:
                    action174();
                    break;
                case 175:
                    action175();
                    break;
                case 176:
                    action176();
                    break;
                case 177:
                    action177();
                    break;
                case 178:
                    action178();
                    break;
                case 179:
                    action179();
                    break;
                case 180:
                    action180();
                    break;
                case 181:
                    action181();
                    break;
                case 182:
                    action182();
                    break;
                case 183:
                    action183();
                    break;
                case 184:
                    action184();
                    break;
                case 185:
                    action185();
                    break;
                case 186:
                    action186();
                    break;
                case 187:
                    action187();
                    break;
                case 188:
                    action188();
                    break;
                case 189:
                    action189();
                    break;
                case 190:
                    action190();
                    break;
                case 191:
                    action191();
                    break;
                case 192:
                    action192();
                    break;
                case 193:
                    action193();
                    break;
                case 194:
                    action194();
                    break;
                case 195:
                    action195();
                    break;
                case 196:
                    action196();
                    break;
                case 197:
                    action197();
                    break;
                case 198:
                    action198();
                    break;
                case 199:
                    action199();
                    break;
                case 200:
                    action200();
                    break;
                case 201:
                    action201();
                    break;
                case 202:
                    action202();
                    break;
                case 203:
                    action203();
                    break;
                case 204:
                    action204();
                    break;
                case 205:
                    action205();
                    break;
                case 206:
                    action206();
                    break;
                case 207:
                    action207();
                    break;
                case 208:
                    action208();
                    break;
                case 209:
                    action209();
                    break;
                case 210:
                    action210();
                    break;
                case 211:
                    action211();
                    break;
                case 212:
                    action212();
                    break;
                case 213:
                    action213();
                    break;
                case 214:
                    action214();
                    break;
                case 215:
                    action215();
                    break;
                case 216:
                    action216();
                    break;
                case 217:
                    action217();
                    break;
                case 218:
                    action218();
                    break;
                case 219:
                    action219();
                    break;
                case 220:
                    action220();
                    break;
                case 221:
                    action221();
                    break;
                case 222:
                    action222();
                    break;
                case 223:
                    action223();
                    break;
                case 224:
                    action224();
                    break;
                case 225:
                    action225();
                    break;
                case 226:
                    action226();
                    break;
                case 227:
                    action227();
                    break;
                case 228:
                    action228();
                    break;
                case 229:
                    action229();
                    break;
                case 230:
                    action230();
                    break;
                case 231:
                    action231();
                    break;
                case 232:
                    action232();
                    break;
                case 233:
                    action233();
                    break;
                case 234:
                    action234();
                    break;
                case 235:
                    action235();
                    break;
                case 236:
                    action236();
                    break;
                case 237:
                    action237();
                    break;
                case 238:
                    action238();
                    break;
                case 239:
                    action239();
                    break;
                case 240:
                    action240();
                    break;
                case 241:
                    action241();
                    break;
                case 242:
                    action242();
                    break;
                case 243:
                    action243();
                    break;
                case 244:
                    action244();
                    break;
                case 245:
                    action245();
                    break;
                case 246:
                    action246();
                    break;
                case 247:
                    action247();
                    break;
                case 248:
                    action248();
                    break;
                case 249:
                    action249();
                    break;
                case 250:
                    action250();
                    break;
                case 251:
                    action251();
                    break;
                case 252:
                    action252();
                    break;
                case 253:
                    action253();
                    break;
                case 254:
                    action254();
                    break;
                case 255:
                    action255();
                    break;
                case 256:
                    action256();
                    break;
                case 257:
                    action257();
                    break;
                case 258:
                    action258();
                    break;
                case 259:
                    action259();
                    break;
                case 260:
                    action260();
                    break;
                case 261:
                    action261();
                    break;
                case 262:
                    action262();
                    break;
                case 263:
                    action263();
                    break;
                case 264:
                    action264();
                    break;
                case 265:
                    action265();
                    break;
                case 266:
                    action266();
                    break;
                case 267:
                    action267();
                    break;
                case 268:
                    action268();
                    break;
                case 269:
                    action269();
                    break;
                case 270:
                    action270();
                    break;
                case 271:
                    action271();
                    break;
                case 272:
                    action272();
                    break;
                case 273:
                    action273();
                    break;
                case 274:
                    action274();
                    break;
                case 275:
                    action275();
                    break;
                case 276:
                    action276();
                    break;
                case 277:
                    action277();
                    break;
                case 278:
                    action278();
                    break;
                case 279:
                    action279();
                    break;
                case 280:
                    action280();
                    break;
                case 281:
                    action281();
                    break;
                case 282:
                    action282();
                    break;
                case 283:
                    action283();
                    break;
                case 284:
                    action284();
                    break;
                case 285:
                    action285();
                    break;
                case 286:
                    action286();
                    break;
                case 287:
                    action287();
                    break;
                case 288:
                    action288();
                    break;
                case 289:
                    action289();
                    break;
                case 290:
                    action290();
                    break;
                case 291:
                    action291();
                    break;
                case 292:
                    action292();
                    break;
                case 293:
                    action293();
                    break;
                case 294:
                    action294();
                    break;
                case 295:
                    action295();
                    break;
                case 296:
                    action296();
                    break;
                case 297:
                    action297();
                    break;
                case 298:
                    action298();
                    break;
                case 299:
                    action299();
                    break;
                case 300:
                    action300();
                    break;
                case 301:
                    action301();
                    break;
                case 302:
                    action302();
                    break;
                case 303:
                    action303();
                    break;
                case 304:
                    action304();
                    break;
                case 305:
                    action305();
                    break;
                case 306:
                    action306();
                    break;
                case 307:
                    action307();
                    break;
                case 308:
                    action308();
                    break;
                case 309:
                    action309();
                    break;
                case 310:
                    action310();
                    break;
                case 311:
                    action311();
                    break;
                case 312:
                    action312();
                    break;
                case 313:
                    action313();
                    break;
                case 314:
                    action314();
                    break;
                case 315:
                    action315();
                    break;
                case 316:
                    action316();
                    break;
                case 317:
                    action317();
                    break;
                case 318:
                    action318();
                    break;
                case 319:
                    action319();
                    break;
                case 320:
                    action320();
                    break;
                case 321:
                    action321();
                    break;
                case 322:
                    action322();
                    break;
                case 323:
                    action323();
                    break;
                case 324:
                    action324();
                    break;
                case 325:
                    action325();
                    break;
                case 326:
                    action326();
                    break;
                case 327:
                    action327();
                    break;
                case 328:
                    action328();
                    break;
                case 329:
                    action329();
                    break;
                case 330:
                    action330();
                    break;
                case 331:
                    action331();
                    break;
                case 332:
                    action332();
                    break;
                case 333:
                    action333();
                    break;
                case 334:
                    action334();
                    break;
                case 335:
                    action335();
                    break;
                case 336:
                    action336();
                    break;
                case 337:
                    action337();
                    break;
                case 338:
                    action338();
                    break;
                case 339:
                    action339();
                    break;
                case 340:
                    action340();
                    break;
                case 341:
                    action341();
                    break;
                case 342:
                    action342();
                    break;
                case 343:
                    action343();
                    break;
                case 344:
                    action344();
                    break;
                case 345:
                    action345();
                    break;
                case 346:
                    action346();
                    break;
                case 347:
                    action347();
                    break;
                case 348:
                    action348();
                    break;
                case 349:
                    action349();
                    break;
                case 350:
                    action350();
                    break;
                case 351:
                    action351();
                    break;
                case 352:
                    action352();
                    break;
                case 353:
                    action353();
                    break;
                case 354:
                    action354();
                    break;
                case 355:
                    action355();
                    break;
                case 356:
                    action356();
                    break;
                case 357:
                    action357();
                    break;
                case 358:
                    action358();
                    break;
                case 359:
                    action359();
                    break;
                case 360:
                    action360();
                    break;
                case 361:
                    action361();
                    break;
                case 362:
                    action362();
                    break;
                case 363:
                    action363();
                    break;
                case 364:
                    action364();
                    break;
                case 365:
                    action365();
                    break;
                case 366:
                    action366();
                    break;
                case 367:
                    action367();
                    break;
                case 368:
                    action368();
                    break;
                case 369:
                    action369();
                    break;
                case 370:
                    action370();
                    break;
                case 371:
                    action371();
                    break;
                case 372:
                    action372();
                    break;
                case 373:
                    action373();
                    break;
                case 374:
                    action374();
                    break;
                case 375:
                    action375();
                    break;
                case 376:
                    action376();
                    break;
                case 377:
                    action377();
                    break;
                case 378:
                    action378();
                    break;
                case 379:
                    action379();
                    break;
                case 380:
                    action380();
                    break;
                case 381:
                    action381();
                    break;
                case 382:
                    action382();
                    break;
                case 383:
                    action383();
                    break;
                case 384:
                    action384();
                    break;
                case 385:
                    action385();
                    break;
                case 386:
                    action386();
                    break;
                case 387:
                    action387();
                    break;
                case 388:
                    action388();
                    break;
                case 389:
                    action389();
                    break;
                case 390:
                    action390();
                    break;
                case 391:
                    action391();
                    break;
                case 392:
                    action392();
                    break;
                case 393:
                    action393();
                    break;
                case 394:
                    action394();
                    break;
                case 395:
                    action395();
                    break;
                case 396:
                    action396();
                    break;
                case 397:
                    action397();
                    break;
                case 398:
                    action398();
                    break;
                case 399:
                    action399();
                    break;
                case 400:
                    action400();
                    break;
                case 401:
                    action401();
                    break;
                case 402:
                    action402();
                    break;
                case 403:
                    action403();
                    break;
                case 404:
                    action404();
                    break;
                case 405:
                    action405();
                    break;
                case 406:
                    action406();
                    break;
                case 407:
                    action407();
                    break;
                case 408:
                    action408();
                    break;
                case 409:
                    action409();
                    break;
                case 410:
                    action410();
                    break;
                case 411:
                    action411();
                    break;
                case 412:
                    action412();
                    break;
                case 413:
                    action413();
                    break;
                case 414:
                    action414();
                    break;
                case 415:
                    action415();
                    break;
                case 416:
                    action416();
                    break;
                case 417:
                    action417();
                    break;
                case 418:
                    action418();
                    break;
                case 419:
                    action419();
                    break;
                case 420:
                    action420();
                    break;
                case 421:
                    action421();
                    break;
                case 422:
                    action422();
                    break;
                case 423:
                    action423();
                    break;
                case 424:
                    action424();
                    break;
                case 425:
                    action425();
                    break;
                case 426:
                    action426();
                    break;
                case 427:
                    action427();
                    break;
                case 428:
                    action428();
                    break;
                case 429:
                    action429();
                    break;
                case 430:
                    action430();
                    break;
                case 431:
                    action431();
                    break;
                case 432:
                    action432();
                    break;
                case 433:
                    action433();
                    break;
                case 434:
                    action434();
                    break;
                case 435:
                    action435();
                    break;
                case 436:
                    action436();
                    break;
                case 437:
                    action437();
                    break;
                case 438:
                    action438();
                    break;
                case 439:
                    action439();
                    break;
                case 440:
                    action440();
                    break;
                case 441:
                    action441();
                    break;
                case 442:
                    action442();
                    break;
                case 443:
                    action443();
                    break;
                case 444:
                    action444();
                    break;
                case 445:
                    action445();
                    break;
                case 446:
                    action446();
                    break;
                case 447:
                    action447();
                    break;
                case 448:
                    action448();
                    break;
                case 449:
                    action449();
                    break;
                case 450:
                    action450();
                    break;
                case 451:
                    action451();
                    break;
                case 452:
                    action452();
                    break;
                case 453:
                    action453();
                    break;
                case 454:
                    action454();
                    break;
                case 455:
                    action455();
                    break;
                case 456:
                    action456();
                    break;
                case 457:
                    action457();
                    break;
                case 458:
                    action458();
                    break;
                case 459:
                    action459();
                    break;
                case 460:
                    action460();
                    break;
                case 461:
                    action461();
                    break;
                case 462:
                    action462();
                    break;
                case 463:
                    action463();
                    break;
                case 464:
                    action464();
                    break;
                case 465:
                    action465();
                    break;
                case 466:
                    action466();
                    break;
                case 467:
                    action467();
                    break;
                case 468:
                    action468();
                    break;
                case 469:
                    action469();
                    break;
                case 470:
                    action470();
                    break;
                case 471:
                    action471();
                    break;
                case 472:
                    action472();
                    break;
                case 473:
                    action473();
                    break;
                case 474:
                    action474();
                    break;
                case 475:
                    action475();
                    break;
                case 476:
                    action476();
                    break;
                case 477:
                    action477();
                    break;
                case 478:
                    action478();
                    break;
                case 479:
                    action479();
                    break;
                case 480:
                    action480();
                    break;
                case 481:
                    action481();
                    break;
                case 482:
                    action482();
                    break;
                case 483:
                    action483();
                    break;
                case 484:
                    action484();
                    break;
                case 485:
                    action485();
                    break;
                case 486:
                    action486();
                    break;
                case 487:
                    action487();
                    break;
                case 488:
                    action488();
                    break;
                case 489:
                    action489();
                    break;
                case 490:
                    action490();
                    break;
                case 491:
                    action491();
                    break;
                case 492:
                    action492();
                    break;
                case 493:
                    action493();
                    break;
                case 494:
                    action494();
                    break;
                case 495:
                    action495();
                    break;
                case 496:
                    action496();
                    break;
                case 497:
                    action497();
                    break;
                case 498:
                    action498();
                    break;
                case 499:
                    action499();
                    break;
                case 500:
                    action500();
                    break;
                case 501:
                    action501();
                    break;
                case 502:
                    action502();
                    break;
                case 503:
                    action503();
                    break;
                case 504:
                    action504();
                    break;
                case 505:
                    action505();
                    break;
                case 506:
                    action506();
                    break;
                case 507:
                    action507();
                    break;
                case 508:
                    action508();
                    break;
                case 509:
                    action509();
                    break;
                case 510:
                    action510();
                    break;
                case 511:
                    action511();
                    break;
                case 512:
                    action512();
                    break;
                case 513:
                    action513();
                    break;
                case 514:
                    action514();
                    break;
                case 515:
                    action515();
                    break;
                case 516:
                    action516();
                    break;
                case 517:
                    action517();
                    break;
                case 518:
                    action518();
                    break;
                case 519:
                    action519();
                    break;
                case 520:
                    action520();
                    break;
                case 521:
                    action521();
                    break;
                case 522:
                    action522();
                    break;
                case 523:
                    action523();
                    break;
                case 524:
                    action524();
                    break;
                case 525:
                    action525();
                    break;
                case 526:
                    action526();
                    break;
                case 527:
                    action527();
                    break;
                case 528:
                    action528();
                    break;
                case 529:
                    action529();
                    break;
                case 530:
                    action530();
                    break;
                case 531:
                    action531();
                    break;
                case 532:
                    action532();
                    break;
                case 533:
                    action533();
                    break;
                case 534:
                    action534();
                    break;
                case 535:
                    action535();
                    break;
                case 536:
                    action536();
                    break;
                case 537:
                    action537();
                    break;
                case 538:
                    action538();
                    break;
                case 539:
                    action539();
                    break;
                case 540:
                    action540();
                    break;
                case 541:
                    action541();
                    break;
                case 542:
                    action542();
                    break;
                case 543:
                    action543();
                    break;
                case 544:
                    action544();
                    break;
                case 545:
                    action545();
                    break;
                case 546:
                    action546();
                    break;
                case 547:
                    action547();
                    break;
                case 548:
                    action548();
                    break;
                case 549:
                    action549();
                    break;
                case 550:
                    action550();
                    break;
                case 551:
                    action551();
                    break;
                case 552:
                    action552();
                    break;
                case 553:
                    action553();
                    break;
                case 554:
                    action554();
                    break;
                case 555:
                    action555();
                    break;
                case 556:
                    action556();
                    break;
                case 557:
                    action557();
                    break;
                case 558:
                    action558();
                    break;
                case 559:
                    action559();
                    break;
                case 560:
                    action560();
                    break;
                case 561:
                    action561();
                    break;
                case 562:
                    action562();
                    break;
                case 563:
                    action563();
                    break;
                case 564:
                    action564();
                    break;
                case 565:
                    action565();
                    break;
                case 566:
                    action566();
                    break;
                case 567:
                    action567();
                    break;
                case 568:
                    action568();
                    break;
                case 569:
                    action569();
                    break;
                case 570:
                    action570();
                    break;
                case 571:
                    action571();
                    break;
                case 572:
                    action572();
                    break;
                case 573:
                    action573();
                    break;
                case 574:
                    action574();
                    break;
                case 575:
                    action575();
                    break;
                case 576:
                    action576();
                    break;
                case 577:
                    action577();
                    break;
                case 578:
                    action578();
                    break;
                case 579:
                    action579();
                    break;
                case 580:
                    action580();
                    break;
                case 581:
                    action581();
                    break;
                case 582:
                    action582();
                    break;
                case 583:
                    action583();
                    break;
                case 584:
                    action584();
                    break;
                case 585:
                    action585();
                    break;
                case 586:
                    action586();
                    break;
                case 587:
                    action587();
                    break;
                case 588:
                    action588();
                    break;
                case 589:
                    action589();
                    break;
                case 590:
                    action590();
                    break;
                case 591:
                    action591();
                    break;
                case 592:
                    action592();
                    break;
                case 593:
                    action593();
                    break;
                case 594:
                    action594();
                    break;
                case 595:
                    action595();
                    break;
                case 596:
                    action596();
                    break;
                case 597:
                    action597();
                    break;
                case 598:
                    action598();
                    break;
                case 599:
                    action599();
                    break;
                case 600:
                    action600();
                    break;
                case 601:
                    action601();
                    break;
                case 602:
                    action602();
                    break;
                case 603:
                    action603();
                    break;
                case 604:
                    action604();
                    break;
                case 605:
                    action605();
                    break;
                case 606:
                    action606();
                    break;
                case 607:
                    action607();
                    break;
                case 608:
                    action608();
                    break;
                case 609:
                    action609();
                    break;
                case 610:
                    action610();
                    break;
                case 611:
                    action611();
                    break;
                case 612:
                    action612();
                    break;
                case 613:
                    action613();
                    break;
                case 614:
                    action614();
                    break;
                case 615:
                    action615();
                    break;
                case 616:
                    action616();
                    break;
                case 617:
                    action617();
                    break;
                case 618:
                    action618();
                    break;
                case 619:
                    action619();
                    break;
                case 620:
                    action620();
                    break;
                case 621:
                    action621();
                    break;
                case 622:
                    action622();
                    break;
                case 623:
                    action623();
                    break;
                case 624:
                    action624();
                    break;
                case 625:
                    action625();
                    break;
                case 626:
                    action626();
                    break;
                case 627:
                    action627();
                    break;
                case 628:
                    action628();
                    break;
                case 629:
                    action629();
                    break;
                case 630:
                    action630();
                    break;
                case 631:
                    action631();
                    break;
                case 632:
                    action632();
                    break;
                case 633:
                    action633();
                    break;
                case 634:
                    action634();
                    break;
                case 635:
                    action635();
                    break;
                case 636:
                    action636();
                    break;
                case 637:
                    action637();
                    break;
                case 638:
                    action638();
                    break;
                case 639:
                    action639();
                    break;
                case 640:
                    action640();
                    break;
                case 641:
                    action641();
                    break;
                case 642:
                    action642();
                    break;
                case 643:
                    action643();
                    break;
                case 644:
                    action644();
                    break;
                case 645:
                    action645();
                    break;
                case 646:
                    action646();
                    break;
                case 647:
                    action647();
                    break;
                case 648:
                    action648();
                    break;
                case 649:
                    action649();
                    break;
                case 650:
                    action650();
                    break;
                case 651:
                    action651();
                    break;
                case 652:
                    action652();
                    break;
                case 653:
                    action653();
                    break;
                case 654:
                    action654();
                    break;
                case 655:
                    action655();
                    break;
                case 656:
                    action656();
                    break;
                case 657:
                    action657();
                    break;
                case 658:
                    action658();
                    break;
                case 659:
                    action659();
                    break;
                case 660:
                    action660();
                    break;
                case 661:
                    action661();
                    break;
                case 662:
                    action662();
                    break;
                case 663:
                    action663();
                    break;
                case 664:
                    action664();
                    break;
                case 665:
                    action665();
                    break;
                case 666:
                    action666();
                    break;
                case 667:
                    action667();
                    break;
                case 668:
                    action668();
                    break;
                case 669:
                    action669();
                    break;
                case 670:
                    action670();
                    break;
                case 671:
                    action671();
                    break;
                case 672:
                    action672();
                    break;
                case 673:
                    action673();
                    break;
                case 674:
                    action674();
                    break;
                case 675:
                    action675();
                    break;
                case 676:
                    action676();
                    break;
                case 677:
                    action677();
                    break;
                case 678:
                    action678();
                    break;
                case 679:
                    action679();
                    break;
                case 680:
                    action680();
                    break;
                case 681:
                    action681();
                    break;
                case 682:
                    action682();
                    break;
                case 683:
                    action683();
                    break;
                case 684:
                    action684();
                    break;
                case 685:
                    action685();
                    break;
                case 686:
                    action686();
                    break;
                case 687:
                    action687();
                    break;
                case 688:
                    action688();
                    break;
                case 689:
                    action689();
                    break;
                case 690:
                    action690();
                    break;
                case 691:
                    action691();
                    break;
                case 692:
                    action692();
                    break;
                case 693:
                    action693();
                    break;
                case 694:
                    action694();
                    break;
                case 695:
                    action695();
                    break;
                case 696:
                    action696();
                    break;
                case 697:
                    action697();
                    break;
                case 698:
                    action698();
                    break;
                case 699:
                    action699();
                    break;
                case 700:
                    action700();
                    break;
                case 701:
                    action701();
                    break;
                case 702:
                    action702();
                    break;
                case 703:
                    action703();
                    break;
                case 704:
                    action704();
                    break;
                case 705:
                    action705();
                    break;
                case 706:
                    action706();
                    break;
                case 707:
                    action707();
                    break;
                case 708:
                    action708();
                    break;
                case 709:
                    action709();
                    break;
                case 710:
                    action710();
                    break;
                case 711:
                    action711();
                    break;
                case 712:
                    action712();
                    break;
                case 713:
                    action713();
                    break;
                case 714:
                    action714();
                    break;
                case 715:
                    action715();
                    break;
                case 716:
                    action716();
                    break;
                case 717:
                    action717();
                    break;
                case 718:
                    action718();
                    break;
                case 719:
                    action719();
                    break;
                case 720:
                    action720();
                    break;
                case 721:
                    action721();
                    break;
                case 722:
                    action722();
                    break;
                case 723:
                    action723();
                    break;
                case 724:
                    action724();
                    break;
                case 725:
                    action725();
                    break;
                case 726:
                    action726();
                    break;
                case 727:
                    action727();
                    break;
                case 728:
                    action728();
                    break;
                case 729:
                    action729();
                    break;
                case 730:
                    action730();
                    break;
                case 731:
                    action731();
                    break;
                case 732:
                    action732();
                    break;
                case 733:
                    action733();
                    break;
                case 734:
                    action734();
                    break;
                case 735:
                    action735();
                    break;
                case 736:
                    action736();
                    break;
                case 737:
                    action737();
                    break;
                case 738:
                    action738();
                    break;
                case 739:
                    action739();
                    break;
                case 740:
                    action740();
                    break;
                case 741:
                    action741();
                    break;
                case 742:
                    action742();
                    break;
                case 743:
                    action743();
                    break;
                case 744:
                    action744();
                    break;
                case 745:
                    action745();
                    break;
                case 746:
                    action746();
                    break;
                case 747:
                    action747();
                    break;
                case 748:
                    action748();
                    break;
                case 749:
                    action749();
                    break;
                case 750:
                    action750();
                    break;
                case 751:
                    action751();
                    break;
                case 752:
                    action752();
                    break;
                case 753:
                    action753();
                    break;
                case 754:
                    action754();
                    break;
                case 755:
                    action755();
                    break;
                case 756:
                    action756();
                    break;
                case 757:
                    action757();
                    break;
                case 758:
                    action758();
                    break;
                case 759:
                    action759();
                    break;
                case 760:
                    action760();
                    break;
                case 761:
                    action761();
                    break;
                case 762:
                    action762();
                    break;
                case 763:
                    action763();
                    break;
                case 764:
                    action764();
                    break;
                case 765:
                    action765();
                    break;
                case 766:
                    action766();
                    break;
                case 767:
                    action767();
                    break;
                case 768:
                    action768();
                    break;
                case 769:
                    action769();
                    break;
                case 770:
                    action770();
                    break;
                case 771:
                    action771();
                    break;
                default:
                    String msg = "Unknown parser state: " + state;
                    throw new RuntimeException(msg);
            }

            // Accept action.
            if (accept) {
                return acceptObject;
            }

            // Shift action.
            if (!reduce) {
                continue;
            }

            // Perform goto (as part of a reduce action).
            switch (reduceState) {
                case 0:
                    goto0();
                    break;
                case 1:
                    goto1();
                    break;
                case 2:
                    goto2();
                    break;
                case 3:
                    goto3();
                    break;
                case 4:
                    goto4();
                    break;
                case 5:
                    goto5();
                    break;
                case 6:
                    goto6();
                    break;
                case 7:
                    goto7();
                    break;
                case 8:
                    goto8();
                    break;
                case 9:
                    goto9();
                    break;
                case 10:
                    goto10();
                    break;
                case 11:
                    goto11();
                    break;
                case 12:
                    goto12();
                    break;
                case 13:
                    goto13();
                    break;
                case 14:
                    goto14();
                    break;
                case 15:
                    goto15();
                    break;
                case 16:
                    goto16();
                    break;
                case 17:
                    goto17();
                    break;
                case 18:
                    goto18();
                    break;
                case 19:
                    goto19();
                    break;
                case 20:
                    goto20();
                    break;
                case 21:
                    goto21();
                    break;
                case 22:
                    goto22();
                    break;
                case 23:
                    goto23();
                    break;
                case 24:
                    goto24();
                    break;
                case 25:
                    goto25();
                    break;
                case 26:
                    goto26();
                    break;
                case 27:
                    goto27();
                    break;
                case 28:
                    goto28();
                    break;
                case 29:
                    goto29();
                    break;
                case 30:
                    goto30();
                    break;
                case 31:
                    goto31();
                    break;
                case 32:
                    goto32();
                    break;
                case 33:
                    goto33();
                    break;
                case 34:
                    goto34();
                    break;
                case 35:
                    goto35();
                    break;
                case 36:
                    goto36();
                    break;
                case 37:
                    goto37();
                    break;
                case 38:
                    goto38();
                    break;
                case 39:
                    goto39();
                    break;
                case 40:
                    goto40();
                    break;
                case 41:
                    goto41();
                    break;
                case 42:
                    goto42();
                    break;
                case 43:
                    goto43();
                    break;
                case 44:
                    goto44();
                    break;
                case 45:
                    goto45();
                    break;
                case 46:
                    goto46();
                    break;
                case 47:
                    goto47();
                    break;
                case 48:
                    goto48();
                    break;
                case 49:
                    goto49();
                    break;
                case 50:
                    goto50();
                    break;
                case 51:
                    goto51();
                    break;
                case 52:
                    goto52();
                    break;
                case 53:
                    goto53();
                    break;
                case 54:
                    goto54();
                    break;
                case 55:
                    goto55();
                    break;
                case 56:
                    goto56();
                    break;
                case 57:
                    goto57();
                    break;
                case 58:
                    goto58();
                    break;
                case 59:
                    goto59();
                    break;
                case 60:
                    goto60();
                    break;
                case 61:
                    goto61();
                    break;
                case 62:
                    goto62();
                    break;
                case 63:
                    goto63();
                    break;
                case 64:
                    goto64();
                    break;
                case 65:
                    goto65();
                    break;
                case 66:
                    goto66();
                    break;
                case 67:
                    goto67();
                    break;
                case 68:
                    goto68();
                    break;
                case 69:
                    goto69();
                    break;
                case 70:
                    goto70();
                    break;
                case 71:
                    goto71();
                    break;
                case 72:
                    goto72();
                    break;
                case 73:
                    goto73();
                    break;
                case 74:
                    goto74();
                    break;
                case 75:
                    goto75();
                    break;
                case 76:
                    goto76();
                    break;
                case 77:
                    goto77();
                    break;
                case 78:
                    goto78();
                    break;
                case 79:
                    goto79();
                    break;
                case 80:
                    goto80();
                    break;
                case 81:
                    goto81();
                    break;
                case 82:
                    goto82();
                    break;
                case 83:
                    goto83();
                    break;
                case 84:
                    goto84();
                    break;
                case 85:
                    goto85();
                    break;
                case 86:
                    goto86();
                    break;
                case 87:
                    goto87();
                    break;
                case 88:
                    goto88();
                    break;
                case 89:
                    goto89();
                    break;
                case 90:
                    goto90();
                    break;
                case 91:
                    goto91();
                    break;
                case 92:
                    goto92();
                    break;
                case 93:
                    goto93();
                    break;
                case 94:
                    goto94();
                    break;
                case 95:
                    goto95();
                    break;
                case 96:
                    goto96();
                    break;
                case 97:
                    goto97();
                    break;
                case 98:
                    goto98();
                    break;
                case 99:
                    goto99();
                    break;
                case 100:
                    goto100();
                    break;
                case 101:
                    goto101();
                    break;
                case 102:
                    goto102();
                    break;
                case 103:
                    goto103();
                    break;
                case 104:
                    goto104();
                    break;
                case 105:
                    goto105();
                    break;
                case 106:
                    goto106();
                    break;
                case 107:
                    goto107();
                    break;
                case 108:
                    goto108();
                    break;
                case 109:
                    goto109();
                    break;
                case 110:
                    goto110();
                    break;
                case 111:
                    goto111();
                    break;
                case 112:
                    goto112();
                    break;
                case 113:
                    goto113();
                    break;
                case 114:
                    goto114();
                    break;
                case 115:
                    goto115();
                    break;
                case 116:
                    goto116();
                    break;
                case 117:
                    goto117();
                    break;
                case 118:
                    goto118();
                    break;
                case 119:
                    goto119();
                    break;
                case 120:
                    goto120();
                    break;
                case 121:
                    goto121();
                    break;
                case 122:
                    goto122();
                    break;
                case 123:
                    goto123();
                    break;
                case 124:
                    goto124();
                    break;
                case 125:
                    goto125();
                    break;
                case 126:
                    goto126();
                    break;
                case 127:
                    goto127();
                    break;
                case 128:
                    goto128();
                    break;
                case 129:
                    goto129();
                    break;
                case 130:
                    goto130();
                    break;
                case 131:
                    goto131();
                    break;
                case 132:
                    goto132();
                    break;
                case 133:
                    goto133();
                    break;
                case 134:
                    goto134();
                    break;
                case 135:
                    goto135();
                    break;
                case 136:
                    goto136();
                    break;
                case 137:
                    goto137();
                    break;
                case 138:
                    goto138();
                    break;
                case 139:
                    goto139();
                    break;
                case 140:
                    goto140();
                    break;
                case 141:
                    goto141();
                    break;
                case 142:
                    goto142();
                    break;
                case 143:
                    goto143();
                    break;
                case 144:
                    goto144();
                    break;
                case 145:
                    goto145();
                    break;
                case 146:
                    goto146();
                    break;
                case 147:
                    goto147();
                    break;
                case 148:
                    goto148();
                    break;
                case 149:
                    goto149();
                    break;
                case 150:
                    goto150();
                    break;
                case 151:
                    goto151();
                    break;
                case 152:
                    goto152();
                    break;
                case 153:
                    goto153();
                    break;
                case 154:
                    goto154();
                    break;
                case 155:
                    goto155();
                    break;
                case 156:
                    goto156();
                    break;
                case 157:
                    goto157();
                    break;
                case 158:
                    goto158();
                    break;
                case 159:
                    goto159();
                    break;
                case 160:
                    goto160();
                    break;
                case 161:
                    goto161();
                    break;
                case 162:
                    goto162();
                    break;
                case 163:
                    goto163();
                    break;
                case 164:
                    goto164();
                    break;
                case 165:
                    goto165();
                    break;
                case 166:
                    goto166();
                    break;
                case 167:
                    goto167();
                    break;
                case 168:
                    goto168();
                    break;
                case 169:
                    goto169();
                    break;
                case 170:
                    goto170();
                    break;
                case 171:
                    goto171();
                    break;
                case 172:
                    goto172();
                    break;
                case 173:
                    goto173();
                    break;
                case 174:
                    goto174();
                    break;
                case 175:
                    goto175();
                    break;
                case 176:
                    goto176();
                    break;
                case 177:
                    goto177();
                    break;
                case 178:
                    goto178();
                    break;
                case 179:
                    goto179();
                    break;
                case 180:
                    goto180();
                    break;
                case 181:
                    goto181();
                    break;
                case 182:
                    goto182();
                    break;
                case 183:
                    goto183();
                    break;
                case 184:
                    goto184();
                    break;
                case 185:
                    goto185();
                    break;
                case 186:
                    goto186();
                    break;
                case 187:
                    goto187();
                    break;
                case 188:
                    goto188();
                    break;
                case 189:
                    goto189();
                    break;
                case 190:
                    goto190();
                    break;
                case 191:
                    goto191();
                    break;
                case 192:
                    goto192();
                    break;
                case 193:
                    goto193();
                    break;
                case 194:
                    goto194();
                    break;
                case 195:
                    goto195();
                    break;
                case 196:
                    goto196();
                    break;
                case 197:
                    goto197();
                    break;
                case 198:
                    goto198();
                    break;
                case 199:
                    goto199();
                    break;
                case 200:
                    goto200();
                    break;
                case 201:
                    goto201();
                    break;
                case 202:
                    goto202();
                    break;
                case 203:
                    goto203();
                    break;
                case 204:
                    goto204();
                    break;
                case 205:
                    goto205();
                    break;
                case 206:
                    goto206();
                    break;
                case 207:
                    goto207();
                    break;
                case 208:
                    goto208();
                    break;
                case 209:
                    goto209();
                    break;
                case 210:
                    goto210();
                    break;
                case 211:
                    goto211();
                    break;
                case 212:
                    goto212();
                    break;
                case 213:
                    goto213();
                    break;
                case 214:
                    goto214();
                    break;
                case 215:
                    goto215();
                    break;
                case 216:
                    goto216();
                    break;
                case 217:
                    goto217();
                    break;
                case 218:
                    goto218();
                    break;
                case 219:
                    goto219();
                    break;
                case 220:
                    goto220();
                    break;
                case 221:
                    goto221();
                    break;
                case 222:
                    goto222();
                    break;
                case 223:
                    goto223();
                    break;
                case 224:
                    goto224();
                    break;
                case 225:
                    goto225();
                    break;
                case 226:
                    goto226();
                    break;
                case 227:
                    goto227();
                    break;
                case 228:
                    goto228();
                    break;
                case 229:
                    goto229();
                    break;
                case 230:
                    goto230();
                    break;
                case 231:
                    goto231();
                    break;
                case 232:
                    goto232();
                    break;
                case 233:
                    goto233();
                    break;
                case 234:
                    goto234();
                    break;
                case 235:
                    goto235();
                    break;
                case 236:
                    goto236();
                    break;
                case 237:
                    goto237();
                    break;
                case 238:
                    goto238();
                    break;
                case 239:
                    goto239();
                    break;
                case 240:
                    goto240();
                    break;
                case 241:
                    goto241();
                    break;
                case 242:
                    goto242();
                    break;
                case 243:
                    goto243();
                    break;
                case 244:
                    goto244();
                    break;
                case 245:
                    goto245();
                    break;
                case 246:
                    goto246();
                    break;
                case 247:
                    goto247();
                    break;
                case 248:
                    goto248();
                    break;
                case 249:
                    goto249();
                    break;
                case 250:
                    goto250();
                    break;
                case 251:
                    goto251();
                    break;
                case 252:
                    goto252();
                    break;
                case 253:
                    goto253();
                    break;
                case 254:
                    goto254();
                    break;
                case 255:
                    goto255();
                    break;
                case 256:
                    goto256();
                    break;
                case 257:
                    goto257();
                    break;
                case 258:
                    goto258();
                    break;
                case 259:
                    goto259();
                    break;
                case 260:
                    goto260();
                    break;
                case 261:
                    goto261();
                    break;
                case 262:
                    goto262();
                    break;
                case 263:
                    goto263();
                    break;
                case 264:
                    goto264();
                    break;
                case 265:
                    goto265();
                    break;
                case 266:
                    goto266();
                    break;
                case 267:
                    goto267();
                    break;
                case 268:
                    goto268();
                    break;
                case 269:
                    goto269();
                    break;
                case 270:
                    goto270();
                    break;
                case 271:
                    goto271();
                    break;
                case 272:
                    goto272();
                    break;
                case 273:
                    goto273();
                    break;
                case 274:
                    goto274();
                    break;
                case 275:
                    goto275();
                    break;
                case 276:
                    goto276();
                    break;
                case 277:
                    goto277();
                    break;
                case 278:
                    goto278();
                    break;
                case 279:
                    goto279();
                    break;
                case 280:
                    goto280();
                    break;
                case 281:
                    goto281();
                    break;
                case 282:
                    goto282();
                    break;
                case 283:
                    goto283();
                    break;
                case 284:
                    goto284();
                    break;
                case 285:
                    goto285();
                    break;
                case 286:
                    goto286();
                    break;
                case 287:
                    goto287();
                    break;
                case 288:
                    goto288();
                    break;
                case 289:
                    goto289();
                    break;
                case 290:
                    goto290();
                    break;
                case 291:
                    goto291();
                    break;
                case 292:
                    goto292();
                    break;
                case 293:
                    goto293();
                    break;
                case 294:
                    goto294();
                    break;
                case 295:
                    goto295();
                    break;
                case 296:
                    goto296();
                    break;
                case 297:
                    goto297();
                    break;
                case 298:
                    goto298();
                    break;
                case 299:
                    goto299();
                    break;
                case 300:
                    goto300();
                    break;
                case 301:
                    goto301();
                    break;
                case 302:
                    goto302();
                    break;
                case 303:
                    goto303();
                    break;
                case 304:
                    goto304();
                    break;
                case 305:
                    goto305();
                    break;
                case 306:
                    goto306();
                    break;
                case 307:
                    goto307();
                    break;
                case 308:
                    goto308();
                    break;
                case 309:
                    goto309();
                    break;
                case 310:
                    goto310();
                    break;
                case 311:
                    goto311();
                    break;
                case 312:
                    goto312();
                    break;
                case 313:
                    goto313();
                    break;
                case 314:
                    goto314();
                    break;
                case 315:
                    goto315();
                    break;
                case 316:
                    goto316();
                    break;
                case 317:
                    goto317();
                    break;
                case 318:
                    goto318();
                    break;
                case 319:
                    goto319();
                    break;
                case 320:
                    goto320();
                    break;
                case 321:
                    goto321();
                    break;
                case 322:
                    goto322();
                    break;
                case 323:
                    goto323();
                    break;
                case 324:
                    goto324();
                    break;
                case 325:
                    goto325();
                    break;
                case 326:
                    goto326();
                    break;
                case 327:
                    goto327();
                    break;
                case 328:
                    goto328();
                    break;
                case 329:
                    goto329();
                    break;
                case 330:
                    goto330();
                    break;
                case 331:
                    goto331();
                    break;
                case 332:
                    goto332();
                    break;
                case 333:
                    goto333();
                    break;
                case 334:
                    goto334();
                    break;
                case 335:
                    goto335();
                    break;
                case 336:
                    goto336();
                    break;
                case 337:
                    goto337();
                    break;
                case 338:
                    goto338();
                    break;
                case 339:
                    goto339();
                    break;
                case 340:
                    goto340();
                    break;
                case 341:
                    goto341();
                    break;
                case 342:
                    goto342();
                    break;
                case 343:
                    goto343();
                    break;
                case 344:
                    goto344();
                    break;
                case 345:
                    goto345();
                    break;
                case 346:
                    goto346();
                    break;
                case 347:
                    goto347();
                    break;
                case 348:
                    goto348();
                    break;
                case 349:
                    goto349();
                    break;
                case 350:
                    goto350();
                    break;
                case 351:
                    goto351();
                    break;
                case 352:
                    goto352();
                    break;
                case 353:
                    goto353();
                    break;
                case 354:
                    goto354();
                    break;
                case 355:
                    goto355();
                    break;
                case 356:
                    goto356();
                    break;
                case 357:
                    goto357();
                    break;
                case 358:
                    goto358();
                    break;
                case 359:
                    goto359();
                    break;
                case 360:
                    goto360();
                    break;
                case 361:
                    goto361();
                    break;
                case 362:
                    goto362();
                    break;
                case 363:
                    goto363();
                    break;
                case 364:
                    goto364();
                    break;
                case 365:
                    goto365();
                    break;
                case 366:
                    goto366();
                    break;
                case 367:
                    goto367();
                    break;
                case 368:
                    goto368();
                    break;
                case 369:
                    goto369();
                    break;
                case 370:
                    goto370();
                    break;
                case 371:
                    goto371();
                    break;
                case 372:
                    goto372();
                    break;
                case 373:
                    goto373();
                    break;
                case 374:
                    goto374();
                    break;
                case 375:
                    goto375();
                    break;
                case 376:
                    goto376();
                    break;
                case 377:
                    goto377();
                    break;
                case 378:
                    goto378();
                    break;
                case 379:
                    goto379();
                    break;
                case 380:
                    goto380();
                    break;
                case 381:
                    goto381();
                    break;
                case 382:
                    goto382();
                    break;
                case 383:
                    goto383();
                    break;
                case 384:
                    goto384();
                    break;
                case 385:
                    goto385();
                    break;
                case 386:
                    goto386();
                    break;
                case 387:
                    goto387();
                    break;
                case 388:
                    goto388();
                    break;
                case 389:
                    goto389();
                    break;
                case 390:
                    goto390();
                    break;
                case 391:
                    goto391();
                    break;
                case 392:
                    goto392();
                    break;
                case 393:
                    goto393();
                    break;
                case 394:
                    goto394();
                    break;
                case 395:
                    goto395();
                    break;
                case 396:
                    goto396();
                    break;
                case 397:
                    goto397();
                    break;
                case 398:
                    goto398();
                    break;
                case 399:
                    goto399();
                    break;
                case 400:
                    goto400();
                    break;
                case 401:
                    goto401();
                    break;
                case 402:
                    goto402();
                    break;
                case 403:
                    goto403();
                    break;
                case 404:
                    goto404();
                    break;
                case 405:
                    goto405();
                    break;
                case 406:
                    goto406();
                    break;
                case 407:
                    goto407();
                    break;
                case 408:
                    goto408();
                    break;
                case 409:
                    goto409();
                    break;
                case 410:
                    goto410();
                    break;
                case 411:
                    goto411();
                    break;
                case 412:
                    goto412();
                    break;
                case 413:
                    goto413();
                    break;
                case 414:
                    goto414();
                    break;
                case 415:
                    goto415();
                    break;
                case 416:
                    goto416();
                    break;
                case 417:
                    goto417();
                    break;
                case 418:
                    goto418();
                    break;
                case 419:
                    goto419();
                    break;
                case 420:
                    goto420();
                    break;
                case 421:
                    goto421();
                    break;
                case 422:
                    goto422();
                    break;
                case 423:
                    goto423();
                    break;
                case 424:
                    goto424();
                    break;
                case 425:
                    goto425();
                    break;
                case 426:
                    goto426();
                    break;
                case 427:
                    goto427();
                    break;
                case 428:
                    goto428();
                    break;
                case 429:
                    goto429();
                    break;
                case 430:
                    goto430();
                    break;
                case 431:
                    goto431();
                    break;
                case 432:
                    goto432();
                    break;
                case 433:
                    goto433();
                    break;
                case 434:
                    goto434();
                    break;
                case 435:
                    goto435();
                    break;
                case 436:
                    goto436();
                    break;
                case 437:
                    goto437();
                    break;
                case 438:
                    goto438();
                    break;
                case 439:
                    goto439();
                    break;
                case 440:
                    goto440();
                    break;
                case 441:
                    goto441();
                    break;
                case 442:
                    goto442();
                    break;
                case 443:
                    goto443();
                    break;
                case 444:
                    goto444();
                    break;
                case 445:
                    goto445();
                    break;
                case 446:
                    goto446();
                    break;
                case 447:
                    goto447();
                    break;
                case 448:
                    goto448();
                    break;
                case 449:
                    goto449();
                    break;
                case 450:
                    goto450();
                    break;
                case 451:
                    goto451();
                    break;
                case 452:
                    goto452();
                    break;
                case 453:
                    goto453();
                    break;
                case 454:
                    goto454();
                    break;
                case 455:
                    goto455();
                    break;
                case 456:
                    goto456();
                    break;
                case 457:
                    goto457();
                    break;
                case 458:
                    goto458();
                    break;
                case 459:
                    goto459();
                    break;
                case 460:
                    goto460();
                    break;
                case 461:
                    goto461();
                    break;
                case 462:
                    goto462();
                    break;
                case 463:
                    goto463();
                    break;
                case 464:
                    goto464();
                    break;
                case 465:
                    goto465();
                    break;
                case 466:
                    goto466();
                    break;
                case 467:
                    goto467();
                    break;
                case 468:
                    goto468();
                    break;
                case 469:
                    goto469();
                    break;
                case 470:
                    goto470();
                    break;
                case 471:
                    goto471();
                    break;
                case 472:
                    goto472();
                    break;
                case 473:
                    goto473();
                    break;
                case 474:
                    goto474();
                    break;
                case 475:
                    goto475();
                    break;
                case 476:
                    goto476();
                    break;
                case 477:
                    goto477();
                    break;
                case 478:
                    goto478();
                    break;
                case 479:
                    goto479();
                    break;
                case 480:
                    goto480();
                    break;
                case 481:
                    goto481();
                    break;
                case 482:
                    goto482();
                    break;
                case 483:
                    goto483();
                    break;
                case 484:
                    goto484();
                    break;
                case 485:
                    goto485();
                    break;
                case 486:
                    goto486();
                    break;
                case 487:
                    goto487();
                    break;
                case 488:
                    goto488();
                    break;
                case 489:
                    goto489();
                    break;
                case 490:
                    goto490();
                    break;
                case 491:
                    goto491();
                    break;
                case 492:
                    goto492();
                    break;
                case 493:
                    goto493();
                    break;
                case 494:
                    goto494();
                    break;
                case 495:
                    goto495();
                    break;
                case 496:
                    goto496();
                    break;
                case 497:
                    goto497();
                    break;
                case 498:
                    goto498();
                    break;
                case 499:
                    goto499();
                    break;
                case 500:
                    goto500();
                    break;
                case 501:
                    goto501();
                    break;
                case 502:
                    goto502();
                    break;
                case 503:
                    goto503();
                    break;
                case 504:
                    goto504();
                    break;
                case 505:
                    goto505();
                    break;
                case 506:
                    goto506();
                    break;
                case 507:
                    goto507();
                    break;
                case 508:
                    goto508();
                    break;
                case 509:
                    goto509();
                    break;
                case 510:
                    goto510();
                    break;
                case 511:
                    goto511();
                    break;
                case 512:
                    goto512();
                    break;
                case 513:
                    goto513();
                    break;
                case 514:
                    goto514();
                    break;
                case 515:
                    goto515();
                    break;
                case 516:
                    goto516();
                    break;
                case 517:
                    goto517();
                    break;
                case 518:
                    goto518();
                    break;
                case 519:
                    goto519();
                    break;
                case 520:
                    goto520();
                    break;
                case 521:
                    goto521();
                    break;
                case 522:
                    goto522();
                    break;
                case 523:
                    goto523();
                    break;
                case 524:
                    goto524();
                    break;
                case 525:
                    goto525();
                    break;
                case 526:
                    goto526();
                    break;
                case 527:
                    goto527();
                    break;
                case 528:
                    goto528();
                    break;
                case 529:
                    goto529();
                    break;
                case 530:
                    goto530();
                    break;
                case 531:
                    goto531();
                    break;
                case 532:
                    goto532();
                    break;
                case 533:
                    goto533();
                    break;
                case 534:
                    goto534();
                    break;
                case 535:
                    goto535();
                    break;
                case 536:
                    goto536();
                    break;
                case 537:
                    goto537();
                    break;
                case 538:
                    goto538();
                    break;
                case 539:
                    goto539();
                    break;
                case 540:
                    goto540();
                    break;
                case 541:
                    goto541();
                    break;
                case 542:
                    goto542();
                    break;
                case 543:
                    goto543();
                    break;
                case 544:
                    goto544();
                    break;
                case 545:
                    goto545();
                    break;
                case 546:
                    goto546();
                    break;
                case 547:
                    goto547();
                    break;
                case 548:
                    goto548();
                    break;
                case 549:
                    goto549();
                    break;
                case 550:
                    goto550();
                    break;
                case 551:
                    goto551();
                    break;
                case 552:
                    goto552();
                    break;
                case 553:
                    goto553();
                    break;
                case 554:
                    goto554();
                    break;
                case 555:
                    goto555();
                    break;
                case 556:
                    goto556();
                    break;
                case 557:
                    goto557();
                    break;
                case 558:
                    goto558();
                    break;
                case 559:
                    goto559();
                    break;
                case 560:
                    goto560();
                    break;
                case 561:
                    goto561();
                    break;
                case 562:
                    goto562();
                    break;
                case 563:
                    goto563();
                    break;
                case 564:
                    goto564();
                    break;
                case 565:
                    goto565();
                    break;
                case 566:
                    goto566();
                    break;
                case 567:
                    goto567();
                    break;
                case 568:
                    goto568();
                    break;
                case 569:
                    goto569();
                    break;
                case 570:
                    goto570();
                    break;
                case 571:
                    goto571();
                    break;
                case 572:
                    goto572();
                    break;
                case 573:
                    goto573();
                    break;
                case 574:
                    goto574();
                    break;
                case 575:
                    goto575();
                    break;
                case 576:
                    goto576();
                    break;
                case 577:
                    goto577();
                    break;
                case 578:
                    goto578();
                    break;
                case 579:
                    goto579();
                    break;
                case 580:
                    goto580();
                    break;
                case 581:
                    goto581();
                    break;
                case 582:
                    goto582();
                    break;
                case 583:
                    goto583();
                    break;
                case 584:
                    goto584();
                    break;
                case 585:
                    goto585();
                    break;
                case 586:
                    goto586();
                    break;
                case 587:
                    goto587();
                    break;
                case 588:
                    goto588();
                    break;
                case 589:
                    goto589();
                    break;
                case 590:
                    goto590();
                    break;
                case 591:
                    goto591();
                    break;
                case 592:
                    goto592();
                    break;
                case 593:
                    goto593();
                    break;
                case 594:
                    goto594();
                    break;
                case 595:
                    goto595();
                    break;
                case 596:
                    goto596();
                    break;
                case 597:
                    goto597();
                    break;
                case 598:
                    goto598();
                    break;
                case 599:
                    goto599();
                    break;
                case 600:
                    goto600();
                    break;
                case 601:
                    goto601();
                    break;
                case 602:
                    goto602();
                    break;
                case 603:
                    goto603();
                    break;
                case 604:
                    goto604();
                    break;
                case 605:
                    goto605();
                    break;
                case 606:
                    goto606();
                    break;
                case 607:
                    goto607();
                    break;
                case 608:
                    goto608();
                    break;
                case 609:
                    goto609();
                    break;
                case 610:
                    goto610();
                    break;
                case 611:
                    goto611();
                    break;
                case 612:
                    goto612();
                    break;
                case 613:
                    goto613();
                    break;
                case 614:
                    goto614();
                    break;
                case 615:
                    goto615();
                    break;
                case 616:
                    goto616();
                    break;
                case 617:
                    goto617();
                    break;
                case 618:
                    goto618();
                    break;
                case 619:
                    goto619();
                    break;
                case 620:
                    goto620();
                    break;
                case 621:
                    goto621();
                    break;
                case 622:
                    goto622();
                    break;
                case 623:
                    goto623();
                    break;
                case 624:
                    goto624();
                    break;
                case 625:
                    goto625();
                    break;
                case 626:
                    goto626();
                    break;
                case 627:
                    goto627();
                    break;
                case 628:
                    goto628();
                    break;
                case 629:
                    goto629();
                    break;
                case 630:
                    goto630();
                    break;
                case 631:
                    goto631();
                    break;
                case 632:
                    goto632();
                    break;
                case 633:
                    goto633();
                    break;
                case 634:
                    goto634();
                    break;
                case 635:
                    goto635();
                    break;
                case 636:
                    goto636();
                    break;
                case 637:
                    goto637();
                    break;
                case 638:
                    goto638();
                    break;
                case 639:
                    goto639();
                    break;
                case 640:
                    goto640();
                    break;
                case 641:
                    goto641();
                    break;
                case 642:
                    goto642();
                    break;
                case 643:
                    goto643();
                    break;
                case 644:
                    goto644();
                    break;
                case 645:
                    goto645();
                    break;
                case 646:
                    goto646();
                    break;
                case 647:
                    goto647();
                    break;
                case 648:
                    goto648();
                    break;
                case 649:
                    goto649();
                    break;
                case 650:
                    goto650();
                    break;
                case 651:
                    goto651();
                    break;
                case 652:
                    goto652();
                    break;
                case 653:
                    goto653();
                    break;
                case 654:
                    goto654();
                    break;
                case 655:
                    goto655();
                    break;
                case 656:
                    goto656();
                    break;
                case 657:
                    goto657();
                    break;
                case 658:
                    goto658();
                    break;
                case 659:
                    goto659();
                    break;
                case 660:
                    goto660();
                    break;
                case 661:
                    goto661();
                    break;
                case 662:
                    goto662();
                    break;
                case 663:
                    goto663();
                    break;
                case 664:
                    goto664();
                    break;
                case 665:
                    goto665();
                    break;
                case 666:
                    goto666();
                    break;
                case 667:
                    goto667();
                    break;
                case 668:
                    goto668();
                    break;
                case 669:
                    goto669();
                    break;
                case 670:
                    goto670();
                    break;
                case 671:
                    goto671();
                    break;
                case 672:
                    goto672();
                    break;
                case 673:
                    goto673();
                    break;
                case 674:
                    goto674();
                    break;
                case 675:
                    goto675();
                    break;
                case 676:
                    goto676();
                    break;
                case 677:
                    goto677();
                    break;
                case 678:
                    goto678();
                    break;
                case 679:
                    goto679();
                    break;
                case 680:
                    goto680();
                    break;
                case 681:
                    goto681();
                    break;
                case 682:
                    goto682();
                    break;
                case 683:
                    goto683();
                    break;
                case 684:
                    goto684();
                    break;
                case 685:
                    goto685();
                    break;
                case 686:
                    goto686();
                    break;
                case 687:
                    goto687();
                    break;
                case 688:
                    goto688();
                    break;
                case 689:
                    goto689();
                    break;
                case 690:
                    goto690();
                    break;
                case 691:
                    goto691();
                    break;
                case 692:
                    goto692();
                    break;
                case 693:
                    goto693();
                    break;
                case 694:
                    goto694();
                    break;
                case 695:
                    goto695();
                    break;
                case 696:
                    goto696();
                    break;
                case 697:
                    goto697();
                    break;
                case 698:
                    goto698();
                    break;
                case 699:
                    goto699();
                    break;
                case 700:
                    goto700();
                    break;
                case 701:
                    goto701();
                    break;
                case 702:
                    goto702();
                    break;
                case 703:
                    goto703();
                    break;
                case 704:
                    goto704();
                    break;
                case 705:
                    goto705();
                    break;
                case 706:
                    goto706();
                    break;
                case 707:
                    goto707();
                    break;
                case 708:
                    goto708();
                    break;
                case 709:
                    goto709();
                    break;
                case 710:
                    goto710();
                    break;
                case 711:
                    goto711();
                    break;
                case 712:
                    goto712();
                    break;
                case 713:
                    goto713();
                    break;
                case 714:
                    goto714();
                    break;
                case 715:
                    goto715();
                    break;
                case 716:
                    goto716();
                    break;
                case 717:
                    goto717();
                    break;
                case 718:
                    goto718();
                    break;
                case 719:
                    goto719();
                    break;
                case 720:
                    goto720();
                    break;
                case 721:
                    goto721();
                    break;
                case 722:
                    goto722();
                    break;
                case 723:
                    goto723();
                    break;
                case 724:
                    goto724();
                    break;
                case 725:
                    goto725();
                    break;
                case 726:
                    goto726();
                    break;
                case 727:
                    goto727();
                    break;
                case 728:
                    goto728();
                    break;
                case 729:
                    goto729();
                    break;
                case 730:
                    goto730();
                    break;
                case 731:
                    goto731();
                    break;
                case 732:
                    goto732();
                    break;
                case 733:
                    goto733();
                    break;
                case 734:
                    goto734();
                    break;
                case 735:
                    goto735();
                    break;
                case 736:
                    goto736();
                    break;
                case 737:
                    goto737();
                    break;
                case 738:
                    goto738();
                    break;
                case 739:
                    goto739();
                    break;
                case 740:
                    goto740();
                    break;
                case 741:
                    goto741();
                    break;
                case 742:
                    goto742();
                    break;
                case 743:
                    goto743();
                    break;
                case 744:
                    goto744();
                    break;
                case 745:
                    goto745();
                    break;
                case 746:
                    goto746();
                    break;
                case 747:
                    goto747();
                    break;
                case 748:
                    goto748();
                    break;
                case 749:
                    goto749();
                    break;
                case 750:
                    goto750();
                    break;
                case 751:
                    goto751();
                    break;
                case 752:
                    goto752();
                    break;
                case 753:
                    goto753();
                    break;
                case 754:
                    goto754();
                    break;
                case 755:
                    goto755();
                    break;
                case 756:
                    goto756();
                    break;
                case 757:
                    goto757();
                    break;
                case 758:
                    goto758();
                    break;
                case 759:
                    goto759();
                    break;
                case 760:
                    goto760();
                    break;
                case 761:
                    goto761();
                    break;
                case 762:
                    goto762();
                    break;
                case 763:
                    goto763();
                    break;
                case 764:
                    goto764();
                    break;
                case 765:
                    goto765();
                    break;
                case 766:
                    goto766();
                    break;
                case 767:
                    goto767();
                    break;
                case 768:
                    goto768();
                    break;
                case 769:
                    goto769();
                    break;
                case 770:
                    goto770();
                    break;
                case 771:
                    goto771();
                    break;
                default:
                    String msg = fmt("Unknown reduce state %d.", reduceState);
                    throw new RuntimeException(msg);
            }
        }
    }

    /**
     * Parser action code for parser state 0.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action0() throws IOException {
        switch (token.id) {
            case 0:
            case 4:
            case 8:
            case 9:
            case 11:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 42:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce OptGroupDecls : ;
                doReduce1(token, 5);
                List<ADecl> o = hooks.parseOptGroupDecls1();

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 1.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action1() throws IOException {
        switch (token.id) {
            case 170: {
                // Reduce Specification : GroupBody;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                ASpecification o = hooks.parseSpecification1((AGroupBody)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 2.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action2() throws IOException {
        switch (token.id) {
            case 0: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 8: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 9: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 11: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 23: {
                // Shift 8.
                token = doShift(token, 8);
                return;
            }

            case 24: {
                // Shift 9.
                token = doShift(token, 9);
                return;
            }

            case 30: {
                // Shift 10.
                token = doShift(token, 10);
                return;
            }

            case 32: {
                // Shift 11.
                token = doShift(token, 11);
                return;
            }

            case 35: {
                // Shift 12.
                token = doShift(token, 12);
                return;
            }

            case 36: {
                // Shift 13.
                token = doShift(token, 13);
                return;
            }

            case 42: {
                // Shift 14.
                token = doShift(token, 14);
                return;
            }

            case 44: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 49: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            case 50: {
                // Shift 17.
                token = doShift(token, 17);
                return;
            }

            case 56: {
                // Shift 18.
                token = doShift(token, 18);
                return;
            }

            case 57: {
                // Shift 19.
                token = doShift(token, 19);
                return;
            }

            case 58: {
                // Shift 20.
                token = doShift(token, 20);
                return;
            }

            case 59: {
                // Shift 21.
                token = doShift(token, 21);
                return;
            }

            case 60: {
                // Shift 22.
                token = doShift(token, 22);
                return;
            }

            case 68: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 69: {
                // Shift 24.
                token = doShift(token, 24);
                return;
            }

            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 22:
            case 170: {
                // Reduce GroupBody : OptGroupDecls;
                doReduce1(token, 3);
                Object o1 = doReduce2();

                AGroupBody o = hooks.parseGroupBody1((List<ADecl>)o1);

                reduce = true;
                reduceNonTerminal = 3;
                reduceState = doReduce3(o);
                return;
            }

            case 4:
            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            case 25: {
                // Reduce OptControllability : ;
                doReduce1(token, 66);
                Token o = hooks.parseOptControllability1();

                reduce = true;
                reduceNonTerminal = 66;
                reduceState = doReduce3(o);
                return;
            }

            case 37:
            case 166: {
                // Reduce OptAnnos : ;
                doReduce1(token, 112);
                List<AAnnotation> o = hooks.parseOptAnnos1();

                reduce = true;
                reduceNonTerminal = 112;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 3.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action3() throws IOException {
        switch (token.id) {
            case 170: {
                // Accept.
                Object rslt = doAccept(token);
                accept = true;
                acceptObject = (ASpecification)rslt;
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 4.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action4() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 5.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action5() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 6.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action6() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 7.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action7() throws IOException {
        switch (token.id) {
            case 5:
            case 14:
            case 17:
            case 25:
            case 30:
            case 38:
            case 40:
            case 51:
            case 54:
            case 55:
            case 67:
            case 72:
            case 159:
            case 160:
            case 161:
            case 162: {
                // Reduce Controllability : CONTROLLABLEKW;
                doReduce1(token, 67);
                Object o1 = doReduce2();

                Token o = hooks.parseControllability1((Token)o1);

                reduce = true;
                reduceNonTerminal = 67;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 8.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action8() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 9.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action9() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 10.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action10() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 11.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action11() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 12: {
                // Shift 663.
                token = doShift(token, 663);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 12.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action12() throws IOException {
        switch (token.id) {
            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 13.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action13() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 14.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action14() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 15.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action15() throws IOException {
        switch (token.id) {
            case 159: {
                // Shift 650.
                token = doShift(token, 650);
                return;
            }

            case 162: {
                // Shift 651.
                token = doShift(token, 651);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 16.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action16() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 47: {
                // Shift 618.
                token = doShift(token, 618);
                return;
            }

            case 48: {
                // Shift 619.
                token = doShift(token, 619);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 17.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action17() throws IOException {
        switch (token.id) {
            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 18.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action18() throws IOException {
        switch (token.id) {
            case 33: {
                // Shift 606.
                token = doShift(token, 606);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 19.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action19() throws IOException {
        switch (token.id) {
            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 20.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action20() throws IOException {
        switch (token.id) {
            case 33: {
                // Shift 579.
                token = doShift(token, 579);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 21.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action21() throws IOException {
        switch (token.id) {
            case 33: {
                // Shift 571.
                token = doShift(token, 571);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 22.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action22() throws IOException {
        switch (token.id) {
            case 33: {
                // Shift 559.
                token = doShift(token, 559);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 23.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action23() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 24.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action24() throws IOException {
        switch (token.id) {
            case 5:
            case 14:
            case 17:
            case 25:
            case 30:
            case 38:
            case 40:
            case 51:
            case 54:
            case 55:
            case 67:
            case 72:
            case 159:
            case 160:
            case 161:
            case 162: {
                // Reduce Controllability : UNCONTROLLABLEKW;
                doReduce1(token, 67);
                Object o1 = doReduce2();

                Token o = hooks.parseControllability2((Token)o1);

                reduce = true;
                reduceNonTerminal = 67;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 25.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action25() throws IOException {
        switch (token.id) {
            case 4:
            case 12:
            case 26:
            case 34:
            case 39:
            case 53:
            case 61:
            case 64:
            case 66:
            case 78:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 90:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            case 96:
            case 97:
            case 98:
            case 99:
            case 100:
            case 101:
            case 102:
            case 103:
            case 104:
            case 105:
            case 106:
            case 107:
            case 108:
            case 109:
            case 110:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 128:
            case 130:
            case 138:
            case 142:
            case 148:
            case 149:
            case 153:
            case 155:
            case 157:
            case 159:
            case 160:
            case 161:
            case 162:
            case 163:
            case 164:
            case 165: {
                // Reduce SupKind : PLANTKW;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                Token o = hooks.parseSupKind1((Token)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 26.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action26() throws IOException {
        switch (token.id) {
            case 4:
            case 12:
            case 26:
            case 34:
            case 39:
            case 53:
            case 61:
            case 64:
            case 66:
            case 78:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 90:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            case 96:
            case 97:
            case 98:
            case 99:
            case 100:
            case 101:
            case 102:
            case 103:
            case 104:
            case 105:
            case 106:
            case 107:
            case 108:
            case 109:
            case 110:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 128:
            case 130:
            case 138:
            case 142:
            case 148:
            case 149:
            case 153:
            case 155:
            case 157:
            case 159:
            case 160:
            case 161:
            case 162:
            case 163:
            case 164:
            case 165: {
                // Reduce SupKind : REQUIREMENTKW;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                Token o = hooks.parseSupKind2((Token)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 27.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action27() throws IOException {
        switch (token.id) {
            case 4:
            case 12:
            case 26:
            case 34:
            case 39:
            case 53:
            case 61:
            case 64:
            case 66:
            case 78:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 90:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            case 96:
            case 97:
            case 98:
            case 99:
            case 100:
            case 101:
            case 102:
            case 103:
            case 104:
            case 105:
            case 106:
            case 107:
            case 108:
            case 109:
            case 110:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 128:
            case 130:
            case 138:
            case 142:
            case 148:
            case 149:
            case 153:
            case 155:
            case 157:
            case 159:
            case 160:
            case 161:
            case 162:
            case 163:
            case 164:
            case 165: {
                // Reduce SupKind : SUPERVISORKW;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                Token o = hooks.parseSupKind3((Token)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 28.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action28() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 45:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 132:
            case 133:
            case 134:
            case 135:
            case 136:
            case 137:
            case 138:
            case 139:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
            case 162: {
                // Reduce Identifier : IDENTIFIERTK;
                doReduce1(token, 10);
                Object o1 = doReduce2();

                AIdentifier o = hooks.parseIdentifier1((Token)o1);

                reduce = true;
                reduceNonTerminal = 10;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 29.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action29() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            case 72: {
                // Shift 474.
                token = doShift(token, 474);
                return;
            }

            case 25: {
                // Reduce OptControllability : Controllability;
                doReduce1(token, 66);
                Object o1 = doReduce2();

                Token o = hooks.parseOptControllability2((Token)o1);

                reduce = true;
                reduceNonTerminal = 66;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 30.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action30() throws IOException {
        switch (token.id) {
            case 0:
            case 4:
            case 8:
            case 9:
            case 11:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 42:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce GroupDecl : Decl;
                doReduce1(token, 6);
                Object o1 = doReduce2();

                ADecl o = hooks.parseGroupDecl01((ADecl)o1);

                reduce = true;
                reduceNonTerminal = 6;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 31.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action31() throws IOException {
        switch (token.id) {
            case 0:
            case 4:
            case 8:
            case 9:
            case 11:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 42:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce OptGroupDecls : OptGroupDecls GroupDecl;
                doReduce1(token, 5);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<ADecl> o = hooks.parseOptGroupDecls2((List<ADecl>)o1, (ADecl)o2);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 32.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action32() throws IOException {
        switch (token.id) {
            case 135: {
                // Shift 537.
                token = doShift(token, 537);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 33.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action33() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce Decl : InvariantDecls;
                doReduce1(token, 9);
                Object o1 = doReduce2();

                ADecl o = hooks.parseDecl13((AInvariantDecl)o1);

                reduce = true;
                reduceNonTerminal = 9;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 34.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action34() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce Decl : IoDecl;
                doReduce1(token, 9);
                Object o1 = doReduce2();

                ADecl o = hooks.parseDecl15((AIoDecl)o1);

                reduce = true;
                reduceNonTerminal = 9;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 35.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action35() throws IOException {
        switch (token.id) {
            case 37: {
                // Shift 517.
                token = doShift(token, 517);
                return;
            }

            case 166: {
                // Shift 518.
                token = doShift(token, 518);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 36.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action36() throws IOException {
        switch (token.id) {
            case 25: {
                // Shift 510.
                token = doShift(token, 510);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 37.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action37() throws IOException {
        switch (token.id) {
            case 39: {
                // Shift 205.
                token = doShift(token, 205);
                return;
            }

            case 4: {
                // Shift 499.
                token = doShift(token, 499);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 38.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action38() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : Print;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl7((APrint)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 39.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action39() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : PrintFile;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl6((APrintFile)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 40.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action40() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 12: {
                // Shift 46.
                token = doShift(token, 46);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 4:
            case 39: {
                // Reduce OptSupKind : SupKind;
                doReduce1(token, 65);
                Object o1 = doReduce2();

                Token o = hooks.parseOptSupKind2((Token)o1);

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 41.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action41() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : SvgCopy;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl2((ASvgCopy)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 42.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action42() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : SvgFile;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl1((ASvgFile)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 43.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action43() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : SvgIn;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl5((ASvgIn)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 44.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action44() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : SvgMove;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl3((ASvgMove)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 45.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action45() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce IoDecl : SvgOut;
                doReduce1(token, 69);
                Object o1 = doReduce2();

                AIoDecl o = hooks.parseIoDecl4((ASvgOut)o1);

                reduce = true;
                reduceNonTerminal = 69;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 46.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action46() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 47.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action47() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : FALSEKW;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor02((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 48.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action48() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 49.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action49() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : SELFKW;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor20((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 50.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action50() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 51.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action51() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : TIMEKW;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor06((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 52.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action52() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : TRUEKW;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor01((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 53.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action53() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ACOSHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction01((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 54.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action54() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ACOSKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction02((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 55.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action55() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ASINHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction03((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 56.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action56() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ASINKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction04((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 57.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action57() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ATANHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction05((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 58.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action58() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ATANKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction06((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 59.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action59() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : COSHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction07((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 60.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action60() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : COSKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction08((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 61.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action61() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SINHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction09((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 62.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action62() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SINKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction10((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 63.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action63() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : TANHKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction11((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 64.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action64() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : TANKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction12((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 65.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action65() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ABSKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction13((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 66.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action66() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : CBRTKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction14((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 67.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action67() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : CEILKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction15((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 68.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action68() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : DELKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction16((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 69.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action69() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : EMPTYKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction17((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 70.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action70() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : EXPKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction18((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 71.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action71() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : FLOORKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction19((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 72.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action72() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : FMTKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction20((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 73.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action73() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : LNKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction21((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 74.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action74() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : LOGKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction22((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 75.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action75() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : MAXKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction23((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 76.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action76() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : MINKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction24((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 77.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action77() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : POPKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction25((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 78.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action78() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : POWKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction26((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 79.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action79() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ROUNDKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction27((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 80.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action80() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SCALEKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction28((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 81.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action81() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SIGNKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction29((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 82.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action82() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SIZEKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction30((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 83.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action83() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : SQRTKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction31((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 84.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action84() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : BERNOULLIKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction32((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 85.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action85() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : BETAKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction33((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 86.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action86() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : BINOMIALKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction34((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 87.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action87() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : CONSTANTKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction35((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 88.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action88() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : ERLANGKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction36((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 89.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action89() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : EXPONENTIALKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction37((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 90.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action90() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : GAMMAKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction38((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 91.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action91() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : GEOMETRICKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction39((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 92.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action92() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : LOGNORMALKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction40((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 93.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action93() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : NORMALKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction41((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 94.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action94() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : POISSONKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction42((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 95.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action95() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : RANDOMKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction43((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 96.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action96() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : TRIANGLEKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction44((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 97.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action97() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : UNIFORMKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction45((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 98.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action98() throws IOException {
        switch (token.id) {
            case 155: {
                // Reduce StdLibFunction : WEIBULLKW;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                Token o = hooks.parseStdLibFunction46((Token)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 99.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action99() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 100.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action100() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 101.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action101() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : QUESTIONTK;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor19((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 102.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action102() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 103.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action103() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 104.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action104() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 105.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action105() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 154: {
                // Shift 412.
                token = doShift(token, 412);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 106.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action106() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 107.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action107() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 158: {
                // Shift 404.
                token = doShift(token, 404);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 108.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action108() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 45:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 136:
            case 137:
            case 138:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
            case 162: {
                // Reduce Name : RELATIVENAMETK;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName2((Token)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 109.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action109() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 45:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 136:
            case 137:
            case 138:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
            case 162: {
                // Reduce Name : ABSOLUTENAMETK;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName3((Token)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 110.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action110() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 45:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 136:
            case 137:
            case 138:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
            case 162: {
                // Reduce Name : ROOTNAMETK;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName4((Token)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 111.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action111() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : NUMBERTK;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor03((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 112.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action112() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : REALTK;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor04((Token)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 113.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action113() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 71:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce StringToken : STRINGTK;
                doReduce1(token, 12);
                Object o1 = doReduce2();

                AStringToken o = hooks.parseStringToken1((Token)o1);

                reduce = true;
                reduceNonTerminal = 12;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 114.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action114() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : AddExpression;
                doReduce1(token, 100);
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 115.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action115() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 147.
                token = doShift(token, 147);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 129:
            case 133:
            case 134:
            case 135:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce OrExpression : AndExpression;
                doReduce1(token, 98);
                Object o1 = doReduce2();

                AExpression o = hooks.parseOrExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 98;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 116.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action116() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 149.
                token = doShift(token, 149);
                return;
            }

            case 131: {
                // Shift 150.
                token = doShift(token, 150);
                return;
            }

            case 142: {
                // Shift 151.
                token = doShift(token, 151);
                return;
            }

            case 143: {
                // Shift 152.
                token = doShift(token, 152);
                return;
            }

            case 144: {
                // Shift 153.
                token = doShift(token, 153);
                return;
            }

            case 145: {
                // Shift 154.
                token = doShift(token, 154);
                return;
            }

            case 146: {
                // Shift 155.
                token = doShift(token, 155);
                return;
            }

            case 147: {
                // Shift 156.
                token = doShift(token, 156);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 129:
            case 133:
            case 134:
            case 135:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce AndExpression : CompareExpression;
                doReduce1(token, 99);
                Object o1 = doReduce2();

                AExpression o = hooks.parseAndExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 99;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 117.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action117() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 395.
                token = doShift(token, 395);
                return;
            }

            case 133:
            case 134: {
                // Reduce Invariant : Expression;
                doReduce1(token, 53);
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 118.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action118() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce FuncExpression : ExpressionFactor;
                doReduce1(token, 104);
                Object o1 = doReduce2();

                AExpression o = hooks.parseFuncExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 104;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 119.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action119() throws IOException {
        switch (token.id) {
            case 155: {
                // Shift 383.
                token = doShift(token, 383);
                return;
            }

            case 157: {
                // Shift 384.
                token = doShift(token, 384);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce UnaryExpression : FuncExpression;
                doReduce1(token, 103);
                Object o1 = doReduce2();

                AExpression o = hooks.parseUnaryExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 103;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 120.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action120() throws IOException {
        switch (token.id) {
            case 135: {
                // Shift 192.
                token = doShift(token, 192);
                return;
            }

            case 15:
            case 45:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 136:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 155:
            case 157: {
                // Reduce Name : Identifier;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 121.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action121() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariants : Invariant;
                doReduce1(token, 52);
                Object o1 = doReduce2();

                List<AInvariant> o = hooks.parseInvariants1((AInvariant)o1);

                reduce = true;
                reduceNonTerminal = 52;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 122.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action122() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 181.
                token = doShift(token, 181);
                return;
            }

            case 134: {
                // Shift 182.
                token = doShift(token, 182);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 123.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action123() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 161.
                token = doShift(token, 161);
                return;
            }

            case 127: {
                // Shift 162.
                token = doShift(token, 162);
                return;
            }

            case 140: {
                // Shift 163.
                token = doShift(token, 163);
                return;
            }

            case 141: {
                // Shift 164.
                token = doShift(token, 164);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce AddExpression : MulExpression;
                doReduce1(token, 101);
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 101;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 124.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action124() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 137.
                token = doShift(token, 137);
                return;
            }

            case 45: {
                // Shift 179.
                token = doShift(token, 179);
                return;
            }

            case 15:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 155:
            case 157: {
                // Reduce ExpressionFactor : Name;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor17((AName)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 125.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action125() throws IOException {
        switch (token.id) {
            case 45: {
                // Shift 177.
                token = doShift(token, 177);
                return;
            }

            case 15:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 155:
            case 157: {
                // Reduce ExpressionFactor : NonEmptySetExpression;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor10((ASetExpression)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 126.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action126() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 141.
                token = doShift(token, 141);
                return;
            }

            case 150: {
                // Shift 142.
                token = doShift(token, 142);
                return;
            }

            case 151: {
                // Shift 143.
                token = doShift(token, 143);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 133:
            case 134:
            case 135:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce Expression : OrExpression;
                doReduce1(token, 97);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 97;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 127.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action127() throws IOException {
        switch (token.id) {
            case 155: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 128.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action128() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : StringToken;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor05((AStringToken)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 129.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action129() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce MulExpression : UnaryExpression;
                doReduce1(token, 102);
                Object o1 = doReduce2();

                AExpression o = hooks.parseMulExpression1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 102;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 130.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action130() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 156: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 131.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action131() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce FuncExpression : StdLibFunction PAROPENTK PARCLOSETK;
                doReduce1(token, 104);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseFuncExpression6((Token)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 104;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 132.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action132() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 133:
            case 134:
            case 135:
            case 154:
            case 156:
            case 158: {
                // Reduce Expressions : Expression;
                doReduce1(token, 95);
                Object o1 = doReduce2();

                List<AExpression> o = hooks.parseExpressions1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 95;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 133.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action133() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 156: {
                // Shift 139.
                token = doShift(token, 139);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 134.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action134() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 45:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 136:
            case 137:
            case 138:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
            case 162: {
                // Reduce Name : Identifier;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 135.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action135() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 137.
                token = doShift(token, 137);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : Name;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor17((AName)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 136.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action136() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : NonEmptySetExpression;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor10((ASetExpression)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 137.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action137() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce ExpressionFactor : Name APOSTROPHETK;
                doReduce1(token, 105);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor18((AName)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 138.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action138() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 139.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action139() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158: {
                // Reduce FuncExpression : StdLibFunction PAROPENTK Expressions PARCLOSETK;
                doReduce1(token, 104);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseFuncExpression7((Token)o1, (Token)o2, (List<AExpression>)o3);

                reduce = true;
                reduceNonTerminal = 104;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 140.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action140() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 133:
            case 134:
            case 135:
            case 154:
            case 156:
            case 158: {
                // Reduce Expressions : Expressions COMMATK Expression;
                doReduce1(token, 95);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AExpression> o = hooks.parseExpressions2((List<AExpression>)o1, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 95;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 141.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action141() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 142.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action142() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 143.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action143() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 144.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action144() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 141.
                token = doShift(token, 141);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 133:
            case 134:
            case 135:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce Expression : OrExpression EQUIVALENCETK OrExpression;
                doReduce1(token, 97);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpression3((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 97;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 145.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action145() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 141.
                token = doShift(token, 141);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 133:
            case 134:
            case 135:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce Expression : OrExpression IMPLIESTK OrExpression;
                doReduce1(token, 97);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 97;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 146.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action146() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 147.
                token = doShift(token, 147);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 129:
            case 133:
            case 134:
            case 135:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce OrExpression : OrExpression ORKW AndExpression;
                doReduce1(token, 98);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseOrExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 98;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 147.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action147() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 148.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action148() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 149.
                token = doShift(token, 149);
                return;
            }

            case 131: {
                // Shift 150.
                token = doShift(token, 150);
                return;
            }

            case 142: {
                // Shift 151.
                token = doShift(token, 151);
                return;
            }

            case 143: {
                // Shift 152.
                token = doShift(token, 152);
                return;
            }

            case 144: {
                // Shift 153.
                token = doShift(token, 153);
                return;
            }

            case 145: {
                // Shift 154.
                token = doShift(token, 154);
                return;
            }

            case 146: {
                // Shift 155.
                token = doShift(token, 155);
                return;
            }

            case 147: {
                // Shift 156.
                token = doShift(token, 156);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 129:
            case 133:
            case 134:
            case 135:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce AndExpression : AndExpression ANDKW CompareExpression;
                doReduce1(token, 99);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseAndExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 99;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 149.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action149() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 150.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action150() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 151.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action151() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 152.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action152() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 153.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action153() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 154.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action154() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 155.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action155() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 156.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action156() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 157.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action157() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression GTTK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression7((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 158.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action158() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 159.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action159() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 160.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action160() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 161.
                token = doShift(token, 161);
                return;
            }

            case 127: {
                // Shift 162.
                token = doShift(token, 162);
                return;
            }

            case 140: {
                // Shift 163.
                token = doShift(token, 163);
                return;
            }

            case 141: {
                // Shift 164.
                token = doShift(token, 164);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce AddExpression : AddExpression MINUSTK MulExpression;
                doReduce1(token, 101);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddExpression3((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 101;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 161.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action161() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 162.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action162() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 163.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action163() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 164.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action164() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 165.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action165() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce MulExpression : MulExpression SLASHTK UnaryExpression;
                doReduce1(token, 102);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseMulExpression3((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 102;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 166.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action166() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce MulExpression : MulExpression ASTERISKTK UnaryExpression;
                doReduce1(token, 102);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseMulExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 102;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 167.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action167() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce MulExpression : MulExpression MODKW UnaryExpression;
                doReduce1(token, 102);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseMulExpression5((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 102;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 168.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action168() throws IOException {
        switch (token.id) {
            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce MulExpression : MulExpression DIVKW UnaryExpression;
                doReduce1(token, 102);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseMulExpression4((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 102;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 169.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action169() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 161.
                token = doShift(token, 161);
                return;
            }

            case 127: {
                // Shift 162.
                token = doShift(token, 162);
                return;
            }

            case 140: {
                // Shift 163.
                token = doShift(token, 163);
                return;
            }

            case 141: {
                // Shift 164.
                token = doShift(token, 164);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce AddExpression : AddExpression PLUSTK MulExpression;
                doReduce1(token, 101);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 101;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 170.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action170() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression GETK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression6((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 171.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action171() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression NETK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression5((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 172.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action172() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression EQTK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression4((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 173.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action173() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression LETK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression3((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 174.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action174() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression LTTK AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression2((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 175.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action175() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression SUBKW AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression9((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 176.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action176() throws IOException {
        switch (token.id) {
            case 148: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 149: {
                // Shift 159.
                token = doShift(token, 159);
                return;
            }

            case 3:
            case 7:
            case 13:
            case 15:
            case 18:
            case 20:
            case 21:
            case 22:
            case 25:
            case 27:
            case 29:
            case 31:
            case 46:
            case 47:
            case 48:
            case 63:
            case 65:
            case 73:
            case 124:
            case 126:
            case 129:
            case 131:
            case 133:
            case 134:
            case 135:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 150:
            case 151:
            case 152:
            case 154:
            case 156:
            case 158: {
                // Reduce CompareExpression : CompareExpression INKW AddExpression;
                doReduce1(token, 100);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseCompareExpression8((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 100;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 177.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action177() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 178.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action178() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariant : NonEmptySetExpression NEEDSKW Expression;
                doReduce1(token, 53);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant5((ASetExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 179.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action179() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 180.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action180() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariant : Name NEEDSKW Expression;
                doReduce1(token, 53);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant3((AName)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 181.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action181() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 182.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action182() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 19:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 70:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce InvariantDecls : SupKind Invariants SEMICOLTK;
                doReduce1(token, 51);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AInvariantDecl o = hooks.parseInvariantDecls2((Token)o1, (List<AInvariant>)o2);

                reduce = true;
                reduceNonTerminal = 51;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 183.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action183() throws IOException {
        switch (token.id) {
            case 135: {
                // Shift 185.
                token = doShift(token, 185);
                return;
            }

            case 15:
            case 45:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 136:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 155:
            case 157: {
                // Reduce Name : Identifier;
                doReduce1(token, 111);
                Object o1 = doReduce2();

                AName o = hooks.parseName1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 111;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 184.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action184() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariants : Invariants COMMATK Invariant;
                doReduce1(token, 52);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AInvariant> o = hooks.parseInvariants2((List<AInvariant>)o1, (AInvariant)o3);

                reduce = true;
                reduceNonTerminal = 52;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 185.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action185() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 186.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action186() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 190.
                token = doShift(token, 190);
                return;
            }

            case 133:
            case 134: {
                // Reduce Invariant : Identifier COLONTK Expression;
                doReduce1(token, 53);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant2((AIdentifier)o1, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 187.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action187() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 137.
                token = doShift(token, 137);
                return;
            }

            case 45: {
                // Shift 188.
                token = doShift(token, 188);
                return;
            }

            case 15:
            case 124:
            case 125:
            case 126:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134:
            case 140:
            case 141:
            case 142:
            case 143:
            case 144:
            case 145:
            case 146:
            case 147:
            case 148:
            case 149:
            case 150:
            case 151:
            case 155:
            case 157: {
                // Reduce ExpressionFactor : Name;
                doReduce1(token, 105);
                Object o1 = doReduce2();

                AExpression o = hooks.parseExpressionFactor17((AName)o1);

                reduce = true;
                reduceNonTerminal = 105;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 188.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action188() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 189.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action189() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariant : Identifier COLONTK Name NEEDSKW Expression;
                doReduce1(token, 53);
                Object o5 = doReduce2();
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant4((AIdentifier)o1, (AName)o3, (Token)o4, (AExpression)o5);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 190.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action190() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 191.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action191() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Invariant : Identifier COLONTK Expression DISABLESKW Name;
                doReduce1(token, 53);
                Object o5 = doReduce2();
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                AInvariant o = hooks.parseInvariant7((AIdentifier)o1, (AExpression)o3, (Token)o4, (AName)o5);

                reduce = true;
                reduceNonTerminal = 53;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 192.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action192() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce OptAutDecls : ;
                doReduce1(token, 7);
                List<ADecl> o = hooks.parseOptAutDecls1();

                reduce = true;
                reduceNonTerminal = 7;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 193.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action193() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 382.
                token = doShift(token, 382);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 194.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action194() throws IOException {
        switch (token.id) {
            case 0: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 8: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 9: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 11: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 23: {
                // Shift 8.
                token = doShift(token, 8);
                return;
            }

            case 24: {
                // Shift 9.
                token = doShift(token, 9);
                return;
            }

            case 36: {
                // Shift 13.
                token = doShift(token, 13);
                return;
            }

            case 42: {
                // Shift 14.
                token = doShift(token, 14);
                return;
            }

            case 49: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            case 50: {
                // Shift 17.
                token = doShift(token, 17);
                return;
            }

            case 56: {
                // Shift 18.
                token = doShift(token, 18);
                return;
            }

            case 57: {
                // Shift 19.
                token = doShift(token, 19);
                return;
            }

            case 58: {
                // Shift 20.
                token = doShift(token, 20);
                return;
            }

            case 59: {
                // Shift 21.
                token = doShift(token, 21);
                return;
            }

            case 60: {
                // Shift 22.
                token = doShift(token, 22);
                return;
            }

            case 68: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 69: {
                // Shift 24.
                token = doShift(token, 24);
                return;
            }

            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 1: {
                // Shift 195.
                token = doShift(token, 195);
                return;
            }

            case 16: {
                // Shift 196.
                token = doShift(token, 196);
                return;
            }

            case 41: {
                // Shift 197.
                token = doShift(token, 197);
                return;
            }

            case 43: {
                // Shift 198.
                token = doShift(token, 198);
                return;
            }

            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            case 25: {
                // Reduce OptControllability : ;
                doReduce1(token, 66);
                Token o = hooks.parseOptControllability1();

                reduce = true;
                reduceNonTerminal = 66;
                reduceState = doReduce3(o);
                return;
            }

            case 37:
            case 166: {
                // Reduce OptAnnos : ;
                doReduce1(token, 112);
                List<AAnnotation> o = hooks.parseOptAnnos1();

                reduce = true;
                reduceNonTerminal = 112;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 195.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action195() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 134: {
                // Shift 379.
                token = doShift(token, 379);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 196.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action196() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 197.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action197() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 134: {
                // Shift 217.
                token = doShift(token, 217);
                return;
            }

            case 135: {
                // Shift 218.
                token = doShift(token, 218);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 198.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action198() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 134: {
                // Shift 211.
                token = doShift(token, 211);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 199.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action199() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce OptAutDecls : OptAutDecls AutDecl;
                doReduce1(token, 7);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<ADecl> o = hooks.parseOptAutDecls2((List<ADecl>)o1, (ADecl)o2);

                reduce = true;
                reduceNonTerminal = 7;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 200.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action200() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce AutDecl : Decl;
                doReduce1(token, 8);
                Object o1 = doReduce2();

                ADecl o = hooks.parseAutDecl1((ADecl)o1);

                reduce = true;
                reduceNonTerminal = 8;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 201.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action201() throws IOException {
        switch (token.id) {
            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Locations : Location;
                doReduce1(token, 32);
                Object o1 = doReduce2();

                List<ALocation> o = hooks.parseLocations1((ALocation)o1);

                reduce = true;
                reduceNonTerminal = 32;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 202.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action202() throws IOException {
        switch (token.id) {
            case 41: {
                // Shift 197.
                token = doShift(token, 197);
                return;
            }

            case 22:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce OptIoDecls : ;
                doReduce1(token, 68);
                List<AIoDecl> o = hooks.parseOptIoDecls1();

                reduce = true;
                reduceNonTerminal = 68;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 203.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action203() throws IOException {
        switch (token.id) {
            case 39: {
                // Shift 205.
                token = doShift(token, 205);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 204.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action204() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 39: {
                // Reduce OptSupKind : SupKind;
                doReduce1(token, 65);
                Object o1 = doReduce2();

                Token o = hooks.parseOptSupKind2((Token)o1);

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 205.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action205() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 206.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action206() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 181.
                token = doShift(token, 181);
                return;
            }

            case 134: {
                // Shift 207.
                token = doShift(token, 207);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 207.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action207() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 4:
            case 8:
            case 9:
            case 11:
            case 16:
            case 19:
            case 22:
            case 23:
            case 24:
            case 25:
            case 30:
            case 32:
            case 35:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 44:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 70:
            case 75:
            case 76:
            case 77:
            case 162:
            case 166:
            case 170: {
                // Reduce InvariantDecls : OptSupKind INVARIANTKW Invariants SEMICOLTK;
                doReduce1(token, 51);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AInvariantDecl o = hooks.parseInvariantDecls1((Token)o1, (Token)o2, (List<AInvariant>)o3);

                reduce = true;
                reduceNonTerminal = 51;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 208.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action208() throws IOException {
        switch (token.id) {
            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Locations : Locations Location;
                doReduce1(token, 32);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<ALocation> o = hooks.parseLocations2((List<ALocation>)o1, (ALocation)o2);

                reduce = true;
                reduceNonTerminal = 32;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 209.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action209() throws IOException {
        switch (token.id) {
            case 49: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            case 50: {
                // Shift 17.
                token = doShift(token, 17);
                return;
            }

            case 56: {
                // Shift 18.
                token = doShift(token, 18);
                return;
            }

            case 57: {
                // Shift 19.
                token = doShift(token, 19);
                return;
            }

            case 58: {
                // Shift 20.
                token = doShift(token, 20);
                return;
            }

            case 59: {
                // Shift 21.
                token = doShift(token, 21);
                return;
            }

            case 60: {
                // Shift 22.
                token = doShift(token, 22);
                return;
            }

            case 22: {
                // Reduce AutomatonBody : OptAutDecls Locations OptIoDecls;
                doReduce1(token, 4);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AAutomatonBody o = hooks.parseAutomatonBody1((List<ADecl>)o1, (List<ALocation>)o2, (List<AIoDecl>)o3);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 210.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action210() throws IOException {
        switch (token.id) {
            case 22:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce OptIoDecls : OptIoDecls IoDecl;
                doReduce1(token, 68);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<AIoDecl> o = hooks.parseOptIoDecls2((List<AIoDecl>)o1, (AIoDecl)o2);

                reduce = true;
                reduceNonTerminal = 68;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 211.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action211() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce AutDecl : MONITORKW SEMICOLTK;
                doReduce1(token, 8);
                doReduce2();
                Object o1 = doReduce2();

                ADecl o = hooks.parseAutDecl5((Token)o1);

                reduce = true;
                reduceNonTerminal = 8;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 212.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action212() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 214.
                token = doShift(token, 214);
                return;
            }

            case 134: {
                // Shift 215.
                token = doShift(token, 215);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 213.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action213() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Events : Name;
                doReduce1(token, 25);
                Object o1 = doReduce2();

                List<AName> o = hooks.parseEvents1((AName)o1);

                reduce = true;
                reduceNonTerminal = 25;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 214.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action214() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 215.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action215() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce AutDecl : MONITORKW Events SEMICOLTK;
                doReduce1(token, 8);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ADecl o = hooks.parseAutDecl4((Token)o1, (List<AName>)o2);

                reduce = true;
                reduceNonTerminal = 8;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 216.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action216() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Events : Events COMMATK Name;
                doReduce1(token, 25);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AName> o = hooks.parseEvents2((List<AName>)o1, (AName)o3);

                reduce = true;
                reduceNonTerminal = 25;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 217.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action217() throws IOException {
        switch (token.id) {
            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Location : LOCATIONKW SEMICOLTK;
                doReduce1(token, 33);
                doReduce2();
                Object o1 = doReduce2();

                ALocation o = hooks.parseLocation1((Token)o1);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 218.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action218() throws IOException {
        switch (token.id) {
            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 19: {
                // Shift 222.
                token = doShift(token, 222);
                return;
            }

            case 24: {
                // Shift 223.
                token = doShift(token, 223);
                return;
            }

            case 36: {
                // Shift 224.
                token = doShift(token, 224);
                return;
            }

            case 42: {
                // Shift 225.
                token = doShift(token, 225);
                return;
            }

            case 70: {
                // Shift 226.
                token = doShift(token, 226);
                return;
            }

            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 219.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action219() throws IOException {
        switch (token.id) {
            case 134: {
                // Shift 220.
                token = doShift(token, 220);
                return;
            }

            case 135: {
                // Shift 221.
                token = doShift(token, 221);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 220.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action220() throws IOException {
        switch (token.id) {
            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Location : LOCATIONKW Identifier SEMICOLTK;
                doReduce1(token, 33);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocation o = hooks.parseLocation2((Token)o1, (AIdentifier)o2);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 221.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action221() throws IOException {
        switch (token.id) {
            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 19: {
                // Shift 222.
                token = doShift(token, 222);
                return;
            }

            case 24: {
                // Shift 223.
                token = doShift(token, 223);
                return;
            }

            case 36: {
                // Shift 224.
                token = doShift(token, 224);
                return;
            }

            case 42: {
                // Shift 225.
                token = doShift(token, 225);
                return;
            }

            case 70: {
                // Shift 226.
                token = doShift(token, 226);
                return;
            }

            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 222.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action222() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 18: {
                // Shift 249.
                token = doShift(token, 249);
                return;
            }

            case 46: {
                // Shift 250.
                token = doShift(token, 250);
                return;
            }

            case 62: {
                // Shift 251.
                token = doShift(token, 251);
                return;
            }

            case 73: {
                // Shift 252.
                token = doShift(token, 252);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 223.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action223() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 224.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action224() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 134: {
                // Shift 235.
                token = doShift(token, 235);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 225.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action225() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 134: {
                // Shift 232.
                token = doShift(token, 232);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 226.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action226() throws IOException {
        switch (token.id) {
            case 134: {
                // Shift 231.
                token = doShift(token, 231);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 227.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action227() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : InvariantDecls;
                doReduce1(token, 35);
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement3((AInvariantDecl)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 228.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action228() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElements : LocationElement;
                doReduce1(token, 34);
                Object o1 = doReduce2();

                List<ALocationElement> o = hooks.parseLocationElements1((ALocationElement)o1);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 229.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action229() throws IOException {
        switch (token.id) {
            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 19: {
                // Shift 222.
                token = doShift(token, 222);
                return;
            }

            case 24: {
                // Shift 223.
                token = doShift(token, 223);
                return;
            }

            case 36: {
                // Shift 224.
                token = doShift(token, 224);
                return;
            }

            case 42: {
                // Shift 225.
                token = doShift(token, 225);
                return;
            }

            case 70: {
                // Shift 226.
                token = doShift(token, 226);
                return;
            }

            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Location : LOCATIONKW Identifier COLONTK LocationElements;
                doReduce1(token, 33);
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocation o = hooks.parseLocation4((Token)o1, (AIdentifier)o2, (List<ALocationElement>)o4);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 230.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action230() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElements : LocationElements LocationElement;
                doReduce1(token, 34);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<ALocationElement> o = hooks.parseLocationElements2((List<ALocationElement>)o1, (ALocationElement)o2);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 231.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action231() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : URGENTKW SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement7((Token)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 232.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action232() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : MARKEDKW SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement5((Token)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 233.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action233() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 134: {
                // Shift 234.
                token = doShift(token, 234);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 234.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action234() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : MARKEDKW Expressions SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement6((Token)o1, (List<AExpression>)o2);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 235.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action235() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : INITIALKW SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement1((Token)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 236.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action236() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 134: {
                // Shift 237.
                token = doShift(token, 237);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 237.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action237() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : INITIALKW Expressions SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement2((Token)o1, (List<AExpression>)o2);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 238.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action238() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Equations : Equation;
                doReduce1(token, 49);
                Object o1 = doReduce2();

                List<AEquation> o = hooks.parseEquations1((AEquation)o1);

                reduce = true;
                reduceNonTerminal = 49;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 239.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action239() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 246.
                token = doShift(token, 246);
                return;
            }

            case 134: {
                // Shift 247.
                token = doShift(token, 247);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 240.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action240() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 241.
                token = doShift(token, 241);
                return;
            }

            case 144: {
                // Shift 242.
                token = doShift(token, 242);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 241.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action241() throws IOException {
        switch (token.id) {
            case 144: {
                // Shift 244.
                token = doShift(token, 244);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 242.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action242() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 243.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action243() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Equation : Identifier EQTK Expression;
                doReduce1(token, 50);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AEquation o = hooks.parseEquation2((AIdentifier)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 50;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 244.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action244() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 245.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action245() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Equation : Identifier APOSTROPHETK EQTK Expression;
                doReduce1(token, 50);
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                AEquation o = hooks.parseEquation1((AIdentifier)o1, (Token)o3, (AExpression)o4);

                reduce = true;
                reduceNonTerminal = 50;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 246.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action246() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 247.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action247() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : EQUATIONKW Equations SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement4((Token)o1, (List<AEquation>)o2);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 248.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action248() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce Equations : Equations COMMATK Equation;
                doReduce1(token, 49);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AEquation> o = hooks.parseEquations2((List<AEquation>)o1, (AEquation)o3);

                reduce = true;
                reduceNonTerminal = 49;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 249.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action249() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 250.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action250() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 265.
                token = doShift(token, 265);
                return;
            }

            case 31:
            case 134: {
                // Reduce OptEdgeUpdate : ;
                doReduce1(token, 29);
                List<AUpdate> o = hooks.parseOptEdgeUpdate1();

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 251.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action251() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvent : TAUKW;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                AEdgeEvent o = hooks.parseEdgeEvent1((Token)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 252.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action252() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 253.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action253() throws IOException {
        switch (token.id) {
            case 31: {
                // Shift 304.
                token = doShift(token, 304);
                return;
            }

            case 134: {
                // Shift 305.
                token = doShift(token, 305);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 254.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action254() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvents : EdgeEvent;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                List<AEdgeEvent> o = hooks.parseEdgeEvents1((AEdgeEvent)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 255.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action255() throws IOException {
        switch (token.id) {
            case 73: {
                // Shift 260.
                token = doShift(token, 260);
                return;
            }

            case 133: {
                // Shift 261.
                token = doShift(token, 261);
                return;
            }

            case 18:
            case 31:
            case 46:
            case 134: {
                // Reduce OptEdgeGuard : ;
                doReduce1(token, 27);
                List<AExpression> o = hooks.parseOptEdgeGuard1();

                reduce = true;
                reduceNonTerminal = 27;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 256.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action256() throws IOException {
        switch (token.id) {
            case 137: {
                // Shift 257.
                token = doShift(token, 257);
                return;
            }

            case 138: {
                // Shift 258.
                token = doShift(token, 258);
                return;
            }

            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvent : Name;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                AEdgeEvent o = hooks.parseEdgeEvent2((AName)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 257.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action257() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvent : Name EXCLAMATIONTK;
                doReduce1(token, 31);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AEdgeEvent o = hooks.parseEdgeEvent3((AName)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 258.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action258() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvent : Name QUESTIONTK;
                doReduce1(token, 31);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AEdgeEvent o = hooks.parseEdgeEvent5((AName)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 259.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action259() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvent : Name EXCLAMATIONTK Expression;
                doReduce1(token, 31);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AEdgeEvent o = hooks.parseEdgeEvent4((AName)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 260.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action260() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 261.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action261() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 62: {
                // Shift 251.
                token = doShift(token, 251);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 262.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action262() throws IOException {
        switch (token.id) {
            case 46: {
                // Shift 263.
                token = doShift(token, 263);
                return;
            }

            case 18:
            case 31:
            case 134: {
                // Reduce OptEdgeUrgent : ;
                doReduce1(token, 28);
                TextPosition o = hooks.parseOptEdgeUrgent1();

                reduce = true;
                reduceNonTerminal = 28;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 263.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action263() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 134: {
                // Reduce OptEdgeUrgent : NOWKW;
                doReduce1(token, 28);
                Object o1 = doReduce2();

                TextPosition o = hooks.parseOptEdgeUrgent2((Token)o1);

                reduce = true;
                reduceNonTerminal = 28;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 264.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action264() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 265.
                token = doShift(token, 265);
                return;
            }

            case 31:
            case 134: {
                // Reduce OptEdgeUpdate : ;
                doReduce1(token, 29);
                List<AUpdate> o = hooks.parseOptEdgeUpdate1();

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 265.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action265() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 266.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action266() throws IOException {
        switch (token.id) {
            case 31:
            case 134: {
                // Reduce CoreEdge : EdgeEvents OptEdgeGuard OptEdgeUrgent OptEdgeUpdate;
                doReduce1(token, 26);
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ACoreEdge o = hooks.parseCoreEdge1((List<AEdgeEvent>)o1, (List<AExpression>)o2, (TextPosition)o3, (List<AUpdate>)o4);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 267.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action267() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 268.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action268() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 269.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action269() throws IOException {
        switch (token.id) {
            case 132: {
                // Shift 281.
                token = doShift(token, 281);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 270.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action270() throws IOException {
        switch (token.id) {
            case 157: {
                // Shift 275.
                token = doShift(token, 275);
                return;
            }

            case 132:
            case 133:
            case 156: {
                // Reduce Addressable : Identifier;
                doReduce1(token, 59);
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddressable1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 59;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 271.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action271() throws IOException {
        switch (token.id) {
            case 20:
            case 21:
            case 22:
            case 31:
            case 133:
            case 134: {
                // Reduce Updates : Update;
                doReduce1(token, 56);
                Object o1 = doReduce2();

                List<AUpdate> o = hooks.parseUpdates1((AUpdate)o1);

                reduce = true;
                reduceNonTerminal = 56;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 272.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action272() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            case 31:
            case 134: {
                // Reduce OptEdgeUpdate : DOKW Updates;
                doReduce1(token, 29);
                Object o2 = doReduce2();
                doReduce2();

                List<AUpdate> o = hooks.parseOptEdgeUpdate2((List<AUpdate>)o2);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 273.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action273() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 274.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action274() throws IOException {
        switch (token.id) {
            case 20:
            case 21:
            case 22:
            case 31:
            case 133:
            case 134: {
                // Reduce Updates : Updates COMMATK Update;
                doReduce1(token, 56);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AUpdate> o = hooks.parseUpdates2((List<AUpdate>)o1, (AUpdate)o3);

                reduce = true;
                reduceNonTerminal = 56;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 275.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action275() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 276.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action276() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156:
            case 157: {
                // Reduce Projections : Projection;
                doReduce1(token, 60);
                Object o1 = doReduce2();

                List<AProjectionExpression> o = hooks.parseProjections1((AProjectionExpression)o1);

                reduce = true;
                reduceNonTerminal = 60;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 277.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action277() throws IOException {
        switch (token.id) {
            case 157: {
                // Shift 275.
                token = doShift(token, 275);
                return;
            }

            case 132:
            case 133:
            case 156: {
                // Reduce Addressable : Identifier Projections;
                doReduce1(token, 59);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddressable2((AIdentifier)o1, (List<AProjectionExpression>)o2);

                reduce = true;
                reduceNonTerminal = 59;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 278.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action278() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156:
            case 157: {
                // Reduce Projections : Projections Projection;
                doReduce1(token, 60);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<AProjectionExpression> o = hooks.parseProjections2((List<AProjectionExpression>)o1, (AProjectionExpression)o2);

                reduce = true;
                reduceNonTerminal = 60;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 279.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action279() throws IOException {
        switch (token.id) {
            case 158: {
                // Shift 280.
                token = doShift(token, 280);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 280.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action280() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156:
            case 157: {
                // Reduce Projection : SQOPENTK Expression SQCLOSETK;
                doReduce1(token, 61);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AProjectionExpression o = hooks.parseProjection1((Token)o1, (AExpression)o2);

                reduce = true;
                reduceNonTerminal = 61;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 281.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action281() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 282.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action282() throws IOException {
        switch (token.id) {
            case 20:
            case 21:
            case 22:
            case 31:
            case 133:
            case 134: {
                // Reduce Update : Addressable BECOMESTK Expression;
                doReduce1(token, 57);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AUpdate o = hooks.parseUpdate1((AExpression)o1, (Token)o2, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 57;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 283.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action283() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 284.
                token = doShift(token, 284);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 284.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action284() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 285.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action285() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156: {
                // Reduce Addressables : Addressable;
                doReduce1(token, 58);
                Object o1 = doReduce2();

                List<AExpression> o = hooks.parseAddressables1((AExpression)o1);

                reduce = true;
                reduceNonTerminal = 58;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 286.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action286() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 287.
                token = doShift(token, 287);
                return;
            }

            case 156: {
                // Shift 288.
                token = doShift(token, 288);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 287.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action287() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 288.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action288() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156: {
                // Reduce Addressable : PAROPENTK Addressable COMMATK Addressables PARCLOSETK;
                doReduce1(token, 59);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AExpression o = hooks.parseAddressable3((Token)o1, (AExpression)o2, (List<AExpression>)o4);

                reduce = true;
                reduceNonTerminal = 59;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 289.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action289() throws IOException {
        switch (token.id) {
            case 132:
            case 133:
            case 156: {
                // Reduce Addressables : Addressables COMMATK Addressable;
                doReduce1(token, 58);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AExpression> o = hooks.parseAddressables2((List<AExpression>)o1, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 58;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 290.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action290() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 135: {
                // Shift 291.
                token = doShift(token, 291);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 291.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action291() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 292.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action292() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            case 20:
            case 21:
            case 22: {
                // Reduce OptElifUpdates : ;
                doReduce1(token, 62);
                List<AElifUpdate> o = hooks.parseOptElifUpdates1();

                reduce = true;
                reduceNonTerminal = 62;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 293.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action293() throws IOException {
        switch (token.id) {
            case 20: {
                // Shift 294.
                token = doShift(token, 294);
                return;
            }

            case 21: {
                // Shift 295.
                token = doShift(token, 295);
                return;
            }

            case 22: {
                // Reduce OptElseUpdate : ;
                doReduce1(token, 63);
                List<AUpdate> o = hooks.parseOptElseUpdate1();

                reduce = true;
                reduceNonTerminal = 63;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 294.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action294() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 295.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action295() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 296.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action296() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 297.
                token = doShift(token, 297);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 297.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action297() throws IOException {
        switch (token.id) {
            case 20:
            case 21:
            case 22:
            case 31:
            case 133:
            case 134: {
                // Reduce Update : IFKW Expressions COLONTK Updates OptElifUpdates OptElseUpdate ENDKW;
                doReduce1(token, 57);
                doReduce2();
                Object o6 = doReduce2();
                Object o5 = doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AUpdate o = hooks.parseUpdate2((Token)o1, (List<AExpression>)o2, (List<AUpdate>)o4, (List<AElifUpdate>)o5, (List<AUpdate>)o6);

                reduce = true;
                reduceNonTerminal = 57;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 298.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action298() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            case 22: {
                // Reduce OptElseUpdate : ELSEKW Updates;
                doReduce1(token, 63);
                Object o2 = doReduce2();
                doReduce2();

                List<AUpdate> o = hooks.parseOptElseUpdate2((List<AUpdate>)o2);

                reduce = true;
                reduceNonTerminal = 63;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 299.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action299() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 135: {
                // Shift 300.
                token = doShift(token, 300);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 300.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action300() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 34: {
                // Shift 267.
                token = doShift(token, 267);
                return;
            }

            case 155: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 301.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action301() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            case 20:
            case 21:
            case 22: {
                // Reduce OptElifUpdates : OptElifUpdates ELIFKW Expressions COLONTK Updates;
                doReduce1(token, 62);
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<AElifUpdate> o = hooks.parseOptElifUpdates2((List<AElifUpdate>)o1, (Token)o2, (List<AExpression>)o3, (List<AUpdate>)o5);

                reduce = true;
                reduceNonTerminal = 62;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 302.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action302() throws IOException {
        switch (token.id) {
            case 18:
            case 31:
            case 46:
            case 73:
            case 133:
            case 134: {
                // Reduce EdgeEvents : EdgeEvents COMMATK EdgeEvent;
                doReduce1(token, 30);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AEdgeEvent> o = hooks.parseEdgeEvents2((List<AEdgeEvent>)o1, (AEdgeEvent)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 303.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action303() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 18:
            case 31:
            case 46:
            case 134: {
                // Reduce OptEdgeGuard : WHENKW Expressions;
                doReduce1(token, 27);
                Object o2 = doReduce2();
                doReduce2();

                List<AExpression> o = hooks.parseOptEdgeGuard2((List<AExpression>)o2);

                reduce = true;
                reduceNonTerminal = 27;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 304.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action304() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 305.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action305() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : EDGEKW CoreEdge SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement8((Token)o1, (ACoreEdge)o2);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 306.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action306() throws IOException {
        switch (token.id) {
            case 134: {
                // Shift 307.
                token = doShift(token, 307);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 307.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action307() throws IOException {
        switch (token.id) {
            case 19:
            case 22:
            case 24:
            case 36:
            case 39:
            case 41:
            case 42:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 70:
            case 75:
            case 76:
            case 77: {
                // Reduce LocationElement : EDGEKW CoreEdge GOTOKW Identifier SEMICOLTK;
                doReduce1(token, 35);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ALocationElement o = hooks.parseLocationElement9((Token)o1, (ACoreEdge)o2, (AIdentifier)o4);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 308.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action308() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 46: {
                // Shift 263.
                token = doShift(token, 263);
                return;
            }

            case 18:
            case 31:
            case 134: {
                // Reduce OptEdgeUrgent : ;
                doReduce1(token, 28);
                TextPosition o = hooks.parseOptEdgeUrgent1();

                reduce = true;
                reduceNonTerminal = 28;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 309.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action309() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 265.
                token = doShift(token, 265);
                return;
            }

            case 31:
            case 134: {
                // Reduce OptEdgeUpdate : ;
                doReduce1(token, 29);
                List<AUpdate> o = hooks.parseOptEdgeUpdate1();

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 310.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action310() throws IOException {
        switch (token.id) {
            case 31:
            case 134: {
                // Reduce CoreEdge : WHENKW Expressions OptEdgeUrgent OptEdgeUpdate;
                doReduce1(token, 26);
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                ACoreEdge o = hooks.parseCoreEdge2((List<AExpression>)o2, (TextPosition)o3, (List<AUpdate>)o4);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 311.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action311() throws IOException {
        switch (token.id) {
            case 31:
            case 134: {
                // Reduce CoreEdge : NOWKW OptEdgeUpdate;
                doReduce1(token, 26);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ACoreEdge o = hooks.parseCoreEdge3((Token)o1, (List<AUpdate>)o2);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 312.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action312() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            case 31:
            case 134: {
                // Reduce CoreEdge : DOKW Updates;
                doReduce1(token, 26);
                Object o2 = doReduce2();
                doReduce2();

                ACoreEdge o = hooks.parseCoreEdge4((List<AUpdate>)o2);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 313.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action313() throws IOException {
        switch (token.id) {
            case 75: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            case 76: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 77: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 19: {
                // Shift 222.
                token = doShift(token, 222);
                return;
            }

            case 24: {
                // Shift 223.
                token = doShift(token, 223);
                return;
            }

            case 36: {
                // Shift 224.
                token = doShift(token, 224);
                return;
            }

            case 42: {
                // Shift 225.
                token = doShift(token, 225);
                return;
            }

            case 70: {
                // Shift 226.
                token = doShift(token, 226);
                return;
            }

            case 22:
            case 41:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60: {
                // Reduce Location : LOCATIONKW COLONTK LocationElements;
                doReduce1(token, 33);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ALocation o = hooks.parseLocation3((Token)o1, (List<ALocationElement>)o3);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            case 39: {
                // Reduce OptSupKind : ;
                doReduce1(token, 65);
                Token o = hooks.parseOptSupKind1();

                reduce = true;
                reduceNonTerminal = 65;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 314.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action314() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : BOOLKW;
                doReduce1(token, 92);
                Object o1 = doReduce2();

                ACifType o = hooks.parseType01((Token)o1);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 315.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action315() throws IOException {
        switch (token.id) {
            case 155: {
                // Shift 374.
                token = doShift(token, 374);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 316.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action316() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 317.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action317() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 318.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action318() throws IOException {
        switch (token.id) {
            case 157: {
                // Shift 360.
                token = doShift(token, 360);
                return;
            }

            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : INTKW;
                doReduce1(token, 92);
                Object o1 = doReduce2();

                ACifType o = hooks.parseType02((Token)o1);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 319.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action319() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            case 157: {
                // Shift 351.
                token = doShift(token, 351);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 320.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action320() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : REALKW;
                doReduce1(token, 92);
                Object o1 = doReduce2();

                ACifType o = hooks.parseType04((Token)o1);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 321.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action321() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 322.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action322() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : STRINGKW;
                doReduce1(token, 92);
                Object o1 = doReduce2();

                ACifType o = hooks.parseType05((Token)o1);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 323.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action323() throws IOException {
        switch (token.id) {
            case 155: {
                // Shift 339.
                token = doShift(token, 339);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 324.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action324() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : Name;
                doReduce1(token, 92);
                Object o1 = doReduce2();

                ACifType o = hooks.parseType15((AName)o1);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 325.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action325() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 326.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action326() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce DiscDecls : DiscDecl;
                doReduce1(token, 44);
                Object o1 = doReduce2();

                List<ADiscVariable> o = hooks.parseDiscDecls1((ADiscVariable)o1);

                reduce = true;
                reduceNonTerminal = 44;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 327.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action327() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 336.
                token = doShift(token, 336);
                return;
            }

            case 134: {
                // Shift 337.
                token = doShift(token, 337);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 328.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action328() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 329.
                token = doShift(token, 329);
                return;
            }

            case 144: {
                // Shift 330.
                token = doShift(token, 330);
                return;
            }

            case 133:
            case 134: {
                // Reduce DiscDecl : Identifier;
                doReduce1(token, 45);
                Object o1 = doReduce2();

                ADiscVariable o = hooks.parseDiscDecl1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 329.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action329() throws IOException {
        switch (token.id) {
            case 2: {
                // Shift 332.
                token = doShift(token, 332);
                return;
            }

            case 153: {
                // Shift 333.
                token = doShift(token, 333);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 330.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action330() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 331.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action331() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce DiscDecl : Identifier EQTK Expression;
                doReduce1(token, 45);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ADiscVariable o = hooks.parseDiscDecl3((AIdentifier)o1, (AExpression)o3);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 332.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action332() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce DiscDecl : Identifier INKW ANYKW;
                doReduce1(token, 45);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ADiscVariable o = hooks.parseDiscDecl2((AIdentifier)o1, (Token)o3);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 333.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action333() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 118: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 119: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 120: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 121: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 122: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 123: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 128: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 130: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 138: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 142: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 148: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 149: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 153: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 155: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 157: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 163: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 164: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 165: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 334.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action334() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 138.
                token = doShift(token, 138);
                return;
            }

            case 154: {
                // Shift 335.
                token = doShift(token, 335);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 335.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action335() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce DiscDecl : Identifier INKW CUROPENTK Expressions CURCLOSETK;
                doReduce1(token, 45);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ADiscVariable o = hooks.parseDiscDecl4((AIdentifier)o1, (List<AExpression>)o4);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 336.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action336() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 337.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action337() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 8:
            case 9:
            case 11:
            case 16:
            case 23:
            case 24:
            case 25:
            case 36:
            case 37:
            case 39:
            case 41:
            case 42:
            case 43:
            case 49:
            case 50:
            case 56:
            case 57:
            case 58:
            case 59:
            case 60:
            case 68:
            case 69:
            case 75:
            case 76:
            case 77:
            case 166: {
                // Reduce AutDecl : DISCKW Type DiscDecls SEMICOLTK;
                doReduce1(token, 8);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ADecl o = hooks.parseAutDecl6((Token)o1, (ACifType)o2, (List<ADiscVariable>)o3);

                reduce = true;
                reduceNonTerminal = 8;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 338.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action338() throws IOException {
        switch (token.id) {
            case 133:
            case 134: {
                // Reduce DiscDecls : DiscDecls COMMATK DiscDecl;
                doReduce1(token, 44);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<ADiscVariable> o = hooks.parseDiscDecls2((List<ADiscVariable>)o1, (ADiscVariable)o3);

                reduce = true;
                reduceNonTerminal = 44;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 339.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action339() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 340.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action340() throws IOException {
        switch (token.id) {
            case 134:
            case 156: {
                // Reduce Fields : Field;
                doReduce1(token, 93);
                Object o1 = doReduce2();

                List<AField> o = hooks.parseFields1((AField)o1);

                reduce = true;
                reduceNonTerminal = 93;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 341.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action341() throws IOException {
        switch (token.id) {
            case 134: {
                // Shift 347.
                token = doShift(token, 347);
                return;
            }

            case 156: {
                // Shift 348.
                token = doShift(token, 348);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 342.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action342() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 343.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action343() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 156: {
                // Reduce Identifiers : Identifier;
                doReduce1(token, 64);
                Object o1 = doReduce2();

                List<AIdentifier> o = hooks.parseIdentifiers1((AIdentifier)o1);

                reduce = true;
                reduceNonTerminal = 64;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 344.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action344() throws IOException {
        switch (token.id) {
            case 133: {
                // Shift 345.
                token = doShift(token, 345);
                return;
            }

            case 134:
            case 156: {
                // Reduce Field : Type Identifiers;
                doReduce1(token, 94);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                AField o = hooks.parseField1((ACifType)o1, (List<AIdentifier>)o2);

                reduce = true;
                reduceNonTerminal = 94;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 345.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action345() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 346.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action346() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 156: {
                // Reduce Identifiers : Identifiers COMMATK Identifier;
                doReduce1(token, 64);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AIdentifier> o = hooks.parseIdentifiers2((List<AIdentifier>)o1, (AIdentifier)o3);

                reduce = true;
                reduceNonTerminal = 64;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 347.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action347() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 159: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 160: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 161: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 5: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            case 14: {
                // Shift 315.
                token = doShift(token, 315);
                return;
            }

            case 17: {
                // Shift 316.
                token = doShift(token, 316);
                return;
            }

            case 30: {
                // Shift 317.
                token = doShift(token, 317);
                return;
            }

            case 38: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 40: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            case 51: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            case 54: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 55: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 67: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 348.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action348() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : TUPLEKW PAROPENTK Fields PARCLOSETK;
                doReduce1(token, 92);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ACifType o = hooks.parseType11((Token)o1, (List<AField>)o3);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 349.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action349() throws IOException {
        switch (token.id) {
            case 134:
            case 156: {
                // Reduce Fields : Fields SEMICOLTK Field;
                doReduce1(token, 93);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<AField> o = hooks.parseFields2((List<AField>)o1, (AField)o3);

                reduce = true;
                reduceNonTerminal = 93;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 350.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action350() throws IOException {
        switch (token.id) {
            case 133:
            case 134:
            case 135:
            case 147:
            case 155:
            case 156:
            case 162: {
                // Reduce Type : SETKW Type;
                doReduce1(token, 92);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ACifType o = hooks.parseType09((Token)o1, (ACifType)o2);

                reduce = true;
                reduceNonTerminal = 92;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 351.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action351() throws IOException {
        switch (token.id) {
            case 162: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 26: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 34: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 53: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            case 61: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            case 64: {
                // Shift 51.
                token = doShift(token, 51);
                return;
            }

            case 66: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 78: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 79: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 80: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            case 81: {
                // Shift 56.
                token = doShift(token, 56);
                return;
            }

            case 82: {
                // Shift 57.
                token = doShift(token, 57);
                return;
            }

            case 83: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            case 84: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 85: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 86: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 87: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 88: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 89: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 90: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 91: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 92: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 93: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 94: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 95: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 96: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 97: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 98: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 99: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 100: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 101: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 102: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 103: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 104: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 105: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 106: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 107: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 108: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 109: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 110: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 111: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 112: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 113: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 114: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 115: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 116: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 117: 