/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.WarnOutput;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.options.ConvertEnumsOption;
import org.eclipse.escet.cif.plcgen.options.PlcConfigurationNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcFormalFuncInvokeArgOption;
import org.eclipse.escet.cif.plcgen.options.PlcFormalFuncInvokeFuncOption;
import org.eclipse.escet.cif.plcgen.options.PlcIntTypeSizeOption;
import org.eclipse.escet.cif.plcgen.options.PlcMaxIterOption;
import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.cif.plcgen.options.PlcProjectNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcRealTypeSizeOption;
import org.eclipse.escet.cif.plcgen.options.PlcResourceNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcTargetTypeOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskCycleTimeOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskPriorityOption;
import org.eclipse.escet.cif.plcgen.options.RenameWarningsOption;
import org.eclipse.escet.cif.plcgen.options.SimplifyValuesOption;
import org.eclipse.escet.cif.plcgen.targets.AbbTarget;
import org.eclipse.escet.cif.plcgen.targets.Iec611313Target;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcOpenXmlTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.targets.SiemensS7Target;
import org.eclipse.escet.cif.plcgen.targets.TwinCatTarget;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;

public class CifPlcGenApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifPlcGenApp app = new CifPlcGenApp();
        app.run(args);
    }

    public CifPlcGenApp() {
    }

    public CifPlcGenApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF PLC code generator";
    }

    public String getAppDescription() {
        return "Generates PLC code from a suitable CIF specification.";
    }

    protected int runInternal() {
        PlcTargetType targetType = PlcTargetTypeOption.getPlcTargetType();
        PlcBaseTarget target = switch (targetType) {
            case PlcTargetType.ABB -> new AbbTarget();
            case PlcTargetType.IEC_61131_3 -> new Iec611313Target();
            case PlcTargetType.PLC_OPEN_XML -> new PlcOpenXmlTarget();
            case PlcTargetType.S7_1500, PlcTargetType.S7_1200, PlcTargetType.S7_400, PlcTargetType.S7_300 -> new SiemensS7Target(targetType);
            case PlcTargetType.TWINCAT -> new TwinCatTarget();
            default -> throw new RuntimeException("Unknown target type: " + (Object)((Object)targetType));
        };
        PlcGenSettings settings = this.makePlcGenSettings(target);
        target.generate(settings);
        return 0;
    }

    private PlcGenSettings makePlcGenSettings(PlcTarget target) {
        String projectName = PlcProjectNameOption.getProjName();
        String configurationName = PlcConfigurationNameOption.getCfgName();
        String resourceName = PlcResourceNameOption.getResName();
        String plcTaskName = PlcTaskNameOption.getTaskName();
        int taskCyceTime = PlcTaskCycleTimeOption.getTaskCycleTime();
        int priority = PlcTaskPriorityOption.getTaskPrio();
        String inputPath = InputFileOption.getPath();
        String outputPath = Paths.resolve((String)OutputFileOption.getDerivedPath((String)".cif", (String)target.getPathSuffixReplacement()));
        PlcNumberBits intSize = PlcIntTypeSizeOption.getNumberBits();
        PlcNumberBits realSize = PlcRealTypeSizeOption.getNumberBits();
        boolean simplifyValues = SimplifyValuesOption.simplifyValues();
        ConvertEnums enumConversion = ConvertEnumsOption.getValue();
        Supplier<Boolean> shouldTerminate = () -> AppEnv.isTerminationRequested();
        boolean warnOnRename = RenameWarningsOption.isEnabled();
        WarnOutput warnOutput = message -> OutputProvider.warn((String)message);
        return new PlcGenSettings(projectName, configurationName, resourceName, plcTaskName, taskCyceTime, priority, inputPath, Paths.resolve((String)inputPath), outputPath, intSize, realSize, simplifyValues, enumConversion, shouldTerminate, warnOnRename, warnOutput);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifPlcGenApp.getGeneralOptionCategory();
        List applicationOpts = Lists.list();
        applicationOpts.add(Options.getInstance(InputFileOption.class));
        applicationOpts.add(Options.getInstance(OutputFileOption.class));
        applicationOpts.add(Options.getInstance(PlcTargetTypeOption.class));
        applicationOpts.add(Options.getInstance(PlcConfigurationNameOption.class));
        applicationOpts.add(Options.getInstance(PlcProjectNameOption.class));
        applicationOpts.add(Options.getInstance(PlcResourceNameOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskCycleTimeOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskNameOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskPriorityOption.class));
        applicationOpts.add(Options.getInstance(PlcIntTypeSizeOption.class));
        applicationOpts.add(Options.getInstance(PlcRealTypeSizeOption.class));
        applicationOpts.add(Options.getInstance(SimplifyValuesOption.class));
        applicationOpts.add(Options.getInstance(ConvertEnumsOption.class));
        applicationOpts.add(Options.getInstance(RenameWarningsOption.class));
        applicationOpts.add(Options.getInstance(PlcMaxIterOption.class));
        applicationOpts.add(Options.getInstance(PlcFormalFuncInvokeArgOption.class));
        applicationOpts.add(Options.getInstance(PlcFormalFuncInvokeFuncOption.class));
        List generatorSubCats = Lists.list();
        OptionCategory generatorCat = new OptionCategory("Generator", "Generator options.", generatorSubCats, applicationOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, generatorCat});
        OptionCategory options = new OptionCategory("CIF PLC Code Generator Options", "All options for the CIF PLC code generator.", cats, Lists.list());
        return options;
    }
}

